/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.base.resource;

import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.core.model.ResourceTable;
import com.netease.nim.camellia.core.model.ResourceTableChecker;
import com.netease.nim.camellia.core.util.CheckUtil;
import com.netease.nim.camellia.core.util.ResourceUtil;
import com.netease.nim.camellia.redis.base.exception.CamelliaRedisException;
import com.netease.nim.camellia.redis.base.resource.RedisClusterResource;
import com.netease.nim.camellia.redis.base.resource.RedisClusterSlavesResource;
import com.netease.nim.camellia.redis.base.resource.RedisProxiesDiscoveryResource;
import com.netease.nim.camellia.redis.base.resource.RedisProxiesResource;
import com.netease.nim.camellia.redis.base.resource.RedisResource;
import com.netease.nim.camellia.redis.base.resource.RedisSentinelResource;
import com.netease.nim.camellia.redis.base.resource.RedisSentinelSlavesResource;
import com.netease.nim.camellia.redis.base.resource.RedisType;
import com.netease.nim.camellia.redis.base.resource.RedisUnixDomainSocketResource;
import com.netease.nim.camellia.redis.base.resource.RedissClusterResource;
import com.netease.nim.camellia.redis.base.resource.RedissClusterSlavesResource;
import com.netease.nim.camellia.redis.base.resource.RedissProxiesDiscoveryResource;
import com.netease.nim.camellia.redis.base.resource.RedissProxiesResource;
import com.netease.nim.camellia.redis.base.resource.RedissResource;
import com.netease.nim.camellia.redis.base.resource.RedissSentinelResource;
import com.netease.nim.camellia.redis.base.resource.RedissSentinelSlavesResource;
import com.netease.nim.camellia.redis.base.resource.SSentinelResource;
import com.netease.nim.camellia.redis.base.resource.SentinelResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RedisResourceUtil {
    public static final ResourceTableChecker RedisResourceTableChecker = resourceTable -> {
        try {
            RedisResourceUtil.checkResourceTable(resourceTable);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    };

    public static void checkResourceTable(ResourceTable resourceTable) {
        boolean check = CheckUtil.checkResourceTable((ResourceTable)resourceTable);
        if (!check) {
            throw new IllegalArgumentException("resourceTable check fail");
        }
        Set allResources = ResourceUtil.getAllResources((ResourceTable)resourceTable);
        for (Resource redisResource : allResources) {
            RedisResourceUtil.parseResourceByUrl(redisResource);
        }
    }

    public static Resource parseResourceByUrl(Resource resource) {
        try {
            if (resource == null) {
                return null;
            }
            String url = resource.getUrl();
            if (url == null) {
                throw new CamelliaRedisException("url is null");
            }
            RedisType redisType = RedisType.parseRedisType(resource);
            if (redisType == RedisType.Redis || redisType == RedisType.Rediss) {
                String hostAndPortString;
                String substring = url.substring(redisType.getPrefix().length());
                if (!substring.contains("@")) {
                    throw new CamelliaRedisException("missing @");
                }
                int index = substring.lastIndexOf("@");
                String[] userNameAndPassword = RedisResourceUtil.getUserNameAndPassword(substring.substring(0, index));
                String userName = userNameAndPassword[0];
                String password = userNameAndPassword[1];
                int db = 0;
                String split = substring.substring(index + 1);
                if (split.contains("?")) {
                    Map<String, String> params;
                    String dbStr;
                    String[] strings = split.split("\\?");
                    if (strings.length == 2 && (dbStr = (params = RedisResourceUtil.getParams(strings[1])).get("db")) != null) {
                        db = Integer.parseInt(dbStr);
                    }
                    hostAndPortString = split.split("\\?")[0];
                } else {
                    hostAndPortString = split;
                }
                String[] split2 = hostAndPortString.split(":");
                String host = split2[0];
                int port = Integer.parseInt(split2[1]);
                if (redisType == RedisType.Rediss) {
                    return new RedissResource(host, port, userName, password, db);
                }
                return new RedisResource(host, port, userName, password, db);
            }
            if (redisType == RedisType.RedisSentinel || redisType == RedisType.RedissSentinel) {
                String master;
                String substring = url.substring(redisType.getPrefix().length());
                if (!substring.contains("@")) {
                    throw new CamelliaRedisException("missing @");
                }
                if (!substring.contains("/")) {
                    throw new CamelliaRedisException("missing /");
                }
                int index = substring.lastIndexOf("@");
                String[] userNameAndPassword = RedisResourceUtil.getUserNameAndPassword(substring.substring(0, index));
                String userName = userNameAndPassword[0];
                String password = userNameAndPassword[1];
                String split = substring.substring(index + 1);
                int index2 = split.indexOf("/");
                String hostPorts = split.substring(0, index2);
                String masterWithParams = split.substring(index2 + 1);
                String[] split2 = hostPorts.split(",");
                ArrayList<RedisSentinelResource.Node> nodeList = new ArrayList<RedisSentinelResource.Node>();
                for (String node : split2) {
                    String[] split3 = node.split(":");
                    String host = split3[0];
                    int port = Integer.parseInt(split3[1]);
                    nodeList.add(new RedisSentinelResource.Node(host, port));
                }
                int db = 0;
                String sentinelUserName = null;
                String sentinelPassword = null;
                boolean sentinelSSL = false;
                if (masterWithParams.contains("?")) {
                    String sentinelSSLStr;
                    int i = masterWithParams.indexOf("?");
                    master = masterWithParams.substring(0, i);
                    String queryString = masterWithParams.substring(i + 1);
                    Map<String, String> params = RedisResourceUtil.getParams(queryString);
                    String dbStr = params.get("db");
                    if (dbStr != null) {
                        db = Integer.parseInt(dbStr);
                    }
                    if ((sentinelSSLStr = params.get("sentinelSSL")) != null && sentinelSSLStr.trim().length() > 0) {
                        if (!sentinelSSLStr.equals("true") && !sentinelSSLStr.equals("false")) {
                            throw new CamelliaRedisException("sentinelSSL only support true/false");
                        }
                        sentinelSSL = Boolean.parseBoolean(sentinelSSLStr);
                    }
                    sentinelUserName = params.get("sentinelUserName");
                    sentinelPassword = params.get("sentinelPassword");
                } else {
                    master = masterWithParams;
                }
                if (redisType == RedisType.RedissSentinel) {
                    return new RedissSentinelResource(master, nodeList, userName, password, db, sentinelUserName, sentinelPassword, sentinelSSL);
                }
                return new RedisSentinelResource(master, nodeList, userName, password, db, sentinelUserName, sentinelPassword, sentinelSSL);
            }
            if (redisType == RedisType.RedisCluster || redisType == RedisType.RedissCluster) {
                String substring = url.substring(redisType.getPrefix().length());
                if (!substring.contains("@")) {
                    throw new CamelliaRedisException("missing @");
                }
                int index = substring.lastIndexOf("@");
                String[] userNameAndPassword = RedisResourceUtil.getUserNameAndPassword(substring.substring(0, index));
                String userName = userNameAndPassword[0];
                String password = userNameAndPassword[1];
                String split = substring.substring(index + 1);
                String[] split2 = split.split(",");
                ArrayList<RedisClusterResource.Node> nodeList = new ArrayList<RedisClusterResource.Node>();
                for (String node : split2) {
                    String[] split1 = node.split(":");
                    String ip = split1[0];
                    int port = Integer.parseInt(split1[1]);
                    nodeList.add(new RedisClusterResource.Node(ip, port));
                }
                if (redisType == RedisType.RedisCluster) {
                    RedisClusterResource redisClusterResource = new RedisClusterResource(nodeList, userName, password);
                    if (!redisClusterResource.getUrl().equals(resource.getUrl())) {
                        throw new CamelliaRedisException("resource url not equals");
                    }
                    return redisClusterResource;
                }
                RedissClusterResource redissClusterResource = new RedissClusterResource(nodeList, userName, password);
                if (!redissClusterResource.getUrl().equals(resource.getUrl())) {
                    throw new CamelliaRedisException("resource url not equals");
                }
                return redissClusterResource;
            }
            if (redisType == RedisType.RedisSentinelSlaves || redisType == RedisType.RedissSentinelSlaves) {
                String master;
                String substring = url.substring(redisType.getPrefix().length());
                if (!substring.contains("@")) {
                    throw new CamelliaRedisException("missing @");
                }
                if (!substring.contains("/")) {
                    throw new CamelliaRedisException("missing /");
                }
                int index = substring.lastIndexOf("@");
                String[] userNameAndPassword = RedisResourceUtil.getUserNameAndPassword(substring.substring(0, index));
                String userName = userNameAndPassword[0];
                String password = userNameAndPassword[1];
                String split = substring.substring(index + 1);
                int index2 = split.indexOf("/");
                String hostPorts = split.substring(0, index2);
                String masterWithParams = split.substring(index2 + 1);
                String[] split2 = hostPorts.split(",");
                ArrayList<RedisSentinelResource.Node> nodeList = new ArrayList<RedisSentinelResource.Node>();
                for (String node : split2) {
                    String[] split3 = node.split(":");
                    String host = split3[0];
                    int port = Integer.parseInt(split3[1]);
                    nodeList.add(new RedisSentinelResource.Node(host, port));
                }
                boolean withMaster = false;
                int db = 0;
                String sentinelUserName = null;
                String sentinelPassword = null;
                boolean sentinelSSL = false;
                if (masterWithParams.contains("?")) {
                    String dbStr;
                    String sentinelSSLStr;
                    int i = masterWithParams.indexOf("?");
                    master = masterWithParams.substring(0, i);
                    String queryString = masterWithParams.substring(i + 1);
                    Map<String, String> params = RedisResourceUtil.getParams(queryString);
                    String withMasterStr = params.get("withMaster");
                    if (withMasterStr != null && withMasterStr.trim().length() > 0) {
                        if (!withMasterStr.equals("true") && !withMasterStr.equals("false")) {
                            throw new CamelliaRedisException("withMaster only support true/false");
                        }
                        withMaster = Boolean.parseBoolean(withMasterStr);
                    }
                    if ((sentinelSSLStr = params.get("sentinelSSL")) != null && sentinelSSLStr.trim().length() > 0) {
                        if (!sentinelSSLStr.equals("true") && !sentinelSSLStr.equals("false")) {
                            throw new CamelliaRedisException("sentinelSSL only support true/false");
                        }
                        sentinelSSL = Boolean.parseBoolean(sentinelSSLStr);
                    }
                    if ((dbStr = params.get("db")) != null) {
                        db = Integer.parseInt(dbStr);
                    }
                    sentinelUserName = params.get("sentinelUserName");
                    sentinelPassword = params.get("sentinelPassword");
                } else {
                    master = masterWithParams;
                }
                if (redisType == RedisType.RedisSentinelSlaves) {
                    return new RedisSentinelSlavesResource(master, nodeList, userName, password, withMaster, db, sentinelUserName, sentinelPassword, sentinelSSL);
                }
                return new RedissSentinelSlavesResource(master, nodeList, userName, password, withMaster, db, sentinelUserName, sentinelPassword, sentinelSSL);
            }
            if (redisType == RedisType.RedisClusterSlaves || redisType == RedisType.RedissClusterSlaves) {
                String hostPortStr;
                String substring = url.substring(redisType.getPrefix().length());
                if (!substring.contains("@")) {
                    throw new CamelliaRedisException("missing @");
                }
                int index = substring.lastIndexOf("@");
                String[] userNameAndPassword = RedisResourceUtil.getUserNameAndPassword(substring.substring(0, index));
                String userName = userNameAndPassword[0];
                String password = userNameAndPassword[1];
                String split = substring.substring(index + 1);
                boolean withMaster = false;
                if (split.contains("?")) {
                    int i = split.indexOf("?");
                    String queryString = split.substring(i + 1);
                    Map<String, String> params = RedisResourceUtil.getParams(queryString);
                    String withMasterStr = (String)params.get("withMaster");
                    if (withMasterStr != null && withMasterStr.trim().length() > 0) {
                        if (!withMasterStr.equals("true") && !withMasterStr.equals("false")) {
                            throw new CamelliaRedisException("withMaster only support true/false");
                        }
                        withMaster = Boolean.parseBoolean(withMasterStr);
                    }
                    hostPortStr = split.substring(0, i);
                } else {
                    hostPortStr = split;
                }
                ArrayList<RedisClusterResource.Node> nodeList = new ArrayList<RedisClusterResource.Node>();
                String[] split2 = hostPortStr.split(",");
                for (String node : split2) {
                    String[] split1 = node.split(":");
                    String ip = split1[0];
                    int port = Integer.parseInt(split1[1]);
                    nodeList.add(new RedisClusterResource.Node(ip, port));
                }
                if (redisType == RedisType.RedisClusterSlaves) {
                    return new RedisClusterSlavesResource(nodeList, userName, password, withMaster);
                }
                return new RedissClusterSlavesResource(nodeList, userName, password, withMaster);
            }
            if (redisType == RedisType.RedisProxies || redisType == RedisType.RedissProxies) {
                String nodesStr;
                String substring = url.substring(redisType.getPrefix().length());
                if (!substring.contains("@")) {
                    throw new CamelliaRedisException("missing @");
                }
                int index = substring.lastIndexOf("@");
                String[] userNameAndPassword = RedisResourceUtil.getUserNameAndPassword(substring.substring(0, index));
                String userName = userNameAndPassword[0];
                String password = userNameAndPassword[1];
                String split = substring.substring(index + 1);
                int db = 0;
                if (split.contains("?")) {
                    int i = split.indexOf("?");
                    String queryString = split.substring(i + 1);
                    Map<String, String> params = RedisResourceUtil.getParams(queryString);
                    String dbStr = (String)params.get("db");
                    if (dbStr != null) {
                        db = Integer.parseInt(dbStr);
                    }
                    nodesStr = split.substring(0, i);
                } else {
                    nodesStr = split;
                }
                String[] split2 = nodesStr.split(",");
                ArrayList<RedisProxiesResource.Node> nodeList = new ArrayList<RedisProxiesResource.Node>();
                for (String node : split2) {
                    String[] split1 = node.split(":");
                    String ip = split1[0];
                    int port = Integer.parseInt(split1[1]);
                    nodeList.add(new RedisProxiesResource.Node(ip, port));
                }
                if (redisType == RedisType.RedisProxies) {
                    return new RedisProxiesResource(nodeList, userName, password, db);
                }
                return new RedissProxiesResource(nodeList, userName, password, db);
            }
            if (redisType == RedisType.RedisProxiesDiscovery || redisType == RedisType.RedissProxiesDiscovery) {
                String proxyName;
                String substring = url.substring(redisType.getPrefix().length());
                if (!substring.contains("@")) {
                    throw new CamelliaRedisException("missing @");
                }
                int index = substring.lastIndexOf("@");
                String[] userNameAndPassword = RedisResourceUtil.getUserNameAndPassword(substring.substring(0, index));
                String userName = userNameAndPassword[0];
                String password = userNameAndPassword[1];
                String str = substring.substring(index + 1);
                int db = 0;
                if (str.contains("?")) {
                    int i = str.indexOf("?");
                    String queryString = str.substring(i + 1);
                    Map<String, String> params = RedisResourceUtil.getParams(queryString);
                    String dbStr = params.get("db");
                    if (dbStr != null) {
                        db = Integer.parseInt(dbStr);
                    }
                    proxyName = str.substring(0, i);
                } else {
                    proxyName = str;
                }
                if (redisType == RedisType.RedisProxiesDiscovery) {
                    return new RedisProxiesDiscoveryResource(userName, password, proxyName, db);
                }
                return new RedissProxiesDiscoveryResource(userName, password, proxyName, db);
            }
            if (redisType == RedisType.Sentinel || redisType == RedisType.SSentinel) {
                String substring = url.substring(redisType.getPrefix().length());
                if (!substring.contains("@")) {
                    throw new CamelliaRedisException("missing @");
                }
                int index = substring.lastIndexOf("@");
                String[] userNameAndPassword = RedisResourceUtil.getUserNameAndPassword(substring.substring(0, index));
                String userName = userNameAndPassword[0];
                String password = userNameAndPassword[1];
                String split = substring.substring(index + 1);
                String[] split2 = split.split(",");
                ArrayList<RedisSentinelResource.Node> nodeList = new ArrayList<RedisSentinelResource.Node>();
                for (String node : split2) {
                    String[] split1 = node.split(":");
                    String ip = split1[0];
                    int port = Integer.parseInt(split1[1]);
                    nodeList.add(new RedisSentinelResource.Node(ip, port));
                }
                if (redisType == RedisType.Sentinel) {
                    return new SentinelResource(nodeList, userName, password);
                }
                return new SSentinelResource(nodeList, userName, password);
            }
            if (redisType == RedisType.UnixDomainSocket) {
                String udsPath;
                String substring = url.substring(redisType.getPrefix().length());
                if (!substring.contains("@")) {
                    throw new CamelliaRedisException("missing @");
                }
                int index = substring.lastIndexOf("@");
                String[] userNameAndPassword = RedisResourceUtil.getUserNameAndPassword(substring.substring(0, index));
                String userName = userNameAndPassword[0];
                String password = userNameAndPassword[1];
                String str = substring.substring(index + 1);
                int db = 0;
                if (str.contains("?")) {
                    int i = str.indexOf("?");
                    udsPath = str.substring(0, i);
                    String queryString = str.substring(i + 1);
                    Map<String, String> params = RedisResourceUtil.getParams(queryString);
                    String dbStr = params.get("db");
                    if (dbStr != null) {
                        db = Integer.parseInt(dbStr);
                    }
                } else {
                    udsPath = str;
                }
                return new RedisUnixDomainSocketResource(udsPath, userName, password, db);
            }
            throw new CamelliaRedisException("not redis resource");
        }
        catch (CamelliaRedisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CamelliaRedisException(e);
        }
    }

    public static Map<String, String> getParams(String queryString) {
        String[] split1 = queryString.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : split1) {
            String[] split3 = s.split("=");
            if (split3.length != 2) continue;
            String k = split3[0];
            String v = split3[1];
            map.put(k, v);
        }
        return map;
    }

    public static String[] getUserNameAndPassword(String str) {
        if (str == null) {
            return new String[2];
        }
        if (str.length() == 0) {
            return new String[2];
        }
        int i = str.indexOf(":");
        if (i == -1) {
            return new String[]{null, str};
        }
        String userName = str.substring(0, i);
        String password = str.substring(i + 1);
        if (userName.length() == 0) {
            userName = null;
        }
        if (password.length() == 0) {
            password = null;
        }
        return new String[]{userName, password};
    }
}

