/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.base.resource;

import com.netease.nim.camellia.core.model.Resource;

public enum RedisType {
    Redis("redis://", false),
    Rediss("rediss://", true),
    RedisSentinel("redis-sentinel://", false),
    RedissSentinel("rediss-sentinel://", true),
    RedisCluster("redis-cluster://", false),
    RedissCluster("rediss-cluster://", true),
    RedisProxy("redis-proxy://", false),
    CamelliaRedisProxy("camellia-redis-proxy://", false),
    RedisSentinelSlaves("redis-sentinel-slaves://", false),
    RedissSentinelSlaves("rediss-sentinel-slaves://", true),
    RedisClusterSlaves("redis-cluster-slaves://", false),
    RedissClusterSlaves("rediss-cluster-slaves://", false),
    RedisProxies("redis-proxies://", false),
    RedissProxies("rediss-proxies://", true),
    RedisProxiesDiscovery("redis-proxies-discovery://", false),
    RedissProxiesDiscovery("rediss-proxies-discovery://", true),
    Sentinel("sentinel://", false),
    SSentinel("ssentinel://", true),
    UnixDomainSocket("redis-uds://", false);

    private final String prefix;
    private final boolean tlsEnable;

    private RedisType(String prefix, boolean tlsEnable) {
        this.prefix = prefix;
        this.tlsEnable = tlsEnable;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isTlsEnable() {
        return this.tlsEnable;
    }

    public static RedisType parseRedisType(Resource resource) {
        for (RedisType type : RedisType.values()) {
            if (!resource.getUrl().startsWith(type.getPrefix())) continue;
            return type;
        }
        return null;
    }
}

