/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.base.resource;

import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.base.resource.RedisType;

public class RedisUnixDomainSocketResource
extends Resource {
    private final String udsPath;
    private final String userName;
    private final String password;
    private final int db;

    public RedisUnixDomainSocketResource(String udsPath, String userName, String password, int db) {
        this.udsPath = udsPath;
        this.userName = userName;
        this.password = password;
        this.db = db;
        StringBuilder url = new StringBuilder();
        url.append(RedisType.UnixDomainSocket.getPrefix());
        if (userName != null && password != null) {
            url.append(userName).append(":").append(password);
        } else if (userName == null && password != null) {
            url.append(password);
        }
        url.append("@");
        url.append(udsPath);
        if (db > 0) {
            url.append("?db=").append(db);
        }
        this.setUrl(url.toString());
    }

    public String getUdsPath() {
        return this.udsPath;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getDb() {
        return this.db;
    }
}

