/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.base.resource;

import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.base.resource.RedisProxiesResource;
import com.netease.nim.camellia.redis.base.resource.RedisType;
import java.util.List;

public class RedissProxiesResource
extends Resource {
    private final List<RedisProxiesResource.Node> nodes;
    private final String password;
    private final String userName;
    private final int db;

    public RedissProxiesResource(List<RedisProxiesResource.Node> nodes, String userName, String password, int db) {
        this.nodes = nodes;
        this.password = password;
        this.userName = userName;
        this.db = db;
        StringBuilder url = new StringBuilder();
        url.append(RedisType.RedissProxies.getPrefix());
        if (userName != null && password != null) {
            url.append(userName).append(":").append(password);
        } else if (userName == null && password != null) {
            url.append(password);
        }
        url.append("@");
        for (RedisProxiesResource.Node node : nodes) {
            url.append(node.getHost()).append(":").append(node.getPort());
            url.append(",");
        }
        url.deleteCharAt(url.length() - 1);
        if (db > 0) {
            url.append("?db=").append(db);
        }
        this.setUrl(url.toString());
    }

    public RedissProxiesResource(List<RedisProxiesResource.Node> nodes, String userName, String password) {
        this(nodes, userName, password, 0);
    }

    public RedissProxiesResource(List<RedisProxiesResource.Node> nodes, String password) {
        this(nodes, null, password);
    }

    public List<RedisProxiesResource.Node> getNodes() {
        return this.nodes;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getDb() {
        return this.db;
    }
}

