/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.base.resource;

import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.base.resource.RedisType;

public class RedissResource
extends Resource {
    private final String host;
    private final int port;
    private final String password;
    private final String userName;
    private final int db;

    public RedissResource(String host, int port, String userName, String password, int db) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.db = db;
        StringBuilder url = new StringBuilder();
        url.append(RedisType.Rediss.getPrefix());
        if (userName != null && password != null) {
            url.append(userName).append(":").append(password);
        } else if (userName == null && password != null) {
            url.append(password);
        }
        url.append("@");
        url.append(host).append(":").append(port);
        if (db > 0) {
            url.append("?db=").append(db);
        }
        this.setUrl(url.toString());
    }

    public RedissResource(String host, int port, String userName, String password) {
        this(host, port, userName, password, 0);
    }

    public RedissResource(String host, int port, String password) {
        this(host, port, null, password);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public int getDb() {
        return this.db;
    }
}

