/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.toolkit.counter;

import com.netease.nim.camellia.redis.CamelliaRedisTemplate;
import com.netease.nim.camellia.redis.pipeline.ICamelliaRedisPipeline;
import com.netease.nim.camellia.redis.toolkit.counter.CounterGetter;
import com.netease.nim.camellia.redis.toolkit.counter.TagToCacheKey;
import com.netease.nim.camellia.tools.base.DynamicValueGetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Response;

public class CamelliaCounterCache<T> {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaCounterCache.class);
    private CounterGetter<T> counterGetter;
    private DynamicValueGetter<Boolean> cacheEnable = () -> true;
    private CamelliaRedisTemplate template;
    private TagToCacheKey<T> tagToCacheKey;
    private DynamicValueGetter<Long> threshold;
    private DynamicValueGetter<Integer> expireSeconds;
    private DynamicValueGetter<Integer> adjustCacheIntervalSeconds;
    private DynamicValueGetter<Integer> exceedThresholdAdjustCacheIntervalSeconds;

    private CamelliaCounterCache() {
    }

    public long getCount(T tag) {
        if (!((Boolean)this.cacheEnable.get()).booleanValue()) {
            return this.counterGetter.get(tag);
        }
        String cacheKey = this.tagToCacheKey.toCacheKey(tag);
        String lastSyncKey = cacheKey + "~lastSync";
        try {
            Long countCache = null;
            Long lastSyncTime = null;
            try (ICamelliaRedisPipeline pipeline = this.template.pipelined();){
                Response response1 = pipeline.get(cacheKey);
                Response response2 = pipeline.get(lastSyncKey);
                pipeline.sync();
                String countCacheValue = (String)response1.get();
                String lastSyncTimeCacheValue = (String)response2.get();
                if (countCacheValue != null && lastSyncTimeCacheValue != null) {
                    try {
                        countCache = Long.parseLong(countCacheValue);
                        lastSyncTime = Long.parseLong(lastSyncTimeCacheValue);
                    }
                    catch (NumberFormatException e) {
                        this.template.del(new String[]{cacheKey, lastSyncKey});
                    }
                }
            }
            long now = System.currentTimeMillis();
            if (countCache != null && lastSyncTime != null) {
                if (countCache < (Long)this.threshold.get()) {
                    if (now - lastSyncTime > (long)((Integer)this.adjustCacheIntervalSeconds.get()).intValue() * 1000L) {
                        return this.rebuildCache(cacheKey, lastSyncKey, tag);
                    }
                    return countCache;
                }
                if (now - lastSyncTime > (long)((Integer)this.exceedThresholdAdjustCacheIntervalSeconds.get()).intValue() * 1000L) {
                    return this.rebuildCache(cacheKey, lastSyncKey, tag);
                }
                return countCache;
            }
            return this.rebuildCache(cacheKey, lastSyncKey, tag);
        }
        catch (Exception e) {
            logger.error("getCount error, tag = {}", tag, (Object)e);
            long dbCount = this.counterGetter.get(tag);
            try {
                this.template.del(new String[]{cacheKey, lastSyncKey});
            }
            catch (Exception ex) {
                logger.error("del error, tag = {}", tag, (Object)ex);
            }
            return dbCount;
        }
    }

    public boolean checkCountExceed(T tag) {
        long count = this.getCount(tag);
        return count > (Long)this.threshold.get();
    }

    private long rebuildCache(String cacheKey, String lastSyncKey, T tag) {
        long dbCount = this.counterGetter.get(tag);
        try (ICamelliaRedisPipeline pipeline = this.template.pipelined();){
            pipeline.setex(cacheKey, ((Integer)this.expireSeconds.get()).intValue(), String.valueOf(dbCount));
            pipeline.setex(lastSyncKey, ((Integer)this.expireSeconds.get()).intValue(), String.valueOf(System.currentTimeMillis()));
            pipeline.sync();
        }
        return dbCount;
    }

    public long incrBy(T tag, long count) {
        if (!((Boolean)this.cacheEnable.get()).booleanValue()) {
            return -1L;
        }
        try {
            String cacheKey = this.tagToCacheKey.toCacheKey(tag);
            Boolean exists = this.template.exists(cacheKey);
            if (exists != null && exists.booleanValue()) {
                return this.template.incrBy(cacheKey, count);
            }
            return -1L;
        }
        catch (Exception e) {
            logger.error("incrBy error, tag = {}", tag, (Object)e);
            return -1L;
        }
    }

    public long incr(T tag) {
        if (!((Boolean)this.cacheEnable.get()).booleanValue()) {
            return -1L;
        }
        try {
            String cacheKey = this.tagToCacheKey.toCacheKey(tag);
            Boolean exists = this.template.exists(cacheKey);
            if (exists != null && exists.booleanValue()) {
                return this.template.incr(cacheKey);
            }
            return -1L;
        }
        catch (Exception e) {
            logger.error("incr error, tag = {}", tag, (Object)e);
            return -1L;
        }
    }

    public long decr(T tag) {
        if (!((Boolean)this.cacheEnable.get()).booleanValue()) {
            return -1L;
        }
        try {
            String cacheKey = this.tagToCacheKey.toCacheKey(tag);
            Boolean exists = this.template.exists(cacheKey);
            if (exists != null && exists.booleanValue()) {
                return this.template.decr(cacheKey);
            }
            return -1L;
        }
        catch (Exception e) {
            logger.error("decr error, tag = {}", tag, (Object)e);
            return -1L;
        }
    }

    public long decrBy(T tag, long count) {
        if (!((Boolean)this.cacheEnable.get()).booleanValue()) {
            return -1L;
        }
        try {
            String cacheKey = this.tagToCacheKey.toCacheKey(tag);
            Boolean exists = this.template.exists(cacheKey);
            if (exists != null && exists.booleanValue()) {
                return this.template.decrBy(cacheKey, count);
            }
            return -1L;
        }
        catch (Exception e) {
            logger.error("decrBy error, tag = {}", tag, (Object)e);
            return -1L;
        }
    }

    public static class Builder<T> {
        private final CamelliaCounterCache<T> counterCache = new CamelliaCounterCache();

        public Builder<T> counterGetter(CounterGetter<T> counterGetter) {
            ((CamelliaCounterCache)this.counterCache).counterGetter = counterGetter;
            return this;
        }

        public Builder<T> redisTemplate(CamelliaRedisTemplate template) {
            ((CamelliaCounterCache)this.counterCache).template = template;
            return this;
        }

        public Builder<T> tagToCacheKey(TagToCacheKey<T> tagToCacheKey) {
            ((CamelliaCounterCache)this.counterCache).tagToCacheKey = tagToCacheKey;
            return this;
        }

        public Builder<T> threshold(DynamicValueGetter<Long> threshold) {
            ((CamelliaCounterCache)this.counterCache).threshold = threshold;
            return this;
        }

        public Builder<T> expireSeconds(DynamicValueGetter<Integer> expireSeconds) {
            ((CamelliaCounterCache)this.counterCache).expireSeconds = expireSeconds;
            return this;
        }

        public Builder<T> adjustCacheIntervalSeconds(DynamicValueGetter<Integer> adjustCacheIntervalSeconds) {
            ((CamelliaCounterCache)this.counterCache).adjustCacheIntervalSeconds = adjustCacheIntervalSeconds;
            return this;
        }

        public Builder<T> cacheEnable(DynamicValueGetter<Boolean> cacheEnable) {
            ((CamelliaCounterCache)this.counterCache).cacheEnable = cacheEnable;
            return this;
        }

        public Builder<T> exceedThresholdAdjustCacheIntervalSeconds(DynamicValueGetter<Integer> exceedThresholdAdjustCacheIntervalSeconds) {
            ((CamelliaCounterCache)this.counterCache).exceedThresholdAdjustCacheIntervalSeconds = exceedThresholdAdjustCacheIntervalSeconds;
            return this;
        }

        public CamelliaCounterCache<T> build() {
            if (((CamelliaCounterCache)this.counterCache).counterGetter == null) {
                throw new IllegalArgumentException("counterGetter required");
            }
            if (((CamelliaCounterCache)this.counterCache).cacheEnable == null) {
                throw new IllegalArgumentException("cacheEnable required");
            }
            if (((CamelliaCounterCache)this.counterCache).template == null) {
                throw new IllegalArgumentException("redisTemplate required");
            }
            if (((CamelliaCounterCache)this.counterCache).tagToCacheKey == null) {
                throw new IllegalArgumentException("tagToCacheKey required");
            }
            if (((CamelliaCounterCache)this.counterCache).threshold == null) {
                throw new IllegalArgumentException("threshold required");
            }
            if (((CamelliaCounterCache)this.counterCache).expireSeconds == null) {
                throw new IllegalArgumentException("expireSeconds required");
            }
            if (((CamelliaCounterCache)this.counterCache).adjustCacheIntervalSeconds == null) {
                throw new IllegalArgumentException("adjustCacheIntervalSeconds required");
            }
            if (((CamelliaCounterCache)this.counterCache).exceedThresholdAdjustCacheIntervalSeconds == null) {
                throw new IllegalArgumentException("exceedThresholdAdjustCacheIntervalSeconds required");
            }
            return this.counterCache;
        }
    }
}

