/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.toolkit.freq;

import com.alibaba.fastjson.JSONObject;
import com.netease.nim.camellia.redis.CamelliaRedisTemplate;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaFreqConfig;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaFreqResponse;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaFreqType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelliaClusterFreq {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaClusterFreq.class);
    private final CamelliaRedisTemplate template;

    public CamelliaClusterFreq(CamelliaRedisTemplate template) {
        this.template = template;
    }

    public CamelliaFreqResponse checkFreqPass(String freqKey, CamelliaFreqConfig freqConfig) {
        return this.checkFreqPass(freqKey, 1, freqConfig);
    }

    public CamelliaFreqResponse checkFreqPass(String freqKey, int delta, CamelliaFreqConfig freqConfig) {
        try {
            boolean pass;
            Object curObj = this.template.eval("local x = redis.call('incrBy', KEYS[1], ARGV[1])\nif x == tonumber(ARGV[1]) then\n\tredis.call('pexpire', KEYS[1], ARGV[2])\nend\nreturn x", 1, new String[]{freqKey, String.valueOf(delta), String.valueOf(freqConfig.getCheckTime())});
            long current = Long.parseLong(String.valueOf(curObj));
            boolean bl = pass = current <= freqConfig.getThreshold();
            if (!pass && freqConfig.getBanTime() > 0L) {
                if (freqConfig.isDelayBanEnable()) {
                    this.template.pexpire(freqKey, freqConfig.getBanTime());
                } else if (current <= freqConfig.getThreshold() + (long)delta) {
                    this.template.pexpire(freqKey, freqConfig.getBanTime());
                }
            }
            return new CamelliaFreqResponse(pass, current, CamelliaFreqType.CLUSTER);
        }
        catch (Throwable e) {
            logger.error("checkFreqPass error, freqKey = {}, delta = {}, freqConfig = {}", new Object[]{freqKey, delta, JSONObject.toJSONString((Object)freqConfig), e});
            return CamelliaFreqResponse.DEFAULT_PASS;
        }
    }
}

