/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.toolkit.freq;

import com.alibaba.fastjson.JSONObject;
import com.netease.nim.camellia.redis.CamelliaRedisTemplate;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaClusterFreq;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaFreqConfig;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaFreqResponse;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaFreqType;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaStandaloneFreq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelliaFreq {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaFreq.class);
    private final CamelliaStandaloneFreq standaloneFreq;
    private CamelliaClusterFreq clusterFreq;

    public CamelliaFreq(CamelliaRedisTemplate template, int standaloneCapacity) {
        this.standaloneFreq = new CamelliaStandaloneFreq(standaloneCapacity);
        this.clusterFreq = new CamelliaClusterFreq(template);
    }

    public CamelliaFreq(CamelliaRedisTemplate template) {
        this.standaloneFreq = new CamelliaStandaloneFreq();
        this.clusterFreq = new CamelliaClusterFreq(template);
    }

    public CamelliaFreq(int standaloneCapacity) {
        this.standaloneFreq = new CamelliaStandaloneFreq(standaloneCapacity);
    }

    public CamelliaFreq() {
        this.standaloneFreq = new CamelliaStandaloneFreq();
    }

    public CamelliaFreqResponse checkFreqPass(String freqKey, CamelliaFreqType freqType, CamelliaFreqConfig freqConfig) {
        return this.checkFreqPass(freqKey, 1, freqType, freqConfig);
    }

    public CamelliaFreqResponse checkFreqPass(String freqKey, int delta, CamelliaFreqType freqType, CamelliaFreqConfig freqConfig) {
        try {
            if (delta <= 0) {
                logger.warn("point is null, return pass, freqKey = {}, delta = {}, freqConfig = {}", new Object[]{freqKey, delta, JSONObject.toJSONString((Object)freqConfig)});
                return CamelliaFreqResponse.DEFAULT_PASS;
            }
            if (freqType == null) {
                logger.warn("freqType is null, return pass, freqKey = {}, delta = {}, freqConfig = {}", new Object[]{freqKey, delta, JSONObject.toJSONString((Object)freqConfig)});
                return CamelliaFreqResponse.DEFAULT_PASS;
            }
            if (freqType == CamelliaFreqType.STANDALONE) {
                return this.standaloneFreq.checkFreqPass(freqKey, delta, freqConfig);
            }
            if (freqType == CamelliaFreqType.CLUSTER) {
                if (this.clusterFreq == null) {
                    logger.warn("CamelliaClusterFreq not init, return pass, freqKey = {}, delta = {}, freqConfig = {}", new Object[]{freqKey, delta, JSONObject.toJSONString((Object)freqConfig)});
                    return CamelliaFreqResponse.DEFAULT_PASS;
                }
                return this.clusterFreq.checkFreqPass(freqKey, delta, freqConfig);
            }
            if (freqType == CamelliaFreqType.MISC) {
                if (this.clusterFreq == null) {
                    logger.warn("CamelliaClusterFreq not init, return pass, freqKey = {}, delta = {}, freqConfig = {}", new Object[]{freqKey, delta, JSONObject.toJSONString((Object)freqConfig)});
                    return CamelliaFreqResponse.DEFAULT_PASS;
                }
                CamelliaFreqResponse response = this.standaloneFreq.checkFreqPass(freqKey, delta, freqConfig);
                if (!response.isPass()) {
                    return response;
                }
                return this.clusterFreq.checkFreqPass(freqKey, delta, freqConfig);
            }
            return CamelliaFreqResponse.DEFAULT_PASS;
        }
        catch (Throwable e) {
            logger.error("checkFreqPass error, return pass, freqKey = {}, delta = {}, freqConfig = {}", new Object[]{freqKey, delta, JSONObject.toJSONString((Object)freqConfig), e});
            return CamelliaFreqResponse.DEFAULT_PASS;
        }
    }
}

