/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.toolkit.freq;

import com.alibaba.fastjson.JSONObject;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaFreqConfig;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaFreqResponse;
import com.netease.nim.camellia.redis.toolkit.freq.CamelliaFreqType;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelliaStandaloneFreq {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaStandaloneFreq.class);
    private final ConcurrentLinkedHashMap<String, Counter> cache;

    public CamelliaStandaloneFreq(int capacity) {
        this.cache = new ConcurrentLinkedHashMap.Builder().initialCapacity(capacity).maximumWeightedCapacity((long)capacity).build();
    }

    public CamelliaStandaloneFreq() {
        this(100000);
    }

    public CamelliaFreqResponse checkFreqPass(String freqKey, CamelliaFreqConfig freqConfig) {
        return this.checkFreqPass(freqKey, 1, freqConfig);
    }

    public CamelliaFreqResponse checkFreqPass(String freqKey, int delta, CamelliaFreqConfig freqConfig) {
        try {
            boolean pass;
            long current;
            Counter oldCounter;
            Counter counter = (Counter)this.cache.get((Object)freqKey);
            if (counter != null && counter.isExpire()) {
                this.cache.remove((Object)freqKey);
                counter = null;
            }
            if (counter == null && (oldCounter = (Counter)this.cache.putIfAbsent((Object)freqKey, (Object)(counter = new Counter()))) != null) {
                counter = oldCounter;
            }
            if ((current = counter.addAndGet(delta)) == (long)delta) {
                counter.expireTime = System.currentTimeMillis() + freqConfig.getCheckTime();
            }
            boolean bl = pass = current <= freqConfig.getThreshold();
            if (!pass && freqConfig.getBanTime() > 0L) {
                if (freqConfig.isDelayBanEnable()) {
                    counter.expireTime = System.currentTimeMillis() + freqConfig.getBanTime();
                } else if (current <= freqConfig.getThreshold() + (long)delta) {
                    counter.expireTime = System.currentTimeMillis() + freqConfig.getBanTime();
                }
            }
            return new CamelliaFreqResponse(pass, current, CamelliaFreqType.STANDALONE);
        }
        catch (Throwable e) {
            logger.error("checkFreqPass error, return pass, freqKey = {}, delta = {}, freqConfig = {}", new Object[]{freqKey, delta, JSONObject.toJSONString((Object)freqConfig), e});
            return CamelliaFreqResponse.DEFAULT_PASS;
        }
    }

    private static class Counter {
        private final AtomicLong count = new AtomicLong();
        private long expireTime;

        private Counter() {
        }

        public boolean isExpire() {
            return System.currentTimeMillis() > this.expireTime;
        }

        public long addAndGet(int delta) {
            return this.count.addAndGet(delta);
        }
    }
}

