/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.toolkit.lock;

import com.netease.nim.camellia.redis.CamelliaRedisTemplate;
import com.netease.nim.camellia.redis.base.utils.SafeEncoder;
import com.netease.nim.camellia.redis.toolkit.lock.LockTaskResult;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelliaRedisLock {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaRedisLock.class);
    private final CamelliaRedisTemplate template;
    private final byte[] lockKey;
    private final long acquireTimeoutMillis;
    private final long expireTimeoutMillis;
    private final long tryLockIntervalMillis;
    private final String lockId;
    private boolean lockOk = false;
    private long expireTimestamp = -1L;
    private final ReentrantLock lock = new ReentrantLock();
    private static final byte[] RENEW_SCRIPT = SafeEncoder.encode((String)"if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('pexpire', KEYS[1], ARGV[2]) else return 0 end");
    private static final byte[] RELEASE_SCRIPT = SafeEncoder.encode((String)"if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end");

    private CamelliaRedisLock(CamelliaRedisTemplate template, byte[] lockKey, String lockId, long acquireTimeoutMillis, long expireTimeoutMillis, long tryLockIntervalMillis) {
        this.template = template;
        this.lockKey = lockKey;
        this.lockId = lockId;
        this.acquireTimeoutMillis = acquireTimeoutMillis;
        this.expireTimeoutMillis = expireTimeoutMillis;
        this.tryLockIntervalMillis = tryLockIntervalMillis;
    }

    public static CamelliaRedisLock newLock(CamelliaRedisTemplate template, String lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return new CamelliaRedisLock(template, SafeEncoder.encode((String)lockKey), UUID.randomUUID().toString(), acquireTimeoutMillis, expireTimeoutMillis, 5L);
    }

    public static CamelliaRedisLock newLock(CamelliaRedisTemplate template, byte[] lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return new CamelliaRedisLock(template, lockKey, UUID.randomUUID().toString(), acquireTimeoutMillis, expireTimeoutMillis, 5L);
    }

    public static CamelliaRedisLock newLock(CamelliaRedisTemplate template, String lockKey, String lockId, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return new CamelliaRedisLock(template, SafeEncoder.encode((String)lockKey), lockId, acquireTimeoutMillis, expireTimeoutMillis, 5L);
    }

    public static CamelliaRedisLock newLock(CamelliaRedisTemplate template, byte[] lockKey, String lockId, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return new CamelliaRedisLock(template, lockKey, lockId, acquireTimeoutMillis, expireTimeoutMillis, 5L);
    }

    public static CamelliaRedisLock newLock(CamelliaRedisTemplate template, String lockKey, String lockId, long acquireTimeoutMillis, long expireTimeoutMillis, long tryLockIntervalMillis) {
        return new CamelliaRedisLock(template, SafeEncoder.encode((String)lockKey), lockId, acquireTimeoutMillis, expireTimeoutMillis, tryLockIntervalMillis);
    }

    public static CamelliaRedisLock newLock(CamelliaRedisTemplate template, byte[] lockKey, String lockId, long acquireTimeoutMillis, long expireTimeoutMillis, long tryLockIntervalMillis) {
        return new CamelliaRedisLock(template, lockKey, lockId, acquireTimeoutMillis, expireTimeoutMillis, tryLockIntervalMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock() {
        if (this.isLockOk()) {
            return true;
        }
        this.lock.lock();
        try {
            boolean ok;
            long timestamp = System.currentTimeMillis() + this.expireTimeoutMillis;
            String set = this.template.set(this.lockKey, SafeEncoder.encode((String)this.lockId), SafeEncoder.encode((String)"NX"), SafeEncoder.encode((String)"PX"), this.expireTimeoutMillis);
            boolean bl = ok = set != null && set.equalsIgnoreCase("ok");
            if (ok) {
                this.lockOk = true;
                this.expireTimestamp = timestamp;
            }
            boolean bl2 = ok;
            return bl2;
        }
        catch (Exception e) {
            logger.error("tryLock error, lockKey = {}, lockId = {}", new Object[]{this.lockKey, this.lockId, e});
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockOk() {
        this.lock.lock();
        try {
            boolean ok;
            if (!this.lockOk) {
                boolean bl = false;
                return bl;
            }
            if (System.currentTimeMillis() < this.expireTimestamp) {
                boolean bl = true;
                return bl;
            }
            byte[] value = this.template.get(this.lockKey);
            boolean bl = ok = value != null && SafeEncoder.encode((byte[])value).equals(this.lockId);
            if (!ok) {
                this.lockOk = false;
                this.expireTimestamp = -1L;
            }
            boolean bl2 = ok;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean lock() {
        if (this.isLockOk()) {
            return true;
        }
        long start = System.currentTimeMillis();
        do {
            boolean lockOk;
            if (lockOk = this.tryLock()) {
                return true;
            }
            try {
                Thread.sleep(this.tryLockIntervalMillis);
            }
            catch (InterruptedException e) {
                logger.error("sleep error", (Throwable)e);
            }
        } while (System.currentTimeMillis() - start <= this.acquireTimeoutMillis);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renew() {
        this.lock.lock();
        try {
            if (!this.lockOk) {
                boolean bl = false;
                return bl;
            }
            long timestamp = System.currentTimeMillis() + this.expireTimeoutMillis;
            Object result = this.template.eval(RENEW_SCRIPT, 1, (byte[][])new byte[][]{this.lockKey, SafeEncoder.encode((String)this.lockId), SafeEncoder.encode((String)String.valueOf(this.expireTimeoutMillis))});
            if (result != null && String.valueOf(result).equals("1")) {
                this.expireTimestamp = timestamp;
                boolean bl = true;
                return bl;
            }
            this.lockOk = false;
            this.expireTimestamp = -1L;
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getExpireTimestamp() {
        if (!this.lockOk) {
            return -1L;
        }
        return this.expireTimestamp;
    }

    public byte[] getLockKey() {
        return this.lockKey;
    }

    public String getLockId() {
        return this.lockId;
    }

    public boolean release() {
        this.lock.lock();
        try {
            if (!this.lockOk) {
                boolean bl = false;
                return bl;
            }
            Object eval = this.template.eval(RELEASE_SCRIPT, 1, (byte[][])new byte[][]{this.lockKey, SafeEncoder.encode((String)this.lockId)});
            if (eval != null && String.valueOf(eval).equals("1")) {
                this.lockOk = false;
                this.expireTimestamp = -1L;
                boolean bl = true;
                return bl;
            }
            this.lockOk = false;
            this.expireTimestamp = -1L;
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error("release error, lockKey = {}, lockId = {}", new Object[]{this.lockKey, this.lockId, e});
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean clear() {
        this.lock.lock();
        try {
            boolean ok = this.template.del(this.lockKey) > 0L;
            this.lockOk = false;
            this.expireTimestamp = -1L;
            boolean bl = ok;
            return bl;
        }
        catch (Exception e) {
            logger.error("clear error, lockKey = {}, lockId = {}", new Object[]{this.lockKey, this.lockId, e});
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockAndRun(Runnable runnable) {
        boolean lock = this.lock();
        if (!lock) {
            return false;
        }
        try {
            runnable.run();
            boolean bl = true;
            return bl;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> LockTaskResult<T> lockAndRun(Callable<T> callable) throws Exception {
        boolean lock = this.lock();
        if (!lock) {
            return new LockTaskResult<Object>(false, null);
        }
        try {
            T result = callable.call();
            LockTaskResult<T> lockTaskResult = new LockTaskResult<T>(true, result);
            return lockTaskResult;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLockAndRun(Runnable runnable) {
        boolean lock = this.tryLock();
        if (!lock) {
            return false;
        }
        try {
            runnable.run();
            boolean bl = true;
            return bl;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> LockTaskResult<T> tryLockAndRun(Callable<T> callable) throws Exception {
        boolean lock = this.tryLock();
        if (!lock) {
            return new LockTaskResult<Object>(false, null);
        }
        try {
            T result = callable.call();
            LockTaskResult<T> lockTaskResult = new LockTaskResult<T>(true, result);
            return lockTaskResult;
        }
        finally {
            this.release();
        }
    }
}

