/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.toolkit.lock;

import com.netease.nim.camellia.redis.CamelliaRedisTemplate;
import com.netease.nim.camellia.redis.toolkit.lock.CamelliaRedisLock;
import com.netease.nim.camellia.redis.toolkit.lock.LockTaskResult;
import com.netease.nim.camellia.tools.executor.CamelliaScheduleExecutor;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CamelliaRedisLockManager {
    private static final int defaultPoolSize = Runtime.getRuntime().availableProcessors() * 4;
    private static final long defaultAcquireTimeoutMillis = 5000L;
    private static final long defaultExpireTimeoutMillis = 5000L;
    private final CamelliaScheduleExecutor scheduleExecutor;
    private final CamelliaRedisTemplate template;
    private final long acquireTimeoutMillis;
    private final long expireTimeoutMillis;
    private final ConcurrentHashMap<LockKey, LockInfo> lockInfoMap = new ConcurrentHashMap();
    private static final CamelliaRedisLockManager INSTANCE = new CamelliaRedisLockManager();

    public CamelliaRedisLockManager() {
        this(null, defaultPoolSize, 5000L, 5000L);
    }

    public CamelliaRedisLockManager(CamelliaRedisTemplate template) {
        this(template, defaultPoolSize, 5000L, 5000L);
    }

    public CamelliaRedisLockManager(int poolSize) {
        this(null, poolSize, 5000L, 5000L);
    }

    public CamelliaRedisLockManager(CamelliaRedisTemplate template, int poolSize) {
        this(template, poolSize, 5000L, 5000L);
    }

    public CamelliaRedisLockManager(CamelliaRedisTemplate template, int poolSize, long acquireTimeoutMillis, long expireTimeoutMillis) {
        this.template = template;
        this.scheduleExecutor = new CamelliaScheduleExecutor("camellia-redis-lock-manager", poolSize, 32768);
        this.acquireTimeoutMillis = acquireTimeoutMillis;
        this.expireTimeoutMillis = expireTimeoutMillis;
    }

    public static CamelliaRedisLockManager getInstance() {
        return INSTANCE;
    }

    public boolean lock(CamelliaRedisTemplate template, String lockKey) {
        return this.lock(template, new LockKey(lockKey), this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean lock(CamelliaRedisTemplate template, byte[] lockKey) {
        return this.lock(template, new LockKey(lockKey), this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean lock(CamelliaRedisTemplate template, String lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.lock(template, new LockKey(lockKey), acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean lock(CamelliaRedisTemplate template, byte[] lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.lock(template, new LockKey(lockKey), acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean lock(String lockKey) {
        return this.lock(this.template, new LockKey(lockKey), this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean lock(byte[] lockKey) {
        return this.lock(this.template, new LockKey(lockKey), this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean lock(String lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.lock(this.template, new LockKey(lockKey), acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean lock(byte[] lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.lock(this.template, new LockKey(lockKey), acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean tryLock(CamelliaRedisTemplate template, String lockKey) {
        return this.tryLock(template, new LockKey(lockKey), this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean tryLock(CamelliaRedisTemplate template, byte[] lockKey) {
        return this.tryLock(template, new LockKey(lockKey), this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean tryLock(CamelliaRedisTemplate template, String lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.tryLock(template, new LockKey(lockKey), acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean tryLock(CamelliaRedisTemplate template, byte[] lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.tryLock(template, new LockKey(lockKey), acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean tryLock(String lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.tryLock(this.template, new LockKey(lockKey), acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean tryLock(byte[] lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.tryLock(this.template, new LockKey(lockKey), acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean tryLock(String lockKey) {
        return this.tryLock(this.template, new LockKey(lockKey), this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean tryLock(byte[] lockKey) {
        return this.tryLock(this.template, new LockKey(lockKey), this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean tryLockAndRun(CamelliaRedisTemplate template, byte[] lockKey, Runnable runnable) {
        return this.tryLockAndRun(template, new LockKey(lockKey), runnable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean tryLockAndRun(CamelliaRedisTemplate template, String lockKey, Runnable runnable) {
        return this.tryLockAndRun(template, new LockKey(lockKey), runnable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean tryLockAndRun(CamelliaRedisTemplate template, byte[] lockKey, Runnable runnable, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.tryLockAndRun(template, new LockKey(lockKey), runnable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean tryLockAndRun(CamelliaRedisTemplate template, String lockKey, Runnable runnable, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.tryLockAndRun(template, new LockKey(lockKey), runnable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean tryLockAndRun(byte[] lockKey, Runnable runnable) {
        return this.tryLockAndRun(this.template, new LockKey(lockKey), runnable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean tryLockAndRun(String lockKey, Runnable runnable) {
        return this.tryLockAndRun(this.template, new LockKey(lockKey), runnable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean tryLockAndRun(byte[] lockKey, Runnable runnable, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.tryLockAndRun(this.template, new LockKey(lockKey), runnable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean tryLockAndRun(String lockKey, Runnable runnable, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.tryLockAndRun(this.template, new LockKey(lockKey), runnable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean lockAndRun(CamelliaRedisTemplate template, byte[] lockKey, Runnable runnable) {
        return this.lockAndRun(template, new LockKey(lockKey), runnable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean lockAndRun(CamelliaRedisTemplate template, String lockKey, Runnable runnable) {
        return this.lockAndRun(template, new LockKey(lockKey), runnable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean lockAndRun(CamelliaRedisTemplate template, byte[] lockKey, Runnable runnable, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.lockAndRun(template, new LockKey(lockKey), runnable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean lockAndRun(CamelliaRedisTemplate template, String lockKey, Runnable runnable, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.lockAndRun(template, new LockKey(lockKey), runnable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean lockAndRun(byte[] lockKey, Runnable runnable) {
        return this.lockAndRun(this.template, new LockKey(lockKey), runnable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean lockAndRun(String lockKey, Runnable runnable) {
        return this.lockAndRun(this.template, new LockKey(lockKey), runnable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public boolean lockAndRun(byte[] lockKey, Runnable runnable, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.lockAndRun(this.template, new LockKey(lockKey), runnable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean lockAndRun(String lockKey, Runnable runnable, long acquireTimeoutMillis, long expireTimeoutMillis) {
        return this.lockAndRun(this.template, new LockKey(lockKey), runnable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> lockAndRun(CamelliaRedisTemplate template, byte[] lockKey, Callable<T> callable) throws Exception {
        return this.lockAndRun(template, new LockKey(lockKey), callable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> lockAndRun(CamelliaRedisTemplate template, String lockKey, Callable<T> callable) throws Exception {
        return this.lockAndRun(template, new LockKey(lockKey), callable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> lockAndRun(CamelliaRedisTemplate template, byte[] lockKey, Callable<T> callable, long acquireTimeoutMillis, long expireTimeoutMillis) throws Exception {
        return this.lockAndRun(template, new LockKey(lockKey), callable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> lockAndRun(CamelliaRedisTemplate template, String lockKey, Callable<T> callable, long acquireTimeoutMillis, long expireTimeoutMillis) throws Exception {
        return this.lockAndRun(template, new LockKey(lockKey), callable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> lockAndRun(byte[] lockKey, Callable<T> callable) throws Exception {
        return this.lockAndRun(this.template, new LockKey(lockKey), callable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> lockAndRun(String lockKey, Callable<T> callable) throws Exception {
        return this.lockAndRun(this.template, new LockKey(lockKey), callable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> lockAndRun(byte[] lockKey, Callable<T> callable, long acquireTimeoutMillis, long expireTimeoutMillis) throws Exception {
        return this.lockAndRun(this.template, new LockKey(lockKey), callable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> lockAndRun(String lockKey, Callable<T> callable, long acquireTimeoutMillis, long expireTimeoutMillis) throws Exception {
        return this.lockAndRun(this.template, new LockKey(lockKey), callable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> tryLockAndRun(CamelliaRedisTemplate template, byte[] lockKey, Callable<T> callable) throws Exception {
        return this.tryLockAndRun(template, new LockKey(lockKey), callable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> tryLockAndRun(CamelliaRedisTemplate template, String lockKey, Callable<T> callable) throws Exception {
        return this.tryLockAndRun(template, new LockKey(lockKey), callable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> tryLockAndRun(CamelliaRedisTemplate template, byte[] lockKey, Callable<T> callable, long acquireTimeoutMillis, long expireTimeoutMillis) throws Exception {
        return this.tryLockAndRun(template, new LockKey(lockKey), callable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> tryLockAndRun(CamelliaRedisTemplate template, String lockKey, Callable<T> callable, long acquireTimeoutMillis, long expireTimeoutMillis) throws Exception {
        return this.tryLockAndRun(template, new LockKey(lockKey), callable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> tryLockAndRun(byte[] lockKey, Callable<T> callable) throws Exception {
        return this.tryLockAndRun(this.template, new LockKey(lockKey), callable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> tryLockAndRun(String lockKey, Callable<T> callable) throws Exception {
        return this.tryLockAndRun(this.template, new LockKey(lockKey), callable, this.acquireTimeoutMillis, this.expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> tryLockAndRun(byte[] lockKey, Callable<T> callable, long acquireTimeoutMillis, long expireTimeoutMillis) throws Exception {
        return this.tryLockAndRun(this.template, new LockKey(lockKey), callable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public <T> LockTaskResult<T> tryLockAndRun(String lockKey, Callable<T> callable, long acquireTimeoutMillis, long expireTimeoutMillis) throws Exception {
        return this.tryLockAndRun(this.template, new LockKey(lockKey), callable, acquireTimeoutMillis, expireTimeoutMillis);
    }

    public boolean release(String lockKey) {
        return this.release(new LockKey(lockKey));
    }

    public boolean release(byte[] lockKey) {
        return this.release(new LockKey(lockKey));
    }

    public boolean clear(String lockKey) {
        return this.clear(new LockKey(lockKey));
    }

    public boolean clear(byte[] lockKey) {
        return this.clear(new LockKey(lockKey));
    }

    public CamelliaRedisLock getLock(String lockKey) {
        return this.getLock(new LockKey(lockKey));
    }

    public CamelliaRedisLock getLock(byte[] lockKey) {
        return this.getLock(new LockKey(lockKey));
    }

    public void clearAll() {
        for (Map.Entry<LockKey, LockInfo> entry : this.lockInfoMap.entrySet()) {
            LockInfo lockInfo = entry.getValue();
            if (lockInfo.lock != null) {
                lockInfo.lock.release();
            }
            if (lockInfo.task == null) continue;
            lockInfo.task.cancel();
        }
        this.lockInfoMap.clear();
    }

    private boolean lock(CamelliaRedisTemplate template, LockKey lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        if (template == null) {
            throw new IllegalArgumentException("camellia redis template is null");
        }
        CamelliaRedisLock lock = CamelliaRedisLock.newLock(template, lockKey.getKey(), acquireTimeoutMillis, expireTimeoutMillis);
        boolean lockOk = lock.lock();
        if (lockOk) {
            CamelliaScheduleExecutor.Task task = this.scheduleExecutor.scheduleAtFixedRate(lock::renew, expireTimeoutMillis / 5L, expireTimeoutMillis / 5L, TimeUnit.MILLISECONDS);
            LockInfo oldLockInfo = this.lockInfoMap.put(lockKey, new LockInfo(lock, task));
            if (oldLockInfo != null) {
                if (oldLockInfo.lock != null) {
                    oldLockInfo.lock.release();
                }
                if (oldLockInfo.task != null) {
                    oldLockInfo.task.cancel();
                }
            }
        }
        return lockOk;
    }

    private boolean tryLock(CamelliaRedisTemplate template, LockKey lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        if (template == null) {
            throw new IllegalArgumentException("camellia redis template is null");
        }
        CamelliaRedisLock lock = CamelliaRedisLock.newLock(template, lockKey.getKey(), acquireTimeoutMillis, expireTimeoutMillis);
        boolean lockOk = lock.tryLock();
        if (lockOk) {
            CamelliaScheduleExecutor.Task task = this.scheduleExecutor.scheduleAtFixedRate(lock::renew, expireTimeoutMillis / 5L, expireTimeoutMillis / 5L, TimeUnit.MILLISECONDS);
            LockInfo oldLockInfo = this.lockInfoMap.put(lockKey, new LockInfo(lock, task));
            if (oldLockInfo != null) {
                if (oldLockInfo.lock != null) {
                    oldLockInfo.lock.release();
                }
                if (oldLockInfo.task != null) {
                    oldLockInfo.task.cancel();
                }
            }
        }
        return lockOk;
    }

    private CamelliaRedisLock getLock(LockKey lockKey) {
        LockInfo lockInfo = this.lockInfoMap.get(lockKey);
        if (lockInfo != null) {
            return lockInfo.lock;
        }
        return null;
    }

    private boolean release(LockKey lockKey) {
        LockInfo lockInfo = this.lockInfoMap.remove(lockKey);
        boolean result = false;
        if (lockInfo != null) {
            if (lockInfo.lock != null) {
                result = lockInfo.lock.release();
            }
            if (lockInfo.task != null) {
                lockInfo.task.cancel();
            }
        }
        return result;
    }

    private boolean clear(LockKey lockKey) {
        LockInfo lockInfo = this.lockInfoMap.remove(lockKey);
        boolean result = false;
        if (lockInfo != null) {
            if (lockInfo.lock != null) {
                result = lockInfo.lock.clear();
            }
            if (lockInfo.task != null) {
                lockInfo.task.cancel();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> LockTaskResult<T> tryLockAndRun(CamelliaRedisTemplate template, LockKey lockKey, Callable<T> callable, long acquireTimeoutMillis, long expireTimeoutMillis) throws Exception {
        boolean lock = this.tryLock(template, lockKey, acquireTimeoutMillis, expireTimeoutMillis);
        if (!lock) {
            return new LockTaskResult<Object>(false, null);
        }
        try {
            T result = callable.call();
            LockTaskResult<T> lockTaskResult = new LockTaskResult<T>(true, result);
            return lockTaskResult;
        }
        finally {
            this.release(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLockAndRun(CamelliaRedisTemplate template, LockKey lockKey, Runnable runnable, long acquireTimeoutMillis, long expireTimeoutMillis) {
        boolean lock = this.tryLock(template, lockKey, acquireTimeoutMillis, expireTimeoutMillis);
        if (!lock) {
            return false;
        }
        try {
            runnable.run();
            boolean bl = true;
            return bl;
        }
        finally {
            this.release(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> LockTaskResult<T> lockAndRun(CamelliaRedisTemplate template, LockKey lockKey, Callable<T> callable, long acquireTimeoutMillis, long expireTimeoutMillis) throws Exception {
        boolean lock = this.lock(template, lockKey, acquireTimeoutMillis, expireTimeoutMillis);
        if (!lock) {
            return new LockTaskResult<Object>(false, null);
        }
        try {
            T result = callable.call();
            LockTaskResult<T> lockTaskResult = new LockTaskResult<T>(true, result);
            return lockTaskResult;
        }
        finally {
            this.release(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockAndRun(CamelliaRedisTemplate template, LockKey lockKey, Runnable runnable, long acquireTimeoutMillis, long expireTimeoutMillis) {
        boolean lock = this.lock(template, lockKey, acquireTimeoutMillis, expireTimeoutMillis);
        if (!lock) {
            return false;
        }
        try {
            runnable.run();
            boolean bl = true;
            return bl;
        }
        finally {
            this.release(lockKey);
        }
    }

    private static class LockKey {
        private byte[] key;
        private int hashCode;

        public LockKey(byte[] key) {
            this.key = key;
        }

        public LockKey(String key) {
            this.key = key.getBytes(StandardCharsets.UTF_8);
        }

        public byte[] getKey() {
            return this.key;
        }

        public void setKey(byte[] key) {
            this.key = key;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LockKey lockKey = (LockKey)object;
            return Arrays.equals(this.key, lockKey.key);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = Arrays.hashCode(this.key);
            }
            return this.hashCode;
        }

        public String toString() {
            if (this.key == null) {
                return null;
            }
            return new String(this.key, StandardCharsets.UTF_8);
        }
    }

    private static class LockInfo {
        CamelliaRedisLock lock;
        CamelliaScheduleExecutor.Task task;

        public LockInfo(CamelliaRedisLock lock, CamelliaScheduleExecutor.Task task) {
            this.lock = lock;
            this.task = task;
        }
    }
}

