/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.toolkit.lock;

import com.netease.nim.camellia.redis.CamelliaRedisTemplate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelliaRedisReadWriteLock {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaRedisReadWriteLock.class);
    private static final int UN_LOCK = 0;
    private static final int READ_LOCK = 1;
    private static final int WRITE_LOCK = 2;
    private final CamelliaRedisTemplate template;
    private final byte[] lockKey;
    private final byte[] lockId;
    private final byte[] readKey;
    private final byte[] writeStatusKey;
    private final byte[] writePendingKey;
    private final long acquireTimeoutMillis;
    private final long expireTimeoutMillis;
    private final long tryLockIntervalMillis;
    private long expireTimestamp = -1L;
    private int status = 0;
    private final ReentrantLock lock = new ReentrantLock();
    private final byte[] readLockScript = "local arg = redis.call('exists', KEYS[2], KEYS[3]);\nif tonumber(arg) >= 1 then\n    return 1;\nend\nredis.call('hset', KEYS[1], ARGV[1], ARGV[2]);\nredis.call('pexpireat', KEYS[1], ARGV[2]);\nreturn 2;".getBytes(StandardCharsets.UTF_8);
    private final byte[] writeLockScript = "local arg = redis.call('exists', KEYS[1], KEYS[3]);\nif tonumber(arg) == 0 then\n    redis.call('psetex', KEYS[3], ARGV[2], ARGV[1]);\n    redis.call('hdel', KEYS[2], ARGV[1]);\n    return 2;\nend\nredis.call('hset', KEYS[2], ARGV[1], ARGV[3]);\nredis.call('pexpireat', KEYS[2], ARGV[3]);\nreturn 1;".getBytes(StandardCharsets.UTF_8);
    private static final byte[] writeLockReleaseScript = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end".getBytes(StandardCharsets.UTF_8);
    private static final byte[] clearExpiredKeysScript = "local arg = redis.call('hget', KEYS[1], ARGV[1]);\nif tonumber(arg) < tonumber(ARGV[2]) then\n    local ret = redis.call('hdel', KEYS[1], ARGV[1]);\n    return 1;\nend\nreturn 2;".getBytes(StandardCharsets.UTF_8);

    private CamelliaRedisReadWriteLock(CamelliaRedisTemplate template, byte[] lockKey, byte[] lockId, long acquireTimeoutMillis, long expireTimeoutMillis, long tryLockIntervalMillis) {
        this.template = template;
        this.lockKey = lockKey;
        this.lockId = lockId;
        this.acquireTimeoutMillis = acquireTimeoutMillis;
        this.expireTimeoutMillis = expireTimeoutMillis;
        this.tryLockIntervalMillis = tryLockIntervalMillis;
        byte[] prefix = this.merge("{".getBytes(StandardCharsets.UTF_8), lockKey);
        prefix = this.merge(prefix, "}".getBytes(StandardCharsets.UTF_8));
        this.readKey = this.merge(prefix, ":read".getBytes(StandardCharsets.UTF_8));
        this.writeStatusKey = this.merge(prefix, ":write".getBytes(StandardCharsets.UTF_8));
        this.writePendingKey = this.merge(prefix, ":write_pending".getBytes(StandardCharsets.UTF_8));
    }

    private byte[] merge(byte[] a, byte[] b) {
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static CamelliaRedisReadWriteLock newLock(CamelliaRedisTemplate template, String lockKey, long acquireTimeoutMillis, long expireTimeoutMillis) {
        byte[] lockId = UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
        return new CamelliaRedisReadWriteLock(template, lockKey.getBytes(StandardCharsets.UTF_8), lockId, acquireTimeoutMillis, expireTimeoutMillis, 5L);
    }

    public boolean isReadLockOk() {
        this.lock.lock();
        try {
            if (this.status == 1) {
                boolean lockOk;
                if (System.currentTimeMillis() < this.expireTimestamp) {
                    boolean bl = true;
                    return bl;
                }
                this.clearExpiredKeys();
                boolean bl = lockOk = this.template.hget(this.readKey, this.lockId) != null;
                if (!lockOk) {
                    this.status = 0;
                    this.expireTimestamp = -1L;
                }
                boolean bl2 = lockOk;
                return bl2;
            }
            boolean lockOk = false;
            return lockOk;
        }
        catch (Exception e) {
            logger.error("isReadLockOk error, lockKey = {}", (Object)new String(this.lockKey, StandardCharsets.UTF_8), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteLockOk() {
        this.lock.lock();
        try {
            if (this.status == 2) {
                boolean lockOk;
                if (System.currentTimeMillis() < this.expireTimestamp) {
                    boolean bl = true;
                    return bl;
                }
                this.clearExpiredKeys();
                byte[] bytes = this.template.get(this.writeStatusKey);
                boolean bl = lockOk = bytes != null && Arrays.equals(bytes, this.lockId);
                if (!lockOk) {
                    this.status = 0;
                    this.expireTimestamp = -1L;
                }
                boolean bl2 = lockOk;
                return bl2;
            }
            boolean bytes = false;
            return bytes;
        }
        catch (Exception e) {
            logger.error("isWriteLockOk error, lockKey = {}", (Object)new String(this.lockKey, StandardCharsets.UTF_8), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readLock() {
        long start = System.currentTimeMillis();
        if (this.isReadLockOk()) {
            return true;
        }
        if (this.isWriteLockOk()) {
            return true;
        }
        this.lock.lock();
        try {
            while (true) {
                this.clearExpiredKeys();
                long lockExpireTimestamp = System.currentTimeMillis() + this.expireTimeoutMillis;
                Object eval = this.template.eval(this.readLockScript, Arrays.asList(this.readKey, this.writePendingKey, this.writeStatusKey), Arrays.asList(this.lockId, String.valueOf(lockExpireTimestamp).getBytes(StandardCharsets.UTF_8)));
                boolean success = String.valueOf(eval).equals("2");
                if (success) {
                    this.status = 1;
                    this.expireTimestamp = lockExpireTimestamp;
                    boolean bl = true;
                    return bl;
                }
                if (System.currentTimeMillis() - start > this.acquireTimeoutMillis) {
                    boolean bl = false;
                    return bl;
                }
                TimeUnit.MILLISECONDS.sleep(this.tryLockIntervalMillis);
                continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error("READ lock error, lockKey = {}", (Object)new String(this.lockKey, StandardCharsets.UTF_8), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeLock() {
        long start = System.currentTimeMillis();
        if (this.isWriteLockOk()) {
            return true;
        }
        if (this.isReadLockOk()) {
            this.release();
        }
        this.lock.lock();
        try {
            while (true) {
                this.clearExpiredKeys();
                long lockExpireTimestamp = System.currentTimeMillis() + this.expireTimeoutMillis;
                Object eval = this.template.eval(this.writeLockScript, 3, (byte[][])new byte[][]{this.readKey, this.writePendingKey, this.writeStatusKey, this.lockId, String.valueOf(this.expireTimeoutMillis).getBytes(StandardCharsets.UTF_8), String.valueOf(lockExpireTimestamp).getBytes(StandardCharsets.UTF_8)});
                boolean success = String.valueOf(eval).equals("2");
                if (success) {
                    this.status = 2;
                    this.expireTimestamp = lockExpireTimestamp;
                    boolean bl = true;
                    return bl;
                }
                if (System.currentTimeMillis() - start > this.acquireTimeoutMillis) {
                    boolean bl = false;
                    return bl;
                }
                TimeUnit.MILLISECONDS.sleep(this.tryLockIntervalMillis);
                continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error("WRITE lock error, lockKey = {}", (Object)new String(this.lockKey, StandardCharsets.UTF_8), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean release() {
        this.lock.lock();
        try {
            this.clearExpiredKeys();
            if (this.status == 1) {
                Long hdel = this.template.hdel(this.readKey, (byte[][])new byte[][]{this.lockId});
                this.status = 0;
                boolean bl = hdel > 0L;
                return bl;
            }
            if (this.status == 2) {
                Object eval = this.template.eval(writeLockReleaseScript, 1, (byte[][])new byte[][]{this.writeStatusKey, this.lockId});
                if (eval != null && String.valueOf(eval).equals("1")) {
                    this.status = 0;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean eval = true;
            return eval;
        }
        catch (Exception e) {
            if (this.status == 1) {
                logger.error("release READ lock error, lockKey = {}", (Object)new String(this.lockKey, StandardCharsets.UTF_8), (Object)e);
            } else if (this.status == 2) {
                logger.error("release WRITE lock error, lockKey = {}", (Object)new String(this.lockKey, StandardCharsets.UTF_8), (Object)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean clear() {
        this.lock.lock();
        try {
            this.template.del((byte[][])new byte[][]{this.readKey, this.writePendingKey, this.writeStatusKey});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("clear lock error, lockKey = {}", (Object)new String(this.lockKey, StandardCharsets.UTF_8), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void clearExpiredKeys() {
        this.clearExpiredHashFields(this.readKey);
        this.clearExpiredHashFields(this.writePendingKey);
    }

    private void clearExpiredHashFields(byte[] key) {
        Map map = this.template.hgetAll(key);
        if (!map.isEmpty()) {
            ArrayList expiredFields = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                String string = new String((byte[])entry.getValue(), StandardCharsets.UTF_8);
                if (Long.parseLong(string) >= System.currentTimeMillis()) continue;
                expiredFields.add(entry.getKey());
            }
            if (!expiredFields.isEmpty()) {
                for (byte[] field : expiredFields) {
                    this.template.eval(clearExpiredKeysScript, 1, (byte[][])new byte[][]{key, field, String.valueOf(System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8)});
                }
            }
        }
    }
}

