/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.toolkit.mergetask;

import com.netease.nim.camellia.redis.toolkit.mergetask.CamelliaMergeTaskFuture;
import com.netease.nim.camellia.tools.executor.CamelliaThreadFactory;
import com.netease.nim.camellia.tools.utils.CamelliaMapUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelliaMergeTaskCache {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaMergeTaskCache.class);
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, CamelliaMergeTaskFuture<?>>> taskCache;
    private final Function<String, ConcurrentHashMap<String, CamelliaMergeTaskFuture<?>>> mappingFunction;
    private final ExecutorService exec = Executors.newSingleThreadExecutor((ThreadFactory)new CamelliaThreadFactory("camellia-merge-task-cache"));

    public CamelliaMergeTaskCache() {
        this.taskCache = new ConcurrentHashMap();
        this.mappingFunction = k -> new ConcurrentHashMap();
    }

    private ConcurrentHashMap<String, CamelliaMergeTaskFuture<?>> getTaskMap(String taskKey) {
        return (ConcurrentHashMap)CamelliaMapUtils.computeIfAbsent(this.taskCache, (Object)taskKey, this.mappingFunction);
    }

    public void addTask(String taskKey, String taskId, CamelliaMergeTaskFuture<?> future) {
        this.exec.submit(() -> {
            try {
                ConcurrentHashMap<String, CamelliaMergeTaskFuture<?>> map = this.getTaskMap(taskKey);
                map.put(taskId, future);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    public void removeTask(String taskKey, String taskId) {
        this.exec.submit(() -> {
            try {
                ConcurrentHashMap<String, CamelliaMergeTaskFuture<?>> map = this.taskCache.get(taskKey);
                if (map != null) {
                    map.remove(taskId);
                    if (map.isEmpty()) {
                        this.taskCache.remove(taskKey);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    public int size(String taskKey) {
        ConcurrentHashMap<String, CamelliaMergeTaskFuture<?>> map = this.taskCache.get(taskKey);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public Map<String, CamelliaMergeTaskFuture<?>> getFutureMap(String taskKey) {
        ConcurrentHashMap<String, CamelliaMergeTaskFuture<?>> map = this.taskCache.get(taskKey);
        if (map != null) {
            return new HashMap(map);
        }
        return null;
    }
}

