/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.toolkit.mergetask;

import com.netease.nim.camellia.core.util.CacheUtil;
import com.netease.nim.camellia.redis.CamelliaRedisTemplate;
import com.netease.nim.camellia.redis.toolkit.lock.CamelliaRedisLockManager;
import com.netease.nim.camellia.redis.toolkit.mergetask.CamelliaMergeTask;
import com.netease.nim.camellia.redis.toolkit.mergetask.CamelliaMergeTaskCache;
import com.netease.nim.camellia.redis.toolkit.mergetask.CamelliaMergeTaskFuture;
import com.netease.nim.camellia.redis.toolkit.mergetask.CamelliaMergeTaskKey;
import com.netease.nim.camellia.redis.toolkit.mergetask.CamelliaMergeTaskResult;
import com.netease.nim.camellia.redis.toolkit.mergetask.CamelliaMergeTaskResultSerializer;
import com.netease.nim.camellia.redis.toolkit.mergetask.CamelliaMergeTaskType;
import com.netease.nim.camellia.tools.cache.CamelliaLocalCache;
import com.netease.nim.camellia.tools.executor.CamelliaHashedExecutor;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelliaMergeTaskExecutor {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaMergeTaskExecutor.class);
    private final CamelliaHashedExecutor executor;
    private final CamelliaRedisTemplate template;
    private final CamelliaMergeTaskCache taskCache;
    private CamelliaRedisLockManager lockManager;
    private final CamelliaLocalCache resultCache;

    public CamelliaMergeTaskExecutor() {
        this((CamelliaRedisTemplate)null);
    }

    public CamelliaMergeTaskExecutor(CamelliaRedisTemplate template) {
        this(new CamelliaHashedExecutor("camellia-merge-task", Runtime.getRuntime().availableProcessors() * 4, 100000, (CamelliaHashedExecutor.RejectedExecutionHandler)new CamelliaHashedExecutor.CallerRunsPolicy()), template);
    }

    public CamelliaMergeTaskExecutor(CamelliaHashedExecutor executor) {
        this(executor, null);
    }

    public CamelliaMergeTaskExecutor(CamelliaHashedExecutor executor, CamelliaRedisTemplate template) {
        this(executor, template, 10000);
    }

    public CamelliaMergeTaskExecutor(CamelliaHashedExecutor executor, CamelliaRedisTemplate template, int resultCacheCapacity) {
        this.executor = executor;
        this.template = template;
        if (template != null) {
            this.lockManager = new CamelliaRedisLockManager(template);
        }
        this.taskCache = new CamelliaMergeTaskCache();
        this.resultCache = new CamelliaLocalCache(resultCacheCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <K extends CamelliaMergeTaskKey, V> CamelliaMergeTaskFuture<V> submit(CamelliaMergeTask<K, V> task) {
        CamelliaMergeTaskType type = task.getType();
        CamelliaMergeTaskResultSerializer<V> resultSerializer = task.getResultSerializer();
        if (resultSerializer == null) {
            throw new IllegalArgumentException("resultSerializer is null");
        }
        String taskId = UUID.randomUUID().toString();
        String taskKey = new String(this.taskKey(task), StandardCharsets.UTF_8);
        CamelliaMergeTaskFuture future = new CamelliaMergeTaskFuture(() -> this.taskCache.removeTask(taskKey, taskId));
        this.taskCache.addTask(taskKey, taskId, future);
        try {
            if (type == CamelliaMergeTaskType.STANDALONE) {
                V v = this.getLocalResultCache(task);
                if (v != null) {
                    future.complete(new CamelliaMergeTaskResult<V>(CamelliaMergeTaskResult.Type.LOCAL_CACHE_HIT_SYNC, v));
                    return future;
                }
                if (this.taskCache.size(taskKey) <= task.taskQueueSizeThreshold() && this.executor.getQueueSize(taskKey) <= task.executorQueueSizeThreshold()) {
                    this.executor.submit(taskKey, () -> {
                        if (future.isDone()) {
                            return;
                        }
                        Object result = null;
                        CamelliaMergeTaskResult.Type resultType = CamelliaMergeTaskResult.Type.LOCAL_CACHE_HIT_ASYNC;
                        try {
                            result = this.getLocalResultCache(task);
                            if (result == null) {
                                try {
                                    result = task.execute(task.getKey());
                                }
                                catch (Exception e) {
                                    future.completeExceptionally(e);
                                    if (result != null) {
                                        this.relatedTaskComplete(task, taskKey, result);
                                    }
                                    return;
                                }
                                resultType = CamelliaMergeTaskResult.Type.EXEC_ASYNC;
                                this.setLocalResultCache(task, result);
                            }
                            future.complete(new CamelliaMergeTaskResult<Object>(resultType, result));
                        }
                        catch (Exception e) {
                            logger.error("merge task execute error, tag = {}, key = {}", new Object[]{task.getTag(), task.getKey().serialize(), e});
                            if (result != null) {
                                future.complete(new CamelliaMergeTaskResult<Object>(resultType, result));
                            } else {
                                future.completeExceptionally(e);
                            }
                        }
                        finally {
                            if (result != null) {
                                this.relatedTaskComplete(task, taskKey, result);
                            }
                        }
                    });
                    return future;
                }
                try {
                    try {
                        v = task.execute(task.getKey());
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                        CamelliaMergeTaskFuture camelliaMergeTaskFuture = future;
                        if (v == null) return camelliaMergeTaskFuture;
                        this.relatedTaskComplete(task, taskKey, v);
                        return camelliaMergeTaskFuture;
                    }
                    this.setLocalResultCache(task, v);
                    future.complete(new CamelliaMergeTaskResult<V>(CamelliaMergeTaskResult.Type.EXEC_SYNC, v));
                    return future;
                }
                catch (Exception e) {
                    logger.error("merge task direct execute error, tag = {}, key = {}", new Object[]{task.getTag(), task.getKey().serialize(), e});
                    future.completeExceptionally(e);
                    return future;
                }
                finally {
                    if (v != null) {
                        this.relatedTaskComplete(task, taskKey, v);
                    }
                }
            }
            if (type != CamelliaMergeTaskType.CLUSTER) throw new IllegalArgumentException("unknown merge task type = " + (Object)((Object)type));
            if (this.template == null) {
                throw new IllegalArgumentException("redis template is null");
            }
            CamelliaMergeTaskResult.Type resultType = CamelliaMergeTaskResult.Type.LOCAL_CACHE_HIT_SYNC;
            V v = this.getLocalResultCache(task);
            if (v == null) {
                v = this.getRedisResultCache(task);
                resultType = CamelliaMergeTaskResult.Type.REDIS_CACHE_HIT_SYNC;
            }
            if (v != null) {
                future.complete(new CamelliaMergeTaskResult<V>(resultType, v));
                return future;
            }
            if (this.taskCache.size(taskKey) <= task.taskQueueSizeThreshold() && this.executor.getQueueSize(taskKey) <= task.executorQueueSizeThreshold()) {
                this.executor.submit(taskKey, () -> {
                    if (future.isDone()) {
                        return;
                    }
                    Object result = null;
                    CamelliaMergeTaskResult.Type resultType1 = CamelliaMergeTaskResult.Type.LOCAL_CACHE_HIT_ASYNC;
                    try {
                        block20: {
                            result = this.getLocalResultCache(task);
                            if (result == null) {
                                result = this.getRedisResultCache(task);
                                resultType1 = CamelliaMergeTaskResult.Type.REDIS_CACHE_HIT_ASYNC;
                            }
                            if (result == null) {
                                byte[] lockKey = this.lockKey(task);
                                boolean lockOk = this.lockManager.lock(lockKey, task.lockTimeoutMillis(), task.lockTimeoutMillis());
                                if (!lockOk) {
                                    logger.warn("try lock fail after {}ms, merge task with tag = {}, taskKey = {} will execute direct", new Object[]{task.lockTimeoutMillis(), task.getTag(), task.getKey().serialize()});
                                }
                                try {
                                    result = this.getRedisResultCache(task);
                                    if (result != null) break block20;
                                    try {
                                        result = task.execute(task.getKey());
                                    }
                                    catch (Exception e) {
                                        future.completeExceptionally(e);
                                        this.lockManager.release(lockKey);
                                        if (result != null) {
                                            this.relatedTaskComplete(task, taskKey, result);
                                        }
                                        return;
                                    }
                                    resultType1 = CamelliaMergeTaskResult.Type.EXEC_ASYNC;
                                    this.setLocalResultCache(task, result);
                                    this.setRedisResultCache(task, result);
                                }
                                finally {
                                    this.lockManager.release(lockKey);
                                }
                            }
                        }
                        future.complete(new CamelliaMergeTaskResult<Object>(resultType1, result));
                    }
                    catch (Exception e) {
                        logger.error("merge task execute error, tag = {}, key = {}", new Object[]{task, task.getKey().serialize(), e});
                        if (result != null) {
                            future.complete(new CamelliaMergeTaskResult<Object>(resultType1, result));
                        } else {
                            future.completeExceptionally(e);
                        }
                    }
                    finally {
                        if (result != null) {
                            this.relatedTaskComplete(task, taskKey, result);
                        }
                    }
                });
                return future;
            }
            try {
                try {
                    v = task.execute(task.getKey());
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                    CamelliaMergeTaskFuture camelliaMergeTaskFuture = future;
                    if (v == null) return camelliaMergeTaskFuture;
                    this.relatedTaskComplete(task, taskKey, v);
                    return camelliaMergeTaskFuture;
                }
                this.setLocalResultCache(task, v);
                this.setRedisResultCache(task, v);
                future.complete(new CamelliaMergeTaskResult<V>(CamelliaMergeTaskResult.Type.EXEC_SYNC, v));
                return future;
            }
            catch (Exception e) {
                logger.error("merge task execute error, tag = {}, key = {}", new Object[]{task.getTag(), task.getKey().serialize(), e});
                future.completeExceptionally(e);
                return future;
            }
            finally {
                if (v != null) {
                    this.relatedTaskComplete(task, taskKey, v);
                }
            }
        }
        catch (Throwable e) {
            future.completeExceptionally(e);
            logger.error("merge task execute error, tag = {}, key = {}", new Object[]{task, task.getKey().serialize(), e});
        }
        return future;
    }

    private <K extends CamelliaMergeTaskKey, V> V getLocalResultCache(CamelliaMergeTask<K, V> task) {
        if (task.resultCacheMillis() <= 0L) {
            return null;
        }
        V result = null;
        try {
            byte[] value = (byte[])this.resultCache.get(task.getTag(), (Object)task.getKey().serialize(), byte[].class);
            if (value != null) {
                result = task.getResultSerializer().deserialize(value);
            }
        }
        catch (Exception e) {
            logger.error("merge task get local cache result error, tag = {}, key = {}", task, (Object)task.getKey().serialize());
        }
        return result;
    }

    private <K extends CamelliaMergeTaskKey, V> void setLocalResultCache(CamelliaMergeTask<K, V> task, V result) {
        this._setLocalResultCache(task, result, task.resultCacheMillis());
    }

    private <K extends CamelliaMergeTaskKey, V> void _setLocalResultCache(CamelliaMergeTask<K, V> task, V result, long expireMillis) {
        if (expireMillis <= 0L) {
            return;
        }
        byte[] data = task.getResultSerializer().serialize(result);
        this.resultCache.put(task.getTag(), (Object)task.getKey().serialize(), (Object)data, expireMillis);
    }

    private <K extends CamelliaMergeTaskKey, V> byte[] taskKey(CamelliaMergeTask<K, V> task) {
        return CacheUtil.buildCacheKey((String)task.getTag(), (Object[])new Object[]{task.getKey().serialize()}).getBytes(StandardCharsets.UTF_8);
    }

    private <K extends CamelliaMergeTaskKey, V> byte[] lockKey(CamelliaMergeTask<K, V> task) {
        return CacheUtil.buildCacheKey((String)task.getTag(), (Object[])new Object[]{task.getKey().serialize(), "~lock"}).getBytes(StandardCharsets.UTF_8);
    }

    private <K extends CamelliaMergeTaskKey, V> V getRedisResultCache(CamelliaMergeTask<K, V> task) {
        Long pttl;
        if (task.resultCacheMillis() <= 0L) {
            return null;
        }
        byte[] value = null;
        try {
            value = this.template.get(this.taskKey(task));
        }
        catch (Exception e) {
            logger.error("merge task get redis cache result error, tag = {}, key = {}", task, (Object)task.getKey().serialize());
        }
        V result = null;
        if (value != null) {
            try {
                result = task.getResultSerializer().deserialize(value);
            }
            catch (Exception e) {
                logger.error("merge task deserialize redis cache result error, tag = {}, key = {}", task, (Object)task.getKey().serialize());
            }
        }
        if (result != null && (pttl = this.template.pttl(this.taskKey(task))) > 0L) {
            this._setLocalResultCache(task, result, pttl);
        }
        return result;
    }

    private <K extends CamelliaMergeTaskKey, V> void setRedisResultCache(CamelliaMergeTask<K, V> task, V result) {
        try {
            if (task.resultCacheMillis() <= 0L) {
                return;
            }
            byte[] serialize = task.getResultSerializer().serialize(result);
            this.template.psetex(this.taskKey(task), task.resultCacheMillis(), serialize);
        }
        catch (Exception e) {
            logger.error("merge task set redis cache result error, tag = {}, key = {}", task, (Object)task.getKey().serialize());
        }
    }

    private <K extends CamelliaMergeTaskKey, V> void relatedTaskComplete(CamelliaMergeTask<K, V> task, String taskKey, V result) {
        Map<String, CamelliaMergeTaskFuture<?>> map = this.taskCache.getFutureMap(taskKey);
        if (map != null && !map.isEmpty()) {
            byte[] data = task.getResultSerializer().serialize(result);
            for (Map.Entry<String, CamelliaMergeTaskFuture<?>> entry : map.entrySet()) {
                entry.getValue().complete(new CamelliaMergeTaskResult<V>(CamelliaMergeTaskResult.Type.COMPLETE_BY_RELATED_TASK_DIRECT, task.getResultSerializer().deserialize(data)));
            }
        }
    }
}

