/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.toolkit.mergetask;

import com.netease.nim.camellia.redis.toolkit.mergetask.CamelliaMergeTaskResult;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelliaMergeTaskFuture<V>
extends CompletableFuture<CamelliaMergeTaskResult<V>> {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaMergeTaskFuture.class);
    private final AtomicBoolean done = new AtomicBoolean(false);
    private Runnable callback;

    public CamelliaMergeTaskFuture() {
    }

    public CamelliaMergeTaskFuture(Runnable callback) {
        this.callback = callback;
    }

    @Override
    public boolean complete(CamelliaMergeTaskResult<V> value) {
        if (this.done.compareAndSet(false, true)) {
            if (this.callback != null) {
                try {
                    this.callback.run();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return super.complete(value);
        }
        return false;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        if (this.done.compareAndSet(false, true)) {
            if (this.callback != null) {
                try {
                    this.callback.run();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return super.completeExceptionally(ex);
        }
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }
}

