/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis;

import com.alibaba.fastjson.JSONObject;
import com.netease.nim.camellia.core.client.annotation.ReadOp;
import com.netease.nim.camellia.core.client.annotation.ShardingParam;
import com.netease.nim.camellia.core.client.annotation.WriteOp;
import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.CamelliaRedisEnv;
import com.netease.nim.camellia.redis.ICamelliaRedis;
import com.netease.nim.camellia.redis.base.exception.CamelliaRedisException;
import com.netease.nim.camellia.redis.base.utils.LogUtil;
import com.netease.nim.camellia.redis.intercept.InterceptContext;
import com.netease.nim.camellia.redis.intercept.RedisInterceptor;
import com.netease.nim.camellia.redis.resource.ResourceWrapper;
import com.netease.nim.camellia.redis.util.CamelliaRedisInitializer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;

public class CamelliaRedisImpl
implements ICamelliaRedis {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaRedisImpl.class);
    private Resource resource;
    private ICamelliaRedis redis;
    private List<RedisInterceptor> interceptorList;

    public CamelliaRedisImpl(Resource resource) {
        if (resource == null) {
            return;
        }
        this.resource = resource;
        if (!(resource instanceof ResourceWrapper)) {
            throw new IllegalArgumentException("not ResourceWrapper");
        }
        CamelliaRedisEnv env = ((ResourceWrapper)resource).getEnv();
        this.interceptorList = env.getInterceptorList();
        this.redis = CamelliaRedisInitializer.init(resource, env);
    }

    @Override
    public List<Jedis> getJedisList() {
        return this.redis.getJedisList();
    }

    @Override
    public Jedis getJedis(byte[] key) {
        return this.redis.getJedis(key);
    }

    private boolean interceptEnable() {
        return this.interceptorList != null && !this.interceptorList.isEmpty();
    }

    private void before(String key, String command) {
        if (!this.interceptEnable()) {
            return;
        }
        if (key == null) {
            return;
        }
        InterceptContext context = new InterceptContext(this.resource, key.getBytes(StandardCharsets.UTF_8), command, false);
        for (RedisInterceptor interceptor : this.interceptorList) {
            try {
                interceptor.before(context);
            }
            catch (Exception e) {
                logger.error("interceptor before error, context = {}", (Object)JSONObject.toJSONString((Object)context), (Object)e);
            }
        }
    }

    private void before(byte[] key, String command) {
        if (!this.interceptEnable()) {
            return;
        }
        if (key == null) {
            return;
        }
        InterceptContext context = new InterceptContext(this.resource, key, command, false);
        for (RedisInterceptor interceptor : this.interceptorList) {
            try {
                interceptor.before(context);
            }
            catch (Exception e) {
                logger.error("interceptor before error, context = {}", (Object)JSONObject.toJSONString((Object)context), (Object)e);
            }
        }
    }

    private void after(String key, String command) {
        if (!this.interceptEnable()) {
            return;
        }
        if (key == null) {
            return;
        }
        InterceptContext context = new InterceptContext(this.resource, key.getBytes(StandardCharsets.UTF_8), command, false);
        for (RedisInterceptor interceptor : this.interceptorList) {
            try {
                interceptor.after(context);
            }
            catch (Exception e) {
                logger.error("interceptor after error, context = {}", (Object)JSONObject.toJSONString((Object)context), (Object)e);
            }
        }
    }

    private void after(byte[] key, String command) {
        if (!this.interceptEnable()) {
            return;
        }
        if (key == null) {
            return;
        }
        InterceptContext context = new InterceptContext(this.resource, key, command, false);
        for (RedisInterceptor interceptor : this.interceptorList) {
            try {
                interceptor.after(context);
            }
            catch (Exception e) {
                logger.error("interceptor after error, context = {}", (Object)JSONObject.toJSONString((Object)context), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String set(@ShardingParam byte[] key, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "set(byte[] key, byte[] value)";
        this.before(key, command);
        try {
            String string = this.redis.set(key, value);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public byte[] get(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "get(byte[] key)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.get(key);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String set(@ShardingParam String key, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "set(String key, String value)";
        this.before(key, command);
        try {
            String string = this.redis.set(key, value);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String get(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "get(String key)";
        this.before(key, command);
        try {
            String string = this.redis.get(key);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Boolean exists(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "exists(String key)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.exists(key);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long persist(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "persist(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.persist(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String type(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "type(String key)";
        this.before(key, command);
        try {
            String string = this.redis.type(key);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long expire(@ShardingParam String key, int seconds) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "expire(String key, int seconds)";
        this.before(key, command);
        try {
            Long l = this.redis.expire(key, seconds);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long pexpire(@ShardingParam String key, long milliseconds) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "pexpire(String key, long milliseconds)";
        this.before(key, command);
        try {
            Long l = this.redis.pexpire(key, milliseconds);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long expireAt(@ShardingParam String key, long unixTime) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "expireAt(String key, long unixTime)";
        this.before(key, command);
        try {
            Long l = this.redis.expireAt(key, unixTime);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long pexpireAt(@ShardingParam String key, long millisecondsTimestamp) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "pexpireAt(String key, long millisecondsTimestamp)";
        this.before(key, command);
        try {
            Long l = this.redis.pexpireAt(key, millisecondsTimestamp);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long ttl(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "ttl(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.ttl(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long pttl(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "pttl(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.pttl(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Boolean setbit(@ShardingParam String key, long offset, boolean value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "setbit(String key, long offset, boolean value)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.setbit(key, offset, value);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Boolean setbit(@ShardingParam String key, long offset, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "setbit(String key, long offset, String value)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.setbit(key, offset, value);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Boolean getbit(@ShardingParam String key, long offset) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "getbit(String key, long offset)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.getbit(key, offset);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long setrange(@ShardingParam String key, long offset, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "setrange(String key, long offset, String value)";
        this.before(key, command);
        try {
            Long l = this.redis.setrange(key, offset, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String getrange(@ShardingParam String key, long startOffset, long endOffset) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "getrange(String key, long startOffset, long endOffset)";
        this.before(key, command);
        try {
            String string = this.redis.getrange(key, startOffset, endOffset);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String getSet(@ShardingParam String key, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "getSet(String key, String value)";
        this.before(key, command);
        try {
            String string = this.redis.getSet(key, value);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long setnx(@ShardingParam String key, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "setnx(String key, String value)";
        this.before(key, command);
        try {
            Long l = this.redis.setnx(key, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String setex(@ShardingParam String key, int seconds, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "setex(String key, int seconds, String value)";
        this.before(key, command);
        try {
            String string = this.redis.setex(key, seconds, value);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String psetex(@ShardingParam String key, long milliseconds, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "psetex(String key, long milliseconds, String value)";
        this.before(key, command);
        try {
            String string = this.redis.psetex(key, milliseconds, value);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long decrBy(@ShardingParam String key, long integer) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "decrBy(String key, long integer)";
        this.before(key, command);
        try {
            Long l = this.redis.decrBy(key, integer);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long decr(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "decr(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.decr(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long incrBy(@ShardingParam String key, long integer) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "incrBy(String key, long integer)";
        this.before(key, command);
        try {
            Long l = this.redis.incrBy(key, integer);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Double incrByFloat(@ShardingParam String key, double value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "incrByFloat(String key, double value)";
        this.before(key, command);
        try {
            Double d = this.redis.incrByFloat(key, value);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long incr(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "incr(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.incr(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long append(@ShardingParam String key, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "append(String key, String value)";
        this.before(key, command);
        try {
            Long l = this.redis.append(key, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String substr(@ShardingParam String key, int start, int end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "substr(String key, int start, int end)";
        this.before(key, command);
        try {
            String string = this.redis.substr(key, start, end);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long hset(@ShardingParam String key, String field, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hset(String key, String field, String value)";
        this.before(key, command);
        try {
            Long l = this.redis.hset(key, field, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String hget(@ShardingParam String key, String field) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hget(String key, String field)";
        this.before(key, command);
        try {
            String string = this.redis.hget(key, field);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long hsetnx(@ShardingParam String key, String field, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hsetnx(String key, String field, String value)";
        this.before(key, command);
        try {
            Long l = this.redis.hsetnx(key, field, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String hmset(@ShardingParam String key, Map<String, String> hash) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hmset(String key, Map<String, String> hash)";
        this.before(key, command);
        try {
            String string = this.redis.hmset(key, hash);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<String> hmget(@ShardingParam String key, String ... fields) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hmget(String key, String... fields)";
        this.before(key, command);
        try {
            List<String> list = this.redis.hmget(key, fields);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long hincrBy(@ShardingParam String key, String field, long value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hincrBy(String key, String field, long value)";
        this.before(key, command);
        try {
            Long l = this.redis.hincrBy(key, field, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Double hincrByFloat(@ShardingParam String key, String field, double value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hincrByFloat(String key, String field, double value)";
        this.before(key, command);
        try {
            Double d = this.redis.hincrByFloat(key, field, value);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Boolean hexists(@ShardingParam String key, String field) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hexists(String key, String field)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.hexists(key, field);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long hdel(@ShardingParam String key, String ... field) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hdel(String key, String... field)";
        this.before(key, command);
        try {
            Long l = this.redis.hdel(key, field);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long hlen(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hlen(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.hlen(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> hkeys(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hkeys(String key)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.hkeys(key);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<String> hvals(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hvals(String key)";
        this.before(key, command);
        try {
            List<String> list = this.redis.hvals(key);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Map<String, String> hgetAll(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hgetAll(String key)";
        this.before(key, command);
        try {
            Map<String, String> map = this.redis.hgetAll(key);
            return map;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long rpush(@ShardingParam String key, String ... string) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "rpush(String key, String... string)";
        this.before(key, command);
        try {
            Long l = this.redis.rpush(key, string);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long lpush(@ShardingParam String key, String ... string) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lpush(String key, String... string)";
        this.before(key, command);
        try {
            Long l = this.redis.lpush(key, string);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long llen(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "llen(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.llen(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<String> lrange(@ShardingParam String key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lrange(String key, long start, long end)";
        this.before(key, command);
        try {
            List<String> list = this.redis.lrange(key, start, end);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String ltrim(@ShardingParam String key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "ltrim(String key, long start, long end)";
        this.before(key, command);
        try {
            String string = this.redis.ltrim(key, start, end);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String lindex(@ShardingParam String key, long index) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lindex(String key, long index)";
        this.before(key, command);
        try {
            String string = this.redis.lindex(key, index);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String lset(@ShardingParam String key, long index, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lset(String key, long index, String value)";
        this.before(key, command);
        try {
            String string = this.redis.lset(key, index, value);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long lrem(@ShardingParam String key, long count, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lrem(String key, long count, String value)";
        this.before(key, command);
        try {
            Long l = this.redis.lrem(key, count, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String lpop(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lpop(String key)";
        this.before(key, command);
        try {
            String string = this.redis.lpop(key);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String rpop(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "rpop(String key)";
        this.before(key, command);
        try {
            String string = this.redis.rpop(key);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long sadd(@ShardingParam String key, String ... member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "sadd(String key, String... member)";
        this.before(key, command);
        try {
            Long l = this.redis.sadd(key, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> smembers(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "smembers(String key)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.smembers(key);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long srem(@ShardingParam String key, String ... member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "srem(String key, String... member)";
        this.before(key, command);
        try {
            Long l = this.redis.srem(key, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String spop(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "spop(String key)";
        this.before(key, command);
        try {
            String string = this.redis.spop(key);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Set<String> spop(@ShardingParam String key, long count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "spop(String key, long count)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.spop(key, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long scard(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "scard(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.scard(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Boolean sismember(@ShardingParam String key, String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "sismember(String key, String member)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.sismember(key, member);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String srandmember(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "srandmember(String key)";
        this.before(key, command);
        try {
            String string = this.redis.srandmember(key);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<String> srandmember(@ShardingParam String key, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "srandmember(String key, int count)";
        this.before(key, command);
        try {
            List<String> list = this.redis.srandmember(key, count);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long strlen(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "strlen(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.strlen(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zadd(@ShardingParam String key, double score, String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zadd(String key, double score, String member)";
        this.before(key, command);
        try {
            Long l = this.redis.zadd(key, score, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zadd(@ShardingParam String key, double score, String member, ZAddParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zadd(String key, double score, String member, ZAddParams params)";
        this.before(key, command);
        try {
            Long l = this.redis.zadd(key, score, member, params);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zadd(@ShardingParam String key, Map<String, Double> scoreMembers) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zadd(String key, Map<String, Double> scoreMembers)";
        this.before(key, command);
        try {
            Long l = this.redis.zadd(key, scoreMembers);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zadd(@ShardingParam String key, Map<String, Double> scoreMembers, ZAddParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zadd(String key, Map<String, Double> scoreMembers, ZAddParams params)";
        this.before(key, command);
        try {
            Long l = this.redis.zadd(key, scoreMembers, params);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrange(@ShardingParam String key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrange(String key, long start, long end)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrange(key, start, end);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zrem(@ShardingParam String key, String ... member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrem(String key, String... member)";
        this.before(key, command);
        try {
            Long l = this.redis.zrem(key, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Double zincrby(@ShardingParam String key, double score, String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zincrby(String key, double score, String member)";
        this.before(key, command);
        try {
            Double d = this.redis.zincrby(key, score, member);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Double zincrby(@ShardingParam String key, double score, String member, ZIncrByParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zincrby(String key, double score, String member, ZIncrByParams params)";
        this.before(key, command);
        try {
            Double d = this.redis.zincrby(key, score, member, params);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zrank(@ShardingParam String key, String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrank(String key, String member)";
        this.before(key, command);
        try {
            Long l = this.redis.zrank(key, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zrevrank(@ShardingParam String key, String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrank(String key, String member)";
        this.before(key, command);
        try {
            Long l = this.redis.zrevrank(key, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrevrange(@ShardingParam String key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrange(String key, long start, long end)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrevrange(key, start, end);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrangeWithScores(@ShardingParam String key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeWithScores(String key, long start, long end)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrangeWithScores(key, start, end);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrevrangeWithScores(@ShardingParam String key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeWithScores(String key, long start, long end)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrevrangeWithScores(key, start, end);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zcard(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zcard(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.zcard(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Double zscore(@ShardingParam String key, String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zscore(String key, String member)";
        this.before(key, command);
        try {
            Double d = this.redis.zscore(key, member);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<String> sort(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "sort(String key)";
        this.before(key, command);
        try {
            List<String> list = this.redis.sort(key);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<String> sort(@ShardingParam String key, SortingParams sortingParameters) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "sort(String key, SortingParams sortingParameters)";
        this.before(key, command);
        try {
            List<String> list = this.redis.sort(key, sortingParameters);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zcount(@ShardingParam String key, double min, double max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zcount(String key, double min, double max)";
        this.before(key, command);
        try {
            Long l = this.redis.zcount(key, min, max);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zcount(@ShardingParam String key, String min, String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zcount(String key, String min, String max)";
        this.before(key, command);
        try {
            Long l = this.redis.zcount(key, min, max);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrangeByScore(@ShardingParam String key, double min, double max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScore(String key, double min, double max)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrangeByScore(key, min, max);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrangeByScore(@ShardingParam String key, String min, String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScore(String key, String min, String max)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrangeByScore(key, min, max);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrevrangeByScore(@ShardingParam String key, double max, double min) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScore(String key, double max, double min)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrevrangeByScore(key, max, min);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrangeByScore(@ShardingParam String key, double min, double max, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScore(String key, double min, double max, int offset, int count)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrevrangeByScore(@ShardingParam String key, String max, String min) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScore(String key, String max, String min)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrevrangeByScore(key, max, min);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrangeByScore(@ShardingParam String key, String min, String max, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScore(String key, String min, String max, int offset, int count)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrevrangeByScore(@ShardingParam String key, double max, double min, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScore(String key, double max, double min, int offset, int count)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrangeByScoreWithScores(@ShardingParam String key, double min, double max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScoreWithScores(String key, double min, double max)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrevrangeByScoreWithScores(@ShardingParam String key, double max, double min) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScoreWithScores(String key, double max, double min)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrangeByScoreWithScores(@ShardingParam String key, double min, double max, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScoreWithScores(String key, double min, double max, int offset, int count)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrevrangeByScore(@ShardingParam String key, String max, String min, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScore(String key, String max, String min, int offset, int count)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrangeByScoreWithScores(@ShardingParam String key, String min, String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScoreWithScores(String key, String min, String max)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrevrangeByScoreWithScores(@ShardingParam String key, String max, String min) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScoreWithScores(String key, String max, String min)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrangeByScoreWithScores(@ShardingParam String key, String min, String max, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScoreWithScores(String key, String min, String max, int offset, int count)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrevrangeByScoreWithScores(@ShardingParam String key, double max, double min, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrevrangeByScoreWithScores(@ShardingParam String key, String max, String min, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zremrangeByRank(@ShardingParam String key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zremrangeByRank(String key, long start, long end)";
        this.before(key, command);
        try {
            Long l = this.redis.zremrangeByRank(key, start, end);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zremrangeByScore(@ShardingParam String key, double start, double end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zremrangeByScore(String key, double start, double end)";
        this.before(key, command);
        try {
            Long l = this.redis.zremrangeByScore(key, start, end);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zremrangeByScore(@ShardingParam String key, String start, String end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zremrangeByScore(String key, String start, String end)";
        this.before(key, command);
        try {
            Long l = this.redis.zremrangeByScore(key, start, end);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zlexcount(@ShardingParam String key, String min, String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zlexcount(String key, String min, String max)";
        this.before(key, command);
        try {
            Long l = this.redis.zlexcount(key, min, max);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrangeByLex(@ShardingParam String key, String min, String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByLex(String key, String min, String max)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrangeByLex(key, min, max);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrangeByLex(@ShardingParam String key, String min, String max, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByLex(String key, String min, String max, int offset, int count)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrangeByLex(key, min, max, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrevrangeByLex(@ShardingParam String key, String max, String min) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByLex(String key, String max, String min)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrevrangeByLex(key, max, min);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<String> zrevrangeByLex(@ShardingParam String key, String max, String min, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByLex(String key, String max, String min, int offset, int count)";
        this.before(key, command);
        try {
            Set<String> set = this.redis.zrevrangeByLex(key, max, min, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zremrangeByLex(@ShardingParam String key, String min, String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zremrangeByLex(String key, String min, String max)";
        this.before(key, command);
        try {
            Long l = this.redis.zremrangeByLex(key, min, max);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long linsert(@ShardingParam String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value)";
        this.before(key, command);
        try {
            Long l = this.redis.linsert(key, where, pivot, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long lpushx(@ShardingParam String key, String ... string) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lpushx(String key, String... string)";
        this.before(key, command);
        try {
            Long l = this.redis.lpushx(key, string);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long rpushx(@ShardingParam String key, String ... string) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "rpushx(String key, String... string)";
        this.before(key, command);
        try {
            Long l = this.redis.rpushx(key, string);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long del(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "del(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.del(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String echo(@ShardingParam String string) {
        LogUtil.debugLog((Resource)this.resource, (String)string);
        String command = "echo(String string)";
        this.before(string, command);
        try {
            String string2 = this.redis.echo(string);
            return string2;
        }
        finally {
            this.after(string, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long bitcount(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "bitcount(String key)";
        this.before(key, command);
        try {
            Long l = this.redis.bitcount(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long bitcount(@ShardingParam String key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "bitcount(String key, long start, long end)";
        this.before(key, command);
        try {
            Long l = this.redis.bitcount(key, start, end);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long bitpos(@ShardingParam String key, boolean value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "bitpos(String key, boolean value)";
        this.before(key, command);
        try {
            Long l = this.redis.bitpos(key, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long bitpos(@ShardingParam String key, boolean value, BitPosParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "bitpos(String key, boolean value, BitPosParams params)";
        this.before(key, command);
        try {
            Long l = this.redis.bitpos(key, value, params);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long bitpos(@ShardingParam byte[] key, boolean value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "bitpos(byte[] key, boolean value)";
        this.before(key, command);
        try {
            Long l = this.redis.bitpos(key, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long bitpos(@ShardingParam byte[] key, boolean value, BitPosParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "bitpos(byte[] key, boolean value, BitPosParams params)";
        this.before(key, command);
        try {
            Long l = this.redis.bitpos(key, value, params);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<Map.Entry<String, String>> hscan(@ShardingParam String key, String cursor) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hscan(String key, String cursor)";
        this.before(key, command);
        try {
            ScanResult<Map.Entry<String, String>> scanResult = this.redis.hscan(key, cursor);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<Map.Entry<String, String>> hscan(@ShardingParam String key, String cursor, ScanParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hscan(String key, String cursor, ScanParams params)";
        this.before(key, command);
        try {
            ScanResult<Map.Entry<String, String>> scanResult = this.redis.hscan(key, cursor, params);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<String> sscan(@ShardingParam String key, String cursor) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "sscan(String key, String cursor)";
        this.before(key, command);
        try {
            ScanResult<String> scanResult = this.redis.sscan(key, cursor);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<String> sscan(@ShardingParam String key, String cursor, ScanParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "sscan(String key, String cursor, ScanParams params)";
        this.before(key, command);
        try {
            ScanResult<String> scanResult = this.redis.sscan(key, cursor, params);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<Tuple> zscan(@ShardingParam String key, String cursor) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zscan(String key, String cursor)";
        this.before(key, command);
        try {
            ScanResult<Tuple> scanResult = this.redis.zscan(key, cursor);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<Tuple> zscan(@ShardingParam String key, String cursor, ScanParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zscan(String key, String cursor, ScanParams params)";
        this.before(key, command);
        try {
            ScanResult<Tuple> scanResult = this.redis.zscan(key, cursor, params);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long pfadd(@ShardingParam String key, String ... elements) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "pfadd(String key, String... elements)";
        this.before(key, command);
        try {
            Long l = this.redis.pfadd(key, elements);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public long pfcount(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "pfcount(String key)";
        this.before(key, command);
        try {
            long l = this.redis.pfcount(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long geoadd(@ShardingParam String key, double longitude, double latitude, String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geoadd(String key, double longitude, double latitude, String member)";
        this.before(key, command);
        try {
            Long l = this.redis.geoadd(key, longitude, latitude, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long geoadd(@ShardingParam String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap)";
        this.before(key, command);
        try {
            Long l = this.redis.geoadd(key, memberCoordinateMap);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Double geodist(@ShardingParam String key, String member1, String member2) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geodist(String key, String member1, String member2)";
        this.before(key, command);
        try {
            Double d = this.redis.geodist(key, member1, member2);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Double geodist(@ShardingParam String key, String member1, String member2, GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geodist(String key, String member1, String member2, GeoUnit unit)";
        this.before(key, command);
        try {
            Double d = this.redis.geodist(key, member1, member2, unit);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<String> geohash(@ShardingParam String key, String ... members) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geohash(String key, String... members)";
        this.before(key, command);
        try {
            List<String> list = this.redis.geohash(key, members);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<GeoCoordinate> geopos(@ShardingParam String key, String ... members) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geopos(String key, String... members)";
        this.before(key, command);
        try {
            List<GeoCoordinate> list = this.redis.geopos(key, members);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<GeoRadiusResponse> georadius(@ShardingParam String key, double longitude, double latitude, double radius, GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "georadius(String key, double longitude, double latitude, double radius, GeoUnit unit)";
        this.before(key, command);
        try {
            List<GeoRadiusResponse> list = this.redis.georadius(key, longitude, latitude, radius, unit);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<GeoRadiusResponse> georadius(@ShardingParam String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param)";
        this.before(key, command);
        try {
            List<GeoRadiusResponse> list = this.redis.georadius(key, longitude, latitude, radius, unit, param);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<GeoRadiusResponse> georadiusByMember(@ShardingParam String key, String member, double radius, GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "georadiusByMember(String key, String member, double radius, GeoUnit unit)";
        this.before(key, command);
        try {
            List<GeoRadiusResponse> list = this.redis.georadiusByMember(key, member, radius, unit);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<GeoRadiusResponse> georadiusByMember(@ShardingParam String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param)";
        this.before(key, command);
        try {
            List<GeoRadiusResponse> list = this.redis.georadiusByMember(key, member, radius, unit, param);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<Long> bitfield(@ShardingParam String key, String ... arguments) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "bitfield(String key, String... arguments)";
        this.before(key, command);
        try {
            List<Long> list = this.redis.bitfield(key, arguments);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long del(byte[] ... keys) {
        LogUtil.debugLog((Resource)this.resource, (byte[][])keys);
        String command = "del(byte[]... keys)";
        for (byte[] key : keys) {
            this.before(key, command);
        }
        try {
            Long l = this.redis.del(keys);
            return l;
        }
        finally {
            for (byte[] key : keys) {
                this.after(key, command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long exists(byte[] ... keys) {
        LogUtil.debugLog((Resource)this.resource, (byte[][])keys);
        String command = "exists(byte[]... keys)";
        for (byte[] key : keys) {
            this.before(key, command);
        }
        try {
            Long l = this.redis.exists(keys);
            return l;
        }
        finally {
            for (byte[] key : keys) {
                this.after(key, command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Map<byte[], byte[]> mget(byte[] ... keys) {
        LogUtil.debugLog((Resource)this.resource, (byte[][])keys);
        String command = "mget(byte[]... keys)";
        if (this.interceptEnable()) {
            for (byte[] key : keys) {
                this.before(key, command);
            }
        }
        try {
            Map<byte[], byte[]> map = this.redis.mget(keys);
            return map;
        }
        finally {
            if (this.interceptEnable()) {
                for (byte[] key : keys) {
                    this.after(key, command);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String mset(@ShardingParam(type=ShardingParam.Type.Collection) Map<byte[], byte[]> keysvalues) {
        LogUtil.debugLog((Resource)this.resource, keysvalues);
        String command = "mset(byte[]... keysvalues)";
        if (this.interceptEnable()) {
            for (byte[] key : keysvalues.keySet()) {
                this.before(key, command);
            }
        }
        try {
            String string = this.redis.mset(keysvalues);
            return string;
        }
        finally {
            if (this.interceptEnable()) {
                for (byte[] key : keysvalues.keySet()) {
                    this.after(key, command);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long del(String ... keys) {
        LogUtil.debugLog((Resource)this.resource, (String[])keys);
        String command = "del(String... keys)";
        if (this.interceptEnable()) {
            for (String key : keys) {
                this.before(key, command);
            }
        }
        try {
            Long l = this.redis.del(keys);
            return l;
        }
        finally {
            if (this.interceptEnable()) {
                for (String key : keys) {
                    this.after(key, command);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long exists(String ... keys) {
        LogUtil.debugLog((Resource)this.resource, (String[])keys);
        String command = "exists(String... keys)";
        if (this.interceptEnable()) {
            for (String key : keys) {
                this.before(key, command);
            }
        }
        try {
            Long l = this.redis.exists(keys);
            return l;
        }
        finally {
            if (this.interceptEnable()) {
                for (String key : keys) {
                    this.after(key, command);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Map<String, String> mget(String ... keys) {
        LogUtil.debugLog((Resource)this.resource, (String[])keys);
        String command = "mget(String... keys)";
        if (this.interceptEnable()) {
            for (String key : keys) {
                this.before(key, command);
            }
        }
        try {
            Map<String, String> map = this.redis.mget(keys);
            return map;
        }
        finally {
            if (this.interceptEnable()) {
                for (String key : keys) {
                    this.after(key, command);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String set(@ShardingParam byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time)";
        this.before(key, command);
        try {
            String string = this.redis.set(key, value, nxxx, expx, time);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Boolean exists(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "exists(byte[] key)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.exists(key);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long persist(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "persist(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.persist(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String type(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "type(byte[] key)";
        this.before(key, command);
        try {
            String string = this.redis.type(key);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long expire(@ShardingParam byte[] key, int seconds) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "expire(byte[] key, int seconds)";
        this.before(key, command);
        try {
            Long l = this.redis.expire(key, seconds);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long pexpire(@ShardingParam byte[] key, long milliseconds) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "pexpire(byte[] key, long milliseconds)";
        this.before(key, command);
        try {
            Long l = this.redis.pexpire(key, milliseconds);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long expireAt(@ShardingParam byte[] key, long unixTime) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "expireAt(byte[] key, long unixTime)";
        this.before(key, command);
        try {
            Long l = this.redis.expireAt(key, unixTime);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long pexpireAt(@ShardingParam byte[] key, long millisecondsTimestamp) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "pexpireAt(byte[] key, long millisecondsTimestamp)";
        this.before(key, command);
        try {
            Long l = this.redis.pexpireAt(key, millisecondsTimestamp);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long ttl(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "ttl(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.ttl(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long pttl(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "pttl(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.pttl(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Boolean setbit(@ShardingParam byte[] key, long offset, boolean value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "setbit(byte[] key, long offset, boolean value)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.setbit(key, offset, value);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Boolean setbit(@ShardingParam byte[] key, long offset, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "setbit(byte[] key, long offset, byte[] value)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.setbit(key, offset, value);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Boolean getbit(@ShardingParam byte[] key, long offset) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "getbit(byte[] key, long offset)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.getbit(key, offset);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long setrange(@ShardingParam byte[] key, long offset, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "setrange(byte[] key, long offset, byte[] value)";
        this.before(key, command);
        try {
            Long l = this.redis.setrange(key, offset, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public byte[] getrange(@ShardingParam byte[] key, long startOffset, long endOffset) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "getrange(byte[] key, long startOffset, long endOffset)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.getrange(key, startOffset, endOffset);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public byte[] getSet(@ShardingParam byte[] key, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "getSet(byte[] key, byte[] value)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.getSet(key, value);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long setnx(@ShardingParam byte[] key, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "setnx(byte[] key, byte[] value)";
        this.before(key, command);
        try {
            Long l = this.redis.setnx(key, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String setex(@ShardingParam byte[] key, int seconds, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "setex(byte[] key, int seconds, byte[] value)";
        this.before(key, command);
        try {
            String string = this.redis.setex(key, seconds, value);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String psetex(@ShardingParam byte[] key, long milliseconds, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "psetex(byte[] key, long milliseconds, byte[] value)";
        this.before(key, command);
        try {
            String string = this.redis.psetex(key, milliseconds, value);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long decrBy(@ShardingParam byte[] key, long integer) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "decrBy(byte[] key, long integer)";
        this.before(key, command);
        try {
            Long l = this.redis.decrBy(key, integer);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long decr(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "decr(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.decr(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long incrBy(@ShardingParam byte[] key, long integer) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "incrBy(byte[] key, long integer)";
        this.before(key, command);
        try {
            Long l = this.redis.incrBy(key, integer);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Double incrByFloat(@ShardingParam byte[] key, double value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "incrByFloat(byte[] key, double value)";
        this.before(key, command);
        try {
            Double d = this.redis.incrByFloat(key, value);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long incr(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "incr(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.incr(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long append(@ShardingParam byte[] key, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "append(byte[] key, byte[] value)";
        this.before(key, command);
        try {
            Long l = this.redis.append(key, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public byte[] substr(@ShardingParam byte[] key, int start, int end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "substr(byte[] key, int start, int end)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.substr(key, start, end);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long hset(@ShardingParam byte[] key, byte[] field, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hset(byte[] key, byte[] field, byte[] value)";
        this.before(key, command);
        try {
            Long l = this.redis.hset(key, field, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public byte[] hget(@ShardingParam byte[] key, byte[] field) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hget(byte[] key, byte[] field)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.hget(key, field);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long hsetnx(@ShardingParam byte[] key, byte[] field, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hsetnx(byte[] key, byte[] field, byte[] value)";
        this.before(key, command);
        try {
            Long l = this.redis.hsetnx(key, field, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String hmset(@ShardingParam byte[] key, Map<byte[], byte[]> hash) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hmset(byte[] key, Map<byte[], byte[]> hash)";
        this.before(key, command);
        try {
            String string = this.redis.hmset(key, hash);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<byte[]> hmget(@ShardingParam byte[] key, byte[] ... fields) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hmget(byte[] key, byte[]... fields)";
        this.before(key, command);
        try {
            List<byte[]> list = this.redis.hmget(key, fields);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long hincrBy(@ShardingParam byte[] key, byte[] field, long value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hincrBy(byte[] key, byte[] field, long value)";
        this.before(key, command);
        try {
            Long l = this.redis.hincrBy(key, field, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Double hincrByFloat(@ShardingParam byte[] key, byte[] field, double value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hincrByFloat(byte[] key, byte[] field, double value)";
        this.before(key, command);
        try {
            Double d = this.redis.hincrByFloat(key, field, value);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Boolean hexists(@ShardingParam byte[] key, byte[] field) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hexists(byte[] key, byte[] field)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.hexists(key, field);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long hdel(@ShardingParam byte[] key, byte[] ... field) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hdel(byte[] key, byte[]... field)";
        this.before(key, command);
        try {
            Long l = this.redis.hdel(key, field);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long hlen(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hlen(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.hlen(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> hkeys(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hkeys(byte[] key)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.hkeys(key);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<byte[]> hvals(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hvals(byte[] key)";
        this.before(key, command);
        try {
            List<byte[]> list = this.redis.hvals(key);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Map<byte[], byte[]> hgetAll(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hgetAll(byte[] key)";
        this.before(key, command);
        try {
            Map<byte[], byte[]> map = this.redis.hgetAll(key);
            return map;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long rpush(@ShardingParam byte[] key, byte[] ... args) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "rpush(byte[] key, byte[]... args)";
        this.before(key, command);
        try {
            Long l = this.redis.rpush(key, args);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long lpush(@ShardingParam byte[] key, byte[] ... args) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lpush(byte[] key, byte[]... args)";
        this.before(key, command);
        try {
            Long l = this.redis.lpush(key, args);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long llen(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "llen(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.llen(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<byte[]> lrange(@ShardingParam byte[] key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lrange(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            List<byte[]> list = this.redis.lrange(key, start, end);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public String ltrim(@ShardingParam byte[] key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "ltrim(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            String string = this.redis.ltrim(key, start, end);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public byte[] lindex(@ShardingParam byte[] key, long index) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lindex(byte[] key, long index)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.lindex(key, index);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String lset(@ShardingParam byte[] key, long index, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lset(byte[] key, long index, byte[] value)";
        this.before(key, command);
        try {
            String string = this.redis.lset(key, index, value);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long lrem(@ShardingParam byte[] key, long count, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lrem(byte[] key, long count, byte[] value)";
        this.before(key, command);
        try {
            Long l = this.redis.lrem(key, count, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public byte[] lpop(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lpop(byte[] key)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.lpop(key);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public byte[] rpop(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "rpop(byte[] key)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.rpop(key);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long sadd(@ShardingParam byte[] key, byte[] ... member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "sadd(byte[] key, byte[]... member)";
        this.before(key, command);
        try {
            Long l = this.redis.sadd(key, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> smembers(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "smembers(byte[] key)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.smembers(key);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long srem(@ShardingParam byte[] key, byte[] ... member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "srem(byte[] key, byte[]... member)";
        this.before(key, command);
        try {
            Long l = this.redis.srem(key, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public byte[] spop(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "spop(byte[] key)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.spop(key);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Set<byte[]> spop(@ShardingParam byte[] key, long count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "spop(byte[] key, long count)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.spop(key, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long scard(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "scard(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.scard(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Boolean sismember(@ShardingParam byte[] key, byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "sismember(byte[] key, byte[] member)";
        this.before(key, command);
        try {
            Boolean bl = this.redis.sismember(key, member);
            return bl;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public byte[] srandmember(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "srandmember(byte[] key)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.srandmember(key);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<byte[]> srandmember(@ShardingParam byte[] key, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "srandmember(byte[] key, int count)";
        this.before(key, command);
        try {
            List<byte[]> list = this.redis.srandmember(key, count);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long strlen(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "strlen(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.strlen(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zadd(@ShardingParam byte[] key, double score, byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zadd(byte[] key, double score, byte[] member)";
        this.before(key, command);
        try {
            Long l = this.redis.zadd(key, score, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zadd(@ShardingParam byte[] key, double score, byte[] member, ZAddParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zadd(byte[] key, double score, byte[] member, ZAddParams params)";
        this.before(key, command);
        try {
            Long l = this.redis.zadd(key, score, member, params);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zadd(@ShardingParam byte[] key, Map<byte[], Double> scoreMembers) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zadd(byte[] key, Map<byte[], Double> scoreMembers)";
        this.before(key, command);
        try {
            Long l = this.redis.zadd(key, scoreMembers);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zadd(@ShardingParam byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params)";
        this.before(key, command);
        try {
            Long l = this.redis.zadd(key, scoreMembers, params);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrange(@ShardingParam byte[] key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrange(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrange(key, start, end);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zrem(@ShardingParam byte[] key, byte[] ... member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrem(byte[] key, byte[]... member)";
        this.before(key, command);
        try {
            Long l = this.redis.zrem(key, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Double zincrby(@ShardingParam byte[] key, double score, byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zincrby(byte[] key, double score, byte[] member)";
        this.before(key, command);
        try {
            Double d = this.redis.zincrby(key, score, member);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Double zincrby(@ShardingParam byte[] key, double score, byte[] member, ZIncrByParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zincrby(byte[] key, double score, byte[] member, ZIncrByParams params)";
        this.before(key, command);
        try {
            Double d = this.redis.zincrby(key, score, member, params);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zrank(@ShardingParam byte[] key, byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrank(byte[] key, byte[] member)";
        this.before(key, command);
        try {
            Long l = this.redis.zrank(key, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zrevrank(@ShardingParam byte[] key, byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrank(byte[] key, byte[] member)";
        this.before(key, command);
        try {
            Long l = this.redis.zrevrank(key, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrevrange(@ShardingParam byte[] key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrange(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrevrange(key, start, end);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrangeWithScores(@ShardingParam byte[] key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeWithScores(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrangeWithScores(key, start, end);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrevrangeWithScores(@ShardingParam byte[] key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeWithScores(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrevrangeWithScores(key, start, end);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zcard(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zcard(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.zcard(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Double zscore(@ShardingParam byte[] key, byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zscore(byte[] key, byte[] member)";
        this.before(key, command);
        try {
            Double d = this.redis.zscore(key, member);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<byte[]> sort(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "sort(byte[] key)";
        this.before(key, command);
        try {
            List<byte[]> list = this.redis.sort(key);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<byte[]> sort(@ShardingParam byte[] key, SortingParams sortingParameters) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "sort(byte[] key, SortingParams sortingParameters)";
        this.before(key, command);
        try {
            List<byte[]> list = this.redis.sort(key, sortingParameters);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zcount(@ShardingParam byte[] key, double min, double max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zcount(byte[] key, double min, double max)";
        this.before(key, command);
        try {
            Long l = this.redis.zcount(key, min, max);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zcount(@ShardingParam byte[] key, byte[] min, byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zcount(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Long l = this.redis.zcount(key, min, max);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrangeByScore(@ShardingParam byte[] key, double min, double max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScore(byte[] key, double min, double max)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrangeByScore(key, min, max);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrangeByScore(@ShardingParam byte[] key, byte[] min, byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScore(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrangeByScore(key, min, max);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrevrangeByScore(@ShardingParam byte[] key, double max, double min) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScore(byte[] key, double max, double min)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrevrangeByScore(key, max, min);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrangeByScore(@ShardingParam byte[] key, double min, double max, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScore(byte[] key, double min, double max, int offset, int count)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrevrangeByScore(@ShardingParam byte[] key, byte[] max, byte[] min) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScore(byte[] key, byte[] max, byte[] min)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrevrangeByScore(key, max, min);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrangeByScore(@ShardingParam byte[] key, byte[] min, byte[] max, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrevrangeByScore(@ShardingParam byte[] key, double max, double min, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScore(byte[] key, double max, double min, int offset, int count)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrangeByScoreWithScores(@ShardingParam byte[] key, double min, double max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScoreWithScores(byte[] key, double min, double max)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrevrangeByScoreWithScores(@ShardingParam byte[] key, double max, double min) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScoreWithScores(byte[] key, double max, double min)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrangeByScoreWithScores(@ShardingParam byte[] key, double min, double max, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrevrangeByScore(@ShardingParam byte[] key, byte[] max, byte[] min, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrangeByScoreWithScores(@ShardingParam byte[] key, byte[] min, byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrevrangeByScoreWithScores(@ShardingParam byte[] key, byte[] max, byte[] min) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrangeByScoreWithScores(@ShardingParam byte[] key, byte[] min, byte[] max, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrevrangeByScoreWithScores(@ShardingParam byte[] key, double max, double min, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<Tuple> zrevrangeByScoreWithScores(@ShardingParam byte[] key, byte[] max, byte[] min, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count)";
        this.before(key, command);
        try {
            Set<Tuple> set = this.redis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zremrangeByRank(@ShardingParam byte[] key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zremrangeByRank(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Long l = this.redis.zremrangeByRank(key, start, end);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zremrangeByScore(@ShardingParam byte[] key, double start, double end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zremrangeByScore(byte[] key, double start, double end)";
        this.before(key, command);
        try {
            Long l = this.redis.zremrangeByScore(key, start, end);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zremrangeByScore(@ShardingParam byte[] key, byte[] start, byte[] end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zremrangeByScore(byte[] key, byte[] start, byte[] end)";
        this.before(key, command);
        try {
            Long l = this.redis.zremrangeByScore(key, start, end);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long zlexcount(@ShardingParam byte[] key, byte[] min, byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zlexcount(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Long l = this.redis.zlexcount(key, min, max);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrangeByLex(@ShardingParam byte[] key, byte[] min, byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByLex(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrangeByLex(key, min, max);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrangeByLex(@ShardingParam byte[] key, byte[] min, byte[] max, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrangeByLex(key, min, max, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrevrangeByLex(@ShardingParam byte[] key, byte[] max, byte[] min) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByLex(byte[] key, byte[] max, byte[] min)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrevrangeByLex(key, max, min);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Set<byte[]> zrevrangeByLex(@ShardingParam byte[] key, byte[] max, byte[] min, int offset, int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count)";
        this.before(key, command);
        try {
            Set<byte[]> set = this.redis.zrevrangeByLex(key, max, min, offset, count);
            return set;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long zremrangeByLex(@ShardingParam byte[] key, byte[] min, byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zremrangeByLex(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Long l = this.redis.zremrangeByLex(key, min, max);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long linsert(@ShardingParam byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value)";
        this.before(key, command);
        try {
            Long l = this.redis.linsert(key, where, pivot, value);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long lpushx(@ShardingParam byte[] key, byte[] ... arg) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lpushx(byte[] key, byte[]... arg)";
        this.before(key, command);
        try {
            Long l = this.redis.lpushx(key, arg);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long rpushx(@ShardingParam byte[] key, byte[] ... arg) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "rpushx(byte[] key, byte[]... arg)";
        this.before(key, command);
        try {
            Long l = this.redis.rpushx(key, arg);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long del(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "del(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.del(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long bitcount(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "bitcount(byte[] key)";
        this.before(key, command);
        try {
            Long l = this.redis.bitcount(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Long bitcount(@ShardingParam byte[] key, long start, long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "bitcount(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Long l = this.redis.bitcount(key, start, end);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long pfadd(@ShardingParam byte[] key, byte[] ... elements) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "pfadd(byte[] key, byte[]... elements)";
        this.before(key, command);
        try {
            Long l = this.redis.pfadd(key, elements);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public long pfcount(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "pfcount(byte[] key)";
        this.before(key, command);
        try {
            long l = this.redis.pfcount(key);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long geoadd(@ShardingParam byte[] key, double longitude, double latitude, byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geoadd(byte[] key, double longitude, double latitude, byte[] member)";
        this.before(key, command);
        try {
            Long l = this.redis.geoadd(key, longitude, latitude, member);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Long geoadd(@ShardingParam byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap)";
        this.before(key, command);
        try {
            Long l = this.redis.geoadd(key, memberCoordinateMap);
            return l;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Double geodist(@ShardingParam byte[] key, byte[] member1, byte[] member2) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geodist(byte[] key, byte[] member1, byte[] member2)";
        this.before(key, command);
        try {
            Double d = this.redis.geodist(key, member1, member2);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Double geodist(@ShardingParam byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit)";
        this.before(key, command);
        try {
            Double d = this.redis.geodist(key, member1, member2, unit);
            return d;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<byte[]> geohash(@ShardingParam byte[] key, byte[] ... members) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geohash(byte[] key, byte[]... members)";
        this.before(key, command);
        try {
            List<byte[]> list = this.redis.geohash(key, members);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<GeoCoordinate> geopos(@ShardingParam byte[] key, byte[] ... members) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geopos(byte[] key, byte[]... members)";
        this.before(key, command);
        try {
            List<GeoCoordinate> list = this.redis.geopos(key, members);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<GeoRadiusResponse> georadius(@ShardingParam byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit)";
        this.before(key, command);
        try {
            List<GeoRadiusResponse> list = this.redis.georadius(key, longitude, latitude, radius, unit);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<GeoRadiusResponse> georadius(@ShardingParam byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param)";
        this.before(key, command);
        try {
            List<GeoRadiusResponse> list = this.redis.georadius(key, longitude, latitude, radius, unit, param);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<GeoRadiusResponse> georadiusByMember(@ShardingParam byte[] key, byte[] member, double radius, GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit)";
        this.before(key, command);
        try {
            List<GeoRadiusResponse> list = this.redis.georadiusByMember(key, member, radius, unit);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<GeoRadiusResponse> georadiusByMember(@ShardingParam byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param)";
        this.before(key, command);
        try {
            List<GeoRadiusResponse> list = this.redis.georadiusByMember(key, member, radius, unit, param);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(@ShardingParam byte[] key, byte[] cursor) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hscan(byte[] key, byte[] cursor)";
        this.before(key, command);
        try {
            ScanResult<Map.Entry<byte[], byte[]>> scanResult = this.redis.hscan(key, cursor);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(@ShardingParam byte[] key, byte[] cursor, ScanParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hscan(byte[] key, byte[] cursor, ScanParams params)";
        this.before(key, command);
        try {
            ScanResult<Map.Entry<byte[], byte[]>> scanResult = this.redis.hscan(key, cursor, params);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<byte[]> sscan(@ShardingParam byte[] key, byte[] cursor) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "sscan(byte[] key, byte[] cursor)";
        this.before(key, command);
        try {
            ScanResult<byte[]> scanResult = this.redis.sscan(key, cursor);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<byte[]> sscan(@ShardingParam byte[] key, byte[] cursor, ScanParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "sscan(byte[] key, byte[] cursor, ScanParams params)";
        this.before(key, command);
        try {
            ScanResult<byte[]> scanResult = this.redis.sscan(key, cursor, params);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<Tuple> zscan(@ShardingParam byte[] key, byte[] cursor) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zscan(byte[] key, byte[] cursor)";
        this.before(key, command);
        try {
            ScanResult<Tuple> scanResult = this.redis.zscan(key, cursor);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public ScanResult<Tuple> zscan(@ShardingParam byte[] key, byte[] cursor, ScanParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zscan(byte[] key, byte[] cursor, ScanParams params)";
        this.before(key, command);
        try {
            ScanResult<Tuple> scanResult = this.redis.zscan(key, cursor, params);
            return scanResult;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public List<Long> bitfield(@ShardingParam byte[] key, byte[] ... arguments) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "bitfield(byte[] key, byte[]... arguments)";
        this.before(key, command);
        try {
            List<Long> list = this.redis.bitfield(key, arguments);
            return list;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String set(@ShardingParam String key, String value, String nxxx, String expx, long time) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "set(String key, String value, String nxxx, String expx, long time)";
        this.before(key, command);
        try {
            String string = this.redis.set(key, value, nxxx, expx, time);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String set(@ShardingParam String key, String value, String nxxx) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "set(String key, String value, String nxxx)";
        this.before(key, command);
        try {
            String string = this.redis.set(key, value, nxxx);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String set(@ShardingParam byte[] key, byte[] value, byte[] nxxx) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "set(byte[] key, byte[] value, byte[] nxxx)";
        this.before(key, command);
        try {
            String string = this.redis.set(key, value, nxxx);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    @Override
    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        throw new CamelliaRedisException("not invoke here");
    }

    @Override
    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        throw new CamelliaRedisException("not invoke here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public byte[] dump(@ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "dump(String key)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.dump(key);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public byte[] dump(@ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "dump(byte[] key)";
        this.before(key, command);
        try {
            byte[] byArray = this.redis.dump(key);
            return byArray;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String restore(@ShardingParam byte[] key, int ttl, byte[] serializedValue) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "restore(byte[] key, int ttl, byte[] serializedValue)";
        this.before(key, command);
        try {
            String string = this.redis.restore(key, ttl, serializedValue);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public String restore(@ShardingParam String key, int ttl, byte[] serializedValue) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "restore(String key, int ttl, byte[] serializedValue)";
        this.before(key, command);
        try {
            String string = this.redis.restore(key, ttl, serializedValue);
            return string;
        }
        finally {
            this.after(key, command);
        }
    }
}

