/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis;

import com.netease.nim.camellia.core.api.CamelliaApi;
import com.netease.nim.camellia.core.api.CamelliaApiUtil;
import com.netease.nim.camellia.redis.CamelliaRedisEnv;
import com.netease.nim.camellia.redis.CamelliaRedisTemplate;
import com.netease.nim.camellia.redis.jedis.JedisPoolFactory;
import com.netease.nim.camellia.redis.jediscluster.JedisClusterFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPoolConfig;

public class CamelliaRedisTemplateManager {
    private static final boolean defaultMonitorEnable = false;
    private static final long defaultCheckMillis = 5000L;
    private final CamelliaRedisEnv redisEnv;
    private final CamelliaApi service;
    private final boolean monitorEnable;
    private final long checkIntervalMillis;
    private final ConcurrentHashMap<String, CamelliaRedisTemplate> redisTemplateMap = new ConcurrentHashMap();

    public CamelliaRedisTemplateManager(CamelliaRedisEnv redisEnv, CamelliaApi service, boolean monitorEnable, long checkIntervalMillis) {
        this.redisEnv = redisEnv;
        this.service = service;
        this.monitorEnable = monitorEnable;
        this.checkIntervalMillis = checkIntervalMillis;
    }

    public CamelliaRedisTemplateManager(CamelliaApi service, JedisPoolConfig poolConfig, int timeout, boolean monitorEnable, long checkIntervalMillis) {
        this.redisEnv = new CamelliaRedisEnv.Builder().jedisPoolFactory(new JedisPoolFactory.DefaultJedisPoolFactory((GenericObjectPoolConfig)poolConfig, timeout)).jedisClusterFactory(new JedisClusterFactory.DefaultJedisClusterFactory((GenericObjectPoolConfig)poolConfig, timeout, timeout, 5)).build();
        this.service = service;
        this.monitorEnable = monitorEnable;
        this.checkIntervalMillis = checkIntervalMillis;
    }

    public CamelliaRedisTemplateManager(CamelliaApi service, int minIdle, int maxIdle, int maxTotal, int maxWaitMillis, int timeout, boolean monitorEnable, long checkIntervalMillis) {
        this.service = service;
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMinIdle(minIdle);
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMaxTotal(maxTotal);
        poolConfig.setMaxWaitMillis((long)maxWaitMillis);
        this.redisEnv = new CamelliaRedisEnv.Builder().jedisPoolFactory(new JedisPoolFactory.DefaultJedisPoolFactory((GenericObjectPoolConfig)poolConfig, timeout)).jedisClusterFactory(new JedisClusterFactory.DefaultJedisClusterFactory((GenericObjectPoolConfig)poolConfig, timeout, timeout, 5)).build();
        this.monitorEnable = monitorEnable;
        this.checkIntervalMillis = checkIntervalMillis;
    }

    public CamelliaRedisTemplateManager(String url, int poolSize, int timeout) {
        this(CamelliaApiUtil.init((String)url), 0, poolSize, poolSize, timeout, timeout, false, 5000L);
    }

    public CamelliaRedisTemplateManager(String url, int poolSize, int timeout, Map<String, String> headerMap) {
        this(CamelliaApiUtil.init((String)url, headerMap), 0, poolSize, poolSize, timeout, timeout, false, 5000L);
    }

    public CamelliaRedisTemplateManager(CamelliaApi service, int poolSize, int timeout) {
        this(service, 0, poolSize, poolSize, timeout, timeout, false, 5000L);
    }

    public CamelliaRedisTemplateManager(String url, int minIdle, int maxIdle, int maxTotal, int maxWaitMillis, int timeout) {
        this(CamelliaApiUtil.init((String)url), minIdle, maxIdle, maxTotal, maxWaitMillis, timeout, false, 5000L);
    }

    public CamelliaRedisTemplateManager(String url, int minIdle, int maxIdle, int maxTotal, int maxWaitMillis, int timeout, Map<String, String> headerMap) {
        this(CamelliaApiUtil.init((String)url, headerMap), minIdle, maxIdle, maxTotal, maxWaitMillis, timeout, false, 5000L);
    }

    public CamelliaRedisTemplateManager(CamelliaApi service, int minIdle, int maxIdle, int maxTotal, int maxWaitMillis, int timeout) {
        this(service, minIdle, maxIdle, maxTotal, maxWaitMillis, timeout, false, 5000L);
    }

    public CamelliaRedisTemplateManager(String url, int minIdle, int maxIdle, int maxTotal, int maxWaitMillis, int timeout, boolean monitorEnable, long checkIntervalMillis) {
        this(CamelliaApiUtil.init((String)url), minIdle, maxIdle, maxTotal, maxWaitMillis, timeout, monitorEnable, checkIntervalMillis);
    }

    public CamelliaRedisTemplateManager(String url, int minIdle, int maxIdle, int maxTotal, int maxWaitMillis, int timeout, boolean monitorEnable, long checkIntervalMillis, Map<String, String> headerMap) {
        this(CamelliaApiUtil.init((String)url, headerMap), minIdle, maxIdle, maxTotal, maxWaitMillis, timeout, monitorEnable, checkIntervalMillis);
    }

    public CamelliaRedisTemplateManager(String url, JedisPoolConfig poolConfig, int timeout) {
        this(CamelliaApiUtil.init((String)url), poolConfig, timeout, false, 5000L);
    }

    public CamelliaRedisTemplateManager(String url, JedisPoolConfig poolConfig, int timeout, Map<String, String> headerMap) {
        this(CamelliaApiUtil.init((String)url, headerMap), poolConfig, timeout, false, 5000L);
    }

    public CamelliaRedisTemplateManager(CamelliaApi service, JedisPoolConfig poolConfig, int timeout) {
        this(service, poolConfig, timeout, false, 5000L);
    }

    public CamelliaRedisTemplateManager(String url, JedisPoolConfig poolConfig, int timeout, boolean monitorEnable, long checkIntervalMillis) {
        this(CamelliaApiUtil.init((String)url), poolConfig, timeout, monitorEnable, checkIntervalMillis);
    }

    public CamelliaRedisTemplateManager(String url, JedisPoolConfig poolConfig, int timeout, boolean monitorEnable, long checkIntervalMillis, Map<String, String> headerMap) {
        this(CamelliaApiUtil.init((String)url, headerMap), poolConfig, timeout, monitorEnable, checkIntervalMillis);
    }

    public CamelliaRedisTemplateManager(CamelliaRedisEnv redisEnv, String url, boolean monitorEnable, long checkIntervalMillis) {
        this(redisEnv, CamelliaApiUtil.init((String)url), monitorEnable, checkIntervalMillis);
    }

    public CamelliaRedisTemplateManager(CamelliaRedisEnv redisEnv, String url, boolean monitorEnable, long checkIntervalMillis, Map<String, String> headerMap) {
        this(redisEnv, CamelliaApiUtil.init((String)url, headerMap), monitorEnable, checkIntervalMillis);
    }

    public CamelliaRedisTemplateManager(CamelliaRedisEnv redisEnv, CamelliaApi service) {
        this(redisEnv, service, false, 5000L);
    }

    public CamelliaRedisTemplateManager(CamelliaRedisEnv redisEnv, String url) {
        this(redisEnv, CamelliaApiUtil.init((String)url), false, 5000L);
    }

    public CamelliaRedisTemplateManager(CamelliaRedisEnv redisEnv, String url, Map<String, String> headerMap) {
        this(redisEnv, CamelliaApiUtil.init((String)url, headerMap), false, 5000L);
    }

    public CamelliaRedisTemplateManager(CamelliaApi service) {
        this(CamelliaRedisEnv.defaultRedisEnv(), service, false, 5000L);
    }

    public CamelliaRedisTemplateManager(String url) {
        this(CamelliaRedisEnv.defaultRedisEnv(), CamelliaApiUtil.init((String)url), false, 5000L);
    }

    public CamelliaRedisTemplateManager(String url, Map<String, String> headerMap) {
        this(CamelliaRedisEnv.defaultRedisEnv(), CamelliaApiUtil.init((String)url, headerMap), false, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CamelliaRedisTemplate getRedisTemplate(long bid, String bgroup) {
        String key = bid + "|" + bgroup;
        CamelliaRedisTemplate template = this.redisTemplateMap.get(key);
        if (template == null) {
            ConcurrentHashMap<String, CamelliaRedisTemplate> concurrentHashMap = this.redisTemplateMap;
            synchronized (concurrentHashMap) {
                template = this.redisTemplateMap.get(key);
                if (template == null) {
                    template = new CamelliaRedisTemplate(this.redisEnv, this.service, bid, bgroup, this.monitorEnable, this.checkIntervalMillis);
                    this.redisTemplateMap.put(key, template);
                }
            }
        }
        return template;
    }

    public void reloadResourceTable() {
        for (CamelliaRedisTemplate template : this.redisTemplateMap.values()) {
            template.reloadResourceTable();
        }
    }
}

