/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.jedis;

import com.netease.nim.camellia.redis.CamelliaRedisEnv;
import com.netease.nim.camellia.redis.ICamelliaRedis;
import com.netease.nim.camellia.redis.base.resource.CamelliaRedisProxyResource;
import com.netease.nim.camellia.redis.base.resource.RedisProxiesDiscoveryResource;
import com.netease.nim.camellia.redis.base.resource.RedisProxiesResource;
import com.netease.nim.camellia.redis.base.resource.RedisResource;
import com.netease.nim.camellia.redis.base.resource.RedisSentinelResource;
import com.netease.nim.camellia.redis.base.resource.RedisSentinelSlavesResource;
import com.netease.nim.camellia.redis.base.utils.CloseUtil;
import com.netease.nim.camellia.redis.proxy.RedisProxyResource;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Client;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.Pool;

public class CamelliaJedis
implements ICamelliaRedis {
    private final Pool<Jedis> jedisPool;

    public CamelliaJedis(RedisResource resource, CamelliaRedisEnv env) {
        this.jedisPool = env.getJedisPoolFactory().getJedisPool(resource);
    }

    public CamelliaJedis(RedisSentinelResource resource, CamelliaRedisEnv env) {
        this.jedisPool = env.getJedisPoolFactory().getJedisSentinelPool(resource);
    }

    public CamelliaJedis(RedisProxyResource resource, CamelliaRedisEnv env) {
        this.jedisPool = resource.getJedisPool();
    }

    public CamelliaJedis(CamelliaRedisProxyResource resource, CamelliaRedisEnv env) {
        this.jedisPool = env.getJedisPoolFactory().getCamelliaJedisPool(resource);
    }

    public CamelliaJedis(RedisSentinelSlavesResource resource, CamelliaRedisEnv env) {
        this.jedisPool = env.getJedisPoolFactory().getJedisSentinelSlavesPool(resource);
    }

    public CamelliaJedis(RedisProxiesResource resource, CamelliaRedisEnv env) {
        this.jedisPool = env.getJedisPoolFactory().getRedisProxiesJedisPool(resource);
    }

    public CamelliaJedis(RedisProxiesDiscoveryResource resource, CamelliaRedisEnv env) {
        this.jedisPool = env.getJedisPoolFactory().getRedisProxiesDiscoveryJedisPool(resource);
    }

    @Override
    public List<Jedis> getJedisList() {
        return Collections.singletonList(this.jedisPool.getResource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(String key, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.set(key, value);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(String key, String value, String nxxx, String expx, long time) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.set(key, value, nxxx, expx, time);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(String key, String value, String nxxx) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.set(key, value, nxxx);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(byte[] key, byte[] value, byte[] nxxx) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.set(key, value, nxxx);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.get(key);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean exists(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.exists(key);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long persist(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.persist(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String type(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.type(key);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long expire(String key, int seconds) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.expire(key, seconds);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pexpire(String key, long milliseconds) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.pexpire(key, milliseconds);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long expireAt(String key, long unixTime) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.expireAt(key, unixTime);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pexpireAt(String key, long millisecondsTimestamp) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.pexpireAt(key, millisecondsTimestamp);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long ttl(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.ttl(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pttl(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.pttl(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean setbit(String key, long offset, boolean value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.setbit(key, offset, value);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean setbit(String key, long offset, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.setbit(key, offset, value);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getbit(String key, long offset) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.getbit(key, offset);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setrange(String key, long offset, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.setrange(key, offset, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.getrange(key, startOffset, endOffset);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSet(String key, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.getSet(key, value);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setnx(String key, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.setnx(key, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setex(String key, int seconds, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.setex(key, seconds, value);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String psetex(String key, long milliseconds, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.psetex(key, milliseconds, value);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrBy(String key, long integer) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.decrBy(key, integer);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decr(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.decr(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(String key, long integer) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.incrBy(key, integer);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double incrByFloat(String key, double value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.incrByFloat(key, value);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.incr(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long append(String key, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.append(key, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String substr(String key, int start, int end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.substr(key, start, end);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hset(String key, String field, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.hset(key, field, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hget(String key, String field) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.hget(key, field);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hsetnx(String key, String field, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.hsetnx(key, field, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hmset(String key, Map<String, String> hash) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.hmset(key, hash);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> hmget(String key, String ... fields) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.hmget(key, fields);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hincrBy(String key, String field, long value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.hincrBy(key, field, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double hincrByFloat(String key, String field, double value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.hincrByFloat(key, field, value);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean hexists(String key, String field) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.hexists(key, field);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hdel(String key, String ... field) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.hdel(key, field);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hlen(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.hlen(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> hkeys(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.hkeys(key);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> hvals(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.hvals(key);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> hgetAll(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Map map = jedis.hgetAll(key);
            return map;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(String key, String ... string) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.rpush(key, string);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpush(String key, String ... string) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.lpush(key, string);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long llen(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.llen(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> lrange(String key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.lrange(key, start, end);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ltrim(String key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.ltrim(key, start, end);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lindex(String key, long index) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.lindex(key, index);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lset(String key, long index, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.lset(key, index, value);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lrem(String key, long count, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.lrem(key, count, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lpop(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.lpop(key);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rpop(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.rpop(key);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sadd(String key, String ... member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.sadd(key, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> smembers(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.smembers(key);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long srem(String key, String ... member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.srem(key, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String spop(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.spop(key);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> spop(String key, long count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.spop(key, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long scard(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.scard(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean sismember(String key, String member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.sismember(key, member);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String srandmember(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.srandmember(key);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> srandmember(String key, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.srandmember(key, count);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long strlen(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.strlen(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String key, double score, String member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zadd(key, score, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String key, double score, String member, ZAddParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zadd(key, score, member, params);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zadd(key, scoreMembers);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zadd(key, scoreMembers, params);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrange(String key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrange(key, start, end);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrem(String key, String ... member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zrem(key, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zincrby(String key, double score, String member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.zincrby(key, score, member);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.zincrby(key, score, member, params);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrank(String key, String member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zrank(key, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrevrank(String key, String member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zrevrank(key, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrevrange(String key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrange(key, start, end);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeWithScores(key, start, end);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeWithScores(key, start, end);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcard(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zcard(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zscore(String key, String member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.zscore(key, member);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> sort(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.sort(key);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.sort(key, sortingParameters);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(String key, double min, double max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zcount(key, min, max);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(String key, String min, String max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zcount(key, min, max);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, double min, double max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, String min, String max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScore(key, max, min);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScore(key, max, min);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zremrangeByRank(key, start, end);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByScore(String key, double start, double end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zremrangeByScore(key, start, end);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByScore(String key, String start, String end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zremrangeByScore(key, start, end);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zlexcount(String key, String min, String max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zlexcount(key, min, max);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByLex(String key, String min, String max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByLex(key, min, max);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByLex(key, min, max, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrevrangeByLex(String key, String max, String min) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByLex(key, max, min);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByLex(key, max, min, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByLex(String key, String min, String max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zremrangeByLex(key, min, max);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.linsert(key, where, pivot, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpushx(String key, String ... string) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.lpushx(key, string);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpushx(String key, String ... string) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.rpushx(key, string);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long del(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.del(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String echo(String string) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string2 = jedis.echo(string);
            return string2;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long bitcount(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.bitcount(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long bitcount(String key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.bitcount(key, start, end);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long bitpos(String key, boolean value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.bitpos(key, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long bitpos(byte[] key, boolean value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.bitpos(key, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long bitpos(byte[] key, boolean value, BitPosParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.bitpos(key, value, params);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long bitpos(String key, boolean value, BitPosParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.bitpos(key, value, params);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.hscan(key, cursor);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.hscan(key, cursor, params);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<String> sscan(String key, String cursor) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.sscan(key, cursor);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.sscan(key, cursor, params);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.zscan(key, cursor);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.zscan(key, cursor, params);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pfadd(String key, String ... elements) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.pfadd(key, elements);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long pfcount(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            long l = jedis.pfcount(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long geoadd(String key, double longitude, double latitude, String member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.geoadd(key, longitude, latitude, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.geoadd(key, memberCoordinateMap);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double geodist(String key, String member1, String member2) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.geodist(key, member1, member2);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.geodist(key, member1, member2, unit);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> geohash(String key, String ... members) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.geohash(key, members);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoCoordinate> geopos(String key, String ... members) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.geopos(key, members);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.georadius(key, longitude, latitude, radius, unit);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.georadius(key, longitude, latitude, radius, unit, param);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.georadiusByMember(key, member, radius, unit);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.georadiusByMember(key, member, radius, unit, param);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> bitfield(String key, String ... arguments) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.bitfield(key, arguments);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long del(byte[] ... keys) {
        if (keys == null) {
            return 0L;
        }
        if (keys.length == 0) {
            return 0L;
        }
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.del(keys);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long exists(byte[] ... keys) {
        if (keys == null) {
            return 0L;
        }
        if (keys.length == 0) {
            return 0L;
        }
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.exists(keys);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<byte[], byte[]> mget(byte[] ... keys) {
        if (keys == null) {
            return Collections.emptyMap();
        }
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            HashMap<byte[], byte[]> ret = new HashMap<byte[], byte[]>();
            List mget = jedis.mget(keys);
            for (int i = 0; i < keys.length; ++i) {
                byte[] key = keys[i];
                byte[] value = (byte[])mget.get(i);
                ret.put(key, value);
            }
            HashMap<byte[], byte[]> hashMap = ret;
            return hashMap;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String mset(Map<byte[], byte[]> keysvalues) {
        if (keysvalues == null) {
            return null;
        }
        if (keysvalues.isEmpty()) {
            return null;
        }
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ArrayList<byte[]> args = new ArrayList<byte[]>();
            for (Map.Entry<byte[], byte[]> entry : keysvalues.entrySet()) {
                args.add(entry.getKey());
                args.add(entry.getValue());
            }
            byte[][] bytes = (byte[][])args.toArray((T[])new byte[0][0]);
            String string = jedis.mset(bytes);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long del(String ... keys) {
        if (keys == null) {
            return 0L;
        }
        if (keys.length == 0) {
            return 0L;
        }
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.del(keys);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long exists(String ... keys) {
        if (keys == null) {
            return 0L;
        }
        if (keys.length == 0) {
            return 0L;
        }
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.exists(keys);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> mget(String ... keys) {
        if (keys == null) {
            return Collections.emptyMap();
        }
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            HashMap<String, String> ret = new HashMap<String, String>();
            List list = jedis.mget(keys);
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String value = (String)list.get(i);
                ret.put(key, value);
            }
            HashMap<String, String> hashMap = ret;
            return hashMap;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    @Override
    public Jedis getJedis(byte[] key) {
        return (Jedis)this.jedisPool.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(byte[] key, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.set(key, value);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.get(key);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.set(key, value, nxxx, expx, time);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean exists(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.exists(key);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long persist(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.persist(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String type(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.type(key);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long expire(byte[] key, int seconds) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.expire(key, seconds);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pexpire(byte[] key, long milliseconds) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.pexpire(key, milliseconds);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long expireAt(byte[] key, long unixTime) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.expireAt(key, unixTime);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.pexpireAt(key, millisecondsTimestamp);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long ttl(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.ttl(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pttl(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.pttl(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean setbit(byte[] key, long offset, boolean value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.setbit(key, offset, value);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean setbit(byte[] key, long offset, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.setbit(key, offset, value);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean getbit(byte[] key, long offset) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.getbit(key, offset);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setrange(byte[] key, long offset, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.setrange(key, offset, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.getrange(key, startOffset, endOffset);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.getSet(key, value);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long setnx(byte[] key, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.setnx(key, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setex(byte[] key, int seconds, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.setex(key, seconds, value);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String psetex(byte[] key, long milliseconds, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.psetex(key, milliseconds, value);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decrBy(byte[] key, long integer) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.decrBy(key, integer);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long decr(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.decr(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(byte[] key, long integer) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.incrBy(key, integer);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double incrByFloat(byte[] key, double value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.incrByFloat(key, value);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.incr(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long append(byte[] key, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.append(key, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] substr(byte[] key, int start, int end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.substr(key, start, end);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.hset(key, field, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] hget(byte[] key, byte[] field) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.hget(key, field);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.hsetnx(key, field, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.hmset(key, hash);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.hmget(key, fields);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hincrBy(byte[] key, byte[] field, long value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.hincrBy(key, field, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.hincrByFloat(key, field, value);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean hexists(byte[] key, byte[] field) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.hexists(key, field);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hdel(byte[] key, byte[] ... field) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.hdel(key, field);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hlen(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.hlen(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> hkeys(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.hkeys(key);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> hvals(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.hvals(key);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Map map = jedis.hgetAll(key);
            return map;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(byte[] key, byte[] ... args) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.rpush(key, args);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpush(byte[] key, byte[] ... args) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.lpush(key, args);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long llen(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.llen(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> lrange(byte[] key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.lrange(key, start, end);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ltrim(byte[] key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.ltrim(key, start, end);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] lindex(byte[] key, long index) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.lindex(key, index);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lset(byte[] key, long index, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.lset(key, index, value);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lrem(byte[] key, long count, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.lrem(key, count, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] lpop(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.lpop(key);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] rpop(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.rpop(key);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sadd(byte[] key, byte[] ... member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.sadd(key, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> smembers(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.smembers(key);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long srem(byte[] key, byte[] ... member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.srem(key, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] spop(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.spop(key);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> spop(byte[] key, long count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.spop(key, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long scard(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.scard(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Boolean bl = jedis.sismember(key, member);
            return bl;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] srandmember(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.srandmember(key);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> srandmember(byte[] key, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.srandmember(key, count);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long strlen(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.strlen(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zadd(key, score, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zadd(key, score, member, params);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zadd(key, scoreMembers);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zadd(key, scoreMembers, params);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrange(byte[] key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrange(key, start, end);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrem(byte[] key, byte[] ... member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zrem(key, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zincrby(byte[] key, double score, byte[] member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.zincrby(key, score, member);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.zincrby(key, score, member, params);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrank(byte[] key, byte[] member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zrank(key, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zrevrank(key, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrange(key, start, end);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeWithScores(key, start, end);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeWithScores(key, start, end);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcard(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zcard(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zscore(byte[] key, byte[] member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.zscore(key, member);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> sort(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.sort(key);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.sort(key, sortingParameters);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(byte[] key, double min, double max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zcount(key, min, max);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zcount(key, min, max);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScore(key, max, min);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScore(key, max, min);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScore(key, max, min, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScoreWithScores(key, min, max);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByScoreWithScores(key, max, min, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByRank(byte[] key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zremrangeByRank(key, start, end);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByScore(byte[] key, double start, double end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zremrangeByScore(key, start, end);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zremrangeByScore(key, start, end);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zlexcount(key, min, max);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByLex(key, min, max);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrangeByLex(key, min, max, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByLex(key, max, min);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.zrevrangeByLex(key, max, min, offset, count);
            return set;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.zremrangeByLex(key, min, max);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.linsert(key, where, pivot, value);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpushx(byte[] key, byte[] ... arg) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.lpushx(key, arg);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpushx(byte[] key, byte[] ... arg) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.rpushx(key, arg);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long del(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.del(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long bitcount(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.bitcount(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long bitcount(byte[] key, long start, long end) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.bitcount(key, start, end);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long pfadd(byte[] key, byte[] ... elements) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.pfadd(key, elements);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long pfcount(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            long l = jedis.pfcount(key);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.geoadd(key, longitude, latitude, member);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Long l = jedis.geoadd(key, memberCoordinateMap);
            return l;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.geodist(key, member1, member2);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Double d = jedis.geodist(key, member1, member2, unit);
            return d;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> geohash(byte[] key, byte[] ... members) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.geohash(key, members);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.geopos(key, members);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.georadius(key, longitude, latitude, radius, unit);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.georadius(key, longitude, latitude, radius, unit, param);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.georadiusByMember(key, member, radius, unit);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.georadiusByMember(key, member, radius, unit, param);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.hscan(key, cursor);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.hscan(key, cursor, params);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.sscan(key, cursor);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.sscan(key, cursor, params);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.zscan(key, cursor);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            ScanResult scanResult = jedis.zscan(key, cursor, params);
            return scanResult;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List list = jedis.bitfield(key, arguments);
            return list;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Client client = jedis.getClient();
            client.eval(script, keyCount, params);
            Object object = client.getOne();
            return object;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Client client = jedis.getClient();
            client.evalsha(sha1, keyCount, params);
            Object object = client.getOne();
            return object;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] dump(String key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.dump(key);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] dump(byte[] key) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            byte[] byArray = jedis.dump(key);
            return byArray;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String restore(byte[] key, int ttl, byte[] serializedValue) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.restore(key, ttl, serializedValue);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String restore(String key, int ttl, byte[] serializedValue) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String string = jedis.restore(key, ttl, serializedValue);
            return string;
        }
        finally {
            CloseUtil.closeQuietly((Closeable)jedis);
        }
    }
}

