/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.jedis;

import com.netease.nim.camellia.redis.base.proxy.IProxyDiscovery;
import com.netease.nim.camellia.redis.base.proxy.Proxy;
import com.netease.nim.camellia.redis.base.resource.CamelliaRedisProxyResource;
import com.netease.nim.camellia.redis.base.resource.RedisProxiesDiscoveryResource;
import com.netease.nim.camellia.redis.base.resource.RedisProxiesResource;
import com.netease.nim.camellia.redis.base.resource.RedisResource;
import com.netease.nim.camellia.redis.base.resource.RedisSentinelResource;
import com.netease.nim.camellia.redis.base.resource.RedisSentinelSlavesResource;
import com.netease.nim.camellia.redis.conf.CamelliaRedisConstants;
import com.netease.nim.camellia.redis.jedis.JedisSentinelPool;
import com.netease.nim.camellia.redis.jedis.JedisSentinelSlavesPool;
import com.netease.nim.camellia.redis.proxy.CamelliaRedisProxyContext;
import com.netease.nim.camellia.redis.proxy.RedisProxiesContext;
import com.netease.nim.camellia.redis.proxy.discovery.common.DetectedLocalConfProxyDiscovery;
import com.netease.nim.camellia.redis.proxy.discovery.jedis.RedisProxyJedisPool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public interface JedisPoolFactory {
    public static final JedisPoolFactory DEFAULT = new DefaultJedisPoolFactory();

    public JedisPool getJedisPool(RedisResource var1);

    public JedisSentinelPool getJedisSentinelPool(RedisSentinelResource var1);

    public JedisPool getCamelliaJedisPool(CamelliaRedisProxyResource var1);

    public JedisPool getJedisSentinelSlavesPool(RedisSentinelSlavesResource var1);

    public JedisPool getRedisProxiesJedisPool(RedisProxiesResource var1);

    public JedisPool getRedisProxiesDiscoveryJedisPool(RedisProxiesDiscoveryResource var1);

    public static class DefaultJedisPoolFactory
    implements JedisPoolFactory {
        private final Object lock = new Object();
        private final ConcurrentHashMap<String, JedisPool> map1 = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, JedisSentinelPool> map2 = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, JedisSentinelSlavesPool> map3 = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, RedisProxyJedisPool> map4 = new ConcurrentHashMap();
        private final GenericObjectPoolConfig poolConfig;
        private final int timeout;
        private final long redisSentinelSlavesCheckIntervalMillis;

        public DefaultJedisPoolFactory() {
            this.poolConfig = new JedisPoolConfig();
            this.poolConfig.setMinIdle(0);
            this.poolConfig.setMaxTotal(CamelliaRedisConstants.Jedis.maxTotal);
            this.poolConfig.setMaxIdle(CamelliaRedisConstants.Jedis.maxIdle);
            this.poolConfig.setMaxWaitMillis(2000L);
            this.timeout = 2000;
            this.redisSentinelSlavesCheckIntervalMillis = 5000L;
        }

        public DefaultJedisPoolFactory(GenericObjectPoolConfig poolConfig, int timeout) {
            this.poolConfig = poolConfig;
            this.timeout = timeout;
            this.redisSentinelSlavesCheckIntervalMillis = 5000L;
        }

        public DefaultJedisPoolFactory(GenericObjectPoolConfig poolConfig, int timeout, int redisSentinelSlavesCheckIntervalMillis) {
            this.poolConfig = poolConfig;
            this.timeout = timeout;
            this.redisSentinelSlavesCheckIntervalMillis = redisSentinelSlavesCheckIntervalMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JedisPool getJedisPool(RedisResource resource) {
            JedisPool jedisPool = this.map1.get(resource.getUrl());
            if (jedisPool == null) {
                Object object = this.lock;
                synchronized (object) {
                    jedisPool = this.map1.get(resource.getUrl());
                    if (jedisPool == null) {
                        String password = resource.getPassword();
                        if (password == null || password.length() == 0) {
                            password = null;
                        }
                        jedisPool = new JedisPool(this.poolConfig, resource.getHost(), resource.getPort(), this.timeout, password, resource.getDb(), null);
                        this.map1.put(resource.getUrl(), jedisPool);
                    }
                }
            }
            return jedisPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JedisSentinelPool getJedisSentinelPool(RedisSentinelResource resource) {
            JedisSentinelPool jedisSentinelPool = this.map2.get(resource.getUrl());
            if (jedisSentinelPool == null) {
                Object object = this.lock;
                synchronized (object) {
                    jedisSentinelPool = this.map2.get(resource.getUrl());
                    if (jedisSentinelPool == null) {
                        List nodes = resource.getNodes();
                        HashSet<String> sentinels = new HashSet<String>();
                        for (RedisSentinelResource.Node node : nodes) {
                            sentinels.add(node.getHost() + ":" + node.getPort());
                        }
                        String password = resource.getPassword();
                        int db = resource.getDb();
                        if (password == null || password.length() == 0) {
                            password = null;
                        }
                        jedisSentinelPool = new JedisSentinelPool(resource.getMaster(), sentinels, this.poolConfig, this.timeout, this.timeout, password, db, resource.getSentinelPassword(), null);
                        this.map2.put(resource.getUrl(), jedisSentinelPool);
                    }
                }
            }
            return jedisSentinelPool;
        }

        @Override
        public JedisPool getCamelliaJedisPool(CamelliaRedisProxyResource resource) {
            return CamelliaRedisProxyContext.getFactory().initOrGet(resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JedisPool getJedisSentinelSlavesPool(RedisSentinelSlavesResource resource) {
            JedisSentinelSlavesPool jedisSentinelSlavesPool = this.map3.get(resource.getUrl());
            if (jedisSentinelSlavesPool == null) {
                Object object = this.lock;
                synchronized (object) {
                    jedisSentinelSlavesPool = this.map3.get(resource.getUrl());
                    if (jedisSentinelSlavesPool == null) {
                        jedisSentinelSlavesPool = new JedisSentinelSlavesPool(resource, this.poolConfig, this.timeout, this.redisSentinelSlavesCheckIntervalMillis);
                        this.map3.put(resource.getUrl(), jedisSentinelSlavesPool);
                    }
                }
            }
            return jedisSentinelSlavesPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JedisPool getRedisProxiesJedisPool(RedisProxiesResource resource) {
            RedisProxyJedisPool redisProxyJedisPool = this.map4.get(resource.getUrl());
            if (redisProxyJedisPool == null) {
                Object object = this.lock;
                synchronized (object) {
                    redisProxyJedisPool = this.map4.get(resource.getUrl());
                    if (redisProxyJedisPool == null) {
                        List nodes = resource.getNodes();
                        ArrayList<Proxy> list = new ArrayList<Proxy>();
                        for (RedisProxiesResource.Node node : nodes) {
                            list.add(new Proxy(node.getHost(), node.getPort()));
                        }
                        DetectedLocalConfProxyDiscovery discovery = new DetectedLocalConfProxyDiscovery(list);
                        redisProxyJedisPool = new RedisProxyJedisPool.Builder().timeout(this.timeout).poolConfig(this.poolConfig).db(resource.getDb()).password(resource.getPassword()).proxyDiscovery((IProxyDiscovery)discovery).build();
                        this.map4.put(resource.getUrl(), redisProxyJedisPool);
                    }
                }
            }
            return redisProxyJedisPool;
        }

        @Override
        public JedisPool getRedisProxiesDiscoveryJedisPool(RedisProxiesDiscoveryResource resource) {
            return RedisProxiesContext.getFactory().initOrGet(resource);
        }
    }
}

