/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.jedis;

import com.netease.nim.camellia.redis.base.exception.CamelliaRedisException;
import com.netease.nim.camellia.redis.base.resource.RedisSentinelResource;
import com.netease.nim.camellia.redis.base.resource.RedisSentinelSlavesResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

public class JedisSentinelSlavesPool
extends JedisPool {
    private static final Logger logger = LoggerFactory.getLogger(JedisSentinelSlavesPool.class);
    private final ConcurrentHashMap<String, JedisPool> poolMap = new ConcurrentHashMap();
    private final RedisSentinelSlavesResource resource;
    private final GenericObjectPoolConfig poolConfig;
    private final int timeout;
    private final String password;
    private final int db;
    private HostAndPort master;
    private List<HostAndPort> slaves;

    public JedisSentinelSlavesPool(RedisSentinelSlavesResource redisSentinelSlavesResource, GenericObjectPoolConfig poolConfig, int timeout) {
        this(redisSentinelSlavesResource, poolConfig, timeout, 5000L);
    }

    public JedisSentinelSlavesPool(RedisSentinelSlavesResource resource, GenericObjectPoolConfig poolConfig, int timeout, long slavesCheckIntervalMillis) {
        this.poolConfig = poolConfig;
        this.timeout = timeout;
        this.password = resource.getPassword();
        this.resource = resource;
        this.db = resource.getDb();
        for (RedisSentinelResource.Node node : resource.getNodes()) {
            if (resource.isWithMaster()) {
                MasterListener masterListener = new MasterListener(this, resource.getMaster(), node.getHost(), node.getPort(), resource.getSentinelPassword());
                if (this.master == null) {
                    masterListener.init();
                }
                masterListener.setDaemon(true);
                masterListener.start();
            }
            SlavesListener slavesListener = new SlavesListener(this, resource.getMaster(), node.getHost(), node.getPort(), resource.getSentinelPassword(), slavesCheckIntervalMillis);
            if (this.slaves == null || this.slaves.isEmpty()) {
                slavesListener.init();
            }
            slavesListener.setDaemon(true);
            slavesListener.start();
        }
        if (this.master == null && (this.slaves == null || this.slaves.isEmpty())) {
            throw new CamelliaRedisException("Could not get an available node of master/slave, url = " + resource.getUrl());
        }
    }

    public Jedis getResource() {
        int retry = 3;
        Exception cause = null;
        while (retry > 0) {
            --retry;
            try {
                JedisPool jedisPool;
                String url;
                HostAndPort slave;
                int index;
                int size;
                if (this.master == null) {
                    size = this.slaves.size();
                    if (size == 0) {
                        cause = new CamelliaRedisException("all slaves down");
                        continue;
                    }
                    index = size == 1 ? 0 : ThreadLocalRandom.current().nextInt(size);
                    slave = this.slaves.get(index);
                    url = slave.getUrl();
                } else if (this.slaves.isEmpty()) {
                    url = this.master.getUrl();
                } else {
                    size = this.slaves.size() + 1;
                    index = ThreadLocalRandom.current().nextInt(size);
                    if (index == 0) {
                        url = this.master.getUrl();
                    } else {
                        slave = this.slaves.get(index - 1);
                        url = slave.getUrl();
                    }
                }
                if ((jedisPool = this.poolMap.get(url)) == null) continue;
                return jedisPool.getResource();
            }
            catch (Exception e) {
                cause = e;
            }
        }
        if (cause == null) {
            throw new CamelliaRedisException("Could not get a resource from the pool");
        }
        throw new CamelliaRedisException("Could not get a resource from the pool", (Throwable)cause);
    }

    public void returnBrokenResource(Jedis resource) {
        if (resource != null) {
            resource.close();
        }
    }

    public void returnResource(Jedis resource) {
        if (resource != null) {
            resource.close();
        }
    }

    private synchronized void updateMaster(HostAndPort master) {
        this.initPool(master);
        if (this.master == null || !this.master.getUrl().equals(master.getUrl())) {
            logger.info("master update, url = {}, oldMaster = {}, newMaster = {}", new Object[]{this.resource.getUrl(), this.master, master});
        }
        this.master = master;
    }

    private synchronized void updateSlaves(List<HostAndPort> slaves) {
        for (HostAndPort hostAndPort : slaves) {
            this.initPool(hostAndPort);
        }
        if (this.slaves == null) {
            logger.info("slaves update, url = {}, oldSlaves = {}, newSlaves = {}", new Object[]{this.resource.getUrl(), this.slaves, slaves});
        } else if (slaves.size() != this.slaves.size()) {
            logger.info("slaves update, url = {}, oldSlaves = {}, newSlaves = {}", new Object[]{this.resource.getUrl(), this.slaves, slaves});
        } else {
            ArrayList<String> oldSlaves = new ArrayList<String>();
            for (HostAndPort slave : this.slaves) {
                oldSlaves.add(slave.toString());
            }
            Collections.sort(oldSlaves);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (HostAndPort slave : slaves) {
                arrayList.add(slave.toString());
            }
            Collections.sort(arrayList);
            if (!((Object)oldSlaves).toString().equals(((Object)arrayList).toString())) {
                logger.info("slaves update, url = {}, oldSlaves = {}, newSlaves = {}", new Object[]{this.resource.getUrl(), this.slaves, slaves});
            }
        }
        this.slaves = slaves;
    }

    private void initPool(HostAndPort hostAndPort) {
        JedisPool jedisPool = this.poolMap.get(hostAndPort.getUrl());
        if (jedisPool == null) {
            jedisPool = new JedisPool(this.poolConfig, hostAndPort.getHost(), hostAndPort.getPort(), this.timeout, this.password, this.db);
            this.poolMap.put(hostAndPort.getUrl(), jedisPool);
        }
    }

    private static class MasterListener
    extends Thread {
        private final JedisSentinelSlavesPool jedisSentinelSlavesPool;
        private final String masterName;
        private final String host;
        private final int port;
        private final String password;
        private final AtomicBoolean running = new AtomicBoolean(false);

        public MasterListener(JedisSentinelSlavesPool jedisSentinelSlavesPool, String masterName, String host, int port, String password) {
            super(String.format("MasterListener-%s-[%s:%d]", masterName, host, port));
            this.jedisSentinelSlavesPool = jedisSentinelSlavesPool;
            this.masterName = masterName;
            this.host = host;
            this.port = port;
            this.password = password;
        }

        public void init() {
            try (Jedis jedis = new Jedis(this.host, this.port);){
                List masterAddr;
                if (this.password != null) {
                    jedis.auth(this.password);
                }
                if ((masterAddr = jedis.sentinelGetMasterAddrByName(this.masterName)) == null || masterAddr.size() != 2) {
                    logger.warn("Can not get master addr, master name: " + this.masterName + ". Sentinel: " + this.host + "\uff1a" + this.port + ".");
                } else {
                    String host = (String)masterAddr.get(0);
                    int port = Integer.parseInt((String)masterAddr.get(1));
                    HostAndPort hostAndPort = new HostAndPort(host, port);
                    this.jedisSentinelSlavesPool.updateMaster(hostAndPort);
                }
            }
            catch (Exception e) {
                logger.error("MasterListener init error", (Throwable)e);
            }
        }

        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                try {
                    Jedis jedis = new Jedis(this.host, this.port);
                    Throwable throwable = null;
                    try {
                        if (!this.running.get()) break;
                        List masterAddr = jedis.sentinelGetMasterAddrByName(this.masterName);
                        if (masterAddr == null || masterAddr.size() != 2) {
                            logger.warn("Can not get master addr, master name: " + this.masterName + ". Sentinel: " + this.host + "\uff1a" + this.port + ".");
                        } else {
                            String host = (String)masterAddr.get(0);
                            int port = Integer.parseInt((String)masterAddr.get(1));
                            HostAndPort hostAndPort = new HostAndPort(host, port);
                            this.jedisSentinelSlavesPool.updateMaster(hostAndPort);
                        }
                        jedis.subscribe(new JedisPubSub(){

                            public void onMessage(String channel, String message) {
                                logger.trace("Sentinel " + host + ":" + port + " published: " + message + ".");
                                String[] switchMasterMsg = message.split(" ");
                                if (switchMasterMsg.length > 3) {
                                    if (masterName.equals(switchMasterMsg[0])) {
                                        String host = switchMasterMsg[3];
                                        int port = Integer.parseInt(switchMasterMsg[4]);
                                        HostAndPort hostAndPort = new HostAndPort(host, port);
                                        jedisSentinelSlavesPool.updateMaster(hostAndPort);
                                    } else {
                                        logger.trace("Ignoring message on +switch-master for master name " + switchMasterMsg[0] + ", our master name is " + masterName);
                                    }
                                } else {
                                    logger.warn("Invalid message received on Sentinel " + host + ":" + port + " on channel +switch-master: " + message);
                                }
                            }
                        }, new String[]{"+switch-master"});
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jedis == null) continue;
                        if (throwable != null) {
                            try {
                                jedis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jedis.close();
                    }
                }
                catch (Exception e) {
                    if (this.running.get()) {
                        logger.warn("Lost connection to Sentinel at " + this.host + ":" + this.port + ". Sleeping 5000ms and retrying.", (Throwable)e);
                        try {
                            TimeUnit.MILLISECONDS.sleep(5000L);
                        }
                        catch (InterruptedException e1) {
                            logger.warn("Sleep interrupted: ", (Throwable)e1);
                        }
                        continue;
                    }
                    logger.trace("Unsubscribing from Sentinel at " + this.host + ":" + this.port);
                }
            }
        }
    }

    private static class SlavesListener
    extends Thread {
        private final JedisSentinelSlavesPool jedisSentinelSlavesPool;
        private final String masterName;
        private final String host;
        private final int port;
        private final String password;
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final long checkIntervalMillis;

        public SlavesListener(JedisSentinelSlavesPool jedisSentinelSlavesPool, String masterName, String host, int port, String password, long checkIntervalMillis) {
            super(String.format("SlavesListener-%s-[%s:%d]", masterName, host, port));
            this.jedisSentinelSlavesPool = jedisSentinelSlavesPool;
            this.masterName = masterName;
            this.host = host;
            this.port = port;
            this.password = password;
            this.checkIntervalMillis = checkIntervalMillis;
        }

        public void init() {
            try (Jedis jedis = new Jedis(this.host, this.port);){
                if (this.password != null) {
                    jedis.auth(this.password);
                }
                this.refresh(jedis);
            }
            catch (Exception e) {
                logger.error("SlavesListener init error", (Throwable)e);
            }
        }

        private void refresh(Jedis jedis) {
            ArrayList<HostAndPort> slaves = new ArrayList<HostAndPort>();
            List list = jedis.sentinelSlaves(this.masterName);
            for (Map map : list) {
                try {
                    String ip = (String)map.get("ip");
                    int port = Integer.parseInt((String)map.get("port"));
                    String flags = (String)map.get("flags");
                    if (flags == null || !flags.equals("slave")) continue;
                    slaves.add(new HostAndPort(ip, port));
                }
                catch (Exception e) {
                    logger.error("parse slaves error", (Throwable)e);
                }
            }
            this.jedisSentinelSlavesPool.updateSlaves(slaves);
        }

        @Override
        public void run() {
            this.running.set(true);
            Jedis jedis = null;
            while (this.running.get()) {
                try {
                    if (jedis == null) {
                        jedis = new Jedis(this.host, this.port);
                    }
                    this.refresh(jedis);
                    TimeUnit.MILLISECONDS.sleep(this.checkIntervalMillis);
                }
                catch (Exception e) {
                    logger.error("sentinelSlaves error", (Throwable)e);
                    if (jedis == null) continue;
                    jedis.close();
                    jedis = null;
                }
            }
        }
    }

    private static class HostAndPort {
        private final String host;
        private final int port;
        private final String url;

        public HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
            this.url = host + ":" + port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.url;
        }
    }
}

