/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.jediscluster;

import com.netease.nim.camellia.redis.CamelliaRedisEnv;
import com.netease.nim.camellia.redis.ICamelliaRedis;
import com.netease.nim.camellia.redis.base.exception.CamelliaRedisException;
import com.netease.nim.camellia.redis.base.resource.RedisClusterResource;
import com.netease.nim.camellia.redis.base.utils.CloseUtil;
import com.netease.nim.camellia.redis.base.utils.SafeEncoder;
import com.netease.nim.camellia.redis.jediscluster.JedisClusterWrapper;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Client;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterCommand;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisAskDataException;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisMovedDataException;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;

public class CamelliaJedisCluster
implements ICamelliaRedis {
    private final JedisClusterWrapper jedisCluster;
    private final CamelliaRedisEnv env;
    private static final String OK = "OK";

    public CamelliaJedisCluster(RedisClusterResource resource, CamelliaRedisEnv env) {
        this.jedisCluster = env.getJedisClusterFactory().getJedisCluster(resource);
        this.env = env;
    }

    @Override
    public List<Jedis> getJedisList() {
        List<JedisPool> jedisPoolList = this.jedisCluster.getJedisPoolList();
        ArrayList<Jedis> jedisList = new ArrayList<Jedis>();
        if (jedisPoolList == null || jedisPoolList.isEmpty()) {
            return jedisList;
        }
        for (JedisPool jedisPool : jedisPoolList) {
            Jedis jedis = jedisPool.getResource();
            jedisList.add(jedis);
        }
        return jedisList;
    }

    @Override
    public Jedis getJedis(byte[] key) {
        return this.jedisCluster.getJedisPool(key).getResource();
    }

    @Override
    public String set(byte[] key, byte[] value) {
        return this.jedisCluster.set(key, value);
    }

    @Override
    public byte[] get(byte[] key) {
        return this.jedisCluster.get(key);
    }

    @Override
    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        return this.jedisCluster.set(key, value, nxxx, expx, time);
    }

    @Override
    public String set(String key, String value) {
        return this.jedisCluster.set(key, value);
    }

    @Override
    public String set(String key, String value, String nxxx, String expx, long time) {
        return this.jedisCluster.set(key, value, nxxx, expx, time);
    }

    @Override
    public String set(String key, String value, String nxxx) {
        return this.jedisCluster.set(key, value, nxxx);
    }

    @Override
    public String set(final byte[] key, final byte[] value, final byte[] nxxx) {
        return (String)new JedisClusterCommand<String>(this.jedisCluster.getConnectionHandler(), this.jedisCluster.getMaxAttempts()){

            public String execute(Jedis connection) {
                return connection.set(key, value, nxxx);
            }
        }.runBinary(key);
    }

    @Override
    public String get(String key) {
        return this.jedisCluster.get(key);
    }

    @Override
    public Boolean exists(String key) {
        return this.jedisCluster.exists(key);
    }

    @Override
    public Long persist(String key) {
        return this.jedisCluster.persist(key);
    }

    @Override
    public String type(String key) {
        return this.jedisCluster.type(key);
    }

    @Override
    public Long expire(String key, int seconds) {
        return this.jedisCluster.expire(key, seconds);
    }

    @Override
    public Long pexpire(String key, long milliseconds) {
        return this.jedisCluster.pexpire(key, milliseconds);
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        return this.jedisCluster.expireAt(key, unixTime);
    }

    @Override
    public Long pexpireAt(String key, long millisecondsTimestamp) {
        return this.jedisCluster.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public Long ttl(String key) {
        return this.jedisCluster.ttl(key);
    }

    @Override
    public Long pttl(String key) {
        return this.jedisCluster.pttl(key);
    }

    @Override
    public Boolean setbit(String key, long offset, boolean value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    @Override
    public Boolean setbit(String key, long offset, String value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    @Override
    public Boolean getbit(String key, long offset) {
        return this.jedisCluster.getbit(key, offset);
    }

    @Override
    public Long setrange(String key, long offset, String value) {
        return this.jedisCluster.setrange(key, offset, value);
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        return this.jedisCluster.getrange(key, startOffset, endOffset);
    }

    @Override
    public String getSet(String key, String value) {
        return this.jedisCluster.getSet(key, value);
    }

    @Override
    public Long setnx(String key, String value) {
        return this.jedisCluster.setnx(key, value);
    }

    @Override
    public String setex(String key, int seconds, String value) {
        return this.jedisCluster.setex(key, seconds, value);
    }

    @Override
    public String psetex(String key, long milliseconds, String value) {
        return this.jedisCluster.psetex(key, milliseconds, value);
    }

    @Override
    public Long decrBy(String key, long integer) {
        return this.jedisCluster.decrBy(key, integer);
    }

    @Override
    public Long decr(String key) {
        return this.jedisCluster.decr(key);
    }

    @Override
    public Long incrBy(String key, long integer) {
        return this.jedisCluster.incrBy(key, integer);
    }

    @Override
    public Double incrByFloat(String key, double value) {
        return this.jedisCluster.incrByFloat(key, value);
    }

    @Override
    public Long incr(String key) {
        return this.jedisCluster.incr(key);
    }

    @Override
    public Long append(String key, String value) {
        return this.jedisCluster.append(key, value);
    }

    @Override
    public String substr(String key, int start, int end) {
        return this.jedisCluster.substr(key, start, end);
    }

    @Override
    public Long hset(String key, String field, String value) {
        return this.jedisCluster.hset(key, field, value);
    }

    @Override
    public String hget(String key, String field) {
        return this.jedisCluster.hget(key, field);
    }

    @Override
    public Long hsetnx(String key, String field, String value) {
        return this.jedisCluster.hsetnx(key, field, value);
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        return this.jedisCluster.hmset(key, hash);
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        return this.jedisCluster.hmget(key, fields);
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        return this.jedisCluster.hincrBy(key, field, value);
    }

    @Override
    public Double hincrByFloat(String key, String field, double value) {
        return this.jedisCluster.hincrByFloat(key, field, value);
    }

    @Override
    public Boolean hexists(String key, String field) {
        return this.jedisCluster.hexists(key, field);
    }

    @Override
    public Long hdel(String key, String ... field) {
        return this.jedisCluster.hdel(key, field);
    }

    @Override
    public Long hlen(String key) {
        return this.jedisCluster.hlen(key);
    }

    @Override
    public Set<String> hkeys(String key) {
        return this.jedisCluster.hkeys(key);
    }

    @Override
    public List<String> hvals(String key) {
        return this.jedisCluster.hvals(key);
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.jedisCluster.hgetAll(key);
    }

    @Override
    public Long rpush(String key, String ... string) {
        return this.jedisCluster.rpush(key, string);
    }

    @Override
    public Long lpush(String key, String ... string) {
        return this.jedisCluster.lpush(key, string);
    }

    @Override
    public Long llen(String key) {
        return this.jedisCluster.llen(key);
    }

    @Override
    public List<String> lrange(String key, long start, long end) {
        return this.jedisCluster.lrange(key, start, end);
    }

    @Override
    public String ltrim(String key, long start, long end) {
        return this.jedisCluster.ltrim(key, start, end);
    }

    @Override
    public String lindex(String key, long index) {
        return this.jedisCluster.lindex(key, index);
    }

    @Override
    public String lset(String key, long index, String value) {
        return this.jedisCluster.lset(key, index, value);
    }

    @Override
    public Long lrem(String key, long count, String value) {
        return this.jedisCluster.lrem(key, count, value);
    }

    @Override
    public String lpop(String key) {
        return this.jedisCluster.lpop(key);
    }

    @Override
    public String rpop(String key) {
        return this.jedisCluster.rpop(key);
    }

    @Override
    public Long sadd(String key, String ... member) {
        return this.jedisCluster.sadd(key, member);
    }

    @Override
    public Set<String> smembers(String key) {
        return this.jedisCluster.smembers(key);
    }

    @Override
    public Long srem(String key, String ... member) {
        return this.jedisCluster.srem(key, member);
    }

    @Override
    public String spop(String key) {
        return this.jedisCluster.spop(key);
    }

    @Override
    public Set<String> spop(String key, long count) {
        return this.jedisCluster.spop(key, count);
    }

    @Override
    public Long scard(String key) {
        return this.jedisCluster.scard(key);
    }

    @Override
    public Boolean sismember(String key, String member) {
        return this.jedisCluster.sismember(key, member);
    }

    @Override
    public String srandmember(String key) {
        return this.jedisCluster.srandmember(key);
    }

    @Override
    public List<String> srandmember(String key, int count) {
        return this.jedisCluster.srandmember(key, count);
    }

    @Override
    public Long strlen(String key) {
        return this.jedisCluster.strlen(key);
    }

    @Override
    public Long zadd(String key, double score, String member) {
        return this.jedisCluster.zadd(key, score, member);
    }

    @Override
    public Long zadd(String key, double score, String member, ZAddParams params) {
        return this.jedisCluster.zadd(key, score, member, params);
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        return this.jedisCluster.zadd(key, scoreMembers);
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        return this.jedisCluster.zadd(key, scoreMembers, params);
    }

    @Override
    public Set<String> zrange(String key, long start, long end) {
        return this.jedisCluster.zrange(key, start, end);
    }

    @Override
    public Long zrem(String key, String ... member) {
        return this.jedisCluster.zrem(key, member);
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        return this.jedisCluster.zincrby(key, score, member);
    }

    @Override
    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        return this.jedisCluster.zincrby(key, score, member, params);
    }

    @Override
    public Long zrank(String key, String member) {
        return this.jedisCluster.zrank(key, member);
    }

    @Override
    public Long zrevrank(String key, String member) {
        return this.jedisCluster.zrevrank(key, member);
    }

    @Override
    public Set<String> zrevrange(String key, long start, long end) {
        return this.jedisCluster.zrevrange(key, start, end);
    }

    @Override
    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        return this.jedisCluster.zrangeWithScores(key, start, end);
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        return this.jedisCluster.zrevrangeWithScores(key, start, end);
    }

    @Override
    public Long zcard(String key) {
        return this.jedisCluster.zcard(key);
    }

    @Override
    public Double zscore(String key, String member) {
        return this.jedisCluster.zscore(key, member);
    }

    @Override
    public List<String> sort(String key) {
        return this.jedisCluster.sort(key);
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        return this.jedisCluster.sort(key, sortingParameters);
    }

    @Override
    public Long zcount(String key, double min, double max) {
        return this.jedisCluster.zcount(key, min, max);
    }

    @Override
    public Long zcount(String key, String min, String max) {
        return this.jedisCluster.zcount(key, min, max);
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min) {
        return this.jedisCluster.zrevrangeByScore(key, max, min);
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min) {
        return this.jedisCluster.zrevrangeByScore(key, max, min);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        return this.jedisCluster.zremrangeByRank(key, start, end);
    }

    @Override
    public Long zremrangeByScore(String key, double start, double end) {
        return this.jedisCluster.zremrangeByScore(key, start, end);
    }

    @Override
    public Long zremrangeByScore(String key, String start, String end) {
        return this.jedisCluster.zremrangeByScore(key, start, end);
    }

    @Override
    public Long zlexcount(String key, String min, String max) {
        return this.jedisCluster.zlexcount(key, min, max);
    }

    @Override
    public Set<String> zrangeByLex(String key, String min, String max) {
        return this.jedisCluster.zrangeByLex(key, min, max);
    }

    @Override
    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByLex(key, min, max, offset, count);
    }

    @Override
    public Set<String> zrevrangeByLex(String key, String max, String min) {
        return this.jedisCluster.zrevrangeByLex(key, max, min);
    }

    @Override
    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        return this.jedisCluster.zrevrangeByLex(key, max, min, offset, count);
    }

    @Override
    public Long zremrangeByLex(String key, String min, String max) {
        return this.jedisCluster.zremrangeByLex(key, min, max);
    }

    @Override
    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        return this.jedisCluster.linsert(key, where, pivot, value);
    }

    @Override
    public Long lpushx(String key, String ... string) {
        return this.jedisCluster.lpushx(key, string);
    }

    @Override
    public Long rpushx(String key, String ... string) {
        return this.jedisCluster.rpushx(key, string);
    }

    @Override
    public Long del(String key) {
        return this.jedisCluster.del(key);
    }

    @Override
    public String echo(String string) {
        return this.jedisCluster.echo(string);
    }

    @Override
    public Long bitcount(String key) {
        return this.jedisCluster.bitcount(key);
    }

    @Override
    public Long bitcount(String key, long start, long end) {
        return this.jedisCluster.bitcount(key, start, end);
    }

    @Override
    public Long bitpos(String key, boolean value) {
        return this.jedisCluster.bitpos(key, value);
    }

    @Override
    public Long bitpos(final byte[] key, final boolean value) {
        return (Long)new JedisClusterCommand<Long>(this.jedisCluster.getConnectionHandler(), this.jedisCluster.getMaxAttempts()){

            public Long execute(Jedis connection) {
                return connection.bitpos(key, value);
            }
        }.runBinary(key);
    }

    @Override
    public Long bitpos(final byte[] key, final boolean value, final BitPosParams params) {
        return (Long)new JedisClusterCommand<Long>(this.jedisCluster.getConnectionHandler(), this.jedisCluster.getMaxAttempts()){

            public Long execute(Jedis connection) {
                return connection.bitpos(key, value, params);
            }
        }.runBinary(key);
    }

    @Override
    public Long bitpos(String key, boolean value, BitPosParams params) {
        return this.jedisCluster.bitpos(key, value, params);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.jedisCluster.hscan(key, cursor);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        return this.jedisCluster.hscan(key, cursor, params);
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor) {
        return this.jedisCluster.sscan(key, cursor);
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        return this.jedisCluster.sscan(key, cursor, params);
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        return this.jedisCluster.zscan(key, cursor);
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        return this.jedisCluster.zscan(key, cursor, params);
    }

    @Override
    public Long pfadd(String key, String ... elements) {
        return this.jedisCluster.pfadd(key, elements);
    }

    @Override
    public long pfcount(String key) {
        return this.jedisCluster.pfcount(key);
    }

    @Override
    public Long geoadd(String key, double longitude, double latitude, String member) {
        return this.jedisCluster.geoadd(key, longitude, latitude, member);
    }

    @Override
    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        return this.jedisCluster.geoadd(key, memberCoordinateMap);
    }

    @Override
    public Double geodist(String key, String member1, String member2) {
        return this.jedisCluster.geodist(key, member1, member2);
    }

    @Override
    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        return this.jedisCluster.geodist(key, member1, member2, unit);
    }

    @Override
    public List<String> geohash(String key, String ... members) {
        return this.jedisCluster.geohash(key, members);
    }

    @Override
    public List<GeoCoordinate> geopos(String key, String ... members) {
        return this.jedisCluster.geopos(key, members);
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit, param);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit, param);
    }

    @Override
    public List<Long> bitfield(String key, String ... arguments) {
        return this.jedisCluster.bitfield(key, arguments);
    }

    @Override
    public Long del(byte[] ... keys) {
        Future<Long> future;
        if (keys == null) {
            return 0L;
        }
        if (keys.length == 0) {
            return 0L;
        }
        Map map = this.toMap((T[])keys);
        ArrayList<Future<Long>> futureList = new ArrayList<Future<Long>>();
        ConcurrentHashMap failMap = new ConcurrentHashMap();
        for (Map.Entry entry : map.entrySet()) {
            JedisPool jedisPool = entry.getKey();
            List list = entry.getValue();
            if (list == null || list.isEmpty()) continue;
            future = this.env.getConcurrentExec().submit(() -> {
                Jedis jedis = null;
                try {
                    Response response;
                    jedis = jedisPool.getResource();
                    Pipeline pipelined = jedis.pipelined();
                    ArrayList<Response> responseList = new ArrayList<Response>();
                    for (byte[] key : list) {
                        response = pipelined.del(key);
                        responseList.add(response);
                    }
                    pipelined.sync();
                    Long ret = 0L;
                    for (int i = 0; i < responseList.size(); ++i) {
                        response = (Response)responseList.get(i);
                        try {
                            ret = ret + (Long)response.get();
                            continue;
                        }
                        catch (Exception e) {
                            byte[] key = (byte[])list.get(i);
                            this.handlerException(key, e, failMap);
                        }
                    }
                    Long l = ret;
                    return l;
                }
                catch (Exception e) {
                    for (byte[] key : list) {
                        this.handlerException(key, e, failMap);
                    }
                    Long l = 0L;
                    return l;
                }
                finally {
                    CloseUtil.closeQuietly((Closeable)jedis);
                }
            });
            futureList.add(future);
        }
        Long ret = this.longFutureListGet(futureList);
        if (!failMap.isEmpty()) {
            ArrayList<Future<Long>> failFutureList = new ArrayList<Future<Long>>();
            for (Map.Entry entry : failMap.entrySet()) {
                future = this.env.getConcurrentExec().submit(() -> {
                    byte[] key = (byte[])entry.getKey();
                    return this.jedisCluster.del(key);
                });
                failFutureList.add(future);
            }
            ret = ret + this.longFutureListGet(failFutureList);
        }
        return ret;
    }

    @Override
    public Long exists(byte[] ... keys) {
        Future<Long> future;
        if (keys == null) {
            return 0L;
        }
        if (keys.length == 0) {
            return 0L;
        }
        Map map = this.toMap((T[])keys);
        ArrayList<Future<Long>> futureList = new ArrayList<Future<Long>>();
        ConcurrentHashMap failMap = new ConcurrentHashMap();
        for (Map.Entry entry : map.entrySet()) {
            JedisPool jedisPool = entry.getKey();
            List list = entry.getValue();
            if (list == null || list.isEmpty()) continue;
            future = this.env.getConcurrentExec().submit(() -> {
                Jedis jedis = null;
                try {
                    jedis = jedisPool.getResource();
                    Pipeline pipelined = jedis.pipelined();
                    ArrayList<Response> responseList = new ArrayList<Response>();
                    for (byte[] key : list) {
                        Response response = pipelined.exists(key);
                        responseList.add(response);
                    }
                    pipelined.sync();
                    long ret = 0L;
                    for (int i = 0; i < responseList.size(); ++i) {
                        Response response = (Response)responseList.get(i);
                        try {
                            ret += (Boolean)response.get() != false ? 1L : 0L;
                            continue;
                        }
                        catch (Exception e) {
                            byte[] key = (byte[])list.get(i);
                            this.handlerException(key, e, failMap);
                        }
                    }
                    Long l = ret;
                    return l;
                }
                catch (Exception e) {
                    for (byte[] key : list) {
                        this.handlerException(key, e, failMap);
                    }
                    Long l = 0L;
                    return l;
                }
                finally {
                    CloseUtil.closeQuietly((Closeable)jedis);
                }
            });
            futureList.add(future);
        }
        Long ret = this.longFutureListGet(futureList);
        if (!failMap.isEmpty()) {
            ArrayList<Future<Long>> failFutureList = new ArrayList<Future<Long>>();
            for (Map.Entry entry : failMap.entrySet()) {
                future = this.env.getConcurrentExec().submit(() -> {
                    Boolean exists = this.jedisCluster.exists((byte[])entry.getKey());
                    return exists != false ? 1L : 0L;
                });
                failFutureList.add(future);
            }
            ret = ret + this.longFutureListGet(failFutureList);
        }
        return ret;
    }

    private void handlerException(byte[] key, Exception e, ConcurrentHashMap<byte[], Exception> failMap) throws CamelliaRedisException {
        if (e == null) {
            return;
        }
        if (e instanceof JedisMovedDataException) {
            this.jedisCluster.renewSlotCache();
            failMap.put(key, e);
            return;
        }
        if (e instanceof JedisAskDataException) {
            failMap.put(key, e);
            return;
        }
        if (e instanceof JedisConnectionException) {
            this.jedisCluster.renewSlotCache();
            failMap.put(key, e);
            return;
        }
        if (e instanceof JedisClusterException) {
            this.jedisCluster.renewSlotCache();
            failMap.put(key, e);
            return;
        }
        throw new CamelliaRedisException((Throwable)e);
    }

    @Override
    public Map<byte[], byte[]> mget(byte[] ... keys) {
        if (keys == null) {
            return Collections.emptyMap();
        }
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        Map map = this.toMap((T[])keys);
        ArrayList futureList = new ArrayList();
        ConcurrentHashMap failMap = new ConcurrentHashMap();
        HashMap<byte[], byte[]> retMap = new HashMap<byte[], byte[]>();
        for (Map.Entry entry : map.entrySet()) {
            JedisPool jedisPool = entry.getKey();
            List list = entry.getValue();
            if (list == null || list.isEmpty()) continue;
            Future<?> future = this.env.getConcurrentExec().submit(() -> {
                Jedis jedis = null;
                try {
                    Response response;
                    jedis = jedisPool.getResource();
                    Pipeline pipelined = jedis.pipelined();
                    ArrayList<Response> responseList = new ArrayList<Response>();
                    for (byte[] key : list) {
                        response = pipelined.get(key);
                        responseList.add(response);
                    }
                    pipelined.sync();
                    for (int i = 0; i < list.size(); ++i) {
                        byte[] key;
                        key = (byte[])list.get(i);
                        response = (Response)responseList.get(i);
                        try {
                            Map map = retMap;
                            synchronized (map) {
                                retMap.put(key, (byte[])response.get());
                                continue;
                            }
                        }
                        catch (Exception e) {
                            this.handlerException(key, e, failMap);
                        }
                    }
                }
                catch (Exception e) {
                    for (byte[] key : list) {
                        this.handlerException(key, e, failMap);
                    }
                }
                finally {
                    CloseUtil.closeQuietly((Closeable)jedis);
                }
            });
            futureList.add(future);
        }
        try {
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (Exception e) {
            this.handlerFutureException(e);
        }
        if (!failMap.isEmpty()) {
            ArrayList failFutureList = new ArrayList();
            for (Map.Entry entry : failMap.entrySet()) {
                Future<?> future = this.env.getConcurrentExec().submit(() -> {
                    byte[] key = (byte[])entry.getKey();
                    byte[] value = this.jedisCluster.get(key);
                    Map map = retMap;
                    synchronized (map) {
                        retMap.put(key, value);
                    }
                });
                failFutureList.add(future);
            }
            try {
                for (Future future : failFutureList) {
                    future.get();
                }
            }
            catch (Exception exception) {
                this.handlerFutureException(exception);
            }
        }
        return retMap;
    }

    @Override
    public String mset(Map<byte[], byte[]> keysvalues) {
        Object key;
        if (keysvalues == null) {
            return null;
        }
        if (keysvalues.isEmpty()) {
            return null;
        }
        HashMap map = new HashMap();
        for (Map.Entry<byte[], byte[]> entry : keysvalues.entrySet()) {
            key = entry.getKey();
            byte[] byArray = entry.getValue();
            if (key == null || byArray == null) continue;
            JedisPool jedisPool = this.jedisCluster.getJedisPool((byte[])key);
            this.addToMap(map, jedisPool, entry);
        }
        ConcurrentHashMap failMap = new ConcurrentHashMap();
        ArrayList futureList = new ArrayList();
        key = map.entrySet().iterator();
        while (key.hasNext()) {
            Map.Entry entry = (Map.Entry)key.next();
            JedisPool jedisPool = (JedisPool)entry.getKey();
            List list = (List)entry.getValue();
            if (list == null || list.isEmpty()) continue;
            Future<?> future = this.env.getConcurrentExec().submit(() -> {
                Jedis jedis = null;
                try {
                    jedis = jedisPool.getResource();
                    Pipeline pipelined = jedis.pipelined();
                    ArrayList<Response> responseList = new ArrayList<Response>();
                    for (Map.Entry subEntry : list) {
                        Response response = pipelined.set((byte[])subEntry.getKey(), (byte[])subEntry.getValue());
                        responseList.add(response);
                    }
                    pipelined.sync();
                    for (int i = 0; i < responseList.size(); ++i) {
                        Response response = (Response)responseList.get(i);
                        try {
                            String ret = (String)response.get();
                            if (ret.equalsIgnoreCase(OK)) continue;
                            throw new CamelliaRedisException(ret);
                        }
                        catch (Exception e) {
                            Map.Entry subEntry = (Map.Entry)list.get(i);
                            this.msetHandlerException(e, (byte[])subEntry.getKey(), (byte[])subEntry.getValue(), failMap);
                        }
                    }
                }
                catch (Exception e) {
                    for (Map.Entry subEntry : list) {
                        this.msetHandlerException(e, (byte[])subEntry.getKey(), (byte[])subEntry.getValue(), failMap);
                    }
                }
                finally {
                    CloseUtil.closeQuietly((Closeable)jedis);
                }
            });
            futureList.add(future);
        }
        try {
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (Exception e) {
            this.handlerFutureException(e);
        }
        if (!failMap.isEmpty()) {
            ArrayList failFutureList = new ArrayList();
            for (Map.Entry entry : failMap.entrySet()) {
                Future<?> future = this.env.getConcurrentExec().submit(() -> {
                    String set = this.jedisCluster.set((byte[])entry.getKey(), (byte[])entry.getValue());
                    if (!set.equalsIgnoreCase(OK)) {
                        throw new CamelliaRedisException(set);
                    }
                });
                failFutureList.add(future);
            }
            try {
                for (Future future : failFutureList) {
                    future.get();
                }
            }
            catch (Exception exception) {
                this.handlerFutureException(exception);
            }
        }
        return OK;
    }

    private void handlerFutureException(Exception e) {
        if (e instanceof ExecutionException) {
            Throwable cause = e.getCause();
            if (cause != null) {
                if (cause instanceof CamelliaRedisException) {
                    throw (CamelliaRedisException)cause;
                }
                throw new CamelliaRedisException(cause);
            }
            throw new CamelliaRedisException((Throwable)e);
        }
        throw new CamelliaRedisException((Throwable)e);
    }

    private void msetHandlerException(Exception e, byte[] key, byte[] value, ConcurrentHashMap<byte[], byte[]> failMap) throws CamelliaRedisException {
        if (e instanceof JedisConnectionException) {
            this.jedisCluster.renewSlotCache();
            failMap.put(key, value);
            return;
        }
        if (e instanceof JedisMovedDataException) {
            this.jedisCluster.renewSlotCache();
            failMap.put(key, value);
            return;
        }
        if (e instanceof JedisAskDataException) {
            failMap.put(key, value);
            return;
        }
        if (e instanceof JedisClusterException) {
            this.jedisCluster.renewSlotCache();
            failMap.put(key, value);
            return;
        }
        throw new CamelliaRedisException((Throwable)e);
    }

    @Override
    public Long del(String ... keys) {
        if (keys == null) {
            return 0L;
        }
        if (keys.length == 0) {
            return 0L;
        }
        ArrayList<byte[]> keysRaw = new ArrayList<byte[]>();
        for (String key : keys) {
            keysRaw.add(SafeEncoder.encode((String)key));
        }
        return this.del((byte[][])keysRaw.toArray((T[])new byte[0][0]));
    }

    private Long longFutureListGet(List<Future<Long>> futureList) {
        if (futureList == null) {
            return null;
        }
        if (futureList.isEmpty()) {
            return 0L;
        }
        Long ret = 0L;
        try {
            for (Future<Long> future : futureList) {
                ret = ret + future.get();
            }
            return ret;
        }
        catch (Exception e) {
            this.handlerFutureException(e);
            return ret;
        }
    }

    @SafeVarargs
    private final <T> Map<JedisPool, List<T>> toMap(T ... keys) {
        HashMap<JedisPool, List<T>> map = new HashMap<JedisPool, List<T>>();
        for (T key : keys) {
            JedisPool jedisPool;
            if (key instanceof byte[]) {
                jedisPool = this.jedisCluster.getJedisPool((byte[])key);
            } else if (key instanceof String) {
                jedisPool = this.jedisCluster.getJedisPool((String)key);
            } else {
                throw new IllegalArgumentException("key not byte[] or String");
            }
            this.addToMap(map, jedisPool, key);
        }
        return map;
    }

    private <K, V> void addToMap(Map<K, List<V>> map, K k, V v) {
        List<V> list = map.get(k);
        if (list == null) {
            list = new ArrayList<V>();
            list.add(v);
            map.put(k, list);
        } else {
            list.add(v);
        }
    }

    @Override
    public Long exists(String ... keys) {
        if (keys == null) {
            return 0L;
        }
        if (keys.length == 0) {
            return 0L;
        }
        ArrayList<byte[]> keysRaw = new ArrayList<byte[]>();
        for (String key : keys) {
            keysRaw.add(SafeEncoder.encode((String)key));
        }
        return this.exists((byte[][])keysRaw.toArray((T[])new byte[0][0]));
    }

    @Override
    public Map<String, String> mget(String ... keys) {
        if (keys == null) {
            return Collections.emptyMap();
        }
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        byte[][] bytes = SafeEncoder.encodeMany((String[])keys);
        Map<byte[], byte[]> map = this.mget(bytes);
        if (map == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (Map.Entry<byte[], byte[]> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                retMap.put(SafeEncoder.encode((byte[])entry.getKey()), null);
                continue;
            }
            retMap.put(SafeEncoder.encode((byte[])entry.getKey()), SafeEncoder.encode((byte[])entry.getValue()));
        }
        return retMap;
    }

    @Override
    public Boolean exists(byte[] key) {
        return this.jedisCluster.exists(key);
    }

    @Override
    public Long persist(byte[] key) {
        return this.jedisCluster.persist(key);
    }

    @Override
    public String type(byte[] key) {
        return this.jedisCluster.type(key);
    }

    @Override
    public Long expire(byte[] key, int seconds) {
        return this.jedisCluster.expire(key, seconds);
    }

    @Override
    public Long pexpire(byte[] key, long milliseconds) {
        return this.jedisCluster.pexpire(key, milliseconds);
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        return this.jedisCluster.expireAt(key, unixTime);
    }

    @Override
    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        return this.jedisCluster.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public Long ttl(byte[] key) {
        return this.jedisCluster.ttl(key);
    }

    @Override
    public Long pttl(byte[] key) {
        return this.jedisCluster.pttl(key);
    }

    @Override
    public Boolean setbit(byte[] key, long offset, boolean value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    @Override
    public Boolean setbit(byte[] key, long offset, byte[] value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    @Override
    public Boolean getbit(byte[] key, long offset) {
        return this.jedisCluster.getbit(key, offset);
    }

    @Override
    public Long setrange(byte[] key, long offset, byte[] value) {
        return this.jedisCluster.setrange(key, offset, value);
    }

    @Override
    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        return this.jedisCluster.getrange(key, startOffset, endOffset);
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        return this.jedisCluster.getSet(key, value);
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        return this.jedisCluster.setnx(key, value);
    }

    @Override
    public String setex(byte[] key, int seconds, byte[] value) {
        return this.jedisCluster.setex(key, seconds, value);
    }

    @Override
    public String psetex(final byte[] key, final long milliseconds, final byte[] value) {
        return (String)new JedisClusterCommand<String>(this.jedisCluster.getConnectionHandler(), this.jedisCluster.getMaxAttempts()){

            public String execute(Jedis connection) {
                return connection.psetex(key, milliseconds, value);
            }
        }.runBinary(key);
    }

    @Override
    public Long decrBy(byte[] key, long integer) {
        return this.jedisCluster.decrBy(key, integer);
    }

    @Override
    public Long decr(byte[] key) {
        return this.jedisCluster.decr(key);
    }

    @Override
    public Long incrBy(byte[] key, long integer) {
        return this.jedisCluster.incrBy(key, integer);
    }

    @Override
    public Double incrByFloat(byte[] key, double value) {
        return this.jedisCluster.incrByFloat(key, value);
    }

    @Override
    public Long incr(byte[] key) {
        return this.jedisCluster.incr(key);
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        return this.jedisCluster.append(key, value);
    }

    @Override
    public byte[] substr(byte[] key, int start, int end) {
        return this.jedisCluster.substr(key, start, end);
    }

    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        return this.jedisCluster.hset(key, field, value);
    }

    @Override
    public byte[] hget(byte[] key, byte[] field) {
        return this.jedisCluster.hget(key, field);
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        return this.jedisCluster.hsetnx(key, field, value);
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        return this.jedisCluster.hmset(key, hash);
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        return this.jedisCluster.hmget(key, fields);
    }

    @Override
    public Long hincrBy(byte[] key, byte[] field, long value) {
        return this.jedisCluster.hincrBy(key, field, value);
    }

    @Override
    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        return this.jedisCluster.hincrByFloat(key, field, value);
    }

    @Override
    public Boolean hexists(byte[] key, byte[] field) {
        return this.jedisCluster.hexists(key, field);
    }

    @Override
    public Long hdel(byte[] key, byte[] ... field) {
        return this.jedisCluster.hdel(key, field);
    }

    @Override
    public Long hlen(byte[] key) {
        return this.jedisCluster.hlen(key);
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        return this.jedisCluster.hkeys(key);
    }

    @Override
    public List<byte[]> hvals(byte[] key) {
        Collection list = this.jedisCluster.hvals(key);
        if (list instanceof List) {
            return (List)list;
        }
        return new ArrayList<byte[]>(list);
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        return this.jedisCluster.hgetAll(key);
    }

    @Override
    public Long rpush(byte[] key, byte[] ... args) {
        return this.jedisCluster.rpush(key, args);
    }

    @Override
    public Long lpush(byte[] key, byte[] ... args) {
        return this.jedisCluster.lpush(key, args);
    }

    @Override
    public Long llen(byte[] key) {
        return this.jedisCluster.llen(key);
    }

    @Override
    public List<byte[]> lrange(byte[] key, long start, long end) {
        return this.jedisCluster.lrange(key, start, end);
    }

    @Override
    public String ltrim(byte[] key, long start, long end) {
        return this.jedisCluster.ltrim(key, start, end);
    }

    @Override
    public byte[] lindex(byte[] key, long index) {
        return this.jedisCluster.lindex(key, index);
    }

    @Override
    public String lset(byte[] key, long index, byte[] value) {
        return this.jedisCluster.lset(key, index, value);
    }

    @Override
    public Long lrem(byte[] key, long count, byte[] value) {
        return this.jedisCluster.lrem(key, count, value);
    }

    @Override
    public byte[] lpop(byte[] key) {
        return this.jedisCluster.lpop(key);
    }

    @Override
    public byte[] rpop(byte[] key) {
        return this.jedisCluster.rpop(key);
    }

    @Override
    public Long sadd(byte[] key, byte[] ... member) {
        return this.jedisCluster.sadd(key, member);
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        return this.jedisCluster.smembers(key);
    }

    @Override
    public Long srem(byte[] key, byte[] ... member) {
        return this.jedisCluster.srem(key, member);
    }

    @Override
    public byte[] spop(byte[] key) {
        return this.jedisCluster.spop(key);
    }

    @Override
    public Set<byte[]> spop(byte[] key, long count) {
        return this.jedisCluster.spop(key, count);
    }

    @Override
    public Long scard(byte[] key) {
        return this.jedisCluster.scard(key);
    }

    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        return this.jedisCluster.sismember(key, member);
    }

    @Override
    public byte[] srandmember(byte[] key) {
        return this.jedisCluster.srandmember(key);
    }

    @Override
    public List<byte[]> srandmember(byte[] key, int count) {
        return this.jedisCluster.srandmember(key, count);
    }

    @Override
    public Long strlen(byte[] key) {
        return this.jedisCluster.strlen(key);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        return this.jedisCluster.zadd(key, score, member);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        return this.jedisCluster.zadd(key, score, member, params);
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        return this.jedisCluster.zadd(key, scoreMembers);
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        return this.jedisCluster.zadd(key, scoreMembers, params);
    }

    @Override
    public Set<byte[]> zrange(byte[] key, long start, long end) {
        return this.jedisCluster.zrange(key, start, end);
    }

    @Override
    public Long zrem(byte[] key, byte[] ... member) {
        return this.jedisCluster.zrem(key, member);
    }

    @Override
    public Double zincrby(byte[] key, double score, byte[] member) {
        return this.jedisCluster.zincrby(key, score, member);
    }

    @Override
    public Double zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        return this.jedisCluster.zincrby(key, score, member, params);
    }

    @Override
    public Long zrank(byte[] key, byte[] member) {
        return this.jedisCluster.zrank(key, member);
    }

    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        return this.jedisCluster.zrevrank(key, member);
    }

    @Override
    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        return this.jedisCluster.zrevrange(key, start, end);
    }

    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        return this.jedisCluster.zrangeWithScores(key, start, end);
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        return this.jedisCluster.zrevrangeWithScores(key, start, end);
    }

    @Override
    public Long zcard(byte[] key) {
        return this.jedisCluster.zcard(key);
    }

    @Override
    public Double zscore(byte[] key, byte[] member) {
        return this.jedisCluster.zscore(key, member);
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        return this.jedisCluster.sort(key);
    }

    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        return this.jedisCluster.sort(key, sortingParameters);
    }

    @Override
    public Long zcount(byte[] key, double min, double max) {
        return this.jedisCluster.zcount(key, min, max);
    }

    @Override
    public Long zcount(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zcount(key, min, max);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        return this.jedisCluster.zrevrangeByScore(key, max, min);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        return this.jedisCluster.zrevrangeByScore(key, max, min);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Long zremrangeByRank(byte[] key, long start, long end) {
        return this.jedisCluster.zremrangeByRank(key, start, end);
    }

    @Override
    public Long zremrangeByScore(byte[] key, double start, double end) {
        return this.jedisCluster.zremrangeByScore(key, start, end);
    }

    @Override
    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        return this.jedisCluster.zremrangeByScore(key, start, end);
    }

    @Override
    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zlexcount(key, min, max);
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zrangeByLex(key, min, max);
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        return this.jedisCluster.zrangeByLex(key, min, max, offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        return this.jedisCluster.zrevrangeByLex(key, max, min);
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        return this.jedisCluster.zrevrangeByLex(key, max, min, offset, count);
    }

    @Override
    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zremrangeByLex(key, min, max);
    }

    @Override
    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        return this.jedisCluster.linsert(key, where, pivot, value);
    }

    @Override
    public Long lpushx(byte[] key, byte[] ... arg) {
        return this.jedisCluster.lpushx(key, arg);
    }

    @Override
    public Long rpushx(byte[] key, byte[] ... arg) {
        return this.jedisCluster.rpushx(key, arg);
    }

    @Override
    public Long del(byte[] key) {
        return this.jedisCluster.del(key);
    }

    @Override
    public Long bitcount(byte[] key) {
        return this.jedisCluster.bitcount(key);
    }

    @Override
    public Long bitcount(byte[] key, long start, long end) {
        return this.jedisCluster.bitcount(key, start, end);
    }

    @Override
    public Long pfadd(byte[] key, byte[] ... elements) {
        return this.jedisCluster.pfadd(key, elements);
    }

    @Override
    public long pfcount(byte[] key) {
        return this.jedisCluster.pfcount(key);
    }

    @Override
    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        return this.jedisCluster.geoadd(key, longitude, latitude, member);
    }

    @Override
    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        return this.jedisCluster.geoadd(key, memberCoordinateMap);
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        return this.jedisCluster.geodist(key, member1, member2);
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        return this.jedisCluster.geodist(key, member1, member2, unit);
    }

    @Override
    public List<byte[]> geohash(byte[] key, byte[] ... members) {
        return this.jedisCluster.geohash(key, members);
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members) {
        return this.jedisCluster.geopos(key, members);
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit, param);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit, param);
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        return this.jedisCluster.hscan(key, cursor);
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        return this.jedisCluster.hscan(key, cursor, params);
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        return this.jedisCluster.sscan(key, cursor);
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params) {
        return this.jedisCluster.sscan(key, cursor, params);
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        return this.jedisCluster.zscan(key, cursor);
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params) {
        return this.jedisCluster.zscan(key, cursor, params);
    }

    @Override
    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        return this.jedisCluster.bitfield(key, arguments);
    }

    @Override
    public Object eval(final byte[] script, final int keyCount, final byte[] ... params) {
        return new JedisClusterCommand<Object>(this.jedisCluster.getConnectionHandler(), this.jedisCluster.getMaxAttempts()){

            public Object execute(Jedis connection) {
                Client client = connection.getClient();
                client.eval(script, Protocol.toByteArray((int)keyCount), params);
                return client.getOne();
            }
        }.runBinary(keyCount, params);
    }

    @Override
    public Object evalsha(final byte[] sha1, final int keyCount, final byte[] ... params) {
        return new JedisClusterCommand<Object>(this.jedisCluster.getConnectionHandler(), this.jedisCluster.getMaxAttempts()){

            public Object execute(Jedis connection) {
                Client client = connection.getClient();
                client.evalsha(sha1, Protocol.toByteArray((int)keyCount), params);
                return client.getOne();
            }
        }.runBinary(keyCount, params);
    }

    @Override
    public byte[] dump(final String key) {
        return (byte[])new JedisClusterCommand<byte[]>(this.jedisCluster.getConnectionHandler(), this.jedisCluster.getMaxAttempts()){

            public byte[] execute(Jedis connection) {
                return connection.dump(key);
            }
        }.runBinary(SafeEncoder.encode((String)key));
    }

    @Override
    public byte[] dump(final byte[] key) {
        return (byte[])new JedisClusterCommand<byte[]>(this.jedisCluster.getConnectionHandler(), this.jedisCluster.getMaxAttempts()){

            public byte[] execute(Jedis connection) {
                return connection.dump(key);
            }
        }.runBinary(key);
    }

    @Override
    public String restore(final byte[] key, final int ttl, final byte[] serializedValue) {
        return (String)new JedisClusterCommand<String>(this.jedisCluster.getConnectionHandler(), this.jedisCluster.getMaxAttempts()){

            public String execute(Jedis connection) {
                return connection.restore(key, ttl, serializedValue);
            }
        }.runBinary(key);
    }

    @Override
    public String restore(final String key, final int ttl, final byte[] serializedValue) {
        return (String)new JedisClusterCommand<String>(this.jedisCluster.getConnectionHandler(), this.jedisCluster.getMaxAttempts()){

            public String execute(Jedis connection) {
                return connection.restore(key, ttl, serializedValue);
            }
        }.runBinary(SafeEncoder.encode((String)key));
    }
}

