/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.jediscluster;

import com.netease.nim.camellia.redis.base.resource.RedisClusterResource;
import com.netease.nim.camellia.redis.conf.CamelliaRedisConstants;
import com.netease.nim.camellia.redis.jediscluster.JedisClusterWrapper;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisPoolConfig;

public interface JedisClusterFactory {
    public static final JedisClusterFactory DEFAULT = new DefaultJedisClusterFactory();

    public JedisClusterWrapper getJedisCluster(RedisClusterResource var1);

    public static class DefaultJedisClusterFactory
    implements JedisClusterFactory {
        private final Object lock = new Object();
        private final ConcurrentHashMap<String, JedisClusterWrapper> map = new ConcurrentHashMap();
        private final GenericObjectPoolConfig poolConfig;
        private final int connectionTimeout;
        private final int soTimeout;
        private final int maxAttempts;

        public DefaultJedisClusterFactory() {
            this.poolConfig = new JedisPoolConfig();
            this.poolConfig.setMinIdle(0);
            this.poolConfig.setMaxTotal(CamelliaRedisConstants.JedisCluster.maxTotal);
            this.poolConfig.setMaxIdle(CamelliaRedisConstants.JedisCluster.maxIdle);
            this.poolConfig.setMaxWaitMillis(2000L);
            this.connectionTimeout = 2000;
            this.soTimeout = 2000;
            this.maxAttempts = 5;
        }

        public DefaultJedisClusterFactory(GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, int maxAttempts) {
            this.poolConfig = poolConfig;
            this.connectionTimeout = connectionTimeout;
            this.soTimeout = soTimeout;
            this.maxAttempts = maxAttempts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JedisClusterWrapper getJedisCluster(RedisClusterResource resource) {
            JedisClusterWrapper jedisCluster = this.map.get(resource.getUrl());
            if (jedisCluster == null) {
                Object object = this.lock;
                synchronized (object) {
                    jedisCluster = this.map.get(resource.getUrl());
                    if (jedisCluster == null) {
                        String password = resource.getPassword();
                        HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
                        for (RedisClusterResource.Node node : resource.getNodes()) {
                            HostAndPort hostAndPort = new HostAndPort(node.getHost(), node.getPort());
                            nodes.add(hostAndPort);
                        }
                        if (password == null || password.length() == 0) {
                            password = null;
                        }
                        jedisCluster = new JedisClusterWrapper(nodes, this.connectionTimeout, this.soTimeout, this.maxAttempts, password, this.poolConfig);
                        this.map.put(resource.getUrl(), jedisCluster);
                    }
                }
            }
            return jedisCluster;
        }
    }
}

