/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.pipeline;

import com.netease.nim.camellia.redis.CamelliaRedisEnv;
import com.netease.nim.camellia.redis.pipeline.CamelliaRedisPipeline;
import java.util.concurrent.LinkedBlockingQueue;

public class PipelinePool {
    private final LinkedBlockingQueue<Item> queue;

    public PipelinePool(CamelliaRedisEnv env) {
        this.queue = new LinkedBlockingQueue(env.getPipelinePoolSize());
    }

    public CamelliaRedisPipeline get() {
        Item item = this.queue.poll();
        if (item == null) {
            return null;
        }
        if (item.openCallback != null) {
            item.openCallback.run();
        }
        return item.pipeline;
    }

    public boolean set(CamelliaRedisPipeline pipeline, Runnable openCallback) {
        return pipeline != null && this.queue.offer(new Item(pipeline, openCallback));
    }

    private static class Item {
        CamelliaRedisPipeline pipeline;
        Runnable openCallback;

        Item(CamelliaRedisPipeline pipeline, Runnable openCallback) {
            this.pipeline = pipeline;
            this.openCallback = openCallback;
        }
    }
}

