/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.pipeline;

import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.CamelliaRedisEnv;
import com.netease.nim.camellia.redis.base.exception.CamelliaRedisException;
import com.netease.nim.camellia.redis.base.resource.RedisClusterResource;
import com.netease.nim.camellia.redis.base.utils.SafeEncoder;
import com.netease.nim.camellia.redis.pipeline.RedisClientPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Future;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisAskDataException;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisMovedDataException;

public class ResponseQueable {
    private final Map<Client, Queue<Item>> map = new HashMap<Client, Queue<Item>>();
    private final List<Item> fallbackList = new ArrayList<Item>();
    private final CamelliaRedisEnv env;

    public ResponseQueable(CamelliaRedisEnv env) {
        this.env = env;
    }

    <T> Response<T> getResponse(Client client, Builder<T> builder, Resource resource, Object key, Fallback fallback) {
        Queue queue = this.map.get(client);
        if (queue == null) {
            queue = this.map.computeIfAbsent(client, k -> new LinkedList());
        }
        Response response = new Response(builder);
        queue.add(new Item(response, resource, key, fallback));
        return response;
    }

    void sync(RedisClientPool redisClientPool) {
        int attempts;
        boolean concurrentEnable = this.map.size() > 1 && this.env.isPipelineConcurrentEnable();
        int initAttempts = attempts = this.env.getPipelineMaxAttempts();
        ArrayList futureList = new ArrayList();
        for (Map.Entry<Client, Queue<Item>> entry : this.map.entrySet()) {
            Runnable runnable = () -> {
                Client client = (Client)entry.getKey();
                Queue queue = (Queue)entry.getValue();
                this.handlerClient(redisClientPool, client, queue, initAttempts > 0);
            };
            if (concurrentEnable) {
                Future<?> future = this.env.getConcurrentExec().submit(runnable);
                futureList.add(future);
                continue;
            }
            runnable.run();
        }
        try {
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new CamelliaRedisException((Throwable)e);
        }
        if (this.fallbackList.isEmpty()) {
            return;
        }
        while (attempts > 0) {
            Object key;
            boolean retry;
            boolean bl = retry = --attempts != 0;
            if (this.fallbackList.isEmpty()) break;
            redisClientPool.clear();
            HashMap<Client, Queue> hashMap = new HashMap<Client, Queue>();
            for (Item item : this.fallbackList) {
                Client client;
                if (item.key instanceof String) {
                    key = SafeEncoder.encode((String)((String)item.key));
                } else if (item.key instanceof byte[]) {
                    key = (byte[])item.key;
                } else {
                    throw new CamelliaRedisException("only support string/byte[] key");
                }
                Exception exception = item.failReason;
                boolean withAsking = false;
                if (exception instanceof JedisMovedDataException || exception instanceof JedisClusterException || exception instanceof JedisConnectionException) {
                    client = redisClientPool.getClient(item.resource, (byte[])key);
                } else if (exception instanceof JedisAskDataException) {
                    HostAndPort targetNode = ((JedisAskDataException)exception).getTargetNode();
                    client = redisClientPool.getClient(item.resource, targetNode.getHost(), targetNode.getPort());
                    withAsking = true;
                } else {
                    throw new CamelliaRedisException("only support JedisMovedDataException/JedisAskDataException/JedisConnectionException/JedisClusterException");
                }
                item.fallback.invoke(client, withAsking);
                Queue queue = (Queue)hashMap.get(client);
                if (queue == null) {
                    queue = hashMap.computeIfAbsent(client, k -> new LinkedList());
                }
                if (withAsking) {
                    queue.add(new Item(new Response(BuilderFactory.STRING), null, null, null));
                }
                queue.add(item);
            }
            this.clear();
            concurrentEnable = hashMap.size() > 1 && this.env.isPipelineConcurrentEnable();
            boolean finalRetry = retry;
            ArrayList retryFutureList = new ArrayList();
            key = hashMap.entrySet().iterator();
            while (key.hasNext()) {
                Map.Entry entry = (Map.Entry)key.next();
                Runnable runnable = () -> {
                    Client client = (Client)entry.getKey();
                    Queue queue = (Queue)entry.getValue();
                    this.handlerClient(redisClientPool, client, queue, finalRetry);
                };
                if (concurrentEnable) {
                    Future<?> future = this.env.getConcurrentExec().submit(runnable);
                    retryFutureList.add(future);
                    continue;
                }
                runnable.run();
            }
            try {
                for (Future future : retryFutureList) {
                    future.get();
                }
            }
            catch (Exception e) {
                throw new CamelliaRedisException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlerClient(RedisClientPool redisClientPool, Client client, Queue<Item> queue, boolean retry) {
        List list = client.getAll();
        for (Object o : list) {
            Item item = queue.poll();
            if (item == null) continue;
            if (item.resource instanceof RedisClusterResource && retry && o instanceof Exception) {
                List<Item> list2;
                redisClientPool.handlerException(item.resource, (Exception)o);
                if (o instanceof JedisMovedDataException || o instanceof JedisClusterException || o instanceof JedisConnectionException) {
                    list2 = this.fallbackList;
                    synchronized (list2) {
                        item.failReason = (Exception)o;
                        this.fallbackList.add(item);
                        continue;
                    }
                }
                if (o instanceof JedisAskDataException) {
                    list2 = this.fallbackList;
                    synchronized (list2) {
                        item.failReason = (Exception)o;
                        this.fallbackList.add(item);
                        continue;
                    }
                }
            }
            item.response.set(o);
        }
    }

    void clear() {
        this.map.clear();
        this.fallbackList.clear();
    }

    static abstract class Fallback {
        Fallback() {
        }

        abstract void invoke(Client var1);

        void invoke(Client client, boolean withAsking) {
            if (withAsking) {
                client.asking();
            }
            this.invoke(client);
        }
    }

    private static class Item {
        private final Response<?> response;
        private final Resource resource;
        private final Object key;
        private final Fallback fallback;
        private Exception failReason;

        Item(Response<?> response, Resource resource, Object key, Fallback fallback) {
            this.response = response;
            this.resource = resource;
            this.key = key;
            this.fallback = fallback;
        }
    }
}

