/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis;

import com.netease.nim.camellia.core.client.env.ProxyEnv;
import com.netease.nim.camellia.redis.conf.CamelliaRedisConstants;
import com.netease.nim.camellia.redis.intercept.RedisInterceptor;
import com.netease.nim.camellia.redis.jedis.JedisPoolFactory;
import com.netease.nim.camellia.redis.jediscluster.JedisClusterFactory;
import com.netease.nim.camellia.tools.executor.CamelliaThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CamelliaRedisEnv {
    private JedisPoolFactory jedisPoolFactory = JedisPoolFactory.DEFAULT;
    private JedisClusterFactory jedisClusterFactory = JedisClusterFactory.DEFAULT;
    private int concurrentExecPoolSize = CamelliaRedisConstants.Misc.concurrentExecPoolSize;
    private ExecutorService concurrentExec;
    private int pipelinePoolSize = CamelliaRedisConstants.Misc.pipelinePoolSize;
    private boolean pipelineConcurrentEnable = true;
    private int pipelineMaxAttempts = 5;
    private ProxyEnv proxyEnv = ProxyEnv.defaultProxyEnv();
    private List<RedisInterceptor> interceptorList = new ArrayList<RedisInterceptor>();

    private CamelliaRedisEnv() {
        this.initExec();
    }

    private CamelliaRedisEnv(JedisPoolFactory jedisPoolFactory, JedisClusterFactory jedisClusterFactory, int concurrentExecPoolSize, int pipelinePoolSize, boolean pipelineConcurrentEnable, int pipelineMaxAttempts, ProxyEnv proxyEnv, List<RedisInterceptor> interceptorList) {
        this.jedisPoolFactory = jedisPoolFactory;
        this.jedisClusterFactory = jedisClusterFactory;
        this.concurrentExecPoolSize = concurrentExecPoolSize;
        this.pipelinePoolSize = pipelinePoolSize;
        this.pipelineConcurrentEnable = pipelineConcurrentEnable;
        this.pipelineMaxAttempts = pipelineMaxAttempts;
        if (proxyEnv != null) {
            this.proxyEnv = proxyEnv;
        }
        this.interceptorList = interceptorList;
        this.initExec();
    }

    private void initExec() {
        this.concurrentExec = new ThreadPoolExecutor(this.concurrentExecPoolSize, this.concurrentExecPoolSize, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new CamelliaThreadFactory(CamelliaRedisEnv.class), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static CamelliaRedisEnv defaultRedisEnv() {
        return new CamelliaRedisEnv();
    }

    public int getPipelinePoolSize() {
        return this.pipelinePoolSize;
    }

    public JedisPoolFactory getJedisPoolFactory() {
        return this.jedisPoolFactory;
    }

    public JedisClusterFactory getJedisClusterFactory() {
        return this.jedisClusterFactory;
    }

    public ExecutorService getConcurrentExec() {
        return this.concurrentExec;
    }

    public boolean isPipelineConcurrentEnable() {
        return this.pipelineConcurrentEnable;
    }

    public int getPipelineMaxAttempts() {
        return this.pipelineMaxAttempts;
    }

    public ProxyEnv getProxyEnv() {
        return this.proxyEnv;
    }

    public List<RedisInterceptor> getInterceptorList() {
        return this.interceptorList;
    }

    public static class Builder {
        private final CamelliaRedisEnv redisEnv;

        public Builder() {
            this.redisEnv = new CamelliaRedisEnv();
        }

        public Builder(CamelliaRedisEnv redisEnv) {
            this.redisEnv = new CamelliaRedisEnv(redisEnv.jedisPoolFactory, redisEnv.jedisClusterFactory, redisEnv.concurrentExecPoolSize, redisEnv.pipelinePoolSize, redisEnv.pipelineConcurrentEnable, redisEnv.pipelineMaxAttempts, redisEnv.proxyEnv, redisEnv.interceptorList);
            this.redisEnv.concurrentExec = redisEnv.concurrentExec;
        }

        public Builder jedisPoolFactory(JedisPoolFactory jedisPoolFactory) {
            this.redisEnv.jedisPoolFactory = jedisPoolFactory;
            return this;
        }

        public Builder jedisClusterFactory(JedisClusterFactory jedisClusterFactory) {
            this.redisEnv.jedisClusterFactory = jedisClusterFactory;
            return this;
        }

        public Builder pipelinePoolSize(int pipelinePoolSize) {
            if (pipelinePoolSize > 0) {
                this.redisEnv.pipelinePoolSize = pipelinePoolSize;
            }
            return this;
        }

        public Builder concurrentExecPoolSize(int concurrentExecPoolSize) {
            if (concurrentExecPoolSize > 0) {
                this.redisEnv.concurrentExecPoolSize = concurrentExecPoolSize;
            }
            return this;
        }

        public Builder pipelineConcurrentEnable(boolean pipelineConcurrentEnable) {
            this.redisEnv.pipelineConcurrentEnable = pipelineConcurrentEnable;
            return this;
        }

        public Builder pipelineMaxAttempts(int pipelineMaxAttempts) {
            this.redisEnv.pipelineMaxAttempts = pipelineMaxAttempts;
            return this;
        }

        public Builder proxyEnv(ProxyEnv proxyEnv) {
            if (proxyEnv != null) {
                this.redisEnv.proxyEnv = proxyEnv;
            }
            return this;
        }

        public Builder addInterceptor(RedisInterceptor interceptor) {
            this.redisEnv.interceptorList.add(interceptor);
            return this;
        }

        public CamelliaRedisEnv build() {
            return this.redisEnv;
        }
    }
}

