/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.jediscluster;

import com.netease.nim.camellia.redis.base.exception.CamelliaRedisException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisClusterInfoCache;
import redis.clients.jedis.JedisPool;
import redis.clients.util.JedisClusterCRC16;

public class JedisClusterWrapper
extends JedisCluster {
    private JedisClusterInfoCache cache;
    private Field slots;

    private void init() {
        try {
            Field cacheField = JedisClusterConnectionHandler.class.getDeclaredField("cache");
            cacheField.setAccessible(true);
            this.cache = (JedisClusterInfoCache)cacheField.get(this.connectionHandler);
            this.slots = JedisClusterInfoCache.class.getDeclaredField("slots");
            this.slots.setAccessible(true);
            JedisPool pool = this.cache.getSlotPool(0);
            if (pool == null) {
                throw new CamelliaRedisException("init jedis cluster info cache error");
            }
        }
        catch (CamelliaRedisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CamelliaRedisException((Throwable)e);
        }
    }

    public List<JedisPool> getJedisPoolList() {
        try {
            Map map = (Map)this.slots.get(this.cache);
            return new ArrayList<JedisPool>(new HashSet(map.values()));
        }
        catch (Exception e) {
            throw new CamelliaRedisException((Throwable)e);
        }
    }

    public JedisPool getJedisPool(String key) {
        return this.cache.getSlotPool(JedisClusterCRC16.getSlot((String)key));
    }

    public JedisPool getJedisPool(byte[] key) {
        return this.cache.getSlotPool(JedisClusterCRC16.getSlot((byte[])key));
    }

    public JedisPool getJedisPool(String host, int port) {
        return this.cache.getNode(host + ":" + port);
    }

    public void renewSlotCache() {
        this.cache.renewClusterSlots(null);
    }

    public JedisClusterWrapper(HostAndPort node) {
        super(node);
        this.init();
    }

    public JedisClusterWrapper(HostAndPort node, int timeout) {
        super(node, timeout);
        this.init();
    }

    public JedisClusterWrapper(HostAndPort node, int timeout, int maxAttempts) {
        super(node, timeout, maxAttempts);
        this.init();
    }

    public JedisClusterWrapper(HostAndPort node, GenericObjectPoolConfig poolConfig) {
        super(node, poolConfig);
        this.init();
    }

    public JedisClusterWrapper(HostAndPort node, int timeout, GenericObjectPoolConfig poolConfig) {
        super(node, timeout, poolConfig);
        this.init();
    }

    public JedisClusterWrapper(HostAndPort node, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(node, timeout, maxAttempts, poolConfig);
        this.init();
    }

    public JedisClusterWrapper(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(node, connectionTimeout, soTimeout, maxAttempts, poolConfig);
        this.init();
    }

    public JedisClusterWrapper(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig) {
        super(node, connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
        this.init();
    }

    public JedisClusterWrapper(Set<HostAndPort> nodes) {
        super(nodes);
        this.init();
    }

    public JedisClusterWrapper(Set<HostAndPort> nodes, int timeout) {
        super(nodes, timeout);
        this.init();
    }

    public JedisClusterWrapper(Set<HostAndPort> nodes, int timeout, int maxAttempts) {
        super(nodes, timeout, maxAttempts);
        this.init();
    }

    public JedisClusterWrapper(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig) {
        super(nodes, poolConfig);
        this.init();
    }

    public JedisClusterWrapper(Set<HostAndPort> nodes, int timeout, GenericObjectPoolConfig poolConfig) {
        super(nodes, timeout, poolConfig);
        this.init();
    }

    public JedisClusterWrapper(Set<HostAndPort> jedisClusterNode, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, timeout, maxAttempts, poolConfig);
        this.init();
    }

    public JedisClusterWrapper(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, poolConfig);
        this.init();
    }

    public JedisClusterWrapper(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
        this.init();
    }

    public JedisClusterConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }
}

