/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.pipeline;

import com.netease.nim.camellia.redis.base.exception.CamelliaRedisException;
import com.netease.nim.camellia.redis.pipeline.ICamelliaRedisPipeline;
import com.netease.nim.camellia.redis.pipeline.PipelinePool;
import com.netease.nim.camellia.redis.pipeline.RedisClientPool;
import com.netease.nim.camellia.redis.pipeline.ResponseQueable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;

public class CamelliaRedisPipeline
implements ICamelliaRedisPipeline {
    private final AtomicBoolean close = new AtomicBoolean(false);
    private final ICamelliaRedisPipeline pipeline;
    private final ResponseQueable queable;
    private final RedisClientPool redisClientPool;
    private final PipelinePool pipelinePool;

    public CamelliaRedisPipeline(ICamelliaRedisPipeline pipeline, ResponseQueable queable, RedisClientPool redisClientPool, PipelinePool pipelinePool) {
        this.pipeline = pipeline;
        this.queable = queable;
        this.redisClientPool = redisClientPool;
        this.pipelinePool = pipelinePool;
    }

    @Override
    public void sync() {
        try {
            this.queable.sync(this.redisClientPool);
        }
        finally {
            this.queable.clear();
            this.redisClientPool.clear();
        }
    }

    @Override
    public void close() {
        try {
            this.sync();
        }
        finally {
            if (this.close.compareAndSet(false, true)) {
                this.pipelinePool.set(this, () -> this.close.compareAndSet(true, false));
            }
        }
    }

    private void check() {
        if (this.close.get()) {
            throw new CamelliaRedisException("pipeline has closed");
        }
    }

    @Override
    public Response<String> set(byte[] key, byte[] value) {
        this.check();
        return this.pipeline.set(key, value);
    }

    @Override
    public Response<String> set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        this.check();
        return this.pipeline.set(key, value, nxxx, expx, time);
    }

    @Override
    public Response<byte[]> get(byte[] key) {
        this.check();
        return this.pipeline.get(key);
    }

    @Override
    public Response<String> get(String key) {
        this.check();
        return this.pipeline.get(key);
    }

    @Override
    public Response<String> set(String key, String value) {
        this.check();
        return this.pipeline.set(key, value);
    }

    @Override
    public Response<Long> append(byte[] key, byte[] value) {
        this.check();
        return this.pipeline.append(key, value);
    }

    @Override
    public Response<Long> decr(byte[] key) {
        this.check();
        return this.pipeline.decr(key);
    }

    @Override
    public Response<Long> decrBy(byte[] key, long integer) {
        this.check();
        return this.pipeline.decrBy(key, integer);
    }

    @Override
    public Response<Long> del(byte[] key) {
        this.check();
        return this.pipeline.del(key);
    }

    @Override
    public Response<byte[]> echo(byte[] string) {
        this.check();
        return this.pipeline.echo(string);
    }

    @Override
    public Response<Boolean> exists(byte[] key) {
        this.check();
        return this.pipeline.exists(key);
    }

    @Override
    public Response<Long> expire(byte[] key, int seconds) {
        this.check();
        return this.pipeline.expire(key, seconds);
    }

    @Override
    public Response<Long> pexpire(byte[] key, long milliseconds) {
        this.check();
        return this.pipeline.pexpire(key, milliseconds);
    }

    @Override
    public Response<Long> expireAt(byte[] key, long unixTime) {
        this.check();
        return this.pipeline.expireAt(key, unixTime);
    }

    @Override
    public Response<Long> pexpireAt(byte[] key, long millisecondsTimestamp) {
        this.check();
        return this.pipeline.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public Response<Boolean> getbit(byte[] key, long offset) {
        this.check();
        return this.pipeline.getbit(key, offset);
    }

    @Override
    public Response<byte[]> getSet(byte[] key, byte[] value) {
        this.check();
        return this.pipeline.getSet(key, value);
    }

    @Override
    public Response<byte[]> getrange(byte[] key, long startOffset, long endOffset) {
        this.check();
        return this.pipeline.getrange(key, startOffset, endOffset);
    }

    @Override
    public Response<Long> hdel(byte[] key, byte[] ... field) {
        this.check();
        return this.pipeline.hdel(key, field);
    }

    @Override
    public Response<Boolean> hexists(byte[] key, byte[] field) {
        this.check();
        return this.pipeline.hexists(key, field);
    }

    @Override
    public Response<byte[]> hget(byte[] key, byte[] field) {
        this.check();
        return this.pipeline.hget(key, field);
    }

    @Override
    public Response<Map<byte[], byte[]>> hgetAll(byte[] key) {
        this.check();
        return this.pipeline.hgetAll(key);
    }

    @Override
    public Response<Long> hincrBy(byte[] key, byte[] field, long value) {
        this.check();
        return this.pipeline.hincrBy(key, field, value);
    }

    @Override
    public Response<Double> hincrByFloat(byte[] key, byte[] field, double value) {
        this.check();
        return this.pipeline.hincrByFloat(key, field, value);
    }

    @Override
    public Response<Set<byte[]>> hkeys(byte[] key) {
        this.check();
        return this.pipeline.hkeys(key);
    }

    @Override
    public Response<Long> hlen(byte[] key) {
        this.check();
        return this.pipeline.hlen(key);
    }

    @Override
    public Response<List<byte[]>> hmget(byte[] key, byte[] ... fields) {
        this.check();
        return this.pipeline.hmget(key, fields);
    }

    @Override
    public Response<String> hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.check();
        return this.pipeline.hmset(key, hash);
    }

    @Override
    public Response<Long> hset(byte[] key, byte[] field, byte[] value) {
        this.check();
        return this.pipeline.hset(key, field, value);
    }

    @Override
    public Response<Long> hsetnx(byte[] key, byte[] field, byte[] value) {
        this.check();
        return this.pipeline.hsetnx(key, field, value);
    }

    @Override
    public Response<List<byte[]>> hvals(byte[] key) {
        this.check();
        return this.pipeline.hvals(key);
    }

    @Override
    public Response<Long> incr(byte[] key) {
        this.check();
        return this.pipeline.incr(key);
    }

    @Override
    public Response<Long> incrBy(byte[] key, long integer) {
        this.check();
        return this.pipeline.incrBy(key, integer);
    }

    @Override
    public Response<Double> incrByFloat(byte[] key, double integer) {
        this.check();
        return this.pipeline.incrByFloat(key, integer);
    }

    @Override
    public Response<byte[]> lindex(byte[] key, long index) {
        this.check();
        return this.pipeline.lindex(key, index);
    }

    @Override
    public Response<Long> linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        this.check();
        return this.pipeline.linsert(key, where, pivot, value);
    }

    @Override
    public Response<Long> llen(byte[] key) {
        this.check();
        return this.pipeline.llen(key);
    }

    @Override
    public Response<byte[]> lpop(byte[] key) {
        this.check();
        return this.pipeline.lpop(key);
    }

    @Override
    public Response<Long> lpush(byte[] key, byte[] ... string) {
        this.check();
        return this.pipeline.lpush(key, string);
    }

    @Override
    public Response<Long> lpushx(byte[] key, byte[] ... bytes) {
        this.check();
        return this.pipeline.lpushx(key, bytes);
    }

    @Override
    public Response<List<byte[]>> lrange(byte[] key, long start, long end) {
        this.check();
        return this.pipeline.lrange(key, start, end);
    }

    @Override
    public Response<Long> lrem(byte[] key, long count, byte[] value) {
        this.check();
        return this.pipeline.lrem(key, count, value);
    }

    @Override
    public Response<String> lset(byte[] key, long index, byte[] value) {
        this.check();
        return this.pipeline.lset(key, index, value);
    }

    @Override
    public Response<String> ltrim(byte[] key, long start, long end) {
        this.check();
        return this.pipeline.ltrim(key, start, end);
    }

    @Override
    public Response<Long> persist(byte[] key) {
        this.check();
        return this.pipeline.persist(key);
    }

    @Override
    public Response<byte[]> rpop(byte[] key) {
        this.check();
        return this.pipeline.rpop(key);
    }

    @Override
    public Response<Long> rpush(byte[] key, byte[] ... string) {
        this.check();
        return this.pipeline.rpush(key, string);
    }

    @Override
    public Response<Long> rpushx(byte[] key, byte[] ... string) {
        this.check();
        return this.pipeline.rpushx(key, string);
    }

    @Override
    public Response<Long> sadd(byte[] key, byte[] ... member) {
        this.check();
        return this.pipeline.sadd(key, member);
    }

    @Override
    public Response<Long> scard(byte[] key) {
        this.check();
        return this.pipeline.scard(key);
    }

    @Override
    public Response<Boolean> setbit(byte[] key, long offset, byte[] value) {
        this.check();
        return this.pipeline.setbit(key, offset, value);
    }

    @Override
    public Response<Long> setrange(byte[] key, long offset, byte[] value) {
        this.check();
        return this.pipeline.setrange(key, offset, value);
    }

    @Override
    public Response<String> setex(byte[] key, int seconds, byte[] value) {
        this.check();
        return this.pipeline.setex(key, seconds, value);
    }

    @Override
    public Response<String> psetex(byte[] key, long milliseconds, byte[] value) {
        this.check();
        return this.pipeline.psetex(key, milliseconds, value);
    }

    @Override
    public Response<Long> setnx(byte[] key, byte[] value) {
        this.check();
        return this.pipeline.setnx(key, value);
    }

    @Override
    public Response<Set<byte[]>> smembers(byte[] key) {
        this.check();
        return this.pipeline.smembers(key);
    }

    @Override
    public Response<Boolean> sismember(byte[] key, byte[] member) {
        this.check();
        return this.pipeline.sismember(key, member);
    }

    @Override
    public Response<List<byte[]>> sort(byte[] key) {
        this.check();
        return this.pipeline.sort(key);
    }

    @Override
    public Response<List<byte[]>> sort(byte[] key, SortingParams sortingParameters) {
        this.check();
        return this.pipeline.sort(key, sortingParameters);
    }

    @Override
    public Response<byte[]> spop(byte[] key) {
        this.check();
        return this.pipeline.spop(key);
    }

    @Override
    public Response<Set<byte[]>> spop(byte[] key, long count) {
        this.check();
        return this.pipeline.spop(key, count);
    }

    @Override
    public Response<byte[]> srandmember(byte[] key) {
        this.check();
        return this.pipeline.srandmember(key);
    }

    @Override
    public Response<List<byte[]>> srandmember(byte[] key, int count) {
        this.check();
        return this.pipeline.srandmember(key, count);
    }

    @Override
    public Response<Long> srem(byte[] key, byte[] ... member) {
        this.check();
        return this.pipeline.srem(key, member);
    }

    @Override
    public Response<Long> strlen(byte[] key) {
        this.check();
        return this.pipeline.strlen(key);
    }

    @Override
    public Response<String> substr(byte[] key, int start, int end) {
        this.check();
        return this.pipeline.substr(key, start, end);
    }

    @Override
    public Response<Long> ttl(byte[] key) {
        this.check();
        return this.pipeline.ttl(key);
    }

    @Override
    public Response<Long> pttl(byte[] key) {
        this.check();
        return this.pipeline.pttl(key);
    }

    @Override
    public Response<String> type(byte[] key) {
        this.check();
        return this.pipeline.type(key);
    }

    @Override
    public Response<Long> zadd(byte[] key, double score, byte[] member) {
        this.check();
        return this.pipeline.zadd(key, score, member);
    }

    @Override
    public Response<Long> zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        this.check();
        return this.pipeline.zadd(key, score, member, params);
    }

    @Override
    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        this.check();
        return this.pipeline.zadd(key, scoreMembers);
    }

    @Override
    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        this.check();
        return this.pipeline.zadd(key, scoreMembers, params);
    }

    @Override
    public Response<Long> zcard(byte[] key) {
        this.check();
        return this.pipeline.zcard(key);
    }

    @Override
    public Response<Long> zcount(byte[] key, double min, double max) {
        this.check();
        return this.pipeline.zcount(key, min, max);
    }

    @Override
    public Response<Double> zincrby(byte[] key, double score, byte[] member) {
        this.check();
        return this.pipeline.zincrby(key, score, member);
    }

    @Override
    public Response<Double> zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        this.check();
        return this.pipeline.zincrby(key, score, member, params);
    }

    @Override
    public Response<Set<byte[]>> zrange(byte[] key, long start, long end) {
        this.check();
        return this.pipeline.zrange(key, start, end);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max) {
        this.check();
        return this.pipeline.zrangeByScore(key, min, max);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.check();
        return this.pipeline.zrangeByScore(key, min, max);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        this.check();
        return this.pipeline.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.check();
        return this.pipeline.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max) {
        this.check();
        return this.pipeline.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.check();
        return this.pipeline.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        this.check();
        return this.pipeline.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.check();
        return this.pipeline.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min) {
        this.check();
        return this.pipeline.zrevrangeByScore(key, max, min);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.check();
        return this.pipeline.zrevrangeByScore(key, max, min);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        this.check();
        return this.pipeline.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.check();
        return this.pipeline.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        this.check();
        return this.pipeline.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.check();
        return this.pipeline.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        this.check();
        return this.pipeline.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.check();
        return this.pipeline.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrangeWithScores(byte[] key, long start, long end) {
        this.check();
        return this.pipeline.zrangeWithScores(key, start, end);
    }

    @Override
    public Response<Long> zrank(byte[] key, byte[] member) {
        this.check();
        return this.pipeline.zrank(key, member);
    }

    @Override
    public Response<Long> zrem(byte[] key, byte[] ... member) {
        this.check();
        return this.pipeline.zrem(key, member);
    }

    @Override
    public Response<Long> zremrangeByRank(byte[] key, long start, long end) {
        this.check();
        return this.pipeline.zremrangeByRank(key, start, end);
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] key, double start, double end) {
        this.check();
        return this.pipeline.zremrangeByScore(key, start, end);
    }

    @Override
    public Response<Long> zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        this.check();
        return this.pipeline.zremrangeByScore(key, start, end);
    }

    @Override
    public Response<Set<byte[]>> zrevrange(byte[] key, long start, long end) {
        this.check();
        return this.pipeline.zrevrange(key, start, end);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeWithScores(byte[] key, long start, long end) {
        this.check();
        return this.pipeline.zrevrangeWithScores(key, start, end);
    }

    @Override
    public Response<Long> zrevrank(byte[] key, byte[] member) {
        this.check();
        return this.pipeline.zrevrank(key, member);
    }

    @Override
    public Response<Double> zscore(byte[] key, byte[] member) {
        this.check();
        return this.pipeline.zscore(key, member);
    }

    @Override
    public Response<Long> zlexcount(byte[] key, byte[] min, byte[] max) {
        this.check();
        return this.pipeline.zlexcount(key, min, max);
    }

    @Override
    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.check();
        return this.pipeline.zrangeByLex(key, min, max);
    }

    @Override
    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.check();
        return this.pipeline.zrangeByLex(key, min, max, offset, count);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        this.check();
        return this.pipeline.zrevrangeByLex(key, max, min);
    }

    @Override
    public Response<Set<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.check();
        return this.pipeline.zrevrangeByLex(key, max, min, offset, count);
    }

    @Override
    public Response<Long> zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        this.check();
        return this.pipeline.zremrangeByLex(key, min, max);
    }

    @Override
    public Response<Long> bitcount(byte[] key) {
        this.check();
        return this.pipeline.bitcount(key);
    }

    @Override
    public Response<Long> bitcount(byte[] key, long start, long end) {
        this.check();
        return this.pipeline.bitcount(key, start, end);
    }

    @Override
    public Response<Long> pfadd(byte[] key, byte[] ... elements) {
        this.check();
        return this.pipeline.pfadd(key, elements);
    }

    @Override
    public Response<Long> pfcount(byte[] key) {
        this.check();
        return this.pipeline.pfcount(key);
    }

    @Override
    public Response<Long> geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        this.check();
        return this.pipeline.geoadd(key, longitude, latitude, member);
    }

    @Override
    public Response<Long> geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        this.check();
        return this.pipeline.geoadd(key, memberCoordinateMap);
    }

    @Override
    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2) {
        this.check();
        return this.pipeline.geodist(key, member1, member2);
    }

    @Override
    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        this.check();
        return this.pipeline.geodist(key, member1, member2, unit);
    }

    @Override
    public Response<List<byte[]>> geohash(byte[] key, byte[] ... members) {
        this.check();
        return this.pipeline.geohash(key, members);
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(byte[] key, byte[] ... members) {
        this.check();
        return this.pipeline.geopos(key, members);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.check();
        return this.pipeline.georadius(key, longitude, latitude, radius, unit);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.check();
        return this.pipeline.georadius(key, longitude, latitude, radius, unit, param);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        this.check();
        return this.pipeline.georadiusByMember(key, member, radius, unit);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.check();
        return this.pipeline.georadiusByMember(key, member, radius, unit, param);
    }

    @Override
    public Response<List<Long>> bitfield(byte[] key, byte[] ... elements) {
        this.check();
        return this.pipeline.bitfield(key, elements);
    }

    @Override
    public Response<Long> bitpos(byte[] key, boolean value, BitPosParams params) {
        this.check();
        return this.pipeline.bitpos(key, value, params);
    }

    @Override
    public Response<Long> append(String key, String value) {
        this.check();
        return this.pipeline.append(key, value);
    }

    @Override
    public Response<Long> decr(String key) {
        this.check();
        return this.pipeline.decr(key);
    }

    @Override
    public Response<Long> decrBy(String key, long integer) {
        this.check();
        return this.pipeline.decrBy(key, integer);
    }

    @Override
    public Response<Long> del(String key) {
        this.check();
        return this.pipeline.del(key);
    }

    @Override
    public Response<String> echo(String string) {
        this.check();
        return this.pipeline.echo(string);
    }

    @Override
    public Response<Boolean> exists(String key) {
        this.check();
        return this.pipeline.exists(key);
    }

    @Override
    public Response<Long> expire(String key, int seconds) {
        this.check();
        return this.pipeline.expire(key, seconds);
    }

    @Override
    public Response<Long> pexpire(String key, long milliseconds) {
        this.check();
        return this.pipeline.pexpire(key, milliseconds);
    }

    @Override
    public Response<Long> expireAt(String key, long unixTime) {
        this.check();
        return this.pipeline.expireAt(key, unixTime);
    }

    @Override
    public Response<Long> pexpireAt(String key, long millisecondsTimestamp) {
        this.check();
        return this.pipeline.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public Response<Boolean> getbit(String key, long offset) {
        this.check();
        return this.pipeline.getbit(key, offset);
    }

    @Override
    public Response<String> getrange(String key, long startOffset, long endOffset) {
        this.check();
        return this.pipeline.getrange(key, startOffset, endOffset);
    }

    @Override
    public Response<String> getSet(String key, String value) {
        this.check();
        return this.pipeline.getSet(key, value);
    }

    @Override
    public Response<Long> hdel(String key, String ... field) {
        this.check();
        return this.pipeline.hdel(key, field);
    }

    @Override
    public Response<Boolean> hexists(String key, String field) {
        this.check();
        return this.pipeline.hexists(key, field);
    }

    @Override
    public Response<String> hget(String key, String field) {
        this.check();
        return this.pipeline.hget(key, field);
    }

    @Override
    public Response<Map<String, String>> hgetAll(String key) {
        this.check();
        return this.pipeline.hgetAll(key);
    }

    @Override
    public Response<Long> hincrBy(String key, String field, long value) {
        this.check();
        return this.pipeline.hincrBy(key, field, value);
    }

    @Override
    public Response<Set<String>> hkeys(String key) {
        this.check();
        return this.pipeline.hkeys(key);
    }

    @Override
    public Response<Long> hlen(String key) {
        this.check();
        return this.pipeline.hlen(key);
    }

    @Override
    public Response<List<String>> hmget(String key, String ... fields) {
        this.check();
        return this.pipeline.hmget(key, fields);
    }

    @Override
    public Response<String> hmset(String key, Map<String, String> hash) {
        this.check();
        return this.pipeline.hmset(key, hash);
    }

    @Override
    public Response<Long> hset(String key, String field, String value) {
        this.check();
        return this.pipeline.hset(key, field, value);
    }

    @Override
    public Response<Long> hsetnx(String key, String field, String value) {
        this.check();
        return this.pipeline.hsetnx(key, field, value);
    }

    @Override
    public Response<List<String>> hvals(String key) {
        this.check();
        return this.pipeline.hvals(key);
    }

    @Override
    public Response<Long> incr(String key) {
        this.check();
        return this.pipeline.incr(key);
    }

    @Override
    public Response<Long> incrBy(String key, long integer) {
        this.check();
        return this.pipeline.incrBy(key, integer);
    }

    @Override
    public Response<String> lindex(String key, long index) {
        this.check();
        return this.pipeline.lindex(key, index);
    }

    @Override
    public Response<Long> linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        this.check();
        return this.pipeline.linsert(key, where, pivot, value);
    }

    @Override
    public Response<Long> llen(String key) {
        this.check();
        return this.pipeline.llen(key);
    }

    @Override
    public Response<String> lpop(String key) {
        this.check();
        return this.pipeline.lpop(key);
    }

    @Override
    public Response<Long> lpush(String key, String ... string) {
        this.check();
        return this.pipeline.lpush(key, string);
    }

    @Override
    public Response<Long> lpushx(String key, String ... string) {
        this.check();
        return this.pipeline.lpushx(key, string);
    }

    @Override
    public Response<List<String>> lrange(String key, long start, long end) {
        this.check();
        return this.pipeline.lrange(key, start, end);
    }

    @Override
    public Response<Long> lrem(String key, long count, String value) {
        this.check();
        return this.pipeline.lrem(key, count, value);
    }

    @Override
    public Response<String> lset(String key, long index, String value) {
        this.check();
        return this.pipeline.lset(key, index, value);
    }

    @Override
    public Response<String> ltrim(String key, long start, long end) {
        this.check();
        return this.pipeline.ltrim(key, start, end);
    }

    @Override
    public Response<Long> persist(String key) {
        this.check();
        return this.pipeline.persist(key);
    }

    @Override
    public Response<String> rpop(String key) {
        this.check();
        return this.pipeline.rpop(key);
    }

    @Override
    public Response<Long> rpush(String key, String ... string) {
        this.check();
        return this.pipeline.rpush(key, string);
    }

    @Override
    public Response<Long> rpushx(String key, String ... string) {
        this.check();
        return this.pipeline.rpushx(key, string);
    }

    @Override
    public Response<Long> sadd(String key, String ... member) {
        this.check();
        return this.pipeline.sadd(key, member);
    }

    @Override
    public Response<Long> scard(String key) {
        this.check();
        return this.pipeline.scard(key);
    }

    @Override
    public Response<Boolean> sismember(String key, String member) {
        this.check();
        return this.pipeline.sismember(key, member);
    }

    @Override
    public Response<Boolean> setbit(String key, long offset, boolean value) {
        this.check();
        return this.pipeline.setbit(key, offset, value);
    }

    @Override
    public Response<String> setex(String key, int seconds, String value) {
        this.check();
        return this.pipeline.setex(key, seconds, value);
    }

    @Override
    public Response<Long> setnx(String key, String value) {
        this.check();
        return this.pipeline.setnx(key, value);
    }

    @Override
    public Response<Long> setrange(String key, long offset, String value) {
        this.check();
        return this.pipeline.setrange(key, offset, value);
    }

    @Override
    public Response<Set<String>> smembers(String key) {
        this.check();
        return this.pipeline.smembers(key);
    }

    @Override
    public Response<List<String>> sort(String key) {
        this.check();
        return this.pipeline.sort(key);
    }

    @Override
    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        this.check();
        return this.pipeline.sort(key, sortingParameters);
    }

    @Override
    public Response<String> spop(String key) {
        this.check();
        return this.pipeline.spop(key);
    }

    @Override
    public Response<Set<String>> spop(String key, long count) {
        this.check();
        return this.pipeline.spop(key, count);
    }

    @Override
    public Response<String> srandmember(String key) {
        this.check();
        return this.pipeline.srandmember(key);
    }

    @Override
    public Response<Long> srem(String key, String ... member) {
        this.check();
        return this.pipeline.srem(key, member);
    }

    @Override
    public Response<Long> strlen(String key) {
        this.check();
        return this.pipeline.strlen(key);
    }

    @Override
    public Response<String> substr(String key, int start, int end) {
        this.check();
        return this.pipeline.substr(key, start, end);
    }

    @Override
    public Response<Long> ttl(String key) {
        this.check();
        return this.pipeline.ttl(key);
    }

    @Override
    public Response<String> type(String key) {
        this.check();
        return this.pipeline.type(key);
    }

    @Override
    public Response<Long> zadd(String key, double score, String member) {
        this.check();
        return this.pipeline.zadd(key, score, member);
    }

    @Override
    public Response<Long> zadd(String key, double score, String member, ZAddParams params) {
        this.check();
        return this.pipeline.zadd(key, score, member, params);
    }

    @Override
    public Response<Long> zadd(String key, Map<String, Double> scoreMembers) {
        this.check();
        return this.pipeline.zadd(key, scoreMembers);
    }

    @Override
    public Response<Long> zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        this.check();
        return this.pipeline.zadd(key, scoreMembers, params);
    }

    @Override
    public Response<Long> zcard(String key) {
        this.check();
        return this.pipeline.zcard(key);
    }

    @Override
    public Response<Long> zcount(String key, double min, double max) {
        this.check();
        return this.pipeline.zcount(key, min, max);
    }

    @Override
    public Response<Double> zincrby(String key, double score, String member) {
        this.check();
        return this.pipeline.zincrby(key, score, member);
    }

    @Override
    public Response<Double> zincrby(String key, double score, String member, ZIncrByParams params) {
        this.check();
        return this.pipeline.zincrby(key, score, member, params);
    }

    @Override
    public Response<Set<String>> zrange(String key, long start, long end) {
        this.check();
        return this.pipeline.zrange(key, start, end);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, double min, double max) {
        this.check();
        return this.pipeline.zrangeByScore(key, min, max);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, String min, String max) {
        this.check();
        return this.pipeline.zrangeByScore(key, min, max);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, double min, double max, int offset, int count) {
        this.check();
        return this.pipeline.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max) {
        this.check();
        return this.pipeline.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.check();
        return this.pipeline.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, double max, double min) {
        this.check();
        return this.pipeline.zrevrangeByScore(key, max, min);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, String max, String min) {
        this.check();
        return this.pipeline.zrevrangeByScore(key, max, min);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        this.check();
        return this.pipeline.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min) {
        this.check();
        return this.pipeline.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        this.check();
        return this.pipeline.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrangeWithScores(String key, long start, long end) {
        this.check();
        return this.pipeline.zrangeWithScores(key, start, end);
    }

    @Override
    public Response<Long> zrank(String key, String member) {
        this.check();
        return this.pipeline.zrank(key, member);
    }

    @Override
    public Response<Long> zrem(String key, String ... member) {
        this.check();
        return this.pipeline.zrem(key, member);
    }

    @Override
    public Response<Long> zremrangeByRank(String key, long start, long end) {
        this.check();
        return this.pipeline.zremrangeByRank(key, start, end);
    }

    @Override
    public Response<Long> zremrangeByScore(String key, double start, double end) {
        this.check();
        return this.pipeline.zremrangeByScore(key, start, end);
    }

    @Override
    public Response<Set<String>> zrevrange(String key, long start, long end) {
        this.check();
        return this.pipeline.zrevrange(key, start, end);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeWithScores(String key, long start, long end) {
        this.check();
        return this.pipeline.zrevrangeWithScores(key, start, end);
    }

    @Override
    public Response<Long> zrevrank(String key, String member) {
        this.check();
        return this.pipeline.zrevrank(key, member);
    }

    @Override
    public Response<Double> zscore(String key, String member) {
        this.check();
        return this.pipeline.zscore(key, member);
    }

    @Override
    public Response<Long> zlexcount(String key, String min, String max) {
        this.check();
        return this.pipeline.zlexcount(key, min, max);
    }

    @Override
    public Response<Set<String>> zrangeByLex(String key, String min, String max) {
        this.check();
        return this.pipeline.zrangeByLex(key, min, max);
    }

    @Override
    public Response<Set<String>> zrangeByLex(String key, String min, String max, int offset, int count) {
        this.check();
        return this.pipeline.zrangeByLex(key, min, max, offset, count);
    }

    @Override
    public Response<Set<String>> zrevrangeByLex(String key, String max, String min) {
        this.check();
        return this.pipeline.zrevrangeByLex(key, max, min);
    }

    @Override
    public Response<Set<String>> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        this.check();
        return this.pipeline.zrevrangeByLex(key, max, min, offset, count);
    }

    @Override
    public Response<Long> zremrangeByLex(String key, String start, String end) {
        this.check();
        return this.pipeline.zremrangeByLex(key, start, end);
    }

    @Override
    public Response<Long> bitcount(String key) {
        this.check();
        return this.pipeline.bitcount(key);
    }

    @Override
    public Response<Long> bitcount(String key, long start, long end) {
        this.check();
        return this.pipeline.bitcount(key, start, end);
    }

    @Override
    public Response<Long> pfadd(String key, String ... elements) {
        this.check();
        return this.pipeline.pfadd(key, elements);
    }

    @Override
    public Response<Long> pfcount(String key) {
        this.check();
        return this.pipeline.pfcount(key);
    }

    @Override
    public Response<List<Long>> bitfield(String key, String ... arguments) {
        this.check();
        return this.pipeline.bitfield(key, arguments);
    }

    @Override
    public Response<Long> geoadd(String key, double longitude, double latitude, String member) {
        this.check();
        return this.pipeline.geoadd(key, longitude, latitude, member);
    }

    @Override
    public Response<Long> geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.check();
        return this.pipeline.geoadd(key, memberCoordinateMap);
    }

    @Override
    public Response<Double> geodist(String key, String member1, String member2) {
        this.check();
        return this.pipeline.geodist(key, member1, member2);
    }

    @Override
    public Response<Double> geodist(String key, String member1, String member2, GeoUnit unit) {
        this.check();
        return this.pipeline.geodist(key, member1, member2, unit);
    }

    @Override
    public Response<List<String>> geohash(String key, String ... members) {
        this.check();
        return this.pipeline.geohash(key, members);
    }

    @Override
    public Response<List<GeoCoordinate>> geopos(String key, String ... members) {
        this.check();
        return this.pipeline.geopos(key, members);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.check();
        return this.pipeline.georadius(key, longitude, latitude, radius, unit);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.check();
        return this.pipeline.georadius(key, longitude, latitude, radius, unit, param);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        this.check();
        return this.pipeline.georadiusByMember(key, member, radius, unit);
    }

    @Override
    public Response<List<GeoRadiusResponse>> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.check();
        return this.pipeline.georadiusByMember(key, member, radius, unit, param);
    }

    @Override
    public Response<byte[]> dump(String key) {
        this.check();
        return this.pipeline.dump(key);
    }

    @Override
    public Response<byte[]> dump(byte[] key) {
        this.check();
        return this.pipeline.dump(key);
    }

    @Override
    public Response<String> restore(byte[] key, int ttl, byte[] serializedValue) {
        this.check();
        return this.pipeline.restore(key, ttl, serializedValue);
    }

    @Override
    public Response<String> restore(String key, int ttl, byte[] serializedValue) {
        this.check();
        return this.pipeline.restore(key, ttl, serializedValue);
    }

    @Override
    public Response<Double> hincrByFloat(String key, String field, double increment) {
        this.check();
        return this.pipeline.hincrByFloat(key, field, increment);
    }

    @Override
    public Response<Double> incrByFloat(String key, double increment) {
        this.check();
        return this.pipeline.incrByFloat(key, increment);
    }

    @Override
    public Response<String> set(String key, String value, String nxxx) {
        this.check();
        return this.pipeline.set(key, value, nxxx);
    }

    @Override
    public Response<String> set(byte[] key, byte[] value, byte[] nxxx) {
        this.check();
        return this.pipeline.set(key, value, nxxx);
    }

    @Override
    public Response<String> set(String key, String value, String nxxx, String expx, int time) {
        this.check();
        return this.pipeline.set(key, value, nxxx, expx, time);
    }

    @Override
    public Response<String> psetex(String key, long milliseconds, String value) {
        this.check();
        return this.pipeline.psetex(key, milliseconds, value);
    }

    @Override
    public Response<String> psetex(String key, int milliseconds, String value) {
        this.check();
        return this.pipeline.psetex(key, milliseconds, value);
    }

    @Override
    public Response<List<String>> srandmember(String key, int count) {
        this.check();
        return this.pipeline.srandmember(key, count);
    }

    @Override
    public Response<Long> pttl(String key) {
        this.check();
        return this.pipeline.pttl(key);
    }

    @Override
    public Response<Set<String>> zrangeByScore(String key, String min, String max, int offset, int count) {
        this.check();
        return this.pipeline.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.check();
        return this.pipeline.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, String min, String max) {
        this.check();
        return this.pipeline.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Response<Set<String>> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.check();
        return this.pipeline.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.check();
        return this.pipeline.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, String max, String min) {
        this.check();
        return this.pipeline.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Response<Long> zremrangeByScore(String key, String min, String max) {
        this.check();
        return this.pipeline.zremrangeByScore(key, min, max);
    }

    @Override
    public Response<Long> bitpos(String key, boolean value) {
        this.check();
        return this.pipeline.bitpos(key, value);
    }

    @Override
    public Response<Long> bitpos(String key, boolean value, BitPosParams params) {
        this.check();
        return this.pipeline.bitpos(key, value, params);
    }

    @Override
    public Response<Long> bitpos(byte[] key, boolean value) {
        this.check();
        return this.pipeline.bitpos(key, value);
    }

    @Override
    public Response<Long> zcount(byte[] key, byte[] min, byte[] max) {
        this.check();
        return this.pipeline.zcount(key, min, max);
    }

    @Override
    public Response<Long> zcount(String key, String min, String max) {
        this.check();
        return this.pipeline.zcount(key, min, max);
    }
}

