/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.pipeline;

import com.alibaba.fastjson.JSONObject;
import com.netease.nim.camellia.core.client.annotation.ReadOp;
import com.netease.nim.camellia.core.client.annotation.ShardingParam;
import com.netease.nim.camellia.core.client.annotation.WriteOp;
import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.base.utils.LogUtil;
import com.netease.nim.camellia.redis.base.utils.SafeEncoder;
import com.netease.nim.camellia.redis.intercept.InterceptContext;
import com.netease.nim.camellia.redis.intercept.RedisInterceptor;
import com.netease.nim.camellia.redis.pipeline.ICamelliaRedisPipeline;
import com.netease.nim.camellia.redis.pipeline.RedisClientPool;
import com.netease.nim.camellia.redis.pipeline.ResponseQueable;
import com.netease.nim.camellia.redis.resource.PipelineResource;
import com.netease.nim.camellia.redis.resource.RedisClientResourceUtil;
import com.netease.nim.camellia.redis.util.CamelliaBitPosParams;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;

public class CamelliaRedisPipelineImpl
implements ICamelliaRedisPipeline {
    private static final Logger logger = LoggerFactory.getLogger(CamelliaRedisPipelineImpl.class);
    private Resource resource;
    private RedisClientPool clientPool;
    private ResponseQueable queable;
    private List<RedisInterceptor> interceptorList;

    public CamelliaRedisPipelineImpl(Resource resource) {
        if (resource == null) {
            return;
        }
        this.resource = RedisClientResourceUtil.parseResourceByUrl(resource);
        if (!(resource instanceof PipelineResource)) {
            throw new IllegalArgumentException("not PipelineResource");
        }
        this.queable = ((PipelineResource)resource).getQueable();
        this.clientPool = ((PipelineResource)resource).getClientPool();
        this.interceptorList = ((PipelineResource)resource).getRedisEnv().getInterceptorList();
    }

    @Override
    public void sync() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    private boolean interceptEnable() {
        return this.interceptorList != null && !this.interceptorList.isEmpty();
    }

    private void before(String key, String command) {
        if (!this.interceptEnable()) {
            return;
        }
        if (key == null) {
            return;
        }
        InterceptContext context = new InterceptContext(this.resource, key.getBytes(StandardCharsets.UTF_8), command, true);
        for (RedisInterceptor interceptor : this.interceptorList) {
            try {
                interceptor.before(context);
            }
            catch (Exception e) {
                logger.error("interceptor before error, context = {}", (Object)JSONObject.toJSONString((Object)context), (Object)e);
            }
        }
    }

    private void before(byte[] key, String command) {
        if (!this.interceptEnable()) {
            return;
        }
        if (key == null) {
            return;
        }
        InterceptContext context = new InterceptContext(this.resource, key, command, true);
        for (RedisInterceptor interceptor : this.interceptorList) {
            try {
                interceptor.before(context);
            }
            catch (Exception e) {
                logger.error("interceptor before error, context = {}", (Object)JSONObject.toJSONString((Object)context), (Object)e);
            }
        }
    }

    private void after(String key, String command) {
        if (!this.interceptEnable()) {
            return;
        }
        if (key == null) {
            return;
        }
        InterceptContext context = new InterceptContext(this.resource, key.getBytes(StandardCharsets.UTF_8), command, true);
        for (RedisInterceptor interceptor : this.interceptorList) {
            try {
                interceptor.after(context);
            }
            catch (Exception e) {
                logger.error("interceptor after error, context = {}", (Object)JSONObject.toJSONString((Object)context), (Object)e);
            }
        }
    }

    private void after(byte[] key, String command) {
        if (!this.interceptEnable()) {
            return;
        }
        if (key == null) {
            return;
        }
        InterceptContext context = new InterceptContext(this.resource, key, command, true);
        for (RedisInterceptor interceptor : this.interceptorList) {
            try {
                interceptor.after(context);
            }
            catch (Exception e) {
                logger.error("interceptor after error, context = {}", (Object)JSONObject.toJSONString((Object)context), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> append(final @ShardingParam byte[] key, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "append(byte[] key, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.append(key, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.append(key, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> decr(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "decr(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.decr(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.decr(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> set(final @ShardingParam String key, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "set(String key, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.set(key, value);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.set(key, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> get(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "get(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.get(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.get(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> decrBy(final @ShardingParam byte[] key, final long integer) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "decrBy(byte[] key, long integer)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.decrBy(key, integer);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.decrBy(key, integer);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> del(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "del(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.del((byte[][])new byte[][]{key});
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.del((byte[][])new byte[][]{key});
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<byte[]> echo(final @ShardingParam byte[] string) {
        LogUtil.debugLog((Resource)this.resource, (byte[])string);
        String command = "echo(byte[] string)";
        this.before(string, command);
        try {
            Client client = this.clientPool.getClient(this.resource, string);
            client.echo(string);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, string, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.echo(string);
                }
            });
            return response;
        }
        finally {
            this.after(string, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Boolean> exists(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "exists(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.exists((byte[][])new byte[][]{key});
            Response response = this.queable.getResponse(client, BuilderFactory.BOOLEAN, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.exists((byte[][])new byte[][]{key});
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> expire(final @ShardingParam byte[] key, final int seconds) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "expire(byte[] key, int seconds)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.expire(key, seconds);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.expire(key, seconds);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> pexpire(final @ShardingParam byte[] key, final long milliseconds) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "pexpire(byte[] key, long milliseconds)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.pexpire(key, milliseconds);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.pexpire(key, milliseconds);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> expireAt(final @ShardingParam byte[] key, final long unixTime) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "expireAt(byte[] key, long unixTime)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.expireAt(key, unixTime);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.expireAt(key, unixTime);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> pexpireAt(final @ShardingParam byte[] key, final long millisecondsTimestamp) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "pexpireAt(byte[] key, long millisecondsTimestamp)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.pexpireAt(key, millisecondsTimestamp);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.pexpireAt(key, millisecondsTimestamp);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<byte[]> get(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "get(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.get(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.get(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Boolean> getbit(final @ShardingParam byte[] key, final long offset) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "getbit(byte[] key, long offset)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.getbit(key, offset);
            Response response = this.queable.getResponse(client, BuilderFactory.BOOLEAN, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.getbit(key, offset);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<byte[]> getSet(final @ShardingParam byte[] key, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "getSet(byte[] key, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.getSet(key, value);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.getSet(key, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<byte[]> getrange(final @ShardingParam byte[] key, final long startOffset, final long endOffset) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "getrange(byte[] key, long startOffset, long endOffset)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.getrange(key, startOffset, endOffset);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.getrange(key, startOffset, endOffset);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> hdel(final @ShardingParam byte[] key, final byte[] ... field) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hdel(byte[] key, byte[]... field)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hdel(key, field);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hdel(key, field);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Boolean> hexists(final @ShardingParam byte[] key, final byte[] field) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hexists(byte[] key, byte[] field)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hexists(key, field);
            Response response = this.queable.getResponse(client, BuilderFactory.BOOLEAN, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hexists(key, field);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<byte[]> hget(final @ShardingParam byte[] key, final byte[] field) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hget(byte[] key, byte[] field)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hget(key, field);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hget(key, field);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Map<byte[], byte[]>> hgetAll(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hgetAll(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hgetAll(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_MAP, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hgetAll(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> hincrBy(final @ShardingParam byte[] key, final byte[] field, final long value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hincrBy(byte[] key, byte[] field, long value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hincrBy(key, field, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hincrBy(key, field, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Double> hincrByFloat(final @ShardingParam byte[] key, final byte[] field, final double value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hincrByFloat(byte[] key, byte[] field, double value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hincrByFloat(key, field, value);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hincrByFloat(key, field, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> hkeys(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hkeys(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hkeys(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hkeys(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> hlen(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hlen(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hlen(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hlen(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<byte[]>> hmget(final @ShardingParam byte[] key, final byte[] ... fields) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hmget(byte[] key, byte[]... fields)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hmget(key, fields);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hmget(key, fields);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> hmset(final @ShardingParam byte[] key, final Map<byte[], byte[]> hash) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hmset(byte[] key, Map<byte[], byte[]> hash)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hmset(key, hash);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hmset(key, hash);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> hset(final @ShardingParam byte[] key, final byte[] field, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hset(byte[] key, byte[] field, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hset(key, field, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hset(key, field, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> hsetnx(final @ShardingParam byte[] key, final byte[] field, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hsetnx(byte[] key, byte[] field, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hsetnx(key, field, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hsetnx(key, field, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<byte[]>> hvals(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "hvals(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.hvals(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hvals(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> incr(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "incr(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.incr(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.incr(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> incrBy(final @ShardingParam byte[] key, final long integer) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "incrBy(byte[] key, long integer)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.incrBy(key, integer);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.incrBy(key, integer);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Double> incrByFloat(final @ShardingParam byte[] key, final double value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "incrByFloat(byte[] key, double value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.incrByFloat(key, value);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.incrByFloat(key, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<byte[]> lindex(final @ShardingParam byte[] key, final long index) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lindex(byte[] key, long index)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.lindex(key, index);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lindex(key, index);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> linsert(final @ShardingParam byte[] key, final BinaryClient.LIST_POSITION where, final byte[] pivot, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.linsert(key, where, pivot, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.linsert(key, where, pivot, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> llen(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "llen(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.llen(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.llen(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<byte[]> lpop(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lpop(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.lpop(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lpop(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> lpush(final @ShardingParam byte[] key, final byte[] ... string) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lpush(byte[] key, byte[]... string)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.lpush(key, string);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lpush(key, string);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> lpushx(final @ShardingParam byte[] key, final byte[] ... bytes) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lpushx(byte[] key, byte[]... bytes)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.lpushx(key, bytes);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lpushx(key, bytes);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<byte[]>> lrange(final @ShardingParam byte[] key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lrange(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.lrange(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lrange(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> lrem(final @ShardingParam byte[] key, final long count, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lrem(byte[] key, long count, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.lrem(key, count, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lrem(key, count, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> lset(final @ShardingParam byte[] key, final long index, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "lset(byte[] key, long index, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.lset(key, index, value);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lset(key, index, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> ltrim(final @ShardingParam byte[] key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "ltrim(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.ltrim(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.ltrim(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> persist(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "persist(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.persist(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.persist(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<byte[]> rpop(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "rpop(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.rpop(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.rpop(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> rpush(final @ShardingParam byte[] key, final byte[] ... string) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "rpush(byte[] key, byte[]... string)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.rpush(key, string);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.rpush(key, string);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> rpushx(final @ShardingParam byte[] key, final byte[] ... string) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "rpushx(byte[] key, byte[]... string)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.rpushx(key, string);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.rpushx(key, string);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> sadd(final @ShardingParam byte[] key, final byte[] ... member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "sadd(byte[] key, byte[]... member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.sadd(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.sadd(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> scard(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "scard(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.scard(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.scard(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> set(final @ShardingParam byte[] key, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "set(byte[] key, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.set(key, value);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.set(key, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    @Override
    @WriteOp
    public Response<String> set(final byte[] key, final byte[] value, final byte[] nxxx, final byte[] expx, final long time) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        Client client = this.clientPool.getClient(this.resource, key);
        client.set(key, value, nxxx, expx, time);
        return this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

            @Override
            public void invoke(Client client) {
                client.set(key, value, nxxx, expx, time);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Boolean> setbit(final @ShardingParam byte[] key, final long offset, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "setbit(byte[] key, long offset, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.setbit(key, offset, value);
            Response response = this.queable.getResponse(client, BuilderFactory.BOOLEAN, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.setbit(key, offset, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> setrange(final @ShardingParam byte[] key, final long offset, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "setrange(byte[] key, long offset, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.setrange(key, offset, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.setrange(key, offset, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> setex(final @ShardingParam byte[] key, final int seconds, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "setex(byte[] key, int seconds, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.setex(key, seconds, value);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.setex(key, seconds, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> psetex(final @ShardingParam byte[] key, final long milliseconds, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "psetex(byte[] key, long milliseconds, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.psetex(key, milliseconds, value);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.psetex(key, milliseconds, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> setnx(final @ShardingParam byte[] key, final byte[] value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "setnx(byte[] key, byte[] value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.setnx(key, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.setnx(key, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> smembers(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "smembers(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.smembers(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.smembers(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Boolean> sismember(final @ShardingParam byte[] key, final byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "sismember(byte[] key, byte[] member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.sismember(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.BOOLEAN, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.sismember(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<byte[]>> sort(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "sort(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.sort(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.sort(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<byte[]>> sort(final @ShardingParam byte[] key, final SortingParams sortingParameters) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "sort(byte[] key, SortingParams sortingParameters)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.sort(key, sortingParameters);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.sort(key, sortingParameters);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<byte[]> spop(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "spop(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.spop(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.spop(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Set<byte[]>> spop(final @ShardingParam byte[] key, final long count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "spop(byte[] key, long count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.spop(key, count);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.spop(key, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<byte[]> srandmember(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "srandmember(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.srandmember(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.srandmember(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<byte[]>> srandmember(final @ShardingParam byte[] key, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "srandmember(byte[] key, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.srandmember(key, count);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.srandmember(key, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> srem(final @ShardingParam byte[] key, final byte[] ... member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "srem(byte[] key, byte[]... member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.srem(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.srem(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> strlen(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "strlen(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.strlen(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.strlen(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> substr(final @ShardingParam byte[] key, final int start, final int end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "substr(byte[] key, int start, int end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.substr(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.substr(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> ttl(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "ttl(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.ttl(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.ttl(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> pttl(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "pttl(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.pttl(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.pttl(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> type(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "type(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.type(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.type(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zadd(final @ShardingParam byte[] key, final double score, final byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zadd(byte[] key, double score, byte[] member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zadd(key, score, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zadd(key, score, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zadd(final @ShardingParam byte[] key, final double score, final byte[] member, final ZAddParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zadd(byte[] key, double score, byte[] member, ZAddParams params)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zadd(key, score, member, params);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zadd(key, score, member, params);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zcard(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zcard(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zcard(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zcard(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zcount(final @ShardingParam byte[] key, final double min, final double max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zcount(byte[] key, double min, double max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zcount(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zcount(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Double> zincrby(final @ShardingParam byte[] key, final double score, final byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zincrby(byte[] key, double score, byte[] member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zincrby(key, score, member);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zincrby(key, score, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Double> zincrby(final @ShardingParam byte[] key, final double score, final byte[] member, final ZIncrByParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zincrby(byte[] key, double score, byte[] member, ZIncrByParams params)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zincrby(key, score, member, params);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zincrby(key, score, member, params);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrange(final @ShardingParam byte[] key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrange(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrange(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrange(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrangeByScore(final @ShardingParam byte[] key, final double min, final double max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScore(byte[] key, double min, double max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeByScore(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScore(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrangeByScore(final @ShardingParam byte[] key, final byte[] min, final byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScore(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeByScore(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScore(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrangeByScore(final @ShardingParam byte[] key, final double min, final double max, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScore(byte[] key, double min, double max, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeByScore(key, min, max, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScore(key, min, max, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrangeByScore(final @ShardingParam byte[] key, final byte[] min, final byte[] max, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeByScore(key, min, max, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScore(key, min, max, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrangeByScoreWithScores(final @ShardingParam byte[] key, final double min, final double max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScoreWithScores(byte[] key, double min, double max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeByScoreWithScores(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScoreWithScores(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrangeByScoreWithScores(final @ShardingParam byte[] key, final byte[] min, final byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeByScoreWithScores(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScoreWithScores(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrangeByScoreWithScores(final @ShardingParam byte[] key, final double min, final double max, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeByScoreWithScores(key, min, max, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScoreWithScores(key, min, max, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrangeByScoreWithScores(final @ShardingParam byte[] key, final byte[] min, final byte[] max, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeByScoreWithScores(key, min, max, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScoreWithScores(key, min, max, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrevrangeByScore(final @ShardingParam byte[] key, final double max, final double min) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScore(byte[] key, double max, double min)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeByScore(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScore(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrevrangeByScore(final @ShardingParam byte[] key, final byte[] max, final byte[] min) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScore(byte[] key, byte[] max, byte[] min)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeByScore(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScore(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrevrangeByScore(final @ShardingParam byte[] key, final double max, final double min, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScore(byte[] key, double max, double min, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeByScore(key, max, min, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScore(key, max, min, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrevrangeByScore(final @ShardingParam byte[] key, final byte[] max, final byte[] min, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeByScore(key, max, min, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScore(key, max, min, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(final @ShardingParam byte[] key, final double max, final double min) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScoreWithScores(byte[] key, double max, double min)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeByScoreWithScores(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScoreWithScores(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(final @ShardingParam byte[] key, final byte[] max, final byte[] min) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeByScoreWithScores(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScoreWithScores(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(final @ShardingParam byte[] key, final double max, final double min, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeByScoreWithScores(key, max, min, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScoreWithScores(key, max, min, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(final @ShardingParam byte[] key, final byte[] max, final byte[] min, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeByScoreWithScores(key, max, min, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScoreWithScores(key, max, min, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrangeWithScores(final @ShardingParam byte[] key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeWithScores(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeWithScores(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeWithScores(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zrank(final @ShardingParam byte[] key, final byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrank(byte[] key, byte[] member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrank(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrank(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zrem(final @ShardingParam byte[] key, final byte[] ... member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrem(byte[] key, byte[]... member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrem(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrem(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zremrangeByRank(final @ShardingParam byte[] key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zremrangeByRank(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zremrangeByRank(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zremrangeByRank(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zremrangeByScore(final @ShardingParam byte[] key, final double start, final double end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zremrangeByScore(byte[] key, double start, double end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zremrangeByScore(SafeEncoder.encode((byte[])key), start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zremrangeByScore(SafeEncoder.encode((byte[])key), start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zremrangeByScore(final @ShardingParam byte[] key, final byte[] start, final byte[] end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zremrangeByScore(byte[] key, byte[] start, byte[] end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zremrangeByScore(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zremrangeByScore(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrevrange(final @ShardingParam byte[] key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrange(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrange(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrange(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrevrangeWithScores(final @ShardingParam byte[] key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeWithScores(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeWithScores(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeWithScores(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zrevrank(final @ShardingParam byte[] key, final byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrank(byte[] key, byte[] member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrank(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrank(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Double> zscore(final @ShardingParam byte[] key, final byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zscore(byte[] key, byte[] member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zscore(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zscore(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zlexcount(final @ShardingParam byte[] key, final byte[] min, final byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zlexcount(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zlexcount(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zlexcount(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrangeByLex(final @ShardingParam byte[] key, final byte[] min, final byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByLex(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeByLex(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByLex(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrangeByLex(final @ShardingParam byte[] key, final byte[] min, final byte[] max, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrangeByLex(key, min, max, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByLex(key, min, max, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrevrangeByLex(final @ShardingParam byte[] key, final byte[] max, final byte[] min) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByLex(byte[] key, byte[] max, byte[] min)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeByLex(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByLex(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<byte[]>> zrevrangeByLex(final @ShardingParam byte[] key, final byte[] max, final byte[] min, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zrevrangeByLex(key, max, min, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByLex(key, max, min, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zremrangeByLex(final @ShardingParam byte[] key, final byte[] min, final byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zremrangeByLex(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zremrangeByLex(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zremrangeByLex(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> bitcount(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "bitcount(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.bitcount(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.bitcount(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> bitcount(final @ShardingParam byte[] key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "bitcount(byte[] key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.bitcount(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.bitcount(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> pfadd(final @ShardingParam byte[] key, final byte[] ... elements) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "pfadd(byte[] key, byte[]... elements)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.pfadd(key, elements);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.pfadd(key, elements);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> pfcount(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "pfcount(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.pfcount(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.pfcount(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> geoadd(final @ShardingParam byte[] key, final double longitude, final double latitude, final byte[] member) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geoadd(byte[] key, double longitude, double latitude, byte[] member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.geoadd(key, longitude, latitude, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geoadd(key, longitude, latitude, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> geoadd(final @ShardingParam byte[] key, final Map<byte[], GeoCoordinate> memberCoordinateMap) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.geoadd(key, memberCoordinateMap);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geoadd(key, memberCoordinateMap);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Double> geodist(final @ShardingParam byte[] key, final byte[] member1, final byte[] member2) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geodist(byte[] key, byte[] member1, byte[] member2)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.geodist(key, member1, member2);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geodist(key, member1, member2);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Double> geodist(final @ShardingParam byte[] key, final byte[] member1, final byte[] member2, final GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.geodist(key, member1, member2, unit);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geodist(key, member1, member2, unit);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<byte[]>> geohash(final @ShardingParam byte[] key, final byte[] ... members) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geohash(byte[] key, byte[]... members)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.geohash(key, members);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geohash(key, members);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<GeoCoordinate>> geopos(final @ShardingParam byte[] key, final byte[] ... members) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "geopos(byte[] key, byte[]... members)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.geopos(key, members);
            Response response = this.queable.getResponse(client, BuilderFactory.GEO_COORDINATE_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geopos(key, members);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<GeoRadiusResponse>> georadius(final @ShardingParam byte[] key, final double longitude, final double latitude, final double radius, final GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.georadius(key, longitude, latitude, radius, unit);
            Response response = this.queable.getResponse(client, BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.georadius(key, longitude, latitude, radius, unit);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<GeoRadiusResponse>> georadius(final @ShardingParam byte[] key, final double longitude, final double latitude, final double radius, final GeoUnit unit, final GeoRadiusParam param) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.georadius(key, longitude, latitude, radius, unit, param);
            Response response = this.queable.getResponse(client, BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.georadius(key, longitude, latitude, radius, unit, param);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<GeoRadiusResponse>> georadiusByMember(final @ShardingParam byte[] key, final byte[] member, final double radius, final GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.georadiusByMember(key, member, radius, unit);
            Response response = this.queable.getResponse(client, BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.georadiusByMember(key, member, radius, unit);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<GeoRadiusResponse>> georadiusByMember(final @ShardingParam byte[] key, final byte[] member, final double radius, final GeoUnit unit, final GeoRadiusParam param) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.georadiusByMember(key, member, radius, unit, param);
            Response response = this.queable.getResponse(client, BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.georadiusByMember(key, member, radius, unit, param);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<Long>> bitfield(final @ShardingParam byte[] key, final byte[] ... elements) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "bitfield(byte[] key, byte[]... elements)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.bitfield(key, elements);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.bitfield(key, elements);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> bitpos(final @ShardingParam byte[] key, final boolean value, final BitPosParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "bitpos(byte[] key, boolean value, BitPosParams params)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.bitpos(key, value, params);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.bitpos(key, value, params);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> append(final @ShardingParam String key, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "append(String key, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.append(key, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.append(key, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> decr(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "decr(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.decr(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.decr(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> decrBy(final @ShardingParam String key, final long integer) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "decrBy(String key, long integer)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.decrBy(key, integer);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.decrBy(key, integer);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> del(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "del(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.del(new String[]{key});
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.del(new String[]{key});
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> echo(final @ShardingParam String string) {
        LogUtil.debugLog((Resource)this.resource, (String)string);
        String command = "echo(String string)";
        this.before(string, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)string));
            client.echo(string);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, string, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.echo(string);
                }
            });
            return response;
        }
        finally {
            this.after(string, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Boolean> exists(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "exists(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.exists(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BOOLEAN, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.exists(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> expire(final @ShardingParam String key, final int seconds) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "expire(String key, int seconds)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.expire(key, seconds);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.expire(key, seconds);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> pexpire(final @ShardingParam String key, final long milliseconds) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "pexpire(String key, long milliseconds)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.pexpire(key, milliseconds);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.pexpire(key, milliseconds);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> expireAt(final @ShardingParam String key, final long unixTime) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "expireAt(String key, long unixTime)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.expireAt(key, unixTime);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.expireAt(key, unixTime);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> pexpireAt(final @ShardingParam String key, final long millisecondsTimestamp) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "pexpireAt(String key, long millisecondsTimestamp)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.pexpireAt(key, millisecondsTimestamp);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.pexpireAt(key, millisecondsTimestamp);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Boolean> getbit(final @ShardingParam String key, final long offset) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "getbit(String key, long offset)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.getbit(key, offset);
            Response response = this.queable.getResponse(client, BuilderFactory.BOOLEAN, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.getbit(key, offset);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> getrange(final @ShardingParam String key, final long startOffset, final long endOffset) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "getrange(String key, long startOffset, long endOffset)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.getrange(key, startOffset, endOffset);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.getrange(key, startOffset, endOffset);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> getSet(final @ShardingParam String key, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "getSet(String key, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.getSet(key, value);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.getSet(key, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> hdel(final @ShardingParam String key, final String ... field) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hdel(String key, String... field)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hdel(key, field);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hdel(key, field);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Boolean> hexists(final @ShardingParam String key, final String field) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hexists(String key, String field)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hexists(key, field);
            Response response = this.queable.getResponse(client, BuilderFactory.BOOLEAN, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hexists(key, field);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> hget(final @ShardingParam String key, final String field) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hget(String key, String field)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hget(key, field);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hget(key, field);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Map<String, String>> hgetAll(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hgetAll(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hgetAll(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_MAP, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hgetAll(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> hincrBy(final @ShardingParam String key, final String field, final long value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hincrBy(String key, String field, long value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hincrBy(key, field, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hincrBy(key, field, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> hkeys(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hkeys(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hkeys(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_SET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hkeys(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> hlen(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hlen(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hlen(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hlen(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<String>> hmget(final @ShardingParam String key, final String ... fields) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hmget(String key, String... fields)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hmget(key, fields);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hmget(key, fields);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> hmset(final @ShardingParam String key, final Map<String, String> hash) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hmset(String key, Map<String, String> hash)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hmset(key, hash);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hmset(key, hash);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> hset(final @ShardingParam String key, final String field, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hset(String key, String field, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hset(key, field, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hset(key, field, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> hsetnx(final @ShardingParam String key, final String field, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hsetnx(String key, String field, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hsetnx(key, field, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hsetnx(key, field, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<String>> hvals(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hvals(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hvals(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hvals(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> incr(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "incr(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.incr(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.incr(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> incrBy(final @ShardingParam String key, final long integer) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "incrBy(String key, long integer)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.incrBy(key, integer);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.incrBy(key, integer);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> lindex(final @ShardingParam String key, final long index) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lindex(String key, long index)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.lindex(key, index);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lindex(key, index);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> linsert(final @ShardingParam String key, final BinaryClient.LIST_POSITION where, final String pivot, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.linsert(key, where, pivot, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.linsert(key, where, pivot, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> llen(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "llen(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.llen(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.llen(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> lpop(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lpop(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.lpop(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lpop(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> lpush(final @ShardingParam String key, final String ... string) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lpush(String key, String... string)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.lpush(key, string);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lpush(key, string);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> lpushx(final @ShardingParam String key, final String ... string) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lpushx(String key, String... string)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.lpushx(key, string);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lpushx(key, string);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<String>> lrange(final @ShardingParam String key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lrange(String key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.lrange(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lrange(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> lrem(final @ShardingParam String key, final long count, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lrem(String key, long count, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.lrem(key, count, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lrem(key, count, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> lset(final @ShardingParam String key, final long index, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "lset(String key, long index, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.lset(key, index, value);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.lset(key, index, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> ltrim(final @ShardingParam String key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "ltrim(String key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.ltrim(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.ltrim(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> persist(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "persist(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.persist(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.persist(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> rpop(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "rpop(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.rpop(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.rpop(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> rpush(final @ShardingParam String key, final String ... string) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "rpush(String key, String... string)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.rpush(key, string);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.rpush(key, string);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> rpushx(final @ShardingParam String key, final String ... string) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "rpushx(String key, String... string)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.rpushx(key, string);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.rpushx(key, string);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> sadd(final @ShardingParam String key, final String ... member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "sadd(String key, String... member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.sadd(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.sadd(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> scard(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "scard(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.scard(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.scard(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Boolean> sismember(final @ShardingParam String key, final String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "sismember(String key, String member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.sismember(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.BOOLEAN, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.sismember(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Boolean> setbit(final @ShardingParam String key, final long offset, final boolean value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "setbit(String key, long offset, boolean value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.setbit(key, offset, value);
            Response response = this.queable.getResponse(client, BuilderFactory.BOOLEAN, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.setbit(key, offset, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> setex(final @ShardingParam String key, final int seconds, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "setex(String key, int seconds, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.setex(key, seconds, value);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.setex(key, seconds, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> setnx(final @ShardingParam String key, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "setnx(String key, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.setnx(key, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.setnx(key, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> setrange(final @ShardingParam String key, final long offset, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "setrange(String key, long offset, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.setrange(key, offset, value);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.setrange(key, offset, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> smembers(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "smembers(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.smembers(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_SET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.smembers(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<String>> sort(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "sort(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.sort(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.sort(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<String>> sort(final @ShardingParam String key, final SortingParams sortingParameters) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "sort(String key, SortingParams sortingParameters)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.sort(key, sortingParameters);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.sort(key, sortingParameters);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> spop(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "spop(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.spop(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.spop(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Set<String>> spop(final @ShardingParam String key, final long count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "spop(String key, long count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.spop(key, count);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_SET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.spop(key, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> srandmember(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "srandmember(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.srandmember(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.srandmember(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> srem(final @ShardingParam String key, final String ... member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "srem(String key, String... member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.srem(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.srem(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> strlen(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "strlen(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.strlen(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.strlen(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> substr(final @ShardingParam String key, final int start, final int end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "substr(String key, int start, int end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.substr(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.substr(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> ttl(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "ttl(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.ttl(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.ttl(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<String> type(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "type(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.type(key);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.type(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zadd(final @ShardingParam String key, final double score, final String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zadd(String key, double score, String member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zadd(key, score, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zadd(key, score, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zadd(final @ShardingParam String key, final double score, final String member, final ZAddParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zadd(String key, double score, String member, ZAddParams params)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zadd(key, score, member, params);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zadd(key, score, member, params);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zadd(final @ShardingParam String key, final Map<String, Double> scoreMembers) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zadd(String key, Map<String, Double> scoreMembers)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zadd(key, scoreMembers);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zadd(key, scoreMembers);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zadd(final @ShardingParam String key, final Map<String, Double> scoreMembers, final ZAddParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zadd(String key, Map<String, Double> scoreMembers, ZAddParams params)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zadd(key, scoreMembers, params);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zadd(key, scoreMembers, params);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zcard(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zcard(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zcard(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zcard(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zcount(final @ShardingParam String key, final double min, final double max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zcount(String key, double min, double max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zcount(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zcount(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Double> zincrby(final @ShardingParam String key, final double score, final String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zincrby(String key, double score, String member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zincrby(key, score, member);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zincrby(key, score, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Double> zincrby(final @ShardingParam String key, final double score, final String member, final ZIncrByParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zincrby(String key, double score, String member, ZIncrByParams params)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zincrby(key, score, member, params);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zincrby(key, score, member, params);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrange(final @ShardingParam String key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrange(String key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrange(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrange(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrangeByScore(final @ShardingParam String key, final double min, final double max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScore(String key, double min, double max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeByScore(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScore(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrangeByScore(final @ShardingParam String key, final String min, final String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScore(String key, String min, String max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeByScore(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScore(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrangeByScore(final @ShardingParam String key, final double min, final double max, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScore(String key, double min, double max, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeByScore(key, min, max, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScore(key, min, max, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrangeByScoreWithScores(final @ShardingParam String key, final double min, final double max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScoreWithScores(String key, double min, double max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeByScoreWithScores(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScoreWithScores(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrangeByScoreWithScores(final @ShardingParam String key, final double min, final double max, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScoreWithScores(String key, double min, double max, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeByScoreWithScores(key, min, max, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScoreWithScores(key, min, max, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrevrangeByScore(final @ShardingParam String key, final double max, final double min) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScore(String key, double max, double min)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeByScore(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScore(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrevrangeByScore(final @ShardingParam String key, final String max, final String min) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScore(String key, String max, String min)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeByScore(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScore(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrevrangeByScore(final @ShardingParam String key, final double max, final double min, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScore(String key, double max, double min, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeByScore(key, max, min, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScore(key, max, min, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(final @ShardingParam String key, final double max, final double min) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScoreWithScores(String key, double max, double min)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeByScoreWithScores(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScoreWithScores(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(final @ShardingParam String key, final double max, final double min, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeByScoreWithScores(key, max, min, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScoreWithScores(key, max, min, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrangeWithScores(final @ShardingParam String key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeWithScores(String key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeWithScores(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeWithScores(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zrank(final @ShardingParam String key, final String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrank(String key, String member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrank(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrank(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zrem(final @ShardingParam String key, final String ... member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrem(String key, String... member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrem(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrem(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zremrangeByRank(final @ShardingParam String key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zremrangeByRank(String key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zremrangeByRank(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zremrangeByRank(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zremrangeByScore(final @ShardingParam String key, final double start, final double end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zremrangeByScore(String key, double start, double end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zremrangeByScore(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zremrangeByScore(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrevrange(final @ShardingParam String key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrange(String key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrange(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrange(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrevrangeWithScores(final @ShardingParam String key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeWithScores(String key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeWithScores(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeWithScores(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zrevrank(final @ShardingParam String key, final String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrank(String key, String member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrank(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrank(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Double> zscore(final @ShardingParam String key, final String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zscore(String key, String member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zscore(key, member);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zscore(key, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zlexcount(final @ShardingParam String key, final String min, final String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zlexcount(String key, String min, String max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zlexcount(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zlexcount(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrangeByLex(final @ShardingParam String key, final String min, final String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByLex(String key, String min, String max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeByLex(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByLex(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrangeByLex(final @ShardingParam String key, final String min, final String max, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByLex(String key, String min, String max, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeByLex(key, min, max, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByLex(key, min, max, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrevrangeByLex(final @ShardingParam String key, final String max, final String min) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByLex(String key, String max, String min)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeByLex(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByLex(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrevrangeByLex(final @ShardingParam String key, final String max, final String min, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByLex(String key, String max, String min, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeByLex(key, max, min, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByLex(key, max, min, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zremrangeByLex(final @ShardingParam String key, final String start, final String end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zremrangeByLex(String key, String start, String end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zremrangeByLex(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zremrangeByLex(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> bitcount(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "bitcount(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.bitcount(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.bitcount(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> bitcount(final @ShardingParam String key, final long start, final long end) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "bitcount(String key, long start, long end)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.bitcount(key, start, end);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.bitcount(key, start, end);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> pfadd(final @ShardingParam String key, final String ... elements) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "pfadd(String key, String... elements)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.pfadd(key, elements);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.pfadd(key, elements);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> pfcount(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "pfcount(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.pfcount(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.pfcount(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<Long>> bitfield(final @ShardingParam String key, final String ... arguments) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "bitfield(String key, String... arguments)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.bitfield(key, arguments);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.bitfield(key, arguments);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> geoadd(final @ShardingParam String key, final double longitude, final double latitude, final String member) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geoadd(String key, double longitude, double latitude, String member)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.geoadd(key, longitude, latitude, member);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geoadd(key, longitude, latitude, member);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> geoadd(final @ShardingParam String key, final Map<String, GeoCoordinate> memberCoordinateMap) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.geoadd(key, memberCoordinateMap);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geoadd(key, memberCoordinateMap);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Double> geodist(final @ShardingParam String key, final String member1, final String member2) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geodist(String key, String member1, String member2)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.geodist(key, member1, member2);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geodist(key, member1, member2);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Double> geodist(final @ShardingParam String key, final String member1, final String member2, final GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geodist(String key, String member1, String member2, GeoUnit unit)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.geodist(key, member1, member2, unit);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geodist(key, member1, member2, unit);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<String>> geohash(final @ShardingParam String key, final String ... members) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geohash(String key, String... members)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.geohash(key, members);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geohash(key, members);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<GeoCoordinate>> geopos(final @ShardingParam String key, final String ... members) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "geopos(String key, String... members)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.geopos(key, members);
            Response response = this.queable.getResponse(client, BuilderFactory.GEO_COORDINATE_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.geopos(key, members);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<GeoRadiusResponse>> georadius(final @ShardingParam String key, final double longitude, final double latitude, final double radius, final GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "georadius(String key, double longitude, double latitude, double radius, GeoUnit unit)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.georadius(key, longitude, latitude, radius, unit);
            Response response = this.queable.getResponse(client, BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.georadius(key, longitude, latitude, radius, unit);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<GeoRadiusResponse>> georadius(final @ShardingParam String key, final double longitude, final double latitude, final double radius, final GeoUnit unit, final GeoRadiusParam param) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.georadius(key, longitude, latitude, radius, unit, param);
            Response response = this.queable.getResponse(client, BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.georadius(key, longitude, latitude, radius, unit, param);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<GeoRadiusResponse>> georadiusByMember(final @ShardingParam String key, final String member, final double radius, final GeoUnit unit) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "georadiusByMember(String key, String member, double radius, GeoUnit unit)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.georadiusByMember(key, member, radius, unit);
            Response response = this.queable.getResponse(client, BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.georadiusByMember(key, member, radius, unit);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<GeoRadiusResponse>> georadiusByMember(final @ShardingParam String key, final String member, final double radius, final GeoUnit unit, final GeoRadiusParam param) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.georadiusByMember(key, member, radius, unit, param);
            Response response = this.queable.getResponse(client, BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.georadiusByMember(key, member, radius, unit, param);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zadd(final @ShardingParam byte[] key, final Map<byte[], Double> scoreMembers) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zadd(byte[] key, Map<byte[], Double> scoreMembers)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zaddBinary(key, scoreMembers);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zaddBinary(key, scoreMembers);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zadd(final @ShardingParam byte[] key, final Map<byte[], Double> scoreMembers, final ZAddParams params) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zaddBinary(key, scoreMembers, params);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zaddBinary(key, scoreMembers, params);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<byte[]> dump(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "dump(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.dump(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.dump(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<byte[]> dump(final @ShardingParam byte[] key) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "dump(byte[] key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.dump(key);
            Response response = this.queable.getResponse(client, BuilderFactory.BYTE_ARRAY, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.dump(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> restore(final @ShardingParam byte[] key, final int ttl, final byte[] serializedValue) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "restore(byte[] key, int ttl, byte[] serializedValue)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.restore(key, ttl, serializedValue);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.restore(key, ttl, serializedValue);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> restore(final @ShardingParam String key, final int ttl, final byte[] serializedValue) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "restore(String key, int ttl, byte[] serializedValue)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.restore(key, ttl, serializedValue);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.restore(key, ttl, serializedValue);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Double> hincrByFloat(final @ShardingParam String key, final String field, final double increment) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "hincrByFloat(String key, String field, double increment)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.hincrByFloat(key, field, increment);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.hincrByFloat(key, field, increment);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Double> incrByFloat(final @ShardingParam String key, final double increment) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "incrByFloat(String key, double increment)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.incrByFloat(key, increment);
            Response response = this.queable.getResponse(client, BuilderFactory.DOUBLE, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.incrByFloat(key, increment);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> set(final @ShardingParam String key, final String value, final String nxxx) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "set(String key, String value, String nxxx)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.set(key, value, nxxx);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.set(key, value, nxxx);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> set(final @ShardingParam byte[] key, final byte[] value, final byte[] nxxx) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "set(byte[] key, byte[] value, byte[] nxxx)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.set(key, value, nxxx);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.set(key, value, nxxx);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> set(final @ShardingParam String key, final String value, final String nxxx, final String expx, final int time) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "set(String key, String value, String nxxx, String expx, int time)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.set(key, value, nxxx, expx, time);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.set(key, value, nxxx, expx, time);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> psetex(final @ShardingParam String key, final long milliseconds, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "psetex(String key, long milliseconds, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.psetex(key, milliseconds, value);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.psetex(key, milliseconds, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<String> psetex(final @ShardingParam String key, final int milliseconds, final String value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "psetex(String key, int milliseconds, String value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.psetex(key, milliseconds, value);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.psetex(key, milliseconds, value);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<List<String>> srandmember(final @ShardingParam String key, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "srandmember(String key, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.srandmember(key, count);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_LIST, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.srandmember(key, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> pttl(final @ShardingParam String key) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "pttl(String key)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.pttl(key);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.pttl(key);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrangeByScore(final @ShardingParam String key, final String min, final String max, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScore(String key, String min, String max, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeByScore(key, min, max, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScore(key, min, max, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrangeByScoreWithScores(final @ShardingParam String key, final String min, final String max, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScoreWithScores(String key, String min, String max, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeByScoreWithScores(key, min, max, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScoreWithScores(key, min, max, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrangeByScoreWithScores(final @ShardingParam String key, final String min, final String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrangeByScoreWithScores(String key, String min, String max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrangeByScoreWithScores(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrangeByScoreWithScores(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<String>> zrevrangeByScore(final @ShardingParam String key, final String max, final String min, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScore(String key, String max, String min, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeByScore(key, max, min, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.STRING_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScore(key, max, min, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(final @ShardingParam String key, final String max, final String min, final int offset, final int count) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeByScoreWithScores(key, max, min, offset, count);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScoreWithScores(key, max, min, offset, count);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Set<Tuple>> zrevrangeByScoreWithScores(final @ShardingParam String key, final String max, final String min) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zrevrangeByScoreWithScores(String key, String max, String min)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zrevrangeByScoreWithScores(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.TUPLE_ZSET, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zrevrangeByScoreWithScores(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WriteOp
    public Response<Long> zremrangeByScore(final @ShardingParam String key, final String min, final String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zremrangeByScore(String key, String min, String max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zremrangeByScore(key, max, min);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zremrangeByScore(key, max, min);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> bitpos(final @ShardingParam String key, final boolean value) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "bitpos(String key, boolean value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.bitpos(key, value, (BitPosParams)new CamelliaBitPosParams());
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.bitpos(key, value, (BitPosParams)new CamelliaBitPosParams());
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> bitpos(final @ShardingParam String key, final boolean value, final BitPosParams params) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "bitpos(String key, boolean value, BitPosParams params)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.bitpos(key, value, params);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.bitpos(key, value, params);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> bitpos(final @ShardingParam byte[] key, final boolean value) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "bitpos(byte[] key, boolean value)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.bitpos(key, value, (BitPosParams)new CamelliaBitPosParams());
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.bitpos(key, value, (BitPosParams)new CamelliaBitPosParams());
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zcount(final @ShardingParam byte[] key, final byte[] min, final byte[] max) {
        LogUtil.debugLog((Resource)this.resource, (byte[])key);
        String command = "zcount(byte[] key, byte[] min, byte[] max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, key);
            client.zcount(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zcount(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ReadOp
    public Response<Long> zcount(final @ShardingParam String key, final String min, final String max) {
        LogUtil.debugLog((Resource)this.resource, (String)key);
        String command = "zcount(String key, String min, String max)";
        this.before(key, command);
        try {
            Client client = this.clientPool.getClient(this.resource, SafeEncoder.encode((String)key));
            client.zcount(key, min, max);
            Response response = this.queable.getResponse(client, BuilderFactory.LONG, this.resource, key, new ResponseQueable.Fallback(){

                @Override
                public void invoke(Client client) {
                    client.zcount(key, min, max);
                }
            });
            return response;
        }
        finally {
            this.after(key, command);
        }
    }
}

