/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.camellia.redis.pipeline;

import com.netease.nim.camellia.core.model.Resource;
import com.netease.nim.camellia.redis.base.exception.CamelliaRedisException;
import com.netease.nim.camellia.redis.base.resource.CamelliaRedisProxyResource;
import com.netease.nim.camellia.redis.base.resource.RedisClusterResource;
import com.netease.nim.camellia.redis.base.resource.RedisProxiesDiscoveryResource;
import com.netease.nim.camellia.redis.base.resource.RedisProxiesResource;
import com.netease.nim.camellia.redis.base.resource.RedisResource;
import com.netease.nim.camellia.redis.base.resource.RedisSentinelResource;
import com.netease.nim.camellia.redis.base.resource.RedisSentinelSlavesResource;
import com.netease.nim.camellia.redis.base.utils.CloseUtil;
import com.netease.nim.camellia.redis.jedis.JedisPoolFactory;
import com.netease.nim.camellia.redis.jediscluster.JedisClusterFactory;
import com.netease.nim.camellia.redis.jediscluster.JedisClusterWrapper;
import com.netease.nim.camellia.redis.proxy.CamelliaRedisProxyContext;
import com.netease.nim.camellia.redis.proxy.RedisProxyResource;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisMovedDataException;

public interface RedisClientPool {
    public Client getClient(Resource var1, byte[] var2);

    public Client getClient(Resource var1, String var2, int var3);

    public void clear();

    public void handlerException(Resource var1, Exception var2);

    public static class DefaultRedisClientPool
    implements RedisClientPool {
        private final Map<String, Jedis> jedisMap = new ConcurrentHashMap<String, Jedis>();
        private final Map<JedisPool, Jedis> jedisClusterMap = new ConcurrentHashMap<JedisPool, Jedis>();
        private final JedisPoolFactory jedisPoolFactory;
        private final JedisClusterFactory jedisClusterFactory;

        public DefaultRedisClientPool(JedisPoolFactory jedisPoolFactory, JedisClusterFactory jedisClusterFactory) {
            this.jedisPoolFactory = jedisPoolFactory;
            this.jedisClusterFactory = jedisClusterFactory;
        }

        @Override
        public Client getClient(Resource resource, byte[] key) {
            try {
                if (resource instanceof RedisResource) {
                    Jedis jedis1 = this.jedisMap.get(resource.getUrl());
                    if (jedis1 != null) {
                        return jedis1.getClient();
                    }
                    jedis1 = this.jedisPoolFactory.getJedisPool((RedisResource)resource).getResource();
                    this.jedisMap.put(resource.getUrl(), jedis1);
                    return jedis1.getClient();
                }
                if (resource instanceof RedisClusterResource) {
                    JedisClusterWrapper jedisCluster = this.jedisClusterFactory.getJedisCluster((RedisClusterResource)resource);
                    JedisPool jedisPool = jedisCluster.getJedisPool(key);
                    Jedis jedis2 = this.jedisClusterMap.get(jedisPool);
                    if (jedis2 != null) {
                        return jedis2.getClient();
                    }
                    jedis2 = jedisPool.getResource();
                    this.jedisClusterMap.put(jedisPool, jedis2);
                    return jedis2.getClient();
                }
                if (resource instanceof RedisSentinelResource) {
                    Jedis jedis3 = this.jedisMap.get(resource.getUrl());
                    if (jedis3 != null) {
                        return jedis3.getClient();
                    }
                    jedis3 = this.jedisPoolFactory.getJedisSentinelPool((RedisSentinelResource)resource).getResource();
                    this.jedisMap.put(resource.getUrl(), jedis3);
                    return jedis3.getClient();
                }
                if (resource instanceof RedisProxyResource) {
                    Jedis jedis4 = this.jedisMap.get(resource.getUrl());
                    if (jedis4 != null) {
                        return jedis4.getClient();
                    }
                    jedis4 = ((RedisProxyResource)resource).getJedisPool().getResource();
                    this.jedisMap.put(resource.getUrl(), jedis4);
                    return jedis4.getClient();
                }
                if (resource instanceof CamelliaRedisProxyResource) {
                    Jedis jedis5 = this.jedisMap.get(resource.getUrl());
                    if (jedis5 != null) {
                        return jedis5.getClient();
                    }
                    JedisPool jedisPool = CamelliaRedisProxyContext.getFactory().initOrGet((CamelliaRedisProxyResource)resource);
                    jedis5 = jedisPool.getResource();
                    this.jedisMap.put(resource.getUrl(), jedis5);
                    return jedis5.getClient();
                }
                if (resource instanceof RedisSentinelSlavesResource) {
                    Jedis jedis6 = this.jedisMap.get(resource.getUrl());
                    if (jedis6 != null) {
                        return jedis6.getClient();
                    }
                    jedis6 = this.jedisPoolFactory.getJedisSentinelSlavesPool((RedisSentinelSlavesResource)resource).getResource();
                    this.jedisMap.put(resource.getUrl(), jedis6);
                    return jedis6.getClient();
                }
                if (resource instanceof RedisProxiesResource) {
                    Jedis jedis6 = this.jedisMap.get(resource.getUrl());
                    if (jedis6 != null) {
                        return jedis6.getClient();
                    }
                    jedis6 = this.jedisPoolFactory.getRedisProxiesJedisPool((RedisProxiesResource)resource).getResource();
                    this.jedisMap.put(resource.getUrl(), jedis6);
                    return jedis6.getClient();
                }
                if (resource instanceof RedisProxiesDiscoveryResource) {
                    Jedis jedis6 = this.jedisMap.get(resource.getUrl());
                    if (jedis6 != null) {
                        return jedis6.getClient();
                    }
                    jedis6 = this.jedisPoolFactory.getRedisProxiesDiscoveryJedisPool((RedisProxiesDiscoveryResource)resource).getResource();
                    this.jedisMap.put(resource.getUrl(), jedis6);
                    return jedis6.getClient();
                }
                throw new UnsupportedOperationException();
            }
            catch (Exception e) {
                this.handlerException(resource, e);
                throw e;
            }
        }

        @Override
        public Client getClient(Resource resource, String host, int port) {
            try {
                if (resource instanceof RedisClusterResource) {
                    JedisClusterWrapper jedisCluster = this.jedisClusterFactory.getJedisCluster((RedisClusterResource)resource);
                    JedisPool jedisPool = jedisCluster.getJedisPool(host, port);
                    Jedis jedis = this.jedisClusterMap.get(jedisPool);
                    if (jedis != null) {
                        return jedis.getClient();
                    }
                    jedis = jedisPool.getResource();
                    this.jedisClusterMap.put(jedisPool, jedis);
                    return jedis.getClient();
                }
                throw new CamelliaRedisException("only support RedisClusterResource");
            }
            catch (Exception e) {
                this.handlerException(resource, e);
                throw e;
            }
        }

        @Override
        public void clear() {
            if (!this.jedisMap.isEmpty()) {
                for (Map.Entry<String, Jedis> entry : this.jedisMap.entrySet()) {
                    CloseUtil.closeQuietly((Closeable)((Closeable)entry.getValue()));
                }
                this.jedisMap.clear();
            }
            if (!this.jedisClusterMap.isEmpty()) {
                for (Map.Entry<String, Jedis> entry : this.jedisClusterMap.entrySet()) {
                    CloseUtil.closeQuietly((Closeable)((Closeable)entry.getValue()));
                }
                this.jedisClusterMap.clear();
            }
        }

        @Override
        public void handlerException(Resource resource, Exception e) {
            if (resource instanceof RedisClusterResource && (e instanceof JedisMovedDataException || e instanceof JedisConnectionException || e instanceof JedisClusterException)) {
                JedisClusterWrapper jedisCluster = this.jedisClusterFactory.getJedisCluster((RedisClusterResource)resource);
                jedisCluster.renewSlotCache();
            }
        }
    }
}

