/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk;

import android.text.TextUtils;
import java.util.HashMap;

public class NosTokenSceneConfig {
    public static final long NEVER_EXPIRE = 0L;
    private static final long DAY_SECOND = 86400L;
    private static final int MAX_CUSTOM_SCENE_COUNT = 10;
    private static final HashMap<String, Long> DEFAULT_SCENE = new HashMap();
    private static int sDefaultSceneCount;
    private static NosTokenSceneConfig sDefault;
    private HashMap<String, Long> mNosTokenScene = new HashMap();

    public NosTokenSceneConfig() {
        this.mNosTokenScene.putAll(DEFAULT_SCENE);
    }

    public void updateDefaultProfileSceneExpireTime(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("expireTimeByDay must >= 0");
        }
        this.mNosTokenScene.put("nim_default_profile_icon", (long)n2 * 86400L);
    }

    public void updateDefaultIMSceneExpireTime(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("expireTimeByDay must >= 0");
        }
        this.mNosTokenScene.put("nim_default_im", (long)n2 * 86400L);
    }

    public NosTokenSceneConfig appendCustomScene(String string2, int n2) {
        if (n2 < 0 || TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("sceneKey must not empty and expireTimeByDay must >= 0");
        }
        if (this.mNosTokenScene.size() - sDefaultSceneCount > 10) {
            throw new IllegalStateException("the custom scene count must <= 10");
        }
        if ("nim_system_nos_scene".equals(string2)) {
            throw new IllegalArgumentException("the \"nim_system_nos_scene\" scene cannot be modified");
        }
        this.mNosTokenScene.put(string2, (long)n2 * 86400L);
        return this;
    }

    public HashMap<String, Long> getNosTokenScene() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>(this.mNosTokenScene.size());
        hashMap.putAll(this.mNosTokenScene);
        return hashMap;
    }

    public static NosTokenSceneConfig defaultConfig() {
        NosTokenSceneConfig.sDefault.mNosTokenScene = DEFAULT_SCENE;
        return sDefault;
    }

    static {
        sDefault = new NosTokenSceneConfig();
        DEFAULT_SCENE.put("nim_default_profile_icon", 0L);
        DEFAULT_SCENE.put("nim_default_im", 0L);
        DEFAULT_SCENE.put("nim_system_nos_scene", 0L);
        DEFAULT_SCENE.put("nim_security", 0L);
        sDefaultSceneCount = DEFAULT_SCENE.size();
    }
}

