/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk;

public enum StatusCode {
    INVALID(0, ""),
    UNLOGIN(1, ""),
    NET_BROKEN(2, ""),
    CONNECTING(3, ""),
    LOGINING(4, ""),
    SYNCING(5, ""),
    LOGINED(6, ""),
    KICKOUT(7, ""),
    KICK_BY_OTHER_CLIENT(8, ""),
    FORBIDDEN(9, ""),
    VER_ERROR(10, ""),
    PWD_ERROR(11, "");

    private int value;
    private String desc;

    public boolean wontAutoLogin() {
        return this == KICKOUT || this == KICK_BY_OTHER_CLIENT || this == FORBIDDEN || this == PWD_ERROR;
    }

    public boolean wontAutoLoginForever() {
        return this == KICKOUT || this == KICK_BY_OTHER_CLIENT;
    }

    public boolean shouldReLogin() {
        return this == UNLOGIN || this == NET_BROKEN;
    }

    private StatusCode(int n3, String string3) {
        this.value = n3;
        this.desc = string3;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String string2) {
        this.desc = string2;
    }

    public static StatusCode typeOfValue(int n2) {
        for (StatusCode statusCode : StatusCode.values()) {
            if (statusCode.getValue() != n2) continue;
            return statusCode;
        }
        return INVALID;
    }

    public static StatusCode statusOfResCode(int n2) {
        switch (n2) {
            case 200: {
                return LOGINED;
            }
            case 403: 
            case 422: {
                return FORBIDDEN;
            }
            case 317: {
                return VER_ERROR;
            }
            case 302: 
            case 404: 
            case 414: {
                return PWD_ERROR;
            }
            case 417: {
                return KICKOUT;
            }
        }
        return UNLOGIN;
    }
}

