/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.media.player;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.netease.nimlib.k.b;
import com.netease.nimlib.sdk.media.player.OnPlayListener;
import java.io.File;

public final class AudioPlayer {
    public static final String TAG = "AudioPlayer";
    private MediaPlayer mPlayer;
    private String mAudioFile;
    private long mIntervalTime = 500L;
    private AudioManager audioManager;
    private OnPlayListener mListener;
    private int audioStreamType = 0;
    private static final int WHAT_COUNT_PLAY = 0;
    private static final int WHAT_DECODE_SUCCEED = 1;
    private static final int WHAT_DECODE_FAILED = 2;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    if (AudioPlayer.this.mListener != null) {
                        AudioPlayer.this.mListener.onPlaying(AudioPlayer.this.mPlayer.getCurrentPosition());
                    }
                    this.sendEmptyMessageDelayed(0, AudioPlayer.this.mIntervalTime);
                    break;
                }
                case 2: {
                    b.e(AudioPlayer.TAG, "convert() error: " + AudioPlayer.this.mAudioFile);
                    break;
                }
                case 1: {
                    AudioPlayer.this.startInner();
                }
            }
        }
    };
    AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int n2) {
            switch (n2) {
                case 1: {
                    if (!AudioPlayer.this.isPlaying()) break;
                    AudioPlayer.this.mPlayer.setVolume(1.0f, 1.0f);
                    break;
                }
                case -1: {
                    AudioPlayer.this.stop();
                    break;
                }
                case -2: {
                    AudioPlayer.this.stop();
                    break;
                }
                case -3: {
                    if (!AudioPlayer.this.isPlaying()) break;
                    AudioPlayer.this.mPlayer.setVolume(0.1f, 0.1f);
                }
            }
        }
    };

    public AudioPlayer(Context context) {
        this(context, null, null);
    }

    public AudioPlayer(Context context, String string2, OnPlayListener onPlayListener) {
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioFile = string2;
        this.mListener = onPlayListener;
    }

    public void setDataSource(String string2) {
        if (!TextUtils.equals((CharSequence)string2, (CharSequence)this.mAudioFile)) {
            b.o("start play audio file" + string2);
            this.mAudioFile = string2;
        }
    }

    public void setOnPlayListener(OnPlayListener onPlayListener) {
        this.mListener = onPlayListener;
    }

    public OnPlayListener getOnPlayListener() {
        return this.mListener;
    }

    public void start(int n2) {
        this.audioStreamType = n2;
        this.startPlay();
    }

    public void stop() {
        if (this.mPlayer != null) {
            this.endPlay();
            if (this.mListener != null) {
                this.mListener.onInterrupt();
            }
        }
    }

    public boolean isPlaying() {
        return this.mPlayer != null && this.mPlayer.isPlaying();
    }

    public long getDuration() {
        if (this.mPlayer != null) {
            return this.mPlayer.getDuration();
        }
        return 0L;
    }

    public long getCurrentPosition() {
        if (this.mPlayer != null) {
            return this.mPlayer.getCurrentPosition();
        }
        return 0L;
    }

    public void seekTo(int n2) {
        this.mPlayer.seekTo(n2);
    }

    private void startPlay() {
        b.b(TAG, "start() called");
        this.endPlay();
        this.startInner();
    }

    private void endPlay() {
        this.audioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
        if (this.mPlayer != null) {
            this.mPlayer.stop();
            this.mPlayer.release();
            this.mPlayer = null;
            this.mHandler.removeMessages(0);
        }
    }

    private void startInner() {
        block6: {
            this.mPlayer = new MediaPlayer();
            this.mPlayer.setLooping(false);
            this.mPlayer.setAudioStreamType(this.audioStreamType);
            if (this.audioStreamType == 3) {
                this.audioManager.setSpeakerphoneOn(true);
            } else {
                this.audioManager.setSpeakerphoneOn(false);
            }
            this.audioManager.requestAudioFocus(this.onAudioFocusChangeListener, this.audioStreamType, 2);
            this.mPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mediaPlayer) {
                    b.b(AudioPlayer.TAG, "player:onPrepared");
                    AudioPlayer.this.mHandler.sendEmptyMessage(0);
                    if (AudioPlayer.this.mListener != null) {
                        AudioPlayer.this.mListener.onPrepared();
                    }
                }
            });
            this.mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mediaPlayer) {
                    b.b(AudioPlayer.TAG, "player:onCompletion");
                    AudioPlayer.this.endPlay();
                    if (AudioPlayer.this.mListener != null) {
                        AudioPlayer.this.mListener.onCompletion();
                    }
                }
            });
            this.mPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                    b.e(AudioPlayer.TAG, String.format("player:onOnError what:%d extra:%d", n2, n3));
                    AudioPlayer.this.endPlay();
                    if (AudioPlayer.this.mListener != null) {
                        AudioPlayer.this.mListener.onError(String.format("OnErrorListener what:%d extra:%d", n2, n3));
                    }
                    return true;
                }
            });
            try {
                if (this.mAudioFile == null) {
                    if (this.mListener != null) {
                        this.mListener.onError("no datasource");
                    }
                    return;
                }
                this.mPlayer.setDataSource(this.mAudioFile);
                this.mPlayer.prepare();
                this.mPlayer.start();
                b.b(TAG, "player:start ok---->" + this.mAudioFile);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                b.e(TAG, "player:onOnError Exception\n" + exception.toString());
                this.endPlay();
                if (this.mListener == null) break block6;
                this.mListener.onError("Exception\n" + exception.toString());
            }
        }
    }

    private void deleteOnExit() {
        File file = new File(this.mAudioFile);
        if (file.exists()) {
            file.deleteOnExit();
        }
    }
}

