/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.media.record;

import android.content.Context;
import android.media.AudioManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.netease.nimlib.c;
import com.netease.nimlib.k.b;
import com.netease.nimlib.s.l;
import com.netease.nimlib.s.r;
import com.netease.nimlib.sdk.media.record.IAudioRecordCallback;
import com.netease.nimlib.sdk.media.record.RecordType;
import com.netease.share.media.a;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class AudioRecorder {
    public static final int DEFAULT_MAX_AUDIO_RECORD_TIME_SECOND = 120;
    private static final int MSG_START_RECORD = 1;
    private static final int MSG_STOP_RECORD = 2;
    private static final int MSG_END_RECORD = 3;
    private static final int RECORD_FAILED = 1;
    private static final int RECORD_READY = 2;
    private static final int RECORD_START = 3;
    private static final int RECORD_SUCCESS = 4;
    private static final int RECORD_CANCELED = 5;
    private static final String TAG = "AudioRecordManager";
    private a mAudioRecorder;
    private AudioManager audioManager;
    private Context context;
    private int networkClass = 0;
    private File audioFile;
    private RecordType recordType;
    private int maxDuration;
    private AtomicBoolean isRecording = new AtomicBoolean(false);
    private AtomicBoolean cancelRecord = new AtomicBoolean(false);
    private IAudioRecordCallback cb;
    private RecordHandler mHandler;
    private Handler mEventHandler = new Handler(Looper.getMainLooper());
    private HandlerThread handlerThread;
    private com.netease.share.media.c infoListener = new com.netease.share.media.c(){

        @Override
        public void onInfo(int n2, int n3, int n4) {
            if (n3 == 2) {
                AudioRecorder.this.handleEndRecord(false, 0);
            } else if (n3 == 1) {
                AudioRecorder.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        AudioRecorder.this.isRecording.set(false);
                    }
                });
                AudioRecorder.this.handleReachedMaxRecordTime(n4);
            } else if (n3 == 3) {
                // empty if block
            }
        }
    };

    public AudioRecorder(Context context, RecordType recordType, int n2, IAudioRecordCallback iAudioRecordCallback) {
        this.context = context.getApplicationContext();
        this.recordType = recordType;
        this.maxDuration = n2 <= 0 ? 120 : n2;
        this.cb = iAudioRecordCallback;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.handlerThread = new HandlerThread("audio_recorder");
        this.handlerThread.start();
        this.mHandler = new RecordHandler(this.handlerThread.getLooper());
    }

    public void startRecord() {
        this.mHandler.removeMessages(1);
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    private void onStartRecord() {
        this.audioManager.requestAudioFocus(null, 0, 2);
        if (this.isRecording.get()) {
            b.o("AudioRecordManager startRecord false, as current state is isRecording");
            this.callBackRecordState(1);
            return;
        }
        if (!com.netease.nimlib.s.a.c.a(com.netease.nimlib.s.a.b.d)) {
            b.o("AudioRecordManager startRecord false, as has no enough space to write");
            this.callBackRecordState(1);
            return;
        }
        int n2 = this.recordType.getOutputFormat();
        String string2 = com.netease.nimlib.s.a.c.a(c.d(), r.a() + n2, com.netease.nimlib.s.a.b.d);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            b.o("AudioRecordManager startRecord false, as outputFilePath is empty");
            this.callBackRecordState(1);
            return;
        }
        string2 = string2 + this.recordType.getFileSuffix();
        this.audioFile = new File(string2);
        this.cancelRecord.set(false);
        try {
            this.mAudioRecorder = new a(this.context, string2, this.maxDuration * 1000);
            this.mAudioRecorder.b(n2);
            this.networkClass = l.l(this.context);
            if (this.networkClass == 2) {
                this.mAudioRecorder.a(22050);
            } else if (this.networkClass == 1) {
                this.mAudioRecorder.a(16000);
            }
            this.mAudioRecorder.a(this.infoListener);
            if (!this.cancelRecord.get()) {
                this.callBackRecordState(2);
                if (this.mAudioRecorder.c()) {
                    this.isRecording.set(true);
                    this.callBackRecordState(3);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.onCompleteRecord(false);
        }
        if (!this.isRecording.get()) {
            this.callBackRecordState(1);
        }
    }

    public void completeRecord(boolean bl) {
        Message message = this.mHandler.obtainMessage(2);
        message.obj = bl;
        message.sendToTarget();
    }

    private void onCompleteRecord(boolean bl) {
        if (!this.isRecording.get()) {
            return;
        }
        this.cancelRecord.set(bl);
        this.audioManager.abandonAudioFocus(null);
        try {
            if (this.mAudioRecorder != null) {
                this.mAudioRecorder.b();
                this.onHandleEndRecord(true, this.mAudioRecorder.d());
                this.mAudioRecorder = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void destroyAudioRecorder() {
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        if (this.handlerThread != null) {
            this.handlerThread.getLooper().quit();
        }
    }

    public boolean isRecording() {
        return this.isRecording.get();
    }

    public void handleEndRecord(boolean bl, int n2) {
        Message message = this.mHandler.obtainMessage(3);
        message.obj = bl;
        message.arg1 = n2;
        message.sendToTarget();
    }

    private void onHandleEndRecord(boolean bl, final int n2) {
        if (this.cancelRecord.get()) {
            com.netease.nimlib.m.a.c.a.c(this.audioFile.getAbsolutePath());
            this.callBackRecordState(5);
        } else if (!bl) {
            com.netease.nimlib.m.a.c.a.c(this.audioFile.getAbsolutePath());
            this.callBackRecordState(1);
        } else if (this.audioFile == null || !this.audioFile.exists() || this.audioFile.length() <= 0L) {
            this.callBackRecordState(1);
        } else {
            this.mEventHandler.post(new Runnable(){

                @Override
                public void run() {
                    AudioRecorder.this.cb.onRecordSuccess(AudioRecorder.this.audioFile, n2, AudioRecorder.this.recordType);
                }
            });
        }
        this.isRecording.set(false);
    }

    private void callBackRecordState(final int n2) {
        this.mEventHandler.post(new Runnable(){

            @Override
            public void run() {
                switch (n2) {
                    case 1: {
                        AudioRecorder.this.cb.onRecordFail();
                        break;
                    }
                    case 2: {
                        AudioRecorder.this.cb.onRecordReady();
                        break;
                    }
                    case 3: {
                        AudioRecorder.this.cb.onRecordStart(AudioRecorder.this.audioFile, AudioRecorder.this.recordType);
                        break;
                    }
                    case 5: {
                        AudioRecorder.this.cb.onRecordCancel();
                    }
                }
            }
        });
    }

    public int getCurrentRecordMaxAmplitude() {
        if (this.mAudioRecorder != null) {
            return this.mAudioRecorder.a();
        }
        return 0;
    }

    private void handleReachedMaxRecordTime(int n2) {
        this.cb.onRecordReachedMaxTime(n2);
    }

    private class RecordHandler
    extends Handler {
        public RecordHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    AudioRecorder.this.onStartRecord();
                    break;
                }
                case 2: {
                    boolean bl = (Boolean)message.obj;
                    AudioRecorder.this.onCompleteRecord(bl);
                    break;
                }
                case 3: {
                    boolean bl = (Boolean)message.obj;
                    int n2 = message.arg1;
                    AudioRecorder.this.onHandleEndRecord(bl, n2);
                }
            }
        }
    }
}

