/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.msg;

import android.text.TextUtils;
import com.netease.nimlib.c;
import com.netease.nimlib.l.a;
import com.netease.nimlib.s.b;
import com.netease.nimlib.s.r;
import com.netease.nimlib.s.t;
import com.netease.nimlib.sdk.msg.attachment.AudioAttachment;
import com.netease.nimlib.sdk.msg.attachment.FileAttachment;
import com.netease.nimlib.sdk.msg.attachment.ImageAttachment;
import com.netease.nimlib.sdk.msg.attachment.LocationAttachment;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.netease.nimlib.sdk.msg.attachment.VideoAttachment;
import com.netease.nimlib.sdk.msg.constant.AttachStatusEnum;
import com.netease.nimlib.sdk.msg.constant.MsgDirectionEnum;
import com.netease.nimlib.sdk.msg.constant.MsgStatusEnum;
import com.netease.nimlib.sdk.msg.constant.MsgTypeEnum;
import com.netease.nimlib.sdk.msg.constant.SessionTypeEnum;
import com.netease.nimlib.sdk.msg.model.CustomMessageConfig;
import com.netease.nimlib.sdk.msg.model.IMMessage;
import com.netease.nimlib.sdk.robot.model.RobotAttachment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageBuilder {
    public static IMMessage createTextMessage(String string2, SessionTypeEnum sessionTypeEnum, String string3) {
        com.netease.nimlib.p.c c2 = MessageBuilder.initSendMessage(string2, sessionTypeEnum);
        c2.a(MsgTypeEnum.text.getValue());
        c2.setContent(string3);
        return c2;
    }

    public static IMMessage createImageMessage(String string2, SessionTypeEnum sessionTypeEnum, File file) {
        return MessageBuilder.createImageMessage(string2, sessionTypeEnum, file, null, "nim_default_im");
    }

    public static IMMessage createImageMessage(String string2, SessionTypeEnum sessionTypeEnum, File file, String string3) {
        return MessageBuilder.createImageMessage(string2, sessionTypeEnum, file, string3, "nim_default_im");
    }

    public static IMMessage createImageMessage(String string2, SessionTypeEnum sessionTypeEnum, File file, String string3, String string4) {
        com.netease.nimlib.p.c c2 = MessageBuilder.initSendMessage(string2, sessionTypeEnum);
        c2.a(MsgTypeEnum.image.getValue());
        ImageAttachment imageAttachment = new ImageAttachment();
        imageAttachment.setPath(file.getPath());
        imageAttachment.setSize(file.length());
        int[] nArray = b.a(file);
        imageAttachment.setWidth(nArray[0]);
        imageAttachment.setHeight(nArray[1]);
        imageAttachment.setDisplayName(string3);
        imageAttachment.setExtension(r.a(file.getName()));
        imageAttachment.setNosTokenSceneKey(string4);
        c2.setAttachment(imageAttachment);
        return c2;
    }

    public static IMMessage createAudioMessage(String string2, SessionTypeEnum sessionTypeEnum, File file, long l2) {
        return MessageBuilder.createAudioMessage(string2, sessionTypeEnum, file, l2, "nim_default_im");
    }

    public static IMMessage createAudioMessage(String string2, SessionTypeEnum sessionTypeEnum, File file, long l2, String string3) {
        com.netease.nimlib.p.c c2 = MessageBuilder.initSendMessage(string2, sessionTypeEnum);
        c2.a(MsgTypeEnum.audio.getValue());
        AudioAttachment audioAttachment = new AudioAttachment();
        audioAttachment.setPath(file.getPath());
        audioAttachment.setSize(file.length());
        if (l2 > 0L && l2 < 1000L) {
            l2 = 1000L;
        }
        audioAttachment.setDuration(l2);
        audioAttachment.setExtension(r.a(file.getName()));
        audioAttachment.setNosTokenSceneKey(string3);
        c2.setAttachment(audioAttachment);
        return c2;
    }

    public static IMMessage createLocationMessage(String string2, SessionTypeEnum sessionTypeEnum, double d2, double d3, String string3) {
        com.netease.nimlib.p.c c2 = MessageBuilder.initSendMessage(string2, sessionTypeEnum);
        c2.a(MsgTypeEnum.location.getValue());
        LocationAttachment locationAttachment = new LocationAttachment();
        locationAttachment.setLatitude(d2);
        locationAttachment.setLongitude(d3);
        locationAttachment.setAddress(string3);
        c2.setAttachStatus(AttachStatusEnum.transferred);
        c2.setAttachment(locationAttachment);
        return c2;
    }

    public static IMMessage createVideoMessage(String string2, SessionTypeEnum sessionTypeEnum, File file, long l2, int n2, int n3, String string3) {
        return MessageBuilder.createVideoMessage(string2, sessionTypeEnum, file, l2, n2, n3, string3, "nim_default_im");
    }

    public static IMMessage createVideoMessage(String string2, SessionTypeEnum sessionTypeEnum, File file, long l2, int n2, int n3, String string3, String string4) {
        com.netease.nimlib.p.c c2 = MessageBuilder.initSendMessage(string2, sessionTypeEnum);
        c2.a(MsgTypeEnum.video.getValue());
        VideoAttachment videoAttachment = new VideoAttachment();
        videoAttachment.setPath(file.getPath());
        videoAttachment.setSize(file.length());
        videoAttachment.setDuration(l2);
        videoAttachment.setWidth(n2);
        videoAttachment.setHeight(n3);
        videoAttachment.setDisplayName(string3);
        videoAttachment.setExtension(r.a(file.getName()));
        videoAttachment.setNosTokenSceneKey(string4);
        c2.setAttachment(videoAttachment);
        b.a(file.getPath(), videoAttachment.getThumbPathForSave());
        return c2;
    }

    public static IMMessage createFileMessage(String string2, SessionTypeEnum sessionTypeEnum, File file, String string3) {
        return MessageBuilder.createFileMessage(string2, sessionTypeEnum, file, string3, "nim_default_im");
    }

    public static IMMessage createFileMessage(String string2, SessionTypeEnum sessionTypeEnum, File file, String string3, String string4) {
        com.netease.nimlib.p.c c2 = MessageBuilder.initSendMessage(string2, sessionTypeEnum);
        c2.a(MsgTypeEnum.file.getValue());
        FileAttachment fileAttachment = new FileAttachment();
        fileAttachment.setPath(file.getPath());
        fileAttachment.setSize(file.length());
        fileAttachment.setDisplayName(string3);
        fileAttachment.setExtension(r.a(file.getName()));
        fileAttachment.setNosTokenSceneKey(string4);
        c2.setAttachment(fileAttachment);
        return c2;
    }

    public static IMMessage createTipMessage(String string2, SessionTypeEnum sessionTypeEnum) {
        com.netease.nimlib.p.c c2 = MessageBuilder.initSendMessage(string2, sessionTypeEnum);
        c2.a(MsgTypeEnum.tip.getValue());
        return c2;
    }

    public static IMMessage createCustomMessage(String string2, SessionTypeEnum sessionTypeEnum, MsgAttachment msgAttachment) {
        return MessageBuilder.createCustomMessage(string2, sessionTypeEnum, null, msgAttachment, null);
    }

    public static IMMessage createCustomMessage(String string2, SessionTypeEnum sessionTypeEnum, String string3, MsgAttachment msgAttachment) {
        return MessageBuilder.createCustomMessage(string2, sessionTypeEnum, string3, msgAttachment, null);
    }

    public static IMMessage createCustomMessage(String string2, SessionTypeEnum sessionTypeEnum, String string3, MsgAttachment msgAttachment, CustomMessageConfig customMessageConfig) {
        return MessageBuilder.createCustomMessage(string2, sessionTypeEnum, string3, msgAttachment, customMessageConfig, "nim_default_im");
    }

    public static IMMessage createCustomMessage(String string2, SessionTypeEnum sessionTypeEnum, String string3, MsgAttachment msgAttachment, CustomMessageConfig customMessageConfig, String string4) {
        com.netease.nimlib.p.c c2 = MessageBuilder.initSendMessage(string2, sessionTypeEnum);
        c2.a(MsgTypeEnum.custom.getValue());
        c2.setContent(string3);
        if (msgAttachment != null && msgAttachment instanceof FileAttachment) {
            ((FileAttachment)msgAttachment).setNosTokenSceneKey(string4);
        }
        c2.setAttachment(msgAttachment);
        c2.setConfig(customMessageConfig);
        return c2;
    }

    public static IMMessage createRobotMessage(String string2, SessionTypeEnum sessionTypeEnum, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (TextUtils.isEmpty((CharSequence)string5) || TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("Invalid param, type and robot account should not be null");
        }
        if (string5.equals("01") && string6 == null) {
            throw new IllegalArgumentException("Invalid param, content should not be null");
        }
        if (string5.equals("03") && TextUtils.isEmpty((CharSequence)string7)) {
            throw new IllegalArgumentException("Invalid param, target should not be null");
        }
        com.netease.nimlib.p.c c2 = MessageBuilder.initSendMessage(string2, sessionTypeEnum);
        c2.a(MsgTypeEnum.robot.getValue());
        RobotAttachment robotAttachment = new RobotAttachment();
        robotAttachment.initSend(string3, string5, string6, string7, string8);
        c2.setAttachment(robotAttachment);
        c2.setContent(string4);
        return c2;
    }

    public static IMMessage createEmptyMessage(String string2, SessionTypeEnum sessionTypeEnum, long l2) {
        com.netease.nimlib.p.c c2 = new com.netease.nimlib.p.c();
        c2.b(string2);
        c2.a(sessionTypeEnum);
        c2.b(l2);
        return c2;
    }

    public static IMMessage createForwardMessage(IMMessage iMMessage, String string2, SessionTypeEnum sessionTypeEnum) {
        if (iMMessage.getMsgType() == MsgTypeEnum.notification || iMMessage.getMsgType() == MsgTypeEnum.avchat || iMMessage.getMsgType() == MsgTypeEnum.robot) {
            return null;
        }
        com.netease.nimlib.p.c c2 = ((com.netease.nimlib.p.c)iMMessage).j();
        if (c2 != null) {
            FileAttachment fileAttachment;
            c2.b(string2);
            c2.a(sessionTypeEnum);
            c2.a(r.b());
            c2.setFromAccount(c.k());
            c2.setDirect(MsgDirectionEnum.Out);
            c2.setStatus(MsgStatusEnum.sending);
            c2.b(t.a());
            c2.c(0L);
            c2.a(0L);
            c2.b(false);
            c2.c(false);
            c2.b(0);
            c2.c(0);
            MsgAttachment msgAttachment = c2.getAttachment();
            if (msgAttachment != null && msgAttachment instanceof FileAttachment && !TextUtils.isEmpty((CharSequence)(fileAttachment = (FileAttachment)msgAttachment).getUrl())) {
                c2.setAttachStatus(AttachStatusEnum.def);
            }
        }
        return c2;
    }

    private static com.netease.nimlib.p.c initSendMessage(String string2, SessionTypeEnum sessionTypeEnum) {
        com.netease.nimlib.p.c c2 = new com.netease.nimlib.p.c();
        c2.a(r.b());
        c2.b(string2);
        c2.setFromAccount(c.k());
        c2.setDirect(MsgDirectionEnum.Out);
        c2.setStatus(MsgStatusEnum.sending);
        c2.a(sessionTypeEnum);
        c2.b(t.a());
        return c2;
    }

    public static String createForwardMessageListFileDetail(List<? extends IMMessage> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        String string2 = list.get(0).getSessionId();
        if (string2 == null) {
            return "";
        }
        ArrayList<IMMessage> arrayList = new ArrayList<IMMessage>(list.size());
        for (IMMessage iMMessage : list) {
            if (!string2.equals(iMMessage.getSessionId()) || iMMessage.getMsgType() == MsgTypeEnum.notification || iMMessage.getMsgType() == MsgTypeEnum.avchat || iMMessage.getMsgType() == MsgTypeEnum.robot) continue;
            arrayList.add(iMMessage);
        }
        return MessageBuilder.buildHeader(0, arrayList.size()) + "\n" + MessageBuilder.buildBody(arrayList);
    }

    private static String buildHeader(int n2, int n3) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("version", n2);
            jSONObject.put("terminal", 1);
            jSONObject.put("sdk_version", (Object)"7.8.1");
            jSONObject.put("app_version", 121);
            jSONObject.put("message_count", n3);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    private static String buildBody(List<IMMessage> list) {
        String string2 = "\n";
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IMMessage iMMessage : list) {
            stringBuilder.append(string2).append(a.a(iMMessage));
        }
        return stringBuilder.substring(string2.length());
    }

    public static IMMessage createFromJson(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        return a.a(string2);
    }

    public static String convertMessageToJson(IMMessage iMMessage) {
        if (iMMessage == null) {
            return null;
        }
        return a.a(iMMessage);
    }
}

