/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;

public final class NIMUtil {
    private NIMUtil() {
    }

    public static boolean isMainProcess(Context context) {
        if (context == null) {
            return false;
        }
        String string2 = context.getApplicationContext().getPackageName();
        String string3 = NIMUtil.getProcessName(context);
        return string2.equals(string3);
    }

    public static String getProcessName(Context context) {
        String string2 = NIMUtil.getProcessFromFile();
        if (string2 == null) {
            string2 = NIMUtil.getProcessNameByAM(context);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessFromFile() {
        BufferedReader bufferedReader = null;
        try {
            int n2;
            int n3 = Process.myPid();
            String string2 = "/proc/" + n3 + "/cmdline";
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "iso-8859-1"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((n2 = bufferedReader.read()) > 0) {
                stringBuilder.append((char)n2);
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        catch (Exception exception) {
            String string4 = null;
            return string4;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static String getProcessNameByAM(Context context) {
        String string2 = null;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager == null) {
            return null;
        }
        while (true) {
            List list;
            if ((list = activityManager.getRunningAppProcesses()) != null) {
                for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                    if (runningAppProcessInfo.pid != Process.myPid()) continue;
                    string2 = runningAppProcessInfo.processName;
                    break;
                }
            }
            if (!TextUtils.isEmpty(string2)) {
                return string2;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static boolean isMainProcessLive(Context context) {
        List list;
        if (context == null) {
            return false;
        }
        String string2 = context.getPackageName();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null && (list = activityManager.getRunningAppProcesses()) != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (!runningAppProcessInfo.processName.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

