/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.highavailable;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.netease.nim.highavailable.HighAvailableCallback;
import com.netease.nim.highavailable.HighAvailableNativeCallback;
import com.netease.nim.highavailable.LogUtils;
import java.util.LinkedList;
import java.util.List;

public class HighAvailable {
    private static final String TAG = "high_available";
    private static boolean isLoadLibSuccess = false;
    private boolean isInitSuccess = false;
    private HighAvailableCallback highAvailableCallback;
    private HighAvailableNativeCallback nativeCallback = new HighAvailableNativeCallback(){

        @Override
        public String getAccid() {
            return HighAvailable.this.highAvailableCallback.getAccid();
        }

        @Override
        public void reportError(int n2, String string, String string2, String string3) {
            HighAvailable.this.highAvailableCallback.reportError(n2, string, string2, string3);
        }

        @Override
        public void onLog(String string) {
            HighAvailable.this.highAvailableCallback.onLog(string);
        }
    };
    private static final int LBS_ADDR_LENGTH = 512;
    private static final int LBS_BACKUP_ADDR_COUNT = 5;
    private static final int LINK_ADDR_LENGTH = 128;
    private static final int LINK_ADDR_COUNT = 10;
    private static final int LINK_IPV6_ADDR_LENGTH = 128;

    public static boolean isLoadLibSuccess() {
        return isLoadLibSuccess;
    }

    public boolean isInitSuccess() {
        return this.isInitSuccess;
    }

    private boolean startHighAvailableEnvironment(HighAvailableEnvironmentSettings highAvailableEnvironmentSettings) {
        boolean bl = this.nativeStartHighAvailableEnvironment(highAvailableEnvironmentSettings.enableHttpDns, highAvailableEnvironmentSettings.businessType, highAvailableEnvironmentSettings.businessToken, highAvailableEnvironmentSettings.businessPublicVersion, highAvailableEnvironmentSettings.internalVersion, highAvailableEnvironmentSettings.protocolVersion, highAvailableEnvironmentSettings.clientType, highAvailableEnvironmentSettings.appdataPath, highAvailableEnvironmentSettings.logPath, this.nativeCallback);
        LogUtils.i(TAG, String.format("startHighAvailableEnvironment %s", bl));
        return bl;
    }

    private HighAvailableLBSSettings fixSettings(HighAvailableLBSSettings highAvailableLBSSettings) {
        HighAvailableLBSSettings highAvailableLBSSettings2 = new HighAvailableLBSSettings();
        highAvailableLBSSettings2.usingPrivate = highAvailableLBSSettings.usingPrivate;
        if (TextUtils.isEmpty((CharSequence)highAvailableLBSSettings.lbsMain)) {
            throw new IllegalArgumentException("lbsMain is empty");
        }
        if (highAvailableLBSSettings.lbsMain.length() > 512) {
            throw new IllegalArgumentException(String.format("lbsMain %s is too long", highAvailableLBSSettings.lbsMain));
        }
        highAvailableLBSSettings2.lbsMain = highAvailableLBSSettings.lbsMain;
        highAvailableLBSSettings2.lbsBackup = new LinkedList();
        if (highAvailableLBSSettings.lbsBackup != null) {
            for (String string : highAvailableLBSSettings.lbsBackup) {
                if (TextUtils.isEmpty((CharSequence)string) || string.length() > 512) continue;
                highAvailableLBSSettings2.lbsBackup.add(string);
                if (highAvailableLBSSettings2.lbsBackup.size() < 5) continue;
                break;
            }
        }
        if (TextUtils.isEmpty((CharSequence)highAvailableLBSSettings.defaultLink)) {
            throw new IllegalArgumentException("defaultLink is empty");
        }
        if (highAvailableLBSSettings.defaultLink.length() > 128) {
            throw new IllegalArgumentException(String.format("defaultLink %s is too long", highAvailableLBSSettings.defaultLink));
        }
        highAvailableLBSSettings2.defaultLink = highAvailableLBSSettings.defaultLink;
        if (highAvailableLBSSettings.defaultLinkIpv6.length() > 128) {
            throw new IllegalArgumentException(String.format("defaultLinkIpv6 %s is too long", highAvailableLBSSettings.defaultLinkIpv6));
        }
        highAvailableLBSSettings2.defaultLinkIpv6 = highAvailableLBSSettings.defaultLinkIpv6;
        highAvailableLBSSettings2.linkList = new LinkedList();
        if (highAvailableLBSSettings.linkList != null) {
            for (String string : highAvailableLBSSettings.linkList) {
                if (TextUtils.isEmpty((CharSequence)string) || string.length() > 128) continue;
                highAvailableLBSSettings2.linkList.add(string);
                if (highAvailableLBSSettings2.linkList.size() < 10) continue;
                break;
            }
        }
        if (highAvailableLBSSettings.addressFamily == null) {
            throw new IllegalArgumentException("addressFamily is null");
        }
        highAvailableLBSSettings2.addressFamily = highAvailableLBSSettings.addressFamily;
        return highAvailableLBSSettings2;
    }

    private void init(HighAvailableEnvironmentSettings highAvailableEnvironmentSettings, HighAvailableLBSSettings highAvailableLBSSettings, HighAvailableCallback highAvailableCallback) {
        this.highAvailableCallback = highAvailableCallback;
        this.isInitSuccess = this.startHighAvailableEnvironment(highAvailableEnvironmentSettings);
        if (!this.isInitSuccess) {
            return;
        }
        this.isInitSuccess = this.initLbs(highAvailableLBSSettings);
    }

    private boolean initLbs(HighAvailableLBSSettings highAvailableLBSSettings) {
        HighAvailableLBSSettings highAvailableLBSSettings2 = this.fixSettings(highAvailableLBSSettings);
        String[] stringArray = new String[highAvailableLBSSettings2.lbsBackup.size()];
        highAvailableLBSSettings2.lbsBackup.toArray(stringArray);
        String[] stringArray2 = new String[highAvailableLBSSettings2.linkList.size()];
        highAvailableLBSSettings2.linkList.toArray(stringArray2);
        boolean bl = this.nativeInit(highAvailableLBSSettings2.usingPrivate, highAvailableLBSSettings2.lbsMain, stringArray, highAvailableLBSSettings2.defaultLink, highAvailableLBSSettings2.defaultLinkIpv6, stringArray2, highAvailableLBSSettings2.addressFamily.ordinal());
        LogUtils.i(TAG, String.format("init %s", bl));
        return bl;
    }

    public HighAvailable(HighAvailableEnvironmentSettings highAvailableEnvironmentSettings, HighAvailableLBSSettings highAvailableLBSSettings, HighAvailableCallback highAvailableCallback) {
        this.init(highAvailableEnvironmentSettings, highAvailableLBSSettings, highAvailableCallback);
    }

    public void releaseLBSService() {
        this.nativeReleaseLBSService();
    }

    public void exit() {
        this.nativeExitHighAvailableEnvironment();
    }

    public void updateAppKey(String string) {
        this.nativeUpdateBusinessToken(string);
    }

    public HighAvailableAddress getLinkAddress(AddressFamily addressFamily) {
        HighAvailableAddress highAvailableAddress = new HighAvailableAddress();
        boolean bl = this.nativeGetLinkAddress(addressFamily.ordinal(), highAvailableAddress);
        LogUtils.i(TAG, String.format("nativeGetLinkAddress %s", bl));
        return highAvailableAddress;
    }

    public HighAvailableAddress getCurrentLinkAddress() {
        HighAvailableAddress highAvailableAddress = new HighAvailableAddress();
        boolean bl = this.nativeGetCurrentLinkAddress(highAvailableAddress);
        LogUtils.i(TAG, String.format("getCurrentLinkAddress %s", bl));
        return highAvailableAddress;
    }

    public void onCurrentLinkConnectSucceed(String string, int n2) {
        this.nativeOnCurrentLinkConnectSucceed(string, n2);
    }

    public int getLinkCount() {
        return this.nativeGetLinkCount();
    }

    public String getLBSResponse() {
        return this.nativeGetLBSResponse();
    }

    public void update(AddressFamily addressFamily) {
        this.nativeUpdate(addressFamily.ordinal());
    }

    public void setNetworkChanged(AddressFamily addressFamily) {
        this.nativeSetNetworkChanged(addressFamily.ordinal());
    }

    private native boolean nativeStartHighAvailableEnvironment(int var1, String var2, String var3, String var4, int var5, int var6, int var7, String var8, String var9, HighAvailableNativeCallback var10);

    private native void nativeExitHighAvailableEnvironment();

    private native boolean nativeInit(boolean var1, String var2, String[] var3, String var4, String var5, String[] var6, int var7);

    private native void nativeReleaseLBSService();

    private native void nativeUpdateBusinessToken(String var1);

    private native boolean nativeGetLinkAddress(int var1, HighAvailableAddress var2);

    private native boolean nativeGetCurrentLinkAddress(HighAvailableAddress var1);

    private native void nativeOnCurrentLinkConnectSucceed(String var1, int var2);

    private native int nativeGetLinkCount();

    private native String nativeGetLBSResponse();

    private native void nativeUpdate(int var1);

    private native void nativeSetNetworkChanged(int var1);

    private native void nativeGetMessageDelayStaticsInfo(MessageDelayStaticsInfo var1);

    static {
        try {
            System.loadLibrary("high_available_android");
            isLoadLibSuccess = true;
        }
        catch (Throwable throwable) {
            isLoadLibSuccess = false;
            LogUtils.e(TAG, "load library high_available_android failed", throwable);
        }
    }

    public static class HighAvailableUploadTag {
        private String name;
        private long ttl;

        public HighAvailableUploadTag(String string, long l2) {
            this.name = string;
            this.ttl = l2;
        }
    }

    public static class MessageDelayStaticsInfo {
        private boolean enable;
        private String host;
        private String api;
        private String desc;

        public boolean isEnable() {
            return this.enable;
        }

        public String getHost() {
            return this.host;
        }

        public String getApi() {
            return this.api;
        }

        public String getDesc() {
            return this.desc;
        }

        public String toString() {
            return "MessageDelayStaticsInfo{enable=" + this.enable + ", host='" + this.host + '\'' + ", api='" + this.api + '\'' + ", desc='" + this.desc + '\'' + '}';
        }
    }

    public static class HighAvailableAddress {
        private String ip;
        private int port;
        private int addressFamily;

        public String toString() {
            return "HighAvailableAddress{ip='" + this.ip + '\'' + ", port=" + this.port + ", addressFamily=" + (Object)((Object)this.getAddressFamily()) + '}';
        }

        public void setAddressFamily(int n2) {
            this.addressFamily = n2;
        }

        public String getIp() {
            return this.ip;
        }

        public int getPort() {
            return this.port;
        }

        public AddressFamily getAddressFamily() {
            return AddressFamily.getAddressFamily(this.addressFamily);
        }
    }

    public static enum AddressFamily {
        kUnknown,
        kIPV4,
        kIPV6;


        public static AddressFamily getAddressFamily(int n2) {
            for (AddressFamily addressFamily : AddressFamily.values()) {
                if (addressFamily.ordinal() != n2) continue;
                return addressFamily;
            }
            return kUnknown;
        }
    }

    public static class HighAvailableLBSSettings {
        private boolean usingPrivate;
        private String lbsMain;
        private List<String> lbsBackup;
        private String defaultLink;
        private String defaultLinkIpv6;
        private List<String> linkList;
        private AddressFamily addressFamily;

        private HighAvailableLBSSettings() {
            this(false, "", "", AddressFamily.kIPV4);
        }

        public HighAvailableLBSSettings(boolean bl, String string, String string2, @NonNull AddressFamily addressFamily) {
            this(bl, string, null, string2, "", null, addressFamily);
        }

        public HighAvailableLBSSettings(boolean bl, String string, List<String> list, String string2, String string3, List<String> list2, @NonNull AddressFamily addressFamily) {
            this.usingPrivate = bl;
            this.lbsMain = string;
            this.lbsBackup = list;
            this.defaultLink = string2;
            this.defaultLinkIpv6 = string3;
            this.linkList = list2;
            this.addressFamily = addressFamily;
        }
    }

    public static class HighAvailableEnvironmentSettings {
        private static final int BUSINESS_TYPE_LENGTH = 32;
        private static final int BUSINESS_TOKEN_LENGTH = 128;
        private static final int BUSINESS_PUBLIC_VERSION_LENGTH = 128;
        private static final int DATA_PATH_LENGTH = 1024;
        private static final int LOG_PATH_LENGTH = 1024;
        private final int enableHttpDns;
        private final String businessType;
        private final String businessToken;
        private final String businessPublicVersion;
        private final int internalVersion;
        private final int protocolVersion;
        private final int clientType;
        private final String appdataPath;
        private final String logPath;

        public HighAvailableEnvironmentSettings(int n2, String string, String string2, String string3, int n3, int n4, int n5, String string4, String string5) {
            if (string == null || string.length() > 32) {
                throw new IllegalArgumentException("businessType length invalid: " + string);
            }
            if (string2 == null || string2.length() > 128) {
                throw new IllegalArgumentException("businessToken length invalid: " + string2);
            }
            if (string3 == null || string3.length() > 128) {
                throw new IllegalArgumentException("businessPublicVersion length invalid: " + string3);
            }
            if (string4 == null || string4.length() > 1024) {
                throw new IllegalArgumentException("appdataPath length invalid: " + string4);
            }
            if (string4 == null || string4.length() > 1024) {
                throw new IllegalArgumentException("logPath length invalid: " + string5);
            }
            this.enableHttpDns = n2;
            this.businessType = string;
            this.businessToken = string2;
            this.businessPublicVersion = string3;
            this.internalVersion = n3;
            this.protocolVersion = n4;
            this.clientType = n5;
            this.appdataPath = string4;
            this.logPath = string5;
        }

        public static interface HttpDnsState {
            public static final int DISABLE = -1;
            public static final int UNDEFINE = 0;
            public static final int ENABLE = 1;
        }
    }
}

