/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.highavailable.lava.base.http;

import android.annotation.SuppressLint;
import android.util.Log;
import com.netease.nim.highavailable.lava.base.annotation.CalledByNative;
import com.netease.nim.highavailable.lava.base.annotation.Keep;
import com.netease.nim.highavailable.lava.base.http.HttpHeaderPair;
import com.netease.nim.highavailable.lava.base.http.HttpStackResponse;
import com.netease.nim.highavailable.lava.base.http.MultipartWriter;
import com.netease.nim.highavailable.lava.base.http.TlsSniSocketFactory;
import com.netease.nim.highavailable.lava.base.util.ArrayUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONObject;

public class HttpStack {
    private static final String TAG = "HttpStack";

    private static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static HttpURLConnection createConnection(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setInstanceFollowRedirects(HttpURLConnection.getFollowRedirects());
        return httpURLConnection;
    }

    private static HttpURLConnection openConnection(URL uRL, String string, Map<String, String> map, byte[] byArray, int n2) throws IOException {
        HttpURLConnection httpURLConnection = HttpStack.createConnection(uRL);
        httpURLConnection.setRequestMethod(string);
        httpURLConnection.setConnectTimeout(n2);
        httpURLConnection.setReadTimeout(n2);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoInput(true);
        HttpStack.configHttps(httpURLConnection);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (!ArrayUtils.isEmpty(byArray)) {
            httpURLConnection.setDoOutput(true);
            Object object = httpURLConnection.getOutputStream();
            if (map != null && "gzip".equals(map.get("Content-Encoding"))) {
                object = new GZIPOutputStream(new BufferedOutputStream((OutputStream)object));
            }
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).flush();
            HttpStack.closeQuietly((Closeable)object);
        }
        return httpURLConnection;
    }

    private static HttpURLConnection openConnection(URL uRL, String string, Map<String, String> map, int n2) throws IOException {
        HttpURLConnection httpURLConnection = HttpStack.createConnection(uRL);
        httpURLConnection.setRequestMethod(string);
        httpURLConnection.setConnectTimeout(n2);
        httpURLConnection.setReadTimeout(n2);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoInput(true);
        HttpStack.configHttps(httpURLConnection);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return httpURLConnection;
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doPost(String string) {
        return HttpStack.doPost(string, null, null, 3000);
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doPost(String string, int n2) {
        return HttpStack.doPost(string, null, null, n2);
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doPost(String string, Map<String, String> map, byte[] byArray, int n2, String string2, String string3) {
        return HttpStack.doHttpMethod(string, map, byArray, n2, string2, string3, "POST");
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doGet(String string, Map<String, String> map, int n2, String string2, String string3) {
        return HttpStack.doHttpMethod(string, map, null, n2, string2, string3, "PGET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpStackResponse doHttpMethod(String string, Map<String, String> map, byte[] byArray, int n2, String string2, String string3, String string4) {
        Object object;
        HttpURLConnection httpURLConnection = null;
        if (string == null || string.isEmpty() || string3 == null || string3.isEmpty()) {
            Log.e((String)TAG, (String)("illegal argument, path:" + string + ", ip:" + string2 + ", host:" + string3));
            return null;
        }
        try {
            int n3;
            URL uRL = new URL(string);
            if (!"https".equals(uRL.getProtocol())) {
                Log.e((String)TAG, (String)("doPost failed, " + uRL.getProtocol() + " is not https"));
                HttpStackResponse httpStackResponse = null;
                return httpStackResponse;
            }
            if (string2 != null && !string2.isEmpty()) {
                Log.d((String)TAG, (String)("replace host:" + uRL.getHost() + " to ip:" + string2));
                object = string.replaceFirst(uRL.getHost(), string2);
                httpURLConnection = (HttpsURLConnection)new URL((String)object).openConnection();
            }
            httpURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Host", string3);
            httpURLConnection.setRequestMethod(string4);
            httpURLConnection.setConnectTimeout(n2);
            httpURLConnection.setReadTimeout(n2);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setInstanceFollowRedirects(false);
            if (map != null) {
                for (Map.Entry object22 : map.entrySet()) {
                    httpURLConnection.setRequestProperty((String)object22.getKey(), (String)object22.getValue());
                }
            }
            object = new TlsSniSocketFactory((HttpsURLConnection)httpURLConnection);
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory((SSLSocketFactory)object);
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(new HostnameVerifier((HttpsURLConnection)httpURLConnection2){
                final /* synthetic */ HttpsURLConnection val$finalConnection;
                {
                    this.val$finalConnection = httpsURLConnection;
                }

                @Override
                @SuppressLint(value={"BadHostnameVerifier"})
                public boolean verify(String string, SSLSession sSLSession) {
                    boolean bl;
                    String string2 = this.val$finalConnection.getRequestProperty("Host");
                    if (null == string2) {
                        string2 = this.val$finalConnection.getURL().getHost();
                    }
                    if (!(bl = HttpsURLConnection.getDefaultHostnameVerifier().verify(string2, sSLSession))) {
                        Log.w((String)HttpStack.TAG, (String)"host name verify failed");
                    }
                    return bl;
                }
            });
            if (!ArrayUtils.isEmpty(byArray)) {
                httpURLConnection.setDoOutput(true);
                OutputStream n32 = httpURLConnection.getOutputStream();
                if (map != null && "gzip".equals(map.get("Content-Encoding"))) {
                    n32 = new GZIPOutputStream(new BufferedOutputStream(n32));
                }
                n32.write(byArray);
                n32.flush();
                HttpStack.closeQuietly(n32);
            }
            if (HttpStack.needRedirect(n3 = httpURLConnection.getResponseCode())) {
                Object object2;
                String l2 = httpURLConnection.getHeaderField("Location");
                if (l2 == null) {
                    l2 = httpURLConnection.getHeaderField("location");
                }
                if (!l2.startsWith("http://") && !l2.startsWith("https://")) {
                    object2 = new URL(string);
                    l2 = ((URL)object2).getProtocol() + "://" + ((URL)object2).getHost() + l2;
                }
                object2 = HttpStack.doPost(l2, map, byArray, n2, null, string3);
                return object2;
            }
            long l2 = httpURLConnection.getLastModified();
            String string5 = HttpStack.readFully(httpURLConnection.getInputStream());
            HttpStackResponse httpStackResponse = new HttpStackResponse();
            httpStackResponse.code = n3;
            httpStackResponse.result = string5;
            httpStackResponse.lastModified = l2;
            Map<String, List<String>> map2 = httpURLConnection.getHeaderFields();
            Set<String> set = map2.keySet();
            JSONObject jSONObject = new JSONObject();
            for (String string6 : set) {
                String string7 = httpURLConnection.getHeaderField(string6);
                jSONObject.put(string6 != null ? string6 : "httpversion", (Object)string7);
            }
            httpStackResponse.headers = jSONObject.toString();
            Log.d((String)TAG, (String)("doPost: response:" + httpStackResponse));
            HttpStackResponse httpStackResponse2 = httpStackResponse;
            return httpStackResponse2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = null;
            return object;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    @CalledByNative
    public static HttpStackResponse doPost(String string, Map<String, String> map, byte[] byArray, int n2) {
        HttpStackResponse httpStackResponse = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = HttpStack.openConnection(uRL, "POST", map, byArray, n2);
            int n3 = httpURLConnection.getResponseCode();
            long l2 = httpURLConnection.getLastModified();
            String string2 = HttpStack.readFully(httpURLConnection.getInputStream());
            httpStackResponse = new HttpStackResponse();
            httpStackResponse.code = n3;
            httpStackResponse.result = string2;
            httpStackResponse.lastModified = l2;
            Map<String, List<String>> map2 = httpURLConnection.getHeaderFields();
            Set<String> set = map2.keySet();
            JSONObject jSONObject = new JSONObject();
            for (String string3 : set) {
                String string4 = httpURLConnection.getHeaderField(string3);
                jSONObject.put(string3 != null ? string3 : "httpversion", (Object)string4);
            }
            httpStackResponse.headers = jSONObject.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return httpStackResponse;
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doPostHeaders(String string, HttpHeaderPair[] httpHeaderPairArray, byte[] byArray, int n2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < httpHeaderPairArray.length; ++i2) {
            HttpHeaderPair httpHeaderPair = httpHeaderPairArray[i2];
            hashMap.put(httpHeaderPair.getKey(), httpHeaderPair.getValue());
        }
        return HttpStack.doPost(string, hashMap, byArray, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpStackResponse multipartPost(String string, String string2, String string3, Map<String, String> map, MultipartWriter multipartWriter) {
        HttpStackResponse httpStackResponse = null;
        OutputStream outputStream = null;
        PrintWriter printWriter = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = HttpStack.openConnection(uRL, "POST", map, 3000);
            httpURLConnection.setDoOutput(true);
            outputStream = httpURLConnection.getOutputStream();
            printWriter = map != null && "gzip".equals(map.get("Content-Encoding")) ? new PrintWriter(new GZIPOutputStream(outputStream)) : new PrintWriter(outputStream);
            multipartWriter.addPart(printWriter, outputStream);
            printWriter.append(string3);
            printWriter.append("--").append(string2).append("--").append(string3);
            printWriter.flush();
            int n2 = httpURLConnection.getResponseCode();
            long l2 = httpURLConnection.getLastModified();
            String string4 = HttpStack.readFully(httpURLConnection.getInputStream());
            httpStackResponse = new HttpStackResponse();
            httpStackResponse.code = n2;
            httpStackResponse.result = string4;
            httpStackResponse.lastModified = l2;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return httpStackResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFully(InputStream inputStream) throws IOException {
        String string;
        if (inputStream == null) {
            return "";
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            int n2;
            bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = bufferedInputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            string = byteArrayOutputStream.toString();
        }
        catch (Throwable throwable) {
            HttpStack.closeQuietly(bufferedInputStream);
            throw throwable;
        }
        HttpStack.closeQuietly(bufferedInputStream);
        return string;
    }

    private static void configHttps(HttpURLConnection httpURLConnection) {
        if (httpURLConnection != null && httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, null, null);
                httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
                HostnameVerifier hostnameVerifier = (string, sSLSession) -> true;
                httpsURLConnection.setHostnameVerifier(hostnameVerifier);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static boolean needRedirect(int n2) {
        return n2 >= 300 && n2 < 400;
    }
}

