/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.highavailable.lava.base.util;

public class ArrayUtils {
    private static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final int INDEX_NOT_FOUND = -1;

    private ArrayUtils() {
    }

    public static Integer[] toObject(int[] nArray) {
        if (ArrayUtils.isEmpty(nArray)) {
            return null;
        }
        if (nArray.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] integerArray = new Integer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            integerArray[i2] = nArray[i2];
        }
        return integerArray;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        return ArrayUtils.indexOf(objectArray, object) != -1;
    }

    public static boolean contains(long[] lArray, long l2) {
        return ArrayUtils.indexOf(lArray, l2) != -1;
    }

    public static boolean contains(int[] nArray, int n2) {
        return ArrayUtils.indexOf(nArray, n2) != -1;
    }

    public static int indexOf(Object[] objectArray, Object object, int n2) {
        if (ArrayUtils.isEmpty(objectArray)) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (object == null) {
            for (int i2 = n2; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 < objectArray.length; ++i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        return ArrayUtils.indexOf(objectArray, object, 0);
    }

    public static int indexOf(long[] lArray, long l2, int n2) {
        if (ArrayUtils.isEmpty(lArray)) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i2 = n2; i2 < lArray.length; ++i2) {
            if (l2 != lArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(long[] lArray, long l2) {
        return ArrayUtils.indexOf(lArray, l2, 0);
    }

    public static int indexOf(int[] nArray, int n2) {
        return ArrayUtils.indexOf(nArray, n2, 0);
    }

    public static int indexOf(int[] nArray, int n2, int n3) {
        if (ArrayUtils.isEmpty(nArray)) {
            return -1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        for (int i2 = n3; i2 < nArray.length; ++i2) {
            if (n2 != nArray[i2]) continue;
            return i2;
        }
        return -1;
    }

    public static <T> boolean nonNullElements(T[] TArray) {
        int n2 = ArrayUtils.getLength(TArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (TArray[i2] != null) continue;
            return false;
        }
        return n2 > 0;
    }

    public static boolean isEmpty(Object[] objectArray) {
        return ArrayUtils.getLength(objectArray) == 0;
    }

    public static boolean isEmpty(long[] lArray) {
        return ArrayUtils.getLength(lArray) == 0;
    }

    public static boolean isEmpty(int[] nArray) {
        return ArrayUtils.getLength(nArray) == 0;
    }

    public static boolean isEmpty(short[] sArray) {
        return ArrayUtils.getLength(sArray) == 0;
    }

    public static boolean isEmpty(char[] cArray) {
        return ArrayUtils.getLength(cArray) == 0;
    }

    public static boolean isEmpty(byte[] byArray) {
        return ArrayUtils.getLength(byArray) == 0;
    }

    public static boolean isEmpty(double[] dArray) {
        return ArrayUtils.getLength(dArray) == 0;
    }

    public static boolean isEmpty(float[] fArray) {
        return ArrayUtils.getLength(fArray) == 0;
    }

    public static boolean isEmpty(boolean[] blArray) {
        return ArrayUtils.getLength(blArray) == 0;
    }

    public static int getLength(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length;
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).length;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length;
        }
        if (object instanceof char[]) {
            return ((char[])object).length;
        }
        if (object instanceof double[]) {
            return ((double[])object).length;
        }
        if (object instanceof float[]) {
            return ((float[])object).length;
        }
        if (object instanceof int[]) {
            return ((int[])object).length;
        }
        if (object instanceof long[]) {
            return ((long[])object).length;
        }
        if (object instanceof short[]) {
            return ((short[])object).length;
        }
        throw ArrayUtils.badArray(object);
    }

    private static RuntimeException badArray(Object object) {
        if (object == null) {
            throw new NullPointerException("array == null");
        }
        if (!object.getClass().isArray()) {
            throw ArrayUtils.notAnArray(object);
        }
        throw ArrayUtils.incompatibleType(object);
    }

    private static IllegalArgumentException notAnArray(Object object) {
        throw new IllegalArgumentException("Not an array: " + object.getClass());
    }

    private static IllegalArgumentException incompatibleType(Object object) {
        throw new IllegalArgumentException("Array has incompatible type: " + object.getClass());
    }

    public static char[] toPrimitive(Character[] characterArray) {
        if (characterArray == null) {
            return null;
        }
        if (characterArray.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[characterArray.length];
        for (int i2 = 0; i2 < characterArray.length; ++i2) {
            cArray[i2] = characterArray[i2].charValue();
        }
        return cArray;
    }

    public static long[] toPrimitive(Long[] longArray) {
        if (longArray == null) {
            return null;
        }
        if (longArray.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] lArray = new long[longArray.length];
        for (int i2 = 0; i2 < longArray.length; ++i2) {
            lArray[i2] = longArray[i2];
        }
        return lArray;
    }

    public static int[] toPrimitive(Integer[] integerArray) {
        if (integerArray == null) {
            return null;
        }
        if (integerArray.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] nArray = new int[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nArray[i2] = integerArray[i2];
        }
        return nArray;
    }

    public static short[] toPrimitive(Short[] shortArray) {
        if (shortArray == null) {
            return null;
        }
        if (shortArray.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] sArray = new short[shortArray.length];
        for (int i2 = 0; i2 < shortArray.length; ++i2) {
            sArray[i2] = shortArray[i2];
        }
        return sArray;
    }

    public static byte[] toPrimitive(Byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            byArray[i2] = byteArray[i2];
        }
        return byArray;
    }

    public static double[] toPrimitive(Double[] doubleArray) {
        if (doubleArray == null) {
            return null;
        }
        if (doubleArray.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] dArray = new double[doubleArray.length];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            dArray[i2] = doubleArray[i2];
        }
        return dArray;
    }

    public static float[] toPrimitive(Float[] floatArray) {
        if (floatArray == null) {
            return null;
        }
        if (floatArray.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] fArray = new float[floatArray.length];
        for (int i2 = 0; i2 < floatArray.length; ++i2) {
            fArray[i2] = floatArray[i2].floatValue();
        }
        return fArray;
    }

    public static boolean[] toPrimitive(Boolean[] booleanArray) {
        if (booleanArray == null) {
            return null;
        }
        if (booleanArray.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[booleanArray.length];
        for (int i2 = 0; i2 < booleanArray.length; ++i2) {
            blArray[i2] = booleanArray[i2];
        }
        return blArray;
    }
}

