/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.io.Serializable;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginInfo
implements Parcelable,
Serializable {
    private static final String KEY_ACCOUNT = "KEY_ACCOUNT";
    private static final String KEY_TOKEN = "KEY_TOKEN";
    private static final String KEY_AUTH_TYPE = "KEY_AUTH_TYPE";
    private static final String KEY_LOGIN_EXT = "KEY_LOGIN_EXT";
    private static final String KEY_APP_KEY = "KEY_APP_KEY";
    private static final String KEY_CUSTOM_CLIENT_TYPE = "KEY_CUSTOM_CLIENT_TYPE";
    private final String account;
    private final String token;
    private int authType;
    private String loginExt;
    private String appKey;
    private int customClientType;
    public static final Parcelable.Creator<LoginInfo> CREATOR = new Parcelable.Creator<LoginInfo>(){

        public LoginInfo createFromParcel(Parcel parcel) {
            return new LoginInfo(parcel);
        }

        public LoginInfo[] newArray(int n2) {
            return new LoginInfo[n2];
        }
    };

    public LoginInfo(String string, String string2) {
        this.account = string == null ? null : string.toLowerCase();
        this.token = string2;
    }

    public LoginInfo(String string, String string2, String string3) {
        this(string, string2);
        this.appKey = string3;
    }

    public LoginInfo(String string, String string2, String string3, int n2) {
        this(string, string2, string3);
        this.customClientType = n2;
    }

    protected LoginInfo(Parcel parcel) {
        this.account = parcel.readString();
        this.token = parcel.readString();
        this.authType = parcel.readInt();
        this.loginExt = parcel.readString();
        this.appKey = parcel.readString();
        this.customClientType = parcel.readInt();
    }

    public String getAccount() {
        return this.account;
    }

    public String getToken() {
        return this.token;
    }

    public int getAuthType() {
        return this.authType;
    }

    public String getLoginExt() {
        return this.loginExt;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public int getCustomClientType() {
        return this.customClientType;
    }

    public boolean valid() {
        if (this.authType == 0) {
            return !TextUtils.isEmpty((CharSequence)this.account) && !TextUtils.isEmpty((CharSequence)this.token);
        }
        return !TextUtils.isEmpty((CharSequence)this.account);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LoginInfo loginInfo = (LoginInfo)object;
        return this.authType == loginInfo.authType && this.customClientType == loginInfo.customClientType && Objects.equals(this.account, loginInfo.account) && Objects.equals(this.token, loginInfo.token) && Objects.equals(this.loginExt, loginInfo.loginExt) && Objects.equals(this.appKey, loginInfo.appKey);
    }

    @NonNull
    public String toString() {
        return "LoginInfo{account='" + this.account + '\'' + ", authType=" + this.authType + ", customClientType=" + this.customClientType + '}';
    }

    public int hashCode() {
        return Objects.hash(this.account, this.token, this.authType, this.loginExt, this.appKey, this.customClientType);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.account);
        parcel.writeString(this.token);
        parcel.writeInt(this.authType);
        parcel.writeString(this.loginExt);
        parcel.writeString(this.appKey);
        parcel.writeInt(this.customClientType);
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.putOpt(KEY_ACCOUNT, (Object)this.account);
            jSONObject.putOpt(KEY_TOKEN, (Object)this.token);
            jSONObject.putOpt(KEY_AUTH_TYPE, (Object)this.authType);
            jSONObject.putOpt(KEY_LOGIN_EXT, (Object)this.loginExt);
            jSONObject.putOpt(KEY_APP_KEY, (Object)this.appKey);
            jSONObject.putOpt(KEY_CUSTOM_CLIENT_TYPE, (Object)this.customClientType);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public static LoginInfo fromJson(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        String string = jSONObject.optString(KEY_ACCOUNT, null);
        String string2 = jSONObject.optString(KEY_TOKEN, null);
        int n2 = jSONObject.optInt(KEY_AUTH_TYPE);
        String string3 = jSONObject.optString(KEY_LOGIN_EXT, null);
        String string4 = jSONObject.optString(KEY_APP_KEY, null);
        int n3 = jSONObject.optInt(KEY_CUSTOM_CLIENT_TYPE);
        return new LoginInfoBuilder(string, string2, n2, string3).withAppKey(string4).withCustomClientType(n3).build();
    }

    public static final class LoginInfoBuilder {
        private String account;
        private String token;
        private int authType;
        private String loginExt;
        private String appKey;
        private int customClientType;

        public LoginInfoBuilder(String string, String string2, int n2, String string3) {
            this.account = string;
            this.token = string2;
            this.authType = n2;
            this.loginExt = string3;
        }

        public static LoginInfoBuilder loginInfoDefault(String string, String string2) {
            return new LoginInfoBuilder(string, string2, 0, "");
        }

        public static LoginInfoBuilder loginInfoDynamic(String string, String string2) {
            return new LoginInfoBuilder(string, string2, 1, "");
        }

        public static LoginInfoBuilder loginInfoThirdParty(String string, String string2, String string3) {
            return new LoginInfoBuilder(string, string2, 2, string3);
        }

        public static LoginInfoBuilder loginInfoThirdPartyDynamic(String string, String string2) {
            return new LoginInfoBuilder(string, string2, 2, "");
        }

        public LoginInfoBuilder withAppKey(String string) {
            this.appKey = string;
            return this;
        }

        public LoginInfoBuilder withCustomClientType(int n2) {
            this.customClientType = n2;
            return this;
        }

        public LoginInfoBuilder withAuthType(int n2) {
            this.authType = n2;
            return this;
        }

        public LoginInfoBuilder withLoginExt(String string) {
            this.loginExt = string;
            return this;
        }

        public LoginInfo build() {
            LoginInfo loginInfo = new LoginInfo(this.account, this.token);
            loginInfo.authType = this.authType;
            loginInfo.loginExt = this.loginExt;
            loginInfo.appKey = this.appKey;
            loginInfo.customClientType = this.customClientType;
            return loginInfo;
        }
    }
}

