/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.msg;

import android.text.TextUtils;
import com.netease.nimlib.c;
import com.netease.nimlib.l.a;
import com.netease.nimlib.r.b;
import com.netease.nimlib.r.u;
import com.netease.nimlib.r.w;
import com.netease.nimlib.sdk.msg.attachment.AudioAttachment;
import com.netease.nimlib.sdk.msg.attachment.FileAttachment;
import com.netease.nimlib.sdk.msg.attachment.ImageAttachment;
import com.netease.nimlib.sdk.msg.attachment.LocationAttachment;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.netease.nimlib.sdk.msg.attachment.VideoAttachment;
import com.netease.nimlib.sdk.msg.constant.AttachStatusEnum;
import com.netease.nimlib.sdk.msg.constant.MsgDirectionEnum;
import com.netease.nimlib.sdk.msg.constant.MsgStatusEnum;
import com.netease.nimlib.sdk.msg.constant.MsgTypeEnum;
import com.netease.nimlib.sdk.msg.constant.SessionTypeEnum;
import com.netease.nimlib.sdk.msg.model.CustomMessageConfig;
import com.netease.nimlib.sdk.msg.model.IMMessage;
import com.netease.nimlib.sdk.robot.model.RobotAttachment;
import com.netease.nimlib.session.IMMessageImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageBuilder {
    public static IMMessage createTextMessage(String string, SessionTypeEnum sessionTypeEnum, String string2) {
        IMMessageImpl iMMessageImpl = MessageBuilder.initSendMessage(string, sessionTypeEnum);
        iMMessageImpl.setMsgType(MsgTypeEnum.text.getValue());
        iMMessageImpl.setContent(string2);
        return iMMessageImpl;
    }

    public static IMMessage createImageMessage(String string, SessionTypeEnum sessionTypeEnum, File file) {
        return MessageBuilder.createImageMessage(string, sessionTypeEnum, file, null, "nim_default_im");
    }

    public static IMMessage createImageMessage(String string, SessionTypeEnum sessionTypeEnum, File file, String string2) {
        return MessageBuilder.createImageMessage(string, sessionTypeEnum, file, string2, "nim_default_im");
    }

    public static IMMessage createImageMessage(String string, SessionTypeEnum sessionTypeEnum, File file, String string2, String string3) {
        IMMessageImpl iMMessageImpl = MessageBuilder.initSendMessage(string, sessionTypeEnum);
        iMMessageImpl.setMsgType(MsgTypeEnum.image.getValue());
        ImageAttachment imageAttachment = new ImageAttachment();
        imageAttachment.setPath(file.getPath());
        imageAttachment.setSize(file.length());
        int[] nArray = b.a(file);
        imageAttachment.setWidth(nArray[0]);
        imageAttachment.setHeight(nArray[1]);
        imageAttachment.setDisplayName(string2);
        imageAttachment.setExtension(u.c(file.getName()));
        imageAttachment.setNosTokenSceneKey(string3);
        iMMessageImpl.setAttachment(imageAttachment);
        return iMMessageImpl;
    }

    public static IMMessage createAudioMessage(String string, SessionTypeEnum sessionTypeEnum, File file, long l2) {
        return MessageBuilder.createAudioMessage(string, sessionTypeEnum, file, l2, "nim_default_im");
    }

    public static IMMessage createAudioMessage(String string, SessionTypeEnum sessionTypeEnum, File file, long l2, String string2) {
        IMMessageImpl iMMessageImpl = MessageBuilder.initSendMessage(string, sessionTypeEnum);
        iMMessageImpl.setMsgType(MsgTypeEnum.audio.getValue());
        AudioAttachment audioAttachment = new AudioAttachment();
        audioAttachment.setPath(file.getPath());
        audioAttachment.setSize(file.length());
        if (l2 > 0L && l2 < 1000L) {
            l2 = 1000L;
        }
        audioAttachment.setDuration(l2);
        audioAttachment.setExtension(u.c(file.getName()));
        audioAttachment.setNosTokenSceneKey(string2);
        iMMessageImpl.setAttachment(audioAttachment);
        return iMMessageImpl;
    }

    public static IMMessage createLocationMessage(String string, SessionTypeEnum sessionTypeEnum, double d2, double d3, String string2) {
        IMMessageImpl iMMessageImpl = MessageBuilder.initSendMessage(string, sessionTypeEnum);
        iMMessageImpl.setMsgType(MsgTypeEnum.location.getValue());
        LocationAttachment locationAttachment = new LocationAttachment();
        locationAttachment.setLatitude(d2);
        locationAttachment.setLongitude(d3);
        locationAttachment.setAddress(string2);
        iMMessageImpl.setAttachStatus(AttachStatusEnum.transferred);
        iMMessageImpl.setAttachment(locationAttachment);
        return iMMessageImpl;
    }

    public static IMMessage createVideoMessage(String string, SessionTypeEnum sessionTypeEnum, File file, long l2, int n2, int n3, String string2) {
        return MessageBuilder.createVideoMessage(string, sessionTypeEnum, file, l2, n2, n3, string2, "nim_default_im");
    }

    public static IMMessage createVideoMessage(String string, SessionTypeEnum sessionTypeEnum, File file, long l2, int n2, int n3, String string2, String string3) {
        IMMessageImpl iMMessageImpl = MessageBuilder.initSendMessage(string, sessionTypeEnum);
        iMMessageImpl.setMsgType(MsgTypeEnum.video.getValue());
        VideoAttachment videoAttachment = new VideoAttachment();
        videoAttachment.setPath(file.getPath());
        videoAttachment.setSize(file.length());
        videoAttachment.setDuration(l2);
        videoAttachment.setWidth(n2);
        videoAttachment.setHeight(n3);
        videoAttachment.setDisplayName(string2);
        videoAttachment.setExtension(u.c(file.getName()));
        videoAttachment.setNosTokenSceneKey(string3);
        iMMessageImpl.setAttachment(videoAttachment);
        b.a(file.getPath(), videoAttachment.getThumbPathForSave());
        return iMMessageImpl;
    }

    public static IMMessage createFileMessage(String string, SessionTypeEnum sessionTypeEnum, File file, String string2) {
        return MessageBuilder.createFileMessage(string, sessionTypeEnum, file, string2, "nim_default_im");
    }

    public static IMMessage createFileMessage(String string, SessionTypeEnum sessionTypeEnum, File file, String string2, String string3) {
        IMMessageImpl iMMessageImpl = MessageBuilder.initSendMessage(string, sessionTypeEnum);
        iMMessageImpl.setMsgType(MsgTypeEnum.file.getValue());
        FileAttachment fileAttachment = new FileAttachment();
        fileAttachment.setPath(file.getPath());
        fileAttachment.setSize(file.length());
        fileAttachment.setDisplayName(string2);
        fileAttachment.setExtension(u.c(file.getName()));
        fileAttachment.setNosTokenSceneKey(string3);
        iMMessageImpl.setAttachment(fileAttachment);
        return iMMessageImpl;
    }

    public static IMMessage createTipMessage(String string, SessionTypeEnum sessionTypeEnum) {
        IMMessageImpl iMMessageImpl = MessageBuilder.initSendMessage(string, sessionTypeEnum);
        iMMessageImpl.setMsgType(MsgTypeEnum.tip.getValue());
        return iMMessageImpl;
    }

    public static IMMessage createCustomMessage(String string, SessionTypeEnum sessionTypeEnum, MsgAttachment msgAttachment) {
        return MessageBuilder.createCustomMessage(string, sessionTypeEnum, null, msgAttachment, null);
    }

    public static IMMessage createCustomMessage(String string, SessionTypeEnum sessionTypeEnum, String string2, MsgAttachment msgAttachment) {
        return MessageBuilder.createCustomMessage(string, sessionTypeEnum, string2, msgAttachment, null);
    }

    public static IMMessage createCustomMessage(String string, SessionTypeEnum sessionTypeEnum, String string2, MsgAttachment msgAttachment, CustomMessageConfig customMessageConfig) {
        return MessageBuilder.createCustomMessage(string, sessionTypeEnum, string2, msgAttachment, customMessageConfig, "nim_default_im");
    }

    public static IMMessage createCustomMessage(String string, SessionTypeEnum sessionTypeEnum, String string2, MsgAttachment msgAttachment, CustomMessageConfig customMessageConfig, String string3) {
        IMMessageImpl iMMessageImpl = MessageBuilder.initSendMessage(string, sessionTypeEnum);
        iMMessageImpl.setMsgType(MsgTypeEnum.custom.getValue());
        iMMessageImpl.setContent(string2);
        if (msgAttachment != null && msgAttachment instanceof FileAttachment) {
            ((FileAttachment)msgAttachment).setNosTokenSceneKey(string3);
        }
        iMMessageImpl.setAttachment(msgAttachment);
        iMMessageImpl.setConfig(customMessageConfig);
        return iMMessageImpl;
    }

    public static IMMessage createRobotMessage(String string, SessionTypeEnum sessionTypeEnum, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (TextUtils.isEmpty((CharSequence)string4) || TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Invalid param, type and robot account should not be null");
        }
        if (string4.equals("01") && string5 == null) {
            throw new IllegalArgumentException("Invalid param, content should not be null");
        }
        if (string4.equals("03") && TextUtils.isEmpty((CharSequence)string6)) {
            throw new IllegalArgumentException("Invalid param, target should not be null");
        }
        IMMessageImpl iMMessageImpl = MessageBuilder.initSendMessage(string, sessionTypeEnum);
        iMMessageImpl.setMsgType(MsgTypeEnum.robot.getValue());
        RobotAttachment robotAttachment = new RobotAttachment();
        robotAttachment.initSend(string2, string4, string5, string6, string7);
        iMMessageImpl.setAttachment(robotAttachment);
        iMMessageImpl.setContent(string3);
        return iMMessageImpl;
    }

    public static IMMessage createNrtcNetcallMessage(String string, SessionTypeEnum sessionTypeEnum, MsgAttachment msgAttachment) {
        IMMessageImpl iMMessageImpl = MessageBuilder.initSendMessage(string, sessionTypeEnum);
        iMMessageImpl.setMsgType(MsgTypeEnum.nrtc_netcall.getValue());
        iMMessageImpl.setAttachment(msgAttachment);
        return iMMessageImpl;
    }

    public static IMMessage createEmptyMessage(String string, SessionTypeEnum sessionTypeEnum, long l2) {
        IMMessageImpl iMMessageImpl = new IMMessageImpl();
        iMMessageImpl.setSessionId(string);
        iMMessageImpl.setSessionType(sessionTypeEnum);
        iMMessageImpl.setTime(l2);
        return iMMessageImpl;
    }

    public static IMMessage createForwardMessage(IMMessage iMMessage, String string, SessionTypeEnum sessionTypeEnum) {
        if (iMMessage.getMsgType() == MsgTypeEnum.notification || iMMessage.getMsgType() == MsgTypeEnum.avchat || iMMessage.getMsgType() == MsgTypeEnum.robot) {
            return null;
        }
        IMMessageImpl iMMessageImpl = ((IMMessageImpl)iMMessage).deepClone();
        if (iMMessageImpl != null) {
            FileAttachment fileAttachment;
            iMMessageImpl.setSessionId(string);
            iMMessageImpl.setSessionType(sessionTypeEnum);
            iMMessageImpl.setUuid(u.b());
            iMMessageImpl.setFromAccount(c.n());
            iMMessageImpl.setDirect(MsgDirectionEnum.Out);
            iMMessageImpl.setStatus(MsgStatusEnum.sending);
            iMMessageImpl.setTime(w.a());
            iMMessageImpl.setServerId(0L);
            iMMessageImpl.setMessageId(0L);
            iMMessageImpl.setMsgAck(false);
            iMMessageImpl.setHasSendAck(false);
            iMMessageImpl.setTeamMsgAckCount(0);
            iMMessageImpl.setTeamMsgUnAckCount(0);
            MsgAttachment msgAttachment = iMMessageImpl.getAttachment();
            if (msgAttachment != null && msgAttachment instanceof FileAttachment && !TextUtils.isEmpty((CharSequence)(fileAttachment = (FileAttachment)msgAttachment).getUrl())) {
                iMMessageImpl.setAttachStatus(AttachStatusEnum.def);
            }
        }
        return iMMessageImpl;
    }

    private static IMMessageImpl initSendMessage(String string, SessionTypeEnum sessionTypeEnum) {
        IMMessageImpl iMMessageImpl = new IMMessageImpl();
        iMMessageImpl.setUuid(u.b());
        iMMessageImpl.setSessionId(string);
        iMMessageImpl.setFromAccount(c.n());
        iMMessageImpl.setDirect(MsgDirectionEnum.Out);
        iMMessageImpl.setStatus(MsgStatusEnum.sending);
        iMMessageImpl.setSessionType(sessionTypeEnum);
        iMMessageImpl.setTime(w.a());
        return iMMessageImpl;
    }

    public static String createForwardMessageListFileDetail(List<? extends IMMessage> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        String string = list.get(0).getSessionId();
        if (string == null) {
            return "";
        }
        ArrayList<IMMessage> arrayList = new ArrayList<IMMessage>(list.size());
        for (IMMessage iMMessage : list) {
            if (!string.equals(iMMessage.getSessionId()) || iMMessage.getMsgType() == MsgTypeEnum.notification || iMMessage.getMsgType() == MsgTypeEnum.avchat || iMMessage.getMsgType() == MsgTypeEnum.robot) continue;
            arrayList.add(iMMessage);
        }
        return MessageBuilder.buildHeader(0, arrayList.size()) + "\n" + MessageBuilder.buildBody(arrayList);
    }

    private static String buildHeader(int n2, int n3) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("version", n2);
            jSONObject.put("terminal", 1);
            jSONObject.put("sdk_version", (Object)"8.9.116");
            jSONObject.put("app_version", 2316);
            jSONObject.put("message_count", n3);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    private static String buildBody(List<IMMessage> list) {
        String string = "\n";
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IMMessage iMMessage : list) {
            stringBuilder.append(string).append(a.a(iMMessage));
        }
        return stringBuilder.substring(string.length());
    }

    public static IMMessage createFromJson(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return a.a(string);
    }

    public static String convertMessageToJson(IMMessage iMMessage) {
        if (iMMessage == null) {
            return null;
        }
        return a.a(iMMessage);
    }
}

