/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.highavailable.lava.base.http;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.netease.nim.highavailable.LogUtils;
import com.netease.nim.highavailable.lava.base.annotation.CalledByNative;
import com.netease.nim.highavailable.lava.base.annotation.Keep;
import com.netease.nim.highavailable.lava.base.http.HttpHeaderPair;
import com.netease.nim.highavailable.lava.base.http.HttpStackResponse;
import com.netease.nim.highavailable.lava.base.http.MultipartWriter;
import com.netease.nim.highavailable.lava.base.http.TlsSniSocketFactory;
import com.netease.nim.highavailable.lava.base.util.ArrayUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONObject;

@Keep
public class HttpStack {
    private static final String TAG = "HttpStack";
    private static final int CURLE_UNSUPPORTED_PROTOCOL = 1;
    private static final int CURLE_URL_MALFORMAT = 3;
    private static final int CURLE_COULDNT_RESOLVE_HOST = 6;
    private static final int CURLE_COULDNT_CONNECT = 7;
    private static final int CURLE_SSL_CONNECT_ERROR = 35;

    private static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static HttpURLConnection createConnection(URL uRL) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setInstanceFollowRedirects(HttpURLConnection.getFollowRedirects());
        return httpURLConnection;
    }

    private static HttpURLConnection openConnection(URL uRL, String string, Map<String, String> map, byte[] byArray, int n2) throws IOException {
        HttpURLConnection httpURLConnection = HttpStack.createConnection(uRL);
        httpURLConnection.setRequestMethod(string);
        httpURLConnection.setConnectTimeout(n2);
        httpURLConnection.setReadTimeout(n2);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoInput(true);
        HttpStack.configHttps(httpURLConnection);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (!ArrayUtils.isEmpty(byArray)) {
            httpURLConnection.setDoOutput(true);
            Object object = httpURLConnection.getOutputStream();
            if (map != null && "gzip".equals(map.get("Content-Encoding"))) {
                object = new GZIPOutputStream(new BufferedOutputStream((OutputStream)object));
            }
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).flush();
            HttpStack.closeQuietly((Closeable)object);
        }
        return httpURLConnection;
    }

    private static HttpURLConnection openConnection(URL uRL, String string, Map<String, String> map, int n2) throws IOException {
        HttpURLConnection httpURLConnection = HttpStack.createConnection(uRL);
        httpURLConnection.setRequestMethod(string);
        httpURLConnection.setConnectTimeout(n2);
        httpURLConnection.setReadTimeout(n2);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoInput(true);
        HttpStack.configHttps(httpURLConnection);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return httpURLConnection;
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doPost(String string) {
        return HttpStack.doPost(string, null, null, 3000);
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doPost(String string, int n2) {
        return HttpStack.doPost(string, null, null, n2);
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doPost(String string, Map<String, String> map, byte[] byArray, int n2, String string2, String string3) {
        return HttpStack.doHttpMethod(string, map, byArray, n2, string2, string3, "POST");
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doGet(String string, Map<String, String> map, int n2, String string2, String string3) {
        return HttpStack.doHttpMethod(string, map, null, n2, string2, string3, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpStackResponse doHttpMethod(String string, Map<String, String> map, byte[] byArray, int n2, String string2, String string3, String string4) {
        Object object;
        HttpURLConnection httpURLConnection = null;
        if (string == null || string.isEmpty() || string3 == null || string3.isEmpty()) {
            LogUtils.e(TAG, "illegal argument, path:" + string + ", ip:" + string2 + ", host:" + string3);
            return null;
        }
        try {
            int n3;
            Object object2;
            URL uRL = new URL(string);
            if (!"https".equals(uRL.getProtocol())) {
                LogUtils.e(TAG, "doPost failed, " + uRL.getProtocol() + " is not https");
                HttpStackResponse httpStackResponse = null;
                return httpStackResponse;
            }
            if (string2 != null && !string2.isEmpty()) {
                object = uRL.toURI();
                URI object32 = new URI(((URI)object).getScheme(), ((URI)object).getUserInfo(), string2, uRL.getPort(), ((URI)object).getPath(), ((URI)object).getQuery(), ((URI)object).getFragment());
                object2 = object32.toURL();
                LogUtils.d(TAG, "oldURL = " + uRL + ", newURL = " + object2);
                httpURLConnection = (HttpsURLConnection)((URL)object2).openConnection();
            }
            httpURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Host", string3);
            httpURLConnection.setRequestMethod(string4);
            httpURLConnection.setConnectTimeout(n2);
            httpURLConnection.setReadTimeout(n2);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setInstanceFollowRedirects(false);
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            object = new TlsSniSocketFactory((HttpsURLConnection)httpURLConnection);
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory((SSLSocketFactory)object);
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(new HostnameVerifier((HttpsURLConnection)httpURLConnection2){
                final /* synthetic */ HttpsURLConnection val$finalConnection;
                {
                    this.val$finalConnection = httpsURLConnection;
                }

                @Override
                @SuppressLint(value={"BadHostnameVerifier"})
                public boolean verify(String string, SSLSession sSLSession) {
                    boolean bl;
                    String string2 = this.val$finalConnection.getRequestProperty("Host");
                    if (null == string2) {
                        string2 = this.val$finalConnection.getURL().getHost();
                    }
                    if (!(bl = HttpsURLConnection.getDefaultHostnameVerifier().verify(string2, sSLSession))) {
                        LogUtils.w(HttpStack.TAG, "host name verify failed");
                    }
                    return bl;
                }
            });
            if (!ArrayUtils.isEmpty(byArray)) {
                httpURLConnection.setDoOutput(true);
                object2 = httpURLConnection.getOutputStream();
                if (map != null && "gzip".equals(map.get("Content-Encoding"))) {
                    object2 = new GZIPOutputStream(new BufferedOutputStream((OutputStream)object2));
                }
                ((OutputStream)object2).write(byArray);
                ((OutputStream)object2).flush();
                HttpStack.closeQuietly((Closeable)object2);
            }
            if (HttpStack.needRedirect(n3 = httpURLConnection.getResponseCode())) {
                Object object3;
                String string5 = httpURLConnection.getHeaderField("Location");
                if (string5 == null) {
                    string5 = httpURLConnection.getHeaderField("location");
                }
                if (!string5.startsWith("http://") && !string5.startsWith("https://")) {
                    object3 = new URL(string);
                    string5 = ((URL)object3).getProtocol() + "://" + ((URL)object3).getHost() + string5;
                }
                object3 = HttpStack.doPost(string5, map, byArray, n2, null, string3);
                return object3;
            }
            long l2 = httpURLConnection.getLastModified();
            String string6 = HttpStack.readFully(httpURLConnection.getInputStream());
            HttpStackResponse httpStackResponse = new HttpStackResponse();
            httpStackResponse.code = n3;
            httpStackResponse.result = string6;
            httpStackResponse.lastModified = l2;
            Map<String, List<String>> map2 = httpURLConnection.getHeaderFields();
            Set<String> set = map2.keySet();
            JSONObject jSONObject = new JSONObject();
            for (String string7 : set) {
                String string8 = httpURLConnection.getHeaderField(string7);
                jSONObject.put(string7 != null ? string7 : "httpversion", (Object)string8);
            }
            httpStackResponse.headers = jSONObject.toString();
            LogUtils.d(TAG, "doPost: response:" + httpStackResponse);
            HttpStackResponse httpStackResponse2 = httpStackResponse;
            return httpStackResponse2;
        }
        catch (Throwable throwable) {
            LogUtils.e(TAG, "doHttpMethod exception," + throwable);
            object = HttpStack.getHttpStackResponse(throwable);
            return object;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    @CalledByNative
    public static HttpStackResponse doPost(String string, Map<String, String> map, byte[] byArray, int n2) {
        HttpStackResponse httpStackResponse = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = HttpStack.openConnection(uRL, "POST", map, byArray, n2);
            int n3 = httpURLConnection.getResponseCode();
            long l2 = httpURLConnection.getLastModified();
            String string2 = HttpStack.readFully(httpURLConnection.getInputStream());
            httpStackResponse = new HttpStackResponse();
            httpStackResponse.code = n3;
            httpStackResponse.result = string2;
            httpStackResponse.lastModified = l2;
            Map<String, List<String>> map2 = httpURLConnection.getHeaderFields();
            Set<String> set = map2.keySet();
            JSONObject jSONObject = new JSONObject();
            for (String string3 : set) {
                String string4 = httpURLConnection.getHeaderField(string3);
                jSONObject.put(string3 != null ? string3 : "httpversion", (Object)string4);
            }
            httpStackResponse.headers = jSONObject.toString();
        }
        catch (Throwable throwable) {
            httpStackResponse = HttpStack.getHttpStackResponse(throwable);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return httpStackResponse;
    }

    @NonNull
    private static HttpStackResponse getHttpStackResponse(Throwable throwable) {
        int n2 = -1;
        String string = throwable.getMessage();
        n2 = throwable instanceof SocketTimeoutException ? 408 : (throwable instanceof FileNotFoundException ? 404 : (throwable instanceof ConnectException ? 7 : (throwable instanceof MalformedURLException ? 3 : (throwable instanceof UnknownHostException ? 6 : (throwable instanceof SSLException ? 35 : (string != null && string.contains("Cleartext HTTP traffic") ? 1 : -1))))));
        HttpStackResponse httpStackResponse = new HttpStackResponse();
        httpStackResponse.code = n2;
        httpStackResponse.result = throwable.toString();
        if (httpStackResponse.result.isEmpty()) {
            httpStackResponse.result = string;
        }
        return httpStackResponse;
    }

    @Keep
    @CalledByNative
    public static HttpStackResponse doPostHeaders(String string, HttpHeaderPair[] httpHeaderPairArray, byte[] byArray, int n2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 0; i2 < httpHeaderPairArray.length; ++i2) {
            HttpHeaderPair httpHeaderPair = httpHeaderPairArray[i2];
            hashMap.put(httpHeaderPair.getKey(), httpHeaderPair.getValue());
        }
        return HttpStack.doPost(string, hashMap, byArray, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static HttpStackResponse multipartPost(String string, String string2, String string3, Map<String, String> map, MultipartWriter multipartWriter) {
        HttpStackResponse httpStackResponse = null;
        OutputStream outputStream = null;
        PrintWriter printWriter = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = HttpStack.openConnection(uRL, "POST", map, 3000);
            httpURLConnection.setDoOutput(true);
            outputStream = httpURLConnection.getOutputStream();
            printWriter = map != null && "gzip".equals(map.get("Content-Encoding")) ? new PrintWriter(new GZIPOutputStream(outputStream)) : new PrintWriter(outputStream);
            multipartWriter.addPart(printWriter, outputStream);
            printWriter.append(string3);
            printWriter.append("--").append(string2).append("--").append(string3);
            printWriter.flush();
            int n2 = httpURLConnection.getResponseCode();
            long l2 = httpURLConnection.getLastModified();
            String string4 = HttpStack.readFully(httpURLConnection.getInputStream());
            httpStackResponse = new HttpStackResponse();
            httpStackResponse.code = n2;
            httpStackResponse.result = string4;
            httpStackResponse.lastModified = l2;
        }
        catch (Throwable throwable) {
            LogUtils.e(TAG, "multipartPost exception," + throwable);
            httpStackResponse = HttpStack.getHttpStackResponse(throwable);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {
                    LogUtils.e(TAG, "multipartPost outputStream.close exception," + throwable);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return httpStackResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFully(InputStream inputStream) throws IOException {
        String string;
        if (inputStream == null) {
            return "";
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            int n2;
            bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = bufferedInputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            string = byteArrayOutputStream.toString();
        }
        catch (Throwable throwable) {
            HttpStack.closeQuietly(bufferedInputStream);
            throw throwable;
        }
        HttpStack.closeQuietly(bufferedInputStream);
        return string;
    }

    private static void configHttps(HttpURLConnection httpURLConnection) {
        if (httpURLConnection != null && httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, null, null);
                httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
                HostnameVerifier hostnameVerifier = (string, sSLSession) -> !TextUtils.isEmpty((CharSequence)string);
                httpsURLConnection.setHostnameVerifier(hostnameVerifier);
            }
            catch (Exception exception) {
                LogUtils.e(TAG, "configHttps exception," + exception);
            }
        }
    }

    private static boolean needRedirect(int n2) {
        return n2 >= 300 && n2 < 400;
    }
}

