/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nim.highavailable.lava.base.http;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URIUtils {
    static final BitSet digit;
    static final BitSet alpha;
    static final BitSet reserved;
    static final BitSet mark;
    static final BitSet alphanum;
    static final BitSet unreserved;
    static final BitSet percent;
    static final BitSet hex;
    static final BitSet escaped;
    static final BitSet uric;
    static final BitSet allowed_query;

    public static String encodeQuery(String string, String string2) throws Exception {
        return new String(URIUtils.encode(string, allowed_query, string2));
    }

    static char[] encode(String string, BitSet bitSet, String string2) throws Exception {
        byte[] byArray;
        if (string == null) {
            throw new Exception("original is null");
        }
        if (bitSet == null) {
            throw new Exception("null allowed characters");
        }
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Exception(unsupportedEncodingException.getMessage());
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            char c2 = (char)byArray[i2];
            if (bitSet.get(c2)) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append('%');
            byte by = byArray[i2];
            char c3 = Character.forDigit(by >> 4 & 0xF, 16);
            stringBuffer.append(Character.toUpperCase(c3));
            c3 = Character.forDigit(by & 0xF, 16);
            stringBuffer.append(Character.toUpperCase(c3));
        }
        return stringBuffer.toString().toCharArray();
    }

    static {
        int n2;
        digit = new BitSet(256);
        for (n2 = 48; n2 <= 57; ++n2) {
            digit.set(n2);
        }
        alpha = new BitSet(256);
        for (n2 = 97; n2 <= 122; ++n2) {
            alpha.set(n2);
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            alpha.set(n2);
        }
        reserved = new BitSet(256);
        reserved.set(59);
        reserved.set(47);
        reserved.set(63);
        reserved.set(58);
        reserved.set(64);
        reserved.set(38);
        reserved.set(61);
        reserved.set(43);
        reserved.set(36);
        reserved.set(44);
        mark = new BitSet(256);
        mark.set(45);
        mark.set(95);
        mark.set(46);
        mark.set(33);
        mark.set(126);
        mark.set(42);
        mark.set(39);
        mark.set(40);
        mark.set(41);
        alphanum = new BitSet(256);
        alphanum.or(alpha);
        alphanum.or(digit);
        unreserved = new BitSet(256);
        unreserved.or(alphanum);
        unreserved.or(mark);
        percent = new BitSet(256);
        percent.set(37);
        hex = new BitSet(256);
        hex.or(digit);
        for (n2 = 97; n2 <= 102; ++n2) {
            hex.set(n2);
        }
        for (n2 = 65; n2 <= 70; ++n2) {
            hex.set(n2);
        }
        escaped = new BitSet(256);
        escaped.or(percent);
        escaped.or(hex);
        uric = new BitSet(256);
        uric.or(reserved);
        uric.or(unreserved);
        uric.or(escaped);
        allowed_query = new BitSet(256);
        allowed_query.or(uric);
        allowed_query.clear(37);
    }
}

