/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.msg.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.netease.nimlib.q.u;
import com.netease.nimlib.sdk.msg.MessageBuilder;
import com.netease.nimlib.sdk.msg.constant.SessionTypeEnum;
import com.netease.nimlib.sdk.msg.model.GetMessageDirectionEnum;
import com.netease.nimlib.sdk.msg.model.IMMessage;
import com.netease.nimlib.session.IMMessageImpl;
import com.netease.nimlib.session.j;
import java.io.Serializable;

public class GetMessagesDynamicallyParam
implements Serializable {
    public static final int MAX_LIMIT = 100;
    @NonNull
    private final String sessionId;
    @NonNull
    private final SessionTypeEnum sessionType;
    private long fromTime;
    private long toTime;
    private long anchorServerId;
    private String anchorClientId;
    private int limit;
    @Nullable
    private GetMessageDirectionEnum direction;

    public GetMessagesDynamicallyParam(@NonNull String string, @NonNull SessionTypeEnum sessionTypeEnum) {
        this(string, sessionTypeEnum, 0L, 0L, 0L, null, 0, GetMessageDirectionEnum.FORWARD);
    }

    public GetMessagesDynamicallyParam(@NonNull String string, @NonNull SessionTypeEnum sessionTypeEnum, long l2, long l3, long l4, String string2, int n2, @Nullable GetMessageDirectionEnum getMessageDirectionEnum) {
        this.sessionId = string;
        this.sessionType = sessionTypeEnum;
        this.fromTime = l2;
        this.toTime = l3;
        this.anchorServerId = l4;
        this.anchorClientId = string2;
        this.limit = n2;
        this.direction = getMessageDirectionEnum;
    }

    @NonNull
    public String getSessionId() {
        return this.sessionId;
    }

    @NonNull
    public SessionTypeEnum getSessionType() {
        return this.sessionType;
    }

    public long getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(long l2) {
        this.fromTime = l2;
    }

    public long getToTime() {
        return this.toTime;
    }

    public void setToTime(long l2) {
        this.toTime = l2;
    }

    public long getAnchorServerId() {
        return this.anchorServerId;
    }

    public void setAnchorServerId(long l2) {
        this.anchorServerId = l2;
    }

    public String getAnchorClientId() {
        return this.anchorClientId;
    }

    public void setAnchorClientId(String string) {
        this.anchorClientId = string;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int n2) {
        this.limit = n2;
    }

    public GetMessageDirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(GetMessageDirectionEnum getMessageDirectionEnum) {
        this.direction = getMessageDirectionEnum;
    }

    @NonNull
    public IMMessage getAnchor() {
        IMMessage iMMessage;
        String string = this.getAnchorClientId();
        if (u.b((CharSequence)string) && (iMMessage = j.b(string)) instanceof IMMessageImpl) {
            return iMMessage;
        }
        long l2 = this.getDirection() == GetMessageDirectionEnum.BACKWARD ? this.getFromTime() : this.getToTime();
        IMMessageImpl iMMessageImpl = (IMMessageImpl)MessageBuilder.createEmptyMessage(this.getSessionId(), this.getSessionType(), l2);
        iMMessageImpl.setUuid(this.getAnchorClientId());
        iMMessageImpl.setServerId(this.getAnchorServerId());
        return iMMessageImpl;
    }

    public GetMessagesDynamicallyParam createStandardizedParam() {
        String string = this.sessionId;
        SessionTypeEnum sessionTypeEnum = this.sessionType == null ? SessionTypeEnum.None : this.sessionType;
        long l2 = this.fromTime;
        long l3 = this.toTime;
        long l4 = this.anchorServerId;
        String string2 = this.anchorClientId;
        int n2 = this.limit;
        n2 = n2 <= 0 ? 100 : n2;
        GetMessageDirectionEnum getMessageDirectionEnum = this.direction == null ? GetMessageDirectionEnum.FORWARD : this.direction;
        return new GetMessagesDynamicallyParam(string, sessionTypeEnum, l2, l3, l4, string2, n2, getMessageDirectionEnum);
    }

    public boolean isValid() {
        return !(!u.b((CharSequence)this.sessionId) || this.sessionType != SessionTypeEnum.P2P && this.sessionType != SessionTypeEnum.Team && this.sessionType != SessionTypeEnum.SUPER_TEAM || this.fromTime < 0L || this.toTime < 0L || this.limit < 0 || this.limit > 100 || this.anchorServerId != 0L && !u.b((CharSequence)this.anchorClientId));
    }

    public String toString() {
        return "GetMessagesDynamicallyParam{sessionId='" + this.sessionId + '\'' + ", sessionType=" + (Object)((Object)this.sessionType) + ", fromTime=" + this.fromTime + ", toTime=" + this.toTime + ", excludeServerId=" + this.anchorServerId + ", excludeClientId='" + this.anchorClientId + '\'' + ", limit=" + this.limit + ", direction=" + (Object)((Object)this.direction) + '}';
    }
}

