/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.util;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.netease.nimlib.log.b;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Collection;

public final class NIMUtil {
    private static final String TAG = "NIMUtil";
    private static String currentProcessName = null;

    private NIMUtil() {
    }

    public static int isMainProcessPure(Context context) {
        if (context == null) {
            Log.d((String)TAG, (String)" isMainProcessPure context == null");
            return -1;
        }
        String string = context.getApplicationContext().getPackageName();
        String string2 = NIMUtil.getProcessNamePure(context);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.d((String)TAG, (String)" isMainProcessPure can not get processName");
            return -1;
        }
        Log.d((String)TAG, (String)(" isMainProcessPure packageName = " + string + ",processName = " + string2));
        return string.equals(string2) ? 1 : 0;
    }

    public static String getProcessNamePure(Context context) {
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            Log.d((String)TAG, (String)("get processName from Cache = " + currentProcessName));
            return currentProcessName;
        }
        currentProcessName = NIMUtil.getCurrentProcessNameByApplication();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            Log.d((String)TAG, (String)("get processName from Application = " + currentProcessName));
            return currentProcessName;
        }
        currentProcessName = NIMUtil.getCurrentProcessNameByActivityThread();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            Log.d((String)TAG, (String)("get processName from ActivityThread = " + currentProcessName));
            return currentProcessName;
        }
        return currentProcessName;
    }

    public static boolean isMainProcess(Context context) {
        if (context == null) {
            return false;
        }
        String string = context.getApplicationContext().getPackageName();
        String string2 = NIMUtil.getProcessName(context);
        return string.equals(string2);
    }

    public static String getProcessName(Context context) {
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            Log.d((String)TAG, (String)("get processName from Cache = " + currentProcessName));
            return currentProcessName;
        }
        currentProcessName = NIMUtil.getCurrentProcessNameByApplication();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            Log.d((String)TAG, (String)("get processName from Application = " + currentProcessName));
            return currentProcessName;
        }
        currentProcessName = NIMUtil.getCurrentProcessNameByActivityThread();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            Log.d((String)TAG, (String)("get processName from ActivityThread = " + currentProcessName));
            return currentProcessName;
        }
        currentProcessName = NIMUtil.getProcessFromFile();
        if (!TextUtils.isEmpty((CharSequence)currentProcessName)) {
            Log.d((String)TAG, (String)("get processName from File = " + currentProcessName));
            return currentProcessName;
        }
        return currentProcessName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessFromFile() {
        BufferedReader bufferedReader = null;
        try {
            int n2;
            int n3 = Process.myPid();
            String string = "/proc/" + n3 + "/cmdline";
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "iso-8859-1"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((n2 = bufferedReader.read()) > 0) {
                stringBuilder.append((char)n2);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (Exception exception) {
            String string = null;
            return string;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static String getNimDefaultCacheDir(Context context) {
        String string = "";
        if (context.getCacheDir() != null) {
            string = context.getCacheDir().getAbsolutePath();
        } else {
            b.e(TAG, "loadStorageState context.getCacheDir() == null");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            if (Environment.getExternalStorageDirectory() != null) {
                String string2 = Environment.getExternalStorageDirectory().getPath();
                string = string2 + "/" + context.getPackageName();
            } else {
                b.e(TAG, "loadStorageState Environment.getExternalStorageDirectory() == null");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            string = string + "/nim/";
        }
        return string;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    private static String getCurrentProcessNameByApplication() {
        if (Build.VERSION.SDK_INT >= 28) {
            return Application.getProcessName();
        }
        return null;
    }

    private static String getCurrentProcessNameByActivityThread() {
        String string = null;
        try {
            Method method = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke(null, new Object[0]);
            if (object instanceof String) {
                string = (String)object;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }
}

