/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.chatroom;

import android.text.TextUtils;
import com.netease.nimlib.c;
import com.netease.nimlib.chatroom.model.ChatRoomMessageImpl;
import com.netease.nimlib.r.b;
import com.netease.nimlib.r.u;
import com.netease.nimlib.r.w;
import com.netease.nimlib.sdk.chatroom.model.ChatRoomMessage;
import com.netease.nimlib.sdk.msg.attachment.AudioAttachment;
import com.netease.nimlib.sdk.msg.attachment.FileAttachment;
import com.netease.nimlib.sdk.msg.attachment.ImageAttachment;
import com.netease.nimlib.sdk.msg.attachment.LocationAttachment;
import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.netease.nimlib.sdk.msg.attachment.VideoAttachment;
import com.netease.nimlib.sdk.msg.constant.AttachStatusEnum;
import com.netease.nimlib.sdk.msg.constant.MsgDirectionEnum;
import com.netease.nimlib.sdk.msg.constant.MsgStatusEnum;
import com.netease.nimlib.sdk.msg.constant.MsgTypeEnum;
import com.netease.nimlib.sdk.msg.constant.SessionTypeEnum;
import com.netease.nimlib.sdk.robot.model.RobotAttachment;
import java.io.File;

public class ChatRoomMessageBuilder {
    public static ChatRoomMessage createChatRoomTextMessage(String string, String string2) {
        ChatRoomMessageImpl chatRoomMessageImpl = ChatRoomMessageBuilder.initSendMessage(string);
        chatRoomMessageImpl.setMsgType(MsgTypeEnum.text.getValue());
        chatRoomMessageImpl.setContent(string2);
        return chatRoomMessageImpl;
    }

    public static ChatRoomMessage createChatRoomCustomMessage(String string, MsgAttachment msgAttachment) {
        return ChatRoomMessageBuilder.createChatRoomCustomMessage(string, msgAttachment, "nim_default_im");
    }

    public static ChatRoomMessage createChatRoomCustomMessage(String string, MsgAttachment msgAttachment, String string2) {
        ChatRoomMessageImpl chatRoomMessageImpl = ChatRoomMessageBuilder.initSendMessage(string);
        chatRoomMessageImpl.setMsgType(MsgTypeEnum.custom.getValue());
        if (msgAttachment != null && msgAttachment instanceof FileAttachment) {
            ((FileAttachment)msgAttachment).setNosTokenSceneKey(string2);
        }
        chatRoomMessageImpl.setAttachment(msgAttachment);
        return chatRoomMessageImpl;
    }

    public static ChatRoomMessage createChatRoomImageMessage(String string, File file, String string2) {
        return ChatRoomMessageBuilder.createChatRoomImageMessage(string, file, string2, "nim_default_im");
    }

    public static ChatRoomMessage createChatRoomImageMessage(String string, File file, String string2, String string3) {
        ChatRoomMessageImpl chatRoomMessageImpl = ChatRoomMessageBuilder.initSendMessage(string);
        chatRoomMessageImpl.setMsgType(MsgTypeEnum.image.getValue());
        ImageAttachment imageAttachment = new ImageAttachment();
        imageAttachment.setPath(file.getPath());
        imageAttachment.setSize(file.length());
        int[] nArray = b.a((File)file);
        imageAttachment.setWidth(nArray[0]);
        imageAttachment.setHeight(nArray[1]);
        imageAttachment.setDisplayName(string2);
        imageAttachment.setExtension(u.c((String)file.getName()));
        imageAttachment.setNosTokenSceneKey(string3);
        chatRoomMessageImpl.setAttachment((MsgAttachment)imageAttachment);
        return chatRoomMessageImpl;
    }

    public static ChatRoomMessage createChatRoomAudioMessage(String string, File file, long l2) {
        return ChatRoomMessageBuilder.createChatRoomAudioMessage(string, file, l2, "nim_default_im");
    }

    public static ChatRoomMessage createChatRoomAudioMessage(String string, File file, long l2, String string2) {
        ChatRoomMessageImpl chatRoomMessageImpl = ChatRoomMessageBuilder.initSendMessage(string);
        chatRoomMessageImpl.setMsgType(MsgTypeEnum.audio.getValue());
        AudioAttachment audioAttachment = new AudioAttachment();
        audioAttachment.setPath(file.getPath());
        audioAttachment.setSize(file.length());
        if (l2 > 0L && l2 < 1000L) {
            l2 = 1000L;
        }
        audioAttachment.setDuration(l2);
        audioAttachment.setExtension(u.c((String)file.getName()));
        audioAttachment.setNosTokenSceneKey(string2);
        chatRoomMessageImpl.setAttachment((MsgAttachment)audioAttachment);
        return chatRoomMessageImpl;
    }

    public static ChatRoomMessage createChatRoomLocationMessage(String string, double d2, double d3, String string2) {
        ChatRoomMessageImpl chatRoomMessageImpl = ChatRoomMessageBuilder.initSendMessage(string);
        chatRoomMessageImpl.setMsgType(MsgTypeEnum.location.getValue());
        LocationAttachment locationAttachment = new LocationAttachment();
        locationAttachment.setLatitude(d2);
        locationAttachment.setLongitude(d3);
        locationAttachment.setAddress(string2);
        chatRoomMessageImpl.setAttachStatus(AttachStatusEnum.transferred);
        chatRoomMessageImpl.setAttachment((MsgAttachment)locationAttachment);
        return chatRoomMessageImpl;
    }

    public static ChatRoomMessage createChatRoomVideoMessage(String string, File file, long l2, int n2, int n3, String string2) {
        return ChatRoomMessageBuilder.createChatRoomVideoMessage(string, file, l2, n2, n3, string2, "nim_default_im");
    }

    public static ChatRoomMessage createChatRoomVideoMessage(String string, File file, long l2, int n2, int n3, String string2, String string3) {
        ChatRoomMessageImpl chatRoomMessageImpl = ChatRoomMessageBuilder.initSendMessage(string);
        chatRoomMessageImpl.setMsgType(MsgTypeEnum.video.getValue());
        VideoAttachment videoAttachment = new VideoAttachment();
        videoAttachment.setPath(file.getPath());
        videoAttachment.setSize(file.length());
        videoAttachment.setDuration(l2);
        videoAttachment.setWidth(n2);
        videoAttachment.setHeight(n3);
        videoAttachment.setDisplayName(string2);
        videoAttachment.setExtension(u.c((String)file.getName()));
        videoAttachment.setNosTokenSceneKey(string3);
        chatRoomMessageImpl.setAttachment((MsgAttachment)videoAttachment);
        b.a((String)file.getPath(), (String)videoAttachment.getThumbPathForSave());
        return chatRoomMessageImpl;
    }

    public static ChatRoomMessage createChatRoomFileMessage(String string, File file, String string2) {
        return ChatRoomMessageBuilder.createChatRoomFileMessage(string, file, string2, "nim_default_im");
    }

    public static ChatRoomMessage createChatRoomFileMessage(String string, File file, String string2, String string3) {
        ChatRoomMessageImpl chatRoomMessageImpl = ChatRoomMessageBuilder.initSendMessage(string);
        chatRoomMessageImpl.setMsgType(MsgTypeEnum.file.getValue());
        FileAttachment fileAttachment = new FileAttachment();
        fileAttachment.setPath(file.getPath());
        fileAttachment.setSize(file.length());
        fileAttachment.setDisplayName(string2);
        fileAttachment.setExtension(u.c((String)file.getName()));
        fileAttachment.setNosTokenSceneKey(string3);
        chatRoomMessageImpl.setAttachment((MsgAttachment)fileAttachment);
        return chatRoomMessageImpl;
    }

    public static ChatRoomMessage createTipMessage(String string) {
        ChatRoomMessageImpl chatRoomMessageImpl = ChatRoomMessageBuilder.initSendMessage(string);
        chatRoomMessageImpl.setMsgType(MsgTypeEnum.tip.getValue());
        return chatRoomMessageImpl;
    }

    public static ChatRoomMessage createRobotMessage(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (TextUtils.isEmpty((CharSequence)string4) || TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Invalid param, type and robot account should not be null");
        }
        if (string4.equals("01") && string5 == null) {
            throw new IllegalArgumentException("Invalid param, content should not be null");
        }
        if (string4.equals("03") && TextUtils.isEmpty((CharSequence)string6)) {
            throw new IllegalArgumentException("Invalid param, target should not be null");
        }
        ChatRoomMessageImpl chatRoomMessageImpl = ChatRoomMessageBuilder.initSendMessage(string);
        chatRoomMessageImpl.setMsgType(MsgTypeEnum.robot.getValue());
        RobotAttachment robotAttachment = new RobotAttachment();
        robotAttachment.initSend(string2, string4, string5, string6, string7);
        chatRoomMessageImpl.setAttachment((MsgAttachment)robotAttachment);
        chatRoomMessageImpl.setContent(string3);
        return chatRoomMessageImpl;
    }

    public static ChatRoomMessage createEmptyChatRoomMessage(String string, long l2) {
        ChatRoomMessageImpl chatRoomMessageImpl = new ChatRoomMessageImpl();
        chatRoomMessageImpl.setSessionId(string);
        chatRoomMessageImpl.setSessionType(SessionTypeEnum.ChatRoom);
        chatRoomMessageImpl.setTime(l2);
        return chatRoomMessageImpl;
    }

    private static final ChatRoomMessageImpl initSendMessage(String string) {
        ChatRoomMessageImpl chatRoomMessageImpl = new ChatRoomMessageImpl();
        chatRoomMessageImpl.setUuid(u.b());
        chatRoomMessageImpl.setSessionId(string);
        chatRoomMessageImpl.setFromAccount(c.o());
        chatRoomMessageImpl.setDirect(MsgDirectionEnum.Out);
        chatRoomMessageImpl.setStatus(MsgStatusEnum.sending);
        chatRoomMessageImpl.setSessionType(SessionTypeEnum.ChatRoom);
        chatRoomMessageImpl.setTime(w.a());
        return chatRoomMessageImpl;
    }
}

