/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.apache.lucene.analysis.tokenattributes.PackedTokenAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeSource;

public abstract class TokenStream
extends AttributeSource
implements Closeable {
    public static final AttributeFactory DEFAULT_TOKEN_ATTRIBUTE_FACTORY = AttributeFactory.getStaticImplementation(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, PackedTokenAttributeImpl.class);

    protected TokenStream() {
        super(DEFAULT_TOKEN_ATTRIBUTE_FACTORY);
        assert (this.assertFinal());
    }

    protected TokenStream(AttributeFactory attributeFactory) {
        super(attributeFactory);
        assert (this.assertFinal());
    }

    private boolean assertFinal() {
        try {
            Class<?> clazz = this.getClass();
            if (!clazz.desiredAssertionStatus()) {
                return true;
            }
            assert (clazz.isAnonymousClass() || (clazz.getModifiers() & 0x12) != 0 || Modifier.isFinal(clazz.getMethod("incrementToken", new Class[0]).getModifiers())) : "TokenStream implementation classes or at least their incrementToken() implementation must be final";
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public abstract boolean incrementToken() throws IOException;

    public void end() throws IOException {
        this.clearAttributes();
        PositionIncrementAttribute positionIncrementAttribute = this.getAttribute(PositionIncrementAttribute.class);
        if (positionIncrementAttribute != null) {
            positionIncrementAttribute.setPositionIncrement(0);
        }
    }

    public void reset() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

