/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.CharFilter;
import org.apache.lucene.analysis.TokenStream;

public abstract class Tokenizer
extends TokenStream {
    protected Reader input = ILLEGAL_STATE_READER;
    private Reader inputPending = ILLEGAL_STATE_READER;
    private static final Reader ILLEGAL_STATE_READER = new Reader(){

        @Override
        public int read(char[] cArray, int n2, int n3) {
            throw new IllegalStateException("TokenStream contract violation: reset()/close() call missing, reset() called multiple times, or subclass does not call super.reset(). Please see Javadocs of TokenStream class for more information about the correct consuming workflow.");
        }

        @Override
        public void close() {
        }
    };

    protected Tokenizer() {
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        this.inputPending = this.input = ILLEGAL_STATE_READER;
    }

    protected final int correctOffset(int n2) {
        return this.input instanceof CharFilter ? ((CharFilter)this.input).correctOffset(n2) : n2;
    }

    public final void setReader(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException("input must not be null");
        }
        if (this.input != ILLEGAL_STATE_READER) {
            throw new IllegalStateException("TokenStream contract violation: close() call missing");
        }
        this.inputPending = reader;
        this.setReaderTestPoint();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.input = this.inputPending;
        this.inputPending = ILLEGAL_STATE_READER;
    }

    void setReaderTestPoint() {
    }
}

