/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.util.Set;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.a;
import org.apache.lucene.codecs.c;
import org.apache.lucene.codecs.f;
import org.apache.lucene.codecs.h;
import org.apache.lucene.codecs.l;
import org.apache.lucene.codecs.m;
import org.apache.lucene.codecs.o;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.util.NamedSPILoader;

public abstract class Codec
implements NamedSPILoader.a {
    private final String name;

    protected Codec(String string) {
        NamedSPILoader.checkServiceName(string);
        this.name = string;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public abstract PostingsFormat postingsFormat();

    public abstract DocValuesFormat docValuesFormat();

    public abstract m storedFieldsFormat();

    public abstract o termVectorsFormat();

    public abstract c fieldInfosFormat();

    public abstract l segmentInfoFormat();

    public abstract h normsFormat();

    public abstract f liveDocsFormat();

    public abstract a compoundFormat();

    public static Codec forName(String string) {
        return Holder.getLoader().lookup(string);
    }

    public static Set<String> availableCodecs() {
        return Holder.getLoader().availableServices();
    }

    public static void reloadCodecs(ClassLoader classLoader) {
        Holder.getLoader().reload(classLoader);
    }

    public static Codec getDefault() {
        if (Holder.defaultCodec == null) {
            throw new IllegalStateException("You tried to lookup the default Codec before all Codecs could be initialized. This likely happens if you try to get it from a Codec's ctor.");
        }
        return Holder.defaultCodec;
    }

    public static void setDefault(Codec codec) {
        Holder.defaultCodec = Objects.requireNonNull(codec);
    }

    public String toString() {
        return this.name;
    }

    private static final class Holder {
        private static final NamedSPILoader<Codec> LOADER = new NamedSPILoader<Codec>(Codec.class);
        static Codec defaultCodec = LOADER.lookup("Lucene53");

        static NamedSPILoader<Codec> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a Codec by name before all Codecs could be initialized. This likely happens if you call Codec#forName from a Codec's ctor.");
            }
            return LOADER;
        }
    }
}

