/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.portmobile.charset.StandardCharsets;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.b;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public final class CodecUtil {
    private CodecUtil() {
    }

    public static void writeHeader(DataOutput dataOutput, String string, int n2) throws IOException {
        BytesRef bytesRef = new BytesRef(string);
        if (bytesRef.length != string.length() || bytesRef.length >= 128) {
            throw new IllegalArgumentException("codec must be simple ASCII, less than 128 characters in length [got " + string + "]");
        }
        dataOutput.writeInt(1071082519);
        dataOutput.writeString(string);
        dataOutput.writeInt(n2);
    }

    public static void writeIndexHeader(DataOutput dataOutput, String string, int n2, byte[] byArray, String string2) throws IOException {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Invalid id: " + StringHelper.idToString(byArray));
        }
        CodecUtil.writeHeader(dataOutput, string, n2);
        dataOutput.writeBytes(byArray, 0, byArray.length);
        BytesRef bytesRef = new BytesRef(string2);
        if (bytesRef.length != string2.length() || bytesRef.length >= 256) {
            throw new IllegalArgumentException("codec must be simple ASCII, less than 256 characters in length [got " + string2 + "]");
        }
        dataOutput.writeByte((byte)bytesRef.length);
        dataOutput.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
    }

    public static int headerLength(String string) {
        return 9 + string.length();
    }

    public static int indexHeaderLength(String string, String string2) {
        return CodecUtil.headerLength(string) + 16 + 1 + string2.length();
    }

    public static int checkHeader(DataInput dataInput, String string, int n2, int n3) throws IOException {
        int n4 = dataInput.readInt();
        if (n4 != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + n4 + " vs expected header=" + 1071082519, dataInput);
        }
        return CodecUtil.checkHeaderNoMagic(dataInput, string, n2, n3);
    }

    public static int checkHeaderNoMagic(DataInput dataInput, String string, int n2, int n3) throws IOException {
        String string2 = dataInput.readString();
        if (!string2.equals(string)) {
            throw new CorruptIndexException("codec mismatch: actual codec=" + string2 + " vs expected codec=" + string, dataInput);
        }
        int n4 = dataInput.readInt();
        if (n4 < n2) {
            throw new IndexFormatTooOldException(dataInput, n4, n2, n3);
        }
        if (n4 > n3) {
            throw new IndexFormatTooNewException(dataInput, n4, n2, n3);
        }
        return n4;
    }

    public static int checkIndexHeader(DataInput dataInput, String string, int n2, int n3, byte[] byArray, String string2) throws IOException {
        int n4 = CodecUtil.checkHeader(dataInput, string, n2, n3);
        CodecUtil.checkIndexHeaderID(dataInput, byArray);
        CodecUtil.checkIndexHeaderSuffix(dataInput, string2);
        return n4;
    }

    public static byte[] checkIndexHeaderID(DataInput dataInput, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[16];
        dataInput.readBytes(byArray2, 0, byArray2.length);
        if (!Arrays.equals(byArray2, byArray)) {
            throw new CorruptIndexException("file mismatch, expected id=" + StringHelper.idToString(byArray) + ", got=" + StringHelper.idToString(byArray2), dataInput);
        }
        return byArray2;
    }

    public static String checkIndexHeaderSuffix(DataInput dataInput, String string) throws IOException {
        int n2 = dataInput.readByte() & 0xFF;
        byte[] byArray = new byte[n2];
        dataInput.readBytes(byArray, 0, byArray.length);
        String string2 = new String(byArray, 0, byArray.length, StandardCharsets.UTF_8);
        if (!string2.equals(string)) {
            throw new CorruptIndexException("file mismatch, expected suffix=" + string + ", got=" + string2, dataInput);
        }
        return string2;
    }

    public static void writeFooter(IndexOutput indexOutput) throws IOException {
        indexOutput.writeInt(-1071082520);
        indexOutput.writeInt(0);
        CodecUtil.writeCRC(indexOutput);
    }

    public static int footerLength() {
        return 16;
    }

    public static long checkFooter(b b2) throws IOException {
        CodecUtil.validateFooter(b2);
        long l2 = b2.getChecksum();
        long l3 = CodecUtil.readCRC(b2);
        if (l3 != l2) {
            throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + Long.toHexString(l3) + " actual=" + Long.toHexString(l2), b2);
        }
        return l2;
    }

    public static void checkFooter(b b2, Throwable throwable) throws IOException {
        if (throwable == null) {
            CodecUtil.checkFooter(b2);
        } else {
            try {
                long l2 = b2.length() - b2.getFilePointer();
                if (l2 < (long)CodecUtil.footerLength()) {
                    throwable.addSuppressed(new CorruptIndexException("checksum status indeterminate: remaining=" + l2 + ", please run checkindex for more details", b2));
                } else {
                    b2.skipBytes(l2 - (long)CodecUtil.footerLength());
                    try {
                        long l3 = CodecUtil.checkFooter(b2);
                        throwable.addSuppressed(new CorruptIndexException("checksum passed (" + Long.toHexString(l3) + "). possibly transient resource issue, or a Lucene or JVM bug", b2));
                    }
                    catch (CorruptIndexException corruptIndexException) {
                        throwable.addSuppressed(corruptIndexException);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(new CorruptIndexException("checksum status indeterminate: unexpected exception", b2, throwable2));
            }
            IOUtils.reThrow(throwable);
        }
    }

    public static long retrieveChecksum(IndexInput indexInput) throws IOException {
        indexInput.seek(indexInput.length() - (long)CodecUtil.footerLength());
        CodecUtil.validateFooter(indexInput);
        return CodecUtil.readCRC(indexInput);
    }

    private static void validateFooter(IndexInput indexInput) throws IOException {
        long l2;
        long l3 = indexInput.length() - indexInput.getFilePointer();
        if (l3 < (l2 = (long)CodecUtil.footerLength())) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): remaining=" + l3 + ", expected=" + l2, indexInput);
        }
        if (l3 > l2) {
            throw new CorruptIndexException("misplaced codec footer (file extended?): remaining=" + l3 + ", expected=" + l2, indexInput);
        }
        int n2 = indexInput.readInt();
        if (n2 != -1071082520) {
            throw new CorruptIndexException("codec footer mismatch (file truncated?): actual footer=" + n2 + " vs expected footer=" + -1071082520, indexInput);
        }
        int n3 = indexInput.readInt();
        if (n3 != 0) {
            throw new CorruptIndexException("codec footer mismatch: unknown algorithmID: " + n3, indexInput);
        }
    }

    @Deprecated
    public static void checkEOF(IndexInput indexInput) throws IOException {
        if (indexInput.getFilePointer() != indexInput.length()) {
            throw new CorruptIndexException("did not read all bytes from file: read " + indexInput.getFilePointer() + " vs size " + indexInput.length(), indexInput);
        }
    }

    public static long checksumEntireFile(IndexInput indexInput) throws IOException {
        IndexInput indexInput2 = indexInput.clone();
        indexInput2.seek(0L);
        BufferedChecksumIndexInput bufferedChecksumIndexInput = new BufferedChecksumIndexInput(indexInput2);
        assert (((IndexInput)bufferedChecksumIndexInput).getFilePointer() == 0L);
        bufferedChecksumIndexInput.seek(((IndexInput)bufferedChecksumIndexInput).length() - (long)CodecUtil.footerLength());
        return CodecUtil.checkFooter(bufferedChecksumIndexInput);
    }

    public static long readCRC(IndexInput indexInput) throws IOException {
        long l2 = indexInput.readLong();
        if ((l2 & 0xFFFFFFFF00000000L) != 0L) {
            throw new CorruptIndexException("Illegal CRC-32 checksum: " + l2, indexInput);
        }
        return l2;
    }

    public static void writeCRC(IndexOutput indexOutput) throws IOException {
        long l2 = indexOutput.getChecksum();
        if ((l2 & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("Illegal CRC-32 checksum: " + l2 + " (resource=" + indexOutput + ")");
        }
        indexOutput.writeLong(l2);
    }
}

