/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.b;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.a;
import org.apache.lucene.index.m;
import org.apache.lucene.index.p;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.LongValues;

public abstract class DocValuesConsumer
implements Closeable {
    protected DocValuesConsumer() {
    }

    public abstract void addNumericField(FieldInfo var1, Iterable<Number> var2) throws IOException;

    public abstract void addBinaryField(FieldInfo var1, Iterable<BytesRef> var2) throws IOException;

    public abstract void addSortedField(FieldInfo var1, Iterable<BytesRef> var2, Iterable<Number> var3) throws IOException;

    public abstract void addSortedNumericField(FieldInfo var1, Iterable<Number> var2, Iterable<Number> var3) throws IOException;

    public abstract void addSortedSetField(FieldInfo var1, Iterable<BytesRef> var2, Iterable<Number> var3, Iterable<Number> var4) throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        for (b object3 : mergeState.docValuesProducers) {
            if (object3 == null) continue;
            object3.checkIntegrity();
        }
        for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
            FieldInfo fieldInfo2;
            b b2;
            Object object;
            Object object2;
            int n2;
            DocValuesType docValuesType = fieldInfo.getDocValuesType();
            if (docValuesType == DocValuesType.NONE) continue;
            if (docValuesType == DocValuesType.NUMERIC) {
                ArrayList<m> arrayList = new ArrayList<m>();
                ArrayList<Bits> arrayList2 = new ArrayList<Bits>();
                for (n2 = 0; n2 < mergeState.docValuesProducers.length; ++n2) {
                    object2 = null;
                    object = null;
                    b2 = mergeState.docValuesProducers[n2];
                    if (b2 != null && (fieldInfo2 = mergeState.fieldInfos[n2].fieldInfo(fieldInfo.name)) != null && fieldInfo2.getDocValuesType() == DocValuesType.NUMERIC) {
                        object2 = b2.getNumeric(fieldInfo2);
                        object = b2.getDocsWithField(fieldInfo2);
                    }
                    if (object2 == null) {
                        object2 = DocValues.emptyNumeric();
                        object = new Bits.MatchNoBits(mergeState.maxDocs[n2]);
                    }
                    arrayList.add((m)object2);
                    arrayList2.add((Bits)object);
                }
                this.mergeNumericField(fieldInfo, mergeState, arrayList, arrayList2);
                continue;
            }
            if (docValuesType == DocValuesType.BINARY) {
                ArrayList<a> arrayList = new ArrayList<a>();
                ArrayList<Bits> arrayList3 = new ArrayList<Bits>();
                for (n2 = 0; n2 < mergeState.docValuesProducers.length; ++n2) {
                    object2 = null;
                    object = null;
                    b2 = mergeState.docValuesProducers[n2];
                    if (b2 != null && (fieldInfo2 = mergeState.fieldInfos[n2].fieldInfo(fieldInfo.name)) != null && fieldInfo2.getDocValuesType() == DocValuesType.BINARY) {
                        object2 = b2.getBinary(fieldInfo2);
                        object = b2.getDocsWithField(fieldInfo2);
                    }
                    if (object2 == null) {
                        object2 = DocValues.emptyBinary();
                        object = new Bits.MatchNoBits(mergeState.maxDocs[n2]);
                    }
                    arrayList.add((a)object2);
                    arrayList3.add((Bits)object);
                }
                this.mergeBinaryField(fieldInfo, mergeState, arrayList, arrayList3);
                continue;
            }
            if (docValuesType == DocValuesType.SORTED) {
                ArrayList<SortedDocValues> arrayList = new ArrayList<SortedDocValues>();
                for (int i2 = 0; i2 < mergeState.docValuesProducers.length; ++i2) {
                    SortedDocValues sortedDocValues = null;
                    object2 = mergeState.docValuesProducers[i2];
                    if (object2 != null && (object = mergeState.fieldInfos[i2].fieldInfo(fieldInfo.name)) != null && ((FieldInfo)object).getDocValuesType() == DocValuesType.SORTED) {
                        sortedDocValues = ((b)object2).getSorted((FieldInfo)object);
                    }
                    if (sortedDocValues == null) {
                        sortedDocValues = DocValues.emptySorted();
                    }
                    arrayList.add(sortedDocValues);
                }
                this.mergeSortedField(fieldInfo, mergeState, arrayList);
                continue;
            }
            if (docValuesType == DocValuesType.SORTED_SET) {
                ArrayList<SortedSetDocValues> arrayList = new ArrayList<SortedSetDocValues>();
                for (int i3 = 0; i3 < mergeState.docValuesProducers.length; ++i3) {
                    SortedSetDocValues sortedSetDocValues = null;
                    object2 = mergeState.docValuesProducers[i3];
                    if (object2 != null && (object = mergeState.fieldInfos[i3].fieldInfo(fieldInfo.name)) != null && ((FieldInfo)object).getDocValuesType() == DocValuesType.SORTED_SET) {
                        sortedSetDocValues = ((b)object2).getSortedSet((FieldInfo)object);
                    }
                    if (sortedSetDocValues == null) {
                        sortedSetDocValues = DocValues.emptySortedSet();
                    }
                    arrayList.add(sortedSetDocValues);
                }
                this.mergeSortedSetField(fieldInfo, mergeState, arrayList);
                continue;
            }
            if (docValuesType == DocValuesType.SORTED_NUMERIC) {
                ArrayList<p> arrayList = new ArrayList<p>();
                for (int i4 = 0; i4 < mergeState.docValuesProducers.length; ++i4) {
                    p p2 = null;
                    object2 = mergeState.docValuesProducers[i4];
                    if (object2 != null && (object = mergeState.fieldInfos[i4].fieldInfo(fieldInfo.name)) != null && ((FieldInfo)object).getDocValuesType() == DocValuesType.SORTED_NUMERIC) {
                        p2 = ((b)object2).getSortedNumeric((FieldInfo)object);
                    }
                    if (p2 == null) {
                        p2 = DocValues.emptySortedNumeric(mergeState.maxDocs[i4]);
                    }
                    arrayList.add(p2);
                }
                this.mergeSortedNumericField(fieldInfo, mergeState, arrayList);
                continue;
            }
            throw new AssertionError((Object)("type=" + (Object)((Object)docValuesType)));
        }
    }

    public void mergeNumericField(FieldInfo fieldInfo, final MergeState mergeState, final List<m> list, final List<Bits> list2) throws IOException {
        this.addNumericField(fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    long nextValue;
                    boolean nextHasValue;
                    int currentMaxDoc;
                    m currentValues;
                    Bits currentLiveDocs;
                    Bits currentDocsWithField;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextHasValue ? Long.valueOf(this.nextValue) : null;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != list.size()) {
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < list.size()) {
                                    this.currentValues = (m)list.get(this.readerUpto);
                                    this.currentDocsWithField = (Bits)list2.get(this.readerUpto);
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                this.nextValue = this.currentValues.get(this.docIDUpto);
                                this.nextHasValue = this.nextValue != 0L || this.currentDocsWithField.get(this.docIDUpto);
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public void mergeBinaryField(FieldInfo fieldInfo, final MergeState mergeState, final List<a> list, final List<Bits> list2) throws IOException {
        this.addBinaryField(fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    BytesRef nextValue;
                    BytesRef nextPointer;
                    int currentMaxDoc;
                    a currentValues;
                    Bits currentLiveDocs;
                    Bits currentDocsWithField;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public BytesRef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextPointer;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != list.size()) {
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < list.size()) {
                                    this.currentValues = (a)list.get(this.readerUpto);
                                    this.currentDocsWithField = (Bits)list2.get(this.readerUpto);
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                this.nextPointer = this.currentDocsWithField.get(this.docIDUpto) ? (this.nextValue = this.currentValues.get(this.docIDUpto)) : null;
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public void mergeSortedNumericField(FieldInfo fieldInfo, final MergeState mergeState, List<p> list) throws IOException {
        final int n2 = list.size();
        final p[] pArray = list.toArray(new p[n2]);
        this.addSortedNumericField(fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    int nextValue;
                    int currentMaxDoc;
                    Bits currentLiveDocs;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != n2) {
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < n2) {
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                p p2 = pArray[this.readerUpto];
                                p2.setDocument(this.docIDUpto);
                                this.nextValue = p2.count();
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    long nextValue;
                    int currentMaxDoc;
                    Bits currentLiveDocs;
                    boolean nextIsSet;
                    int valueUpto;
                    int valueLength;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != n2) {
                            if (this.valueUpto < this.valueLength) {
                                this.nextValue = pArray[this.readerUpto].valueAt(this.valueUpto);
                                ++this.valueUpto;
                                this.nextIsSet = true;
                                return true;
                            }
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < n2) {
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                assert (this.docIDUpto < this.currentMaxDoc);
                                p p2 = pArray[this.readerUpto];
                                p2.setDocument(this.docIDUpto);
                                this.valueUpto = 0;
                                this.valueLength = p2.count();
                                ++this.docIDUpto;
                                continue;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public void mergeSortedField(FieldInfo fieldInfo, final MergeState mergeState, List<SortedDocValues> list) throws IOException {
        final int n2 = list.size();
        final SortedDocValues[] sortedDocValuesArray = list.toArray(new SortedDocValues[n2]);
        TermsEnum[] termsEnumArray = new TermsEnum[sortedDocValuesArray.length];
        long[] lArray = new long[termsEnumArray.length];
        for (int i2 = 0; i2 < n2; ++i2) {
            SortedDocValues sortedDocValues = sortedDocValuesArray[i2];
            Bits bits = mergeState.liveDocs[i2];
            int n3 = mergeState.maxDocs[i2];
            if (bits == null) {
                termsEnumArray[i2] = sortedDocValues.termsEnum();
                lArray[i2] = sortedDocValues.getValueCount();
                continue;
            }
            LongBitSet longBitSet = new LongBitSet(sortedDocValues.getValueCount());
            for (int i3 = 0; i3 < n3; ++i3) {
                int n4;
                if (!bits.get(i3) || (n4 = sortedDocValues.getOrd(i3)) < 0) continue;
                longBitSet.set(n4);
            }
            termsEnumArray[i2] = new BitsFilteredTermsEnum(sortedDocValues.termsEnum(), longBitSet);
            lArray[i2] = longBitSet.cardinality();
        }
        final MultiDocValues.OrdinalMap ordinalMap = MultiDocValues.OrdinalMap.build(this, termsEnumArray, lArray, 0.0f);
        this.addSortedField(fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    int currentOrd;

                    @Override
                    public boolean hasNext() {
                        return (long)this.currentOrd < ordinalMap.getValueCount();
                    }

                    @Override
                    public BytesRef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int n2 = ordinalMap.getFirstSegmentNumber(this.currentOrd);
                        int n3 = (int)ordinalMap.getFirstSegmentOrd(this.currentOrd);
                        BytesRef bytesRef = sortedDocValuesArray[n2].lookupOrd(n3);
                        ++this.currentOrd;
                        return bytesRef;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    int nextValue;
                    int currentMaxDoc;
                    Bits currentLiveDocs;
                    LongValues currentMap;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != n2) {
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < n2) {
                                    this.currentMap = ordinalMap.getGlobalOrds(this.readerUpto);
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                int n2 = sortedDocValuesArray[this.readerUpto].getOrd(this.docIDUpto);
                                this.nextValue = n2 == -1 ? -1 : (int)this.currentMap.get(n2);
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public void mergeSortedSetField(FieldInfo fieldInfo, final MergeState mergeState, List<SortedSetDocValues> list) throws IOException {
        final SortedSetDocValues[] sortedSetDocValuesArray = list.toArray(new SortedSetDocValues[list.size()]);
        final int n2 = mergeState.maxDocs.length;
        TermsEnum[] termsEnumArray = new TermsEnum[sortedSetDocValuesArray.length];
        long[] lArray = new long[termsEnumArray.length];
        for (int i2 = 0; i2 < termsEnumArray.length; ++i2) {
            SortedSetDocValues sortedSetDocValues = sortedSetDocValuesArray[i2];
            Bits bits = mergeState.liveDocs[i2];
            int n3 = mergeState.maxDocs[i2];
            if (bits == null) {
                termsEnumArray[i2] = sortedSetDocValues.termsEnum();
                lArray[i2] = sortedSetDocValues.getValueCount();
                continue;
            }
            LongBitSet longBitSet = new LongBitSet(sortedSetDocValues.getValueCount());
            for (int i3 = 0; i3 < n3; ++i3) {
                long l2;
                if (!bits.get(i3)) continue;
                sortedSetDocValues.setDocument(i3);
                while ((l2 = sortedSetDocValues.nextOrd()) != -1L) {
                    longBitSet.set(l2);
                }
            }
            termsEnumArray[i2] = new BitsFilteredTermsEnum(sortedSetDocValues.termsEnum(), longBitSet);
            lArray[i2] = longBitSet.cardinality();
        }
        final MultiDocValues.OrdinalMap ordinalMap = MultiDocValues.OrdinalMap.build(this, termsEnumArray, lArray, 0.0f);
        this.addSortedSetField(fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    long currentOrd;

                    @Override
                    public boolean hasNext() {
                        return this.currentOrd < ordinalMap.getValueCount();
                    }

                    @Override
                    public BytesRef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int n2 = ordinalMap.getFirstSegmentNumber(this.currentOrd);
                        long l2 = ordinalMap.getFirstSegmentOrd(this.currentOrd);
                        BytesRef bytesRef = sortedSetDocValuesArray[n2].lookupOrd(l2);
                        ++this.currentOrd;
                        return bytesRef;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    int nextValue;
                    int currentMaxDoc;
                    Bits currentLiveDocs;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != n2) {
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < n2) {
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                SortedSetDocValues sortedSetDocValues = sortedSetDocValuesArray[this.readerUpto];
                                sortedSetDocValues.setDocument(this.docIDUpto);
                                this.nextValue = 0;
                                while (sortedSetDocValues.nextOrd() != -1L) {
                                    ++this.nextValue;
                                }
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    long nextValue;
                    int currentMaxDoc;
                    Bits currentLiveDocs;
                    LongValues currentMap;
                    boolean nextIsSet;
                    long[] ords = new long[8];
                    int ordUpto;
                    int ordLength;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != n2) {
                            if (this.ordUpto < this.ordLength) {
                                this.nextValue = this.ords[this.ordUpto];
                                ++this.ordUpto;
                                this.nextIsSet = true;
                                return true;
                            }
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < n2) {
                                    this.currentMap = ordinalMap.getGlobalOrds(this.readerUpto);
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                long l2;
                                assert (this.docIDUpto < this.currentMaxDoc);
                                SortedSetDocValues sortedSetDocValues = sortedSetDocValuesArray[this.readerUpto];
                                sortedSetDocValues.setDocument(this.docIDUpto);
                                this.ordLength = 0;
                                this.ordUpto = 0;
                                while ((l2 = sortedSetDocValues.nextOrd()) != -1L) {
                                    if (this.ordLength == this.ords.length) {
                                        this.ords = ArrayUtil.grow(this.ords, this.ordLength + 1);
                                    }
                                    this.ords[this.ordLength] = this.currentMap.get(l2);
                                    ++this.ordLength;
                                }
                                ++this.docIDUpto;
                                continue;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public static boolean isSingleValued(Iterable<Number> iterable) {
        for (Number number : iterable) {
            if (number.longValue() <= 1L) continue;
            return false;
        }
        return true;
    }

    public static Iterable<Number> singletonView(final Iterable<Number> iterable, final Iterable<Number> iterable2, final Number number) {
        assert (DocValuesConsumer.isSingleValued(iterable));
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                final Iterator iterator = iterable.iterator();
                final Iterator iterator2 = iterable2.iterator();
                return new Iterator<Number>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Number next() {
                        int n2 = ((Number)iterator.next()).intValue();
                        if (n2 == 0) {
                            return number;
                        }
                        return (Number)iterator2.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static class BitsFilteredTermsEnum
    extends FilteredTermsEnum {
        final LongBitSet liveTerms;

        BitsFilteredTermsEnum(TermsEnum termsEnum, LongBitSet longBitSet) {
            super(termsEnum, false);
            assert (longBitSet != null);
            this.liveTerms = longBitSet;
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef bytesRef) throws IOException {
            if (this.liveTerms.get(this.ord())) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }
}

